/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.convert.IGenerator;
import kd.fi.bcm.business.convert.convertor.AbstractConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorFactory;
import kd.fi.bcm.business.dimension.helper.InitPeriodServiceHelper;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class CvtInfluenceConvertor
extends AbstractConvertor
implements IGenerator {
    private boolean cvt_gen = true;
    private boolean isInitPeriod = false;
    private int index = 0;

    public CvtInfluenceConvertor(ICvtContext ctx, boolean cvt_gen) {
        super(ctx);
        this.cvt_gen = cvt_gen;
        this.isInitPeriod = InitPeriodServiceHelper.isInitPeriod(this._ctx.getModelVo().id, this._ctx.getCvtOrgVo().id, this._ctx.getScenarioVo().id, this._ctx.getCvtYearVo().number, this._ctx.getCvtPeriodVo().id);
    }

    @Override
    protected String[] getAccountTypeEnumFilterVals() {
        switch (this.index) {
            case 0: {
                return null;
            }
            case 1: {
                return new String[]{AccountTypeEnum.RIGHTS.index, AccountTypeEnum.ASSET.index, AccountTypeEnum.DEBT.index};
            }
            case 2: {
                return new String[]{AccountTypeEnum.LOSS.index, AccountTypeEnum.CASHFLOW.index};
            }
        }
        return new String[]{AccountTypeEnum.UNFINNANCE.index, AccountTypeEnum.OTHERS.index};
    }

    @Override
    protected String[] getExchangeTypeFilter() {
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            return new String[]{"BOP"};
        }
        return new String[0];
    }

    @Override
    public Set<String> doConvert() {
        this.runCvtInfluence();
        return this.errorMsgs;
    }

    protected void runCvtInfluence() {
        if (this._ctx.isFirstPeriod() || !this.isInitPeriod) {
            this.carryBeginPeriodCarry();
        } else {
            super.doConvert();
        }
    }

    private void carryBeginPeriodCarry() {
        int size = 1;
        if (!this._ctx.isFirstPeriod()) {
            size = 3;
        }
        for (int i = 1; i <= size; ++i) {
            RunScriptBuilder run = new RunScriptBuilder(this._ctx.getModelVo().number);
            this.index = i;
            run.setSourceEnum(OlapSourceEnum.S2);
            this.buildBeginPeriodRunScript(run);
            this.buildBeginPeriodRunScope(run);
            if (!this.hasExistFilterAccts) continue;
            run.runScript();
        }
    }

    private void buildBeginPeriodRunScript(RunScriptBuilder run) {
        boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id));
        if (existChangeTypeDimension) {
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"BOP").addPair((Object)PresetConstant.PERIOD_DIM, (Object)this._ctx.getCvtPeriodVo().number));
        } else {
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PERIOD_DIM, (Object)this._ctx.getCvtPeriodVo().number));
        }
        run.appendEqualSign();
        if (this._ctx.isFirstPeriod()) {
            this.index = 0;
            if (existChangeTypeDimension) {
                run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"BBOY").addPair((Object)PresetConstant.PERIOD_DIM, (Object)this._ctx.getCvtPeriodVo().number));
            } else {
                run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PERIOD_DIM, (Object)this._ctx.getCvtPeriodVo().number));
            }
        } else {
            String changeType = null;
            if (existChangeTypeDimension) {
                changeType = this.index == 1 ? "EndingBalance" : "YTD";
            }
            String prePeriod = this._ctx.getPrePeriod();
            PairList addPair = new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)changeType).addPair((Object)PresetConstant.PERIOD_DIM, (Object)prePeriod);
            if (this.index != 3) {
                run.appendV((PairList<String, String>)addPair);
            } else {
                String YTDStr = run.parseV((PairList<String, String>)addPair);
                String endingBalanceStr = existChangeTypeDimension ? run.parseV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"EndingBalance").addPair((Object)PresetConstant.PERIOD_DIM, (Object)prePeriod)) : run.parseV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PERIOD_DIM, (Object)prePeriod));
                run.appendStr(YTDStr + "==null?" + endingBalanceStr + ":(" + YTDStr + "==0?" + endingBalanceStr + ':' + YTDStr + ')');
            }
        }
        run.endRunExpress();
    }

    private void buildBeginPeriodRunScope(RunScriptBuilder run) {
        List<String> accttype;
        run.addDimensionScope(PresetConstant.ENTITY_DIM, this._ctx.getCvtOrgVo().number);
        run.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getCvtYearVo().number);
        run.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenarioVo().number);
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, this.getCurrency());
        run.addDimensionScope(PresetConstant.PROCESS_DIM, "IRpt");
        switch (this.index) {
            case 0: {
                accttype = null;
                break;
            }
            case 1: {
                accttype = Arrays.asList("1", "2", "3");
                break;
            }
            case 2: {
                accttype = Arrays.asList("7", "10");
                break;
            }
            default: {
                accttype = Arrays.asList("9", "11");
            }
        }
        Set<String> acctNums = this.filterAccount(ChangeTypeSort.BOP.getValue(), this._ctx.getTemplateId(), accttype);
        boolean bl = this.hasExistFilterAccts = acctNums.size() > 0;
        if (this.hasExistFilterAccts) {
            run.addDimensionScope(PresetConstant.ACCOUNT_DIM, acctNums.toArray(new String[0]));
        }
    }

    private Set<String> filterAccount(String changeType, Object templateId) {
        QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelVo().id);
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            qf.and("changetype", "=", (Object)changeType);
        }
        if (templateId != null) {
            qf.and("template", "=", templateId);
        }
        HashSet<String> accounts = new HashSet<String>(16);
        Collection data = BusinessDataServiceHelper.loadFromCache((String)"bcm_beginperioddims", (String)"account.number", (QFilter[])new QFilter[]{qf}).values();
        if (data.size() > 0) {
            data.forEach(d -> accounts.add(d.getString("account.number")));
        }
        return accounts;
    }

    private Set<String> filterAccount(String changeType, Object templateId, List<String> accounttype) {
        QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelVo().id);
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            qf.and("changetype", "=", (Object)changeType);
        }
        if (templateId != null) {
            qf.and("template", "=", templateId);
        }
        HashSet<String> accounts = new HashSet<String>(16);
        Collection data = BusinessDataServiceHelper.loadFromCache((String)"bcm_beginperioddims", (String)"account.number,account.accounttype", (QFilter[])new QFilter[]{qf}).values();
        if (data.size() > 0) {
            data.forEach(d -> {
                if ((accounttype == null || accounttype.contains(d.getString("account.accounttype"))) && StringUtils.isNotEmpty((CharSequence)d.getString("account.number"))) {
                    accounts.add(d.getString("account.number"));
                }
            });
        }
        return accounts;
    }

    public void doRunCvtInfluence() {
        RunScriptBuilder run;
        Set<String> acctNums_cp = this.filterAccount(ChangeTypeSort.CPCHANGES.getValue(), this._ctx.getTemplateId());
        Set<String> acctNums_fy = this.filterAccount(ChangeTypeSort.FYCHANGES.getValue(), this._ctx.getTemplateId());
        if (acctNums_cp.size() > 0) {
            run = new RunScriptBuilder(this._ctx.getModelVo().number);
            this.buildCpRunScript(run);
            this.buildRunScope(run, acctNums_cp.toArray(new String[0]));
            run.runScript();
        }
        if (acctNums_fy.size() > 0) {
            run = new RunScriptBuilder(this._ctx.getModelVo().number);
            this.buildFyRunScript(run);
            this.buildRunScope(run, acctNums_fy.toArray(new String[0]));
            run.runScript();
        }
    }

    private void buildCpRunScript(RunScriptBuilder run) {
        run.appendEqualSign();
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"CPTraDif"));
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"EndingBalance"));
            run.subtractV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"BOP"));
            run.subtractV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"CPIncrease"));
            run.addV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"CPDecrease"));
        }
        run.endRunExpress();
    }

    private void buildFyRunScript(RunScriptBuilder run) {
        run.appendEqualSign();
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"FYTraDif"));
            run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"EndingBalance"));
            run.subtractV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"BBOY"));
            run.subtractV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"FYIncrease"));
            run.addV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"FYDecrease"));
        }
        run.endRunExpress();
    }

    private void buildRunScope(RunScriptBuilder run, String[] accts) {
        run.addDimensionScope(PresetConstant.ENTITY_DIM, this._ctx.getCvtOrgVo().number);
        run.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getCvtYearVo().number);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getCvtPeriodVo().number);
        run.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenarioVo().number);
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, this.getCurrency());
        run.addDimensionScope(PresetConstant.PROCESS_DIM, "IRpt");
        run.addDimensionScope(PresetConstant.ACCOUNT_DIM, accts);
    }

    private String[] getCurrency() {
        String[] stringArray;
        if (this.cvt_gen) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this._ctx.getCvtCurrencyVo().number;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this._ctx.getSrcCurrencyVo().number;
        }
        return stringArray;
    }

    @Override
    public boolean generate() {
        this.runCvtInfluence();
        return this.hasExistFilterAccts;
    }

    @Override
    protected CvtEquation genEquation(String[] params) {
        CvtFactor leftEquation = CvtFactorFactory.instance(CvtFactorEnum.beginPeriodInputCvtAmount, params);
        CvtFactorExpress rightEquation = null;
        rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.beginPeriodSumAmount, params));
        rightEquation.multiply(CvtFactorFactory.instance(CvtFactorEnum.PreRate, params));
        return new CvtEquation(leftEquation, rightEquation);
    }

    @Override
    protected boolean willGoBizConvertLogic() {
        return true;
    }

    public static enum ChangeTypeSort {
        NOTHING("0", new MultiLangEnumBridge("\u65e0", "CvtInfluenceConvertor_0", "fi-bcm-business")),
        BOP("1", new MultiLangEnumBridge("\u671f\u521d", "CvtInfluenceConvertor_1", "fi-bcm-business")),
        CPCHANGES("2", new MultiLangEnumBridge("\u672c\u671f\u589e\u51cf\u53d8\u52a8\u6298\u7b97\u5dee", "CvtInfluenceConvertor_2", "fi-bcm-business")),
        FYCHANGES("3", new MultiLangEnumBridge("\u672c\u5e74\u589e\u51cf\u53d8\u52a8\u6298\u7b97\u5dee", "CvtInfluenceConvertor_3", "fi-bcm-business"));

        private String value;
        private MultiLangEnumBridge bridge;

        private ChangeTypeSort(String value, MultiLangEnumBridge bridge) {
            this.value = value;
            this.bridge = bridge;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.bridge.loadKDString();
        }
    }
}

