/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.convert.convertor.AbstractConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorFactory;
import kd.fi.bcm.business.convert.factor.CvtFactorParser;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.ConvertFormulaEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;

public class InterestsAcctConvertor
extends AbstractConvertor {
    boolean isAfterConvert = false;

    public InterestsAcctConvertor(ICvtContext ctx) {
        super(ctx);
    }

    @Override
    protected IMDResultSet doQuery() {
        MDResultSet specialRs;
        IMDResultSet rs = super.doQuery();
        SQLBuilder sql = this.buildSQL(false);
        this.handleSpecialFilter(sql);
        MDResultSet mDResultSet = specialRs = this.hasExistFilterAccts ? OlapServiceHelper.queryData(sql) : new MDResultSet();
        if (specialRs != null && specialRs.getFetchSize() > 0) {
            int fyIndex = specialRs.getMetaData().getColIndex(PresetConstant.FY_DIM);
            int periodIndex = specialRs.getMetaData().getColIndex(PresetConstant.PERIOD_DIM);
            int currencyIndex = specialRs.getMetaData().getColIndex(PresetConstant.CURRENCY_DIM);
            int changetypeIndex = specialRs.getMetaData().getColIndex(PresetConstant.CHANGETYPE_DIM);
            while (specialRs.next()) {
                Row r = specialRs.getRow();
                r.replaceColumnValue(fyIndex, this._ctx.getCvtYearVo().number);
                r.replaceColumnValue(periodIndex, this._ctx.getCvtPeriodVo().number);
                r.replaceColumnValue(currencyIndex, this._ctx.getSrcCurrencyVo().number);
                if (!MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) continue;
                r.replaceColumnValue(changetypeIndex, "EndingBalance");
            }
            rs.mergerReduce(specialRs);
        }
        return rs;
    }

    protected void handleSpecialFilter(SQLBuilder sql) {
        HashSet<String> changetypes = new HashSet<String>(16);
        HashSet<String> fy = new HashSet<String>(16);
        HashSet<String> period = new HashSet<String>(16);
        HashSet<String> currency = new HashSet<String>(16);
        fy.add(this._ctx.getCvtYearVo().number);
        period.add(this._ctx.getCvtPeriodVo().number);
        currency.add(this._ctx.getSrcCurrencyVo().number);
        boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id));
        ConvertFormulaEnum cvtType = this._ctx.getConvertFormulaEnumByType("rights");
        if (ConvertFormulaEnum.RIGHTS1 == cvtType) {
            if (this._ctx.isFirstPeriod()) {
                if (existChangeTypeDimension) {
                    changetypes.add("BBOY");
                }
                currency.add(this._ctx.getCvtCurrencyVo().number);
            } else {
                period.add(this._ctx.getPrePeriod());
                currency.add(this._ctx.getCvtCurrencyVo().number);
            }
        } else if (ConvertFormulaEnum.RIGHTS2 == cvtType) {
            if (existChangeTypeDimension) {
                changetypes.add("BBOY");
                changetypes.add("EndingBalance");
            }
            currency.add(this._ctx.getCvtCurrencyVo().number);
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u7c7b\u79d1\u76ee\u6682\u4e0d\u652f\u6301\u7b97\u6cd5\u4e3a\u201c%s \u201d\u7684\u6298\u7b97\u65b9\u5f0f\u3002", (String)"InterestsAcctConvertor_0", (String)"fi-bcm-business", (Object[])new Object[0]), cvtType == null ? "Null" : cvtType.getFormula()));
        }
        if (!changetypes.isEmpty()) {
            sql.replaceOrAddFilter(PresetConstant.CHANGETYPE_DIM, changetypes.toArray(new String[0]));
        }
        sql.replaceOrAddFilter(PresetConstant.FY_DIM, fy.toArray(new String[0]));
        sql.replaceOrAddFilter(PresetConstant.PERIOD_DIM, period.toArray(new String[0]));
        sql.replaceOrAddFilter(PresetConstant.CURRENCY_DIM, currency.toArray(new String[0]));
    }

    @Override
    protected CvtEquation genEquation(String[] params) {
        CvtFactor leftEquation = CvtFactorFactory.instance(CvtFactorEnum.CurrInputCvtAmount, params);
        ConvertFormulaEnum cvtType = this._ctx.getConvertFormulaEnumByType("rights");
        CvtFactorExpress rightEquation = null;
        boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id));
        if (!existChangeTypeDimension) {
            return null;
        }
        String changeType = CvtFactorParser.getParamValueByMetaData(params, PresetConstant.CHANGETYPE_DIM, this._metadata);
        if (ConvertFormulaEnum.RIGHTS1 == cvtType) {
            if (this._ctx.isFirstPeriod()) {
                if ("EndingBalance".equals(changeType)) {
                    rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.BeginYSumCvtAmount, params));
                    rightEquation.addSign("+(");
                    rightEquation.append(CvtFactorFactory.instance(CvtFactorEnum.EndPeriodSumAmount, params));
                    rightEquation.subtract(CvtFactorFactory.instance(CvtFactorEnum.BeginYSumAmount, params));
                    rightEquation.addSign(")");
                } else {
                    rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.CurrPeriodSumAmount, params));
                }
            } else {
                rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.PrePeriodSumCvtAmount, params));
                rightEquation.addSign("+(");
                rightEquation.append(CvtFactorFactory.instance(CvtFactorEnum.CurrPeriodSumAmount, params));
                rightEquation.subtract(CvtFactorFactory.instance(CvtFactorEnum.PrePeriodSumAmount, params));
                rightEquation.addSign(")");
            }
        } else if (ConvertFormulaEnum.RIGHTS2 == cvtType) {
            if ("EndingBalance".equals(changeType)) {
                rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.BeginYSumCvtAmount, params));
                rightEquation.addSign("+(");
                rightEquation.append(CvtFactorFactory.instance(CvtFactorEnum.EndPeriodSumAmount, params));
                rightEquation.subtract(CvtFactorFactory.instance(CvtFactorEnum.BeginYSumAmount, params));
                rightEquation.addSign(")");
            } else {
                rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.CurrPeriodSumAmount, params));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u7c7b\u79d1\u76ee\u6682\u4e0d\u652f\u6301\u7b97\u6cd5\u4e3a\u201c%s \u201d\u7684\u6298\u7b97\u65b9\u5f0f\u3002", (String)"InterestsAcctConvertor_0", (String)"fi-bcm-business", (Object[])new Object[0]), cvtType == null ? "Null" : cvtType.getFormula()));
        }
        if (this._ctx.isConvert4InvElim() && this._ctx.get("cvtPath") != null) {
            rightEquation.multiply(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
        } else {
            String orgNum = params[this._metadata.getColIndex(PresetConstant.ENTITY_DIM)];
            String tgtNum = this._ctx.getCvtCurrencyVo().number;
            String srcNum = this._ctx.getSrcCurrencyVo().number;
            RateModel rm = ConvertUtil.getExchangeRateDetail(this._ctx.getBaseData(), orgNum, srcNum, tgtNum);
            if (rm.isMultiply()) {
                rightEquation.multiply(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
            } else {
                rightEquation.divide(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
            }
        }
        return new CvtEquation(leftEquation, rightEquation);
    }

    @Override
    protected String[] getAccountTypeEnumFilterVals() {
        return new String[]{AccountTypeEnum.RIGHTS.index};
    }

    @Override
    protected boolean willGoBizConvertLogic() {
        return true;
    }

    @Override
    public Set<String> afterConvert() {
        this.isAfterConvert = true;
        this.equations.clear();
        this.errorMsgs.addAll(super.doConvert());
        this.saveCvtValues2CubeDb(this.saveValPairs, OlapSourceEnum.T1);
        return this.errorMsgs;
    }

    @Override
    protected void addSaveValPair(Pair<String[], Object> p) {
        if (this.isAfterConvert) {
            this.saveValPairs.add(p);
        } else {
            super.addSaveValPair(p);
        }
    }
}

