/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.convert.convertor.AbstractLossOrCashFlowAcctConvertor;
import kd.fi.bcm.business.convert.ctx.GeneratorContext;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorFactory;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ConvertFormulaEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.util.PeriodUtils;

public class LossOrCashFlowAcctConvertor4YDT
extends AbstractLossOrCashFlowAcctConvertor {
    public LossOrCashFlowAcctConvertor4YDT(ICvtContext ctx) {
        super(ctx);
    }

    @Override
    protected IMDResultSet doQuery() {
        IMDResultSet rs = super.doQuery();
        boolean isDoConvert = ConfigServiceHelper.getBoolParam(this._ctx.getModelVo().id, "isConvertYTD");
        if (!isDoConvert) {
            return rs;
        }
        if (!(this._ctx instanceof GeneratorContext)) {
            ConvertFormulaEnum cvtType = this._ctx.getConvertFormulaEnumByType("profitloss");
            if (!this._ctx.isFirstPeriod() && ConvertFormulaEnum.PROFITLOSS2 == cvtType) {
                MDResultSet specialRs;
                SQLBuilder sql = this.buildSQL(true);
                this.handleIsConvertYTDSpecialFilter(sql);
                MDResultSet mDResultSet = specialRs = this.checkHasAcctFilter(sql) ? OlapServiceHelper.queryData(sql) : new MDResultSet();
                if (specialRs != null && specialRs.getFetchSize() > 0) {
                    int fyIndex = specialRs.getMetaData().getColIndex(PresetConstant.FY_DIM);
                    int periodIndex = specialRs.getMetaData().getColIndex(PresetConstant.PERIOD_DIM);
                    int currencyIndex = specialRs.getMetaData().getColIndex(PresetConstant.CURRENCY_DIM);
                    int changetypeIndex = specialRs.getMetaData().getColIndex(PresetConstant.CHANGETYPE_DIM);
                    while (specialRs.next()) {
                        Row r = specialRs.getRow();
                        r.replaceColumnValue(fyIndex, this._ctx.getCvtYearVo().number);
                        r.replaceColumnValue(periodIndex, this._ctx.getCvtPeriodVo().number);
                        r.replaceColumnValue(currencyIndex, this._ctx.getSrcCurrencyVo().number);
                        if (!MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) continue;
                        r.replaceColumnValue(changetypeIndex, "YTD");
                    }
                    rs.mergerReduce(specialRs);
                }
            }
        }
        return rs;
    }

    private void handleIsConvertYTDSpecialFilter(SQLBuilder sql) {
        if (this._ctx.isFirstPeriod()) {
            return;
        }
        HashSet<String> period = new HashSet<String>(2);
        HashSet<String> currency = new HashSet<String>(2);
        HashSet<String> changetype = new HashSet<String>(2);
        period.add(this._ctx.getCvtPeriodVo().number);
        period.add(this._ctx.getPrePeriod());
        currency.add(this._ctx.getSrcCurrencyVo().number);
        currency.add(this._ctx.getCvtCurrencyVo().number);
        changetype.add("YTD");
        changetype.add("CurrentPeriod");
        sql.replaceOrAddFilter(PresetConstant.PERIOD_DIM, period.toArray(new String[0]));
        sql.replaceOrAddFilter(PresetConstant.CURRENCY_DIM, currency.toArray(new String[0]));
        sql.replaceOrAddFilter(PresetConstant.CHANGETYPE_DIM, changetype.toArray(new String[0]));
    }

    @Override
    protected CvtEquation genEquation(String[] params) {
        CvtFactor leftEquation = CvtFactorFactory.instance(CvtFactorEnum.PeriodYDTInputCvtAmount, params);
        ConvertFormulaEnum cvtType = this._ctx.getConvertFormulaEnumByType("profitloss");
        CvtFactorExpress rightEquation = null;
        if (ConvertFormulaEnum.PROFITLOSS2 == cvtType) {
            if (PeriodUtils.isFirstPeriod((String)this._ctx.getModelVo().number, (String)this._ctx.getCvtPeriodVo().number)) {
                rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.PeriodSumAmount, params));
            } else {
                rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.PreYDTSumCvtAmount, params));
                rightEquation.add(CvtFactorFactory.instance(CvtFactorEnum.PeriodSumAmount, params));
            }
        } else if (ConvertFormulaEnum.PROFITLOSS1 == cvtType) {
            rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(CvtFactorEnum.PeriodYDTSumAmount, params));
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u635f\u76ca\u7c7b\u79d1\u76ee\u6682\u4e0d\u652f\u6301\u7b97\u6cd5\u4e3a\uff1a%s \u6298\u7b97\u65b9\u5f0f\u3002", (String)"LossOrCashFlowAcctConvertor4YDT_0", (String)"fi-bcm-business", (Object[])new Object[0]), cvtType == null ? "Null" : cvtType.getFormula()));
        }
        if (this._ctx.isConvert4InvElim() && this._ctx.get("cvtPath") != null) {
            rightEquation.multiply(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
        } else {
            String orgNum = params[this._metadata.getColIndex(PresetConstant.ENTITY_DIM)];
            String tgtNum = this._ctx.getCvtCurrencyVo().number;
            String srcNum = this._ctx.getSrcCurrencyVo().number;
            RateModel rm = ConvertUtil.getExchangeRateDetail(this._ctx.getBaseData(), orgNum, srcNum, tgtNum);
            if (rm.isMultiply()) {
                rightEquation.multiply(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
            } else {
                rightEquation.divide(CvtFactorFactory.instance(CvtFactorEnum.Rate, params));
            }
        }
        return new CvtEquation(leftEquation, rightEquation);
    }

    @Override
    protected boolean willGoBizConvertLogic() {
        return true;
    }

    @Override
    protected String[] getExchangeTypeFilter() {
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id))) {
            return new String[]{"YTD"};
        }
        return new String[0];
    }
}

