/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.fi.bcm.business.convert.IGenerator;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowAcctConvertor4CurrPeriod;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorFactory;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class LossOrCashFlowCurrPeriodGenYDT
extends LossOrCashFlowAcctConvertor4CurrPeriod
implements IGenerator {
    private int gen_type = 1;

    public LossOrCashFlowCurrPeriodGenYDT(ICvtContext ctx, int gen_type) {
        super(ctx);
        this.gen_type = gen_type;
    }

    @Override
    protected String[] getExchangeTypeFilter() {
        return new String[]{"CurrentPeriod", "YTD"};
    }

    @Override
    protected String[] handleAuditTrailFilter() {
        return null;
    }

    protected boolean willGoRunCvtInfluence() {
        return true;
    }

    @Override
    public Set<String> doConvert() {
        return new HashSet<String>(0);
    }

    @Override
    protected IMDResultSet doQuery() {
        MDResultSet currentPeriodResult = (MDResultSet)super.doQuery();
        if (this._ctx.isConvert4Checking()) {
            return currentPeriodResult;
        }
        SQLBuilder sql = this.buildSQL(true);
        String[] lastPeriod = PeriodUtils.getLastPeriodIncludeYear((String)this._ctx.getModelVo().number, (String)this._ctx.getCvtYearVo().number, (String)this._ctx.getCvtPeriodVo().number, (boolean)true);
        if (!StringUtils.isBlank((CharSequence)lastPeriod[0]) && !StringUtils.isBlank((CharSequence)lastPeriod[1])) {
            sql.replaceOrAddFilter(DimTypesEnum.YEAR.getNumber(), lastPeriod[0]);
            sql.replaceOrAddFilter(DimTypesEnum.PERIOD.getNumber(), lastPeriod[1]);
            currentPeriodResult.merger(this.checkHasAcctFilter(sql) ? OlapServiceHelper.queryData(sql) : new MDResultSet());
        }
        return currentPeriodResult;
    }

    @Override
    protected SQLBuilder buildSQL(boolean isIncludeNull) {
        SQLBuilder sql = super.buildSQL(isIncludeNull);
        sql.setExcludeDynaData(true);
        return sql;
    }

    @Override
    protected String[] getDimParams(Row row) {
        String[] data = super.getDimParams(row);
        int yearIndex = this._metadata.getColIndex(SysDimensionEnum.Year.getNumber());
        int periodIndex = this._metadata.getColIndex(SysDimensionEnum.Period.getNumber());
        data[yearIndex] = this._ctx.getCvtYearVo().number;
        data[periodIndex] = this._ctx.getCvtPeriodVo().number;
        return data;
    }

    @Override
    public Set<String> afterConvert() {
        this._ctx.put("isGenConvertor", true);
        this.errorMsgs.addAll(super.doConvert());
        this.resetGenData2Null(true, true);
        this.saveCvtValues2CubeDb(this.saveValPairs, OlapSourceEnum.S4);
        this._ctx.put("isGenConvertor", false);
        return this.errorMsgs;
    }

    @Override
    protected String[] getFixDims() {
        ArrayList<String> fixDimList = new ArrayList<String>(Arrays.asList(super.getFixDims()));
        fixDimList.remove("Currency");
        return fixDimList.toArray(new String[0]);
    }

    @Override
    protected void addFixedDimensionNew(OlapSaveBuilder save) {
        this._ctx.getFixDim2MembNumber().forEach((dimNumber, memberNumber) -> {
            if (!"Currency".equals(dimNumber)) {
                save.addFixedDimension((String)dimNumber, (String)memberNumber);
            }
        });
    }

    @Override
    protected boolean willGoBizConvertLogic() {
        return true;
    }

    @Override
    protected void addSaveValPair(Pair<String[], Object> p) {
        this.saveValPairs.add(p);
    }

    @Override
    protected String[] getProcessFilters() {
        IDNumberTreeNode processMemberNode = MemberReader.findProcessMemberByNum((String)this._ctx.getModelVo().number, (String)PresetConstant.PROCESS_DIM);
        List allChildren = processMemberNode.getAllChildren();
        ArrayList<String> leafProcessFilter = new ArrayList<String>(10);
        for (IDNumberTreeNode child : allChildren) {
            if (!child.isLeaf()) continue;
            leafProcessFilter.add(child.getNumber());
        }
        if (leafProcessFilter.size() > 0) {
            return leafProcessFilter.toArray(new String[0]);
        }
        return null;
    }

    @Override
    protected boolean isGenerateLogic() {
        return true;
    }

    @Override
    protected List<CvtEquation> genEquations(String[] params) {
        ArrayList<CvtEquation> equations = new ArrayList<CvtEquation>(2);
        switch (this.gen_type) {
            case 1: {
                if (!this._ctx.checkECFlowStatusIsSubmit()) break;
                equations.add(this.genEquationByGenType(params, false));
                break;
            }
            case 2: {
                if (this._ctx.checkPcFlowStatusIsSubmit()) break;
                equations.add(this.genEquationByGenType(params, true));
                break;
            }
            case 3: {
                if (this._ctx.checkECFlowStatusIsSubmit()) {
                    equations.add(this.genEquationByGenType(params, false));
                }
                if (this._ctx.checkPcFlowStatusIsSubmit()) break;
                equations.add(this.genEquationByGenType(params, true));
                break;
            }
        }
        return equations;
    }

    private CvtEquation genEquationByGenType(String[] params, boolean isCvt) {
        CvtFactor leftEquation = CvtFactorFactory.instance(isCvt ? CvtFactorEnum.PeriodYDTCvtAmount : CvtFactorEnum.PeriodYDTAmount, params);
        CvtFactorExpress rightEquation = null;
        if (PeriodUtils.isFirstPeriod((String)this._ctx.getModelVo().number, (String)this._ctx.getCvtPeriodVo().number)) {
            rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(isCvt ? CvtFactorEnum.PeriodCurrPeriodCvtAmount : CvtFactorEnum.PeriodCurrPeriodAmount, params));
        } else {
            rightEquation = new CvtFactorExpress(CvtFactorFactory.instance(isCvt ? CvtFactorEnum.PreYDTCvtAmount : CvtFactorEnum.PreYDTAmount, params));
            rightEquation.add(CvtFactorFactory.instance(isCvt ? CvtFactorEnum.PeriodCurrPeriodCvtAmount : CvtFactorEnum.PeriodCurrPeriodAmount, params));
        }
        return new CvtEquation(leftEquation, rightEquation);
    }

    @Override
    public boolean generate() {
        this._ctx.put("isGenConvertor", true);
        super.doConvert();
        this.resetGenData2Null(true, false);
        this.saveCvtValues2CubeDb(this.saveValPairs, OlapSourceEnum.S4);
        this._ctx.put("isGenConvertor", false);
        return !this.saveValPairs.isEmpty();
    }
}

