/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.convert.convertor.AbstractConvertor;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.convertor.calculate.CalculateEngineProxy;
import kd.fi.bcm.business.convert.ctx.CvtDataProvider;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorFactory;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.model.cvt.CvtFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum4Edit;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class UserDefinedFormulaConvertor
extends AbstractConvertor {
    public static final String ONLY_HAS_CVT_NUMBER = "hasCvtNumber";
    private Map<String, Set<String>> udfsDimNums = new HashMap<String, Set<String>>(16);
    private Map<String, Map<String, String>> membNum2Ids = new HashMap<String, Map<String, String>>(16);
    private Map<String, String> accountNum2Type = new HashMap<String, String>(16);
    private List<DynamicObject> udfs = new ArrayList<DynamicObject>(10);
    protected Map<String, String> dimAndMemb = new HashMap<String, String>(16);

    public UserDefinedFormulaConvertor(ICvtContext ctx) {
        super(ctx);
    }

    private List<DynamicObject> getUdfs() {
        QFBuilder qf = new QFBuilder("model", "=", (Object)this._ctx.getModelVo().id);
        qf.add("status", "=", (Object)"1");
        DynamicObject[] udfstmp = BusinessDataServiceHelper.load((String)"bcm_userdefcvtformula", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdefcvtformula").getAllFields().keySet()), (QFilter[])qf.toArray());
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(this._ctx.getModelVo().id);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(20);
        Collections.addAll(list, udfstmp);
        list.removeIf(udf -> {
            DynamicObjectCollection effectives = udf.getDynamicObjectCollection("effective");
            return udf.getDynamicObject("scenario") != null && udf.getDynamicObject("scenario").getLong("id") != this._ctx.getScenarioVo().id.longValue() || !ConvertDifferenceHandle.isApply(this._ctx.getCvtYearVo().id, this._ctx.getCvtPeriodVo().id, effectives, yearIdsList);
        });
        return list;
    }

    private Map<Integer, List<DynamicObject>> getUserDefinedFormulasGroup() {
        List<DynamicObject> udfs = this.getUdfs();
        Map<String, DynamicObject> orgs = this.getOrgs(udfs);
        ArrayList<DynamicObject> udfsClone = new ArrayList<DynamicObject>(10);
        udfsClone.addAll(udfs);
        udfsClone.removeIf(udf -> {
            boolean existOrg = false;
            DynamicObjectCollection entryentity = udf.getDynamicObjectCollection("entryentity");
            for (DynamicObject member : entryentity) {
                if (!member.getString("dimensionnum").equals(PresetConstant.ENTITY_DIM)) continue;
                existOrg = true;
                DynamicObject custom = member.getDynamicObject("propertyvalue");
                boolean isCustom = custom != null;
                DynamicObject org = (DynamicObject)orgs.get(member.getString("membernum"));
                if (!isCustom && org == null) continue;
                Long id = isCustom ? custom.getLong("id") : org.getLong("id");
                String longnumber = isCustom ? custom.getString("longnumber") : org.getString("longnumber");
                HashSet temp = new HashSet(16);
                new MembRangeItem("bcm_entitymembertree", id, longnumber, member.getString("membernum"), RangeEnum.getRangeByVal((int)member.getInt("membbound")), isCustom, (Object)this._ctx.getModelVo().id).matchItems(c -> temp.add(c.number));
                if (!temp.contains(this._ctx.getRealOrgNum())) continue;
                return false;
            }
            return existOrg;
        });
        if (udfsClone.isEmpty()) {
            return null;
        }
        Collection accounts = BusinessDataServiceHelper.loadFromCache((String)"bcm_accountmembertree", (String)"number, accounttype", (QFilter[])new QFBuilder("model", "=", (Object)this._ctx.getModelVo().id).add("accounttype", "=", (Object)AccountTypeEnum.RIGHTS.index).toArray()).values();
        accounts.forEach(a -> this.accountNum2Type.put(a.getString("number"), a.getString("accounttype")));
        TreeMap<Integer, List<DynamicObject>> seqGroup = new TreeMap<Integer, List<DynamicObject>>();
        for (DynamicObject dy : udfsClone) {
            Integer priority = dy.getInt("executionorder");
            List list = seqGroup.computeIfAbsent(priority, k -> new ArrayList(10));
            list.add(dy);
        }
        return seqGroup;
    }

    private Map<String, DynamicObject> getOrgs(Collection<DynamicObject> udfs) {
        HashSet orgNums = new HashSet(16);
        udfs.forEach(udf -> udf.getDynamicObjectCollection("entryentity").forEach(e -> {
            String dim = e.getString("dimensionnum");
            if (dim.equals(PresetConstant.ENTITY_DIM) && e.get("membernum") != null) {
                orgNums.add(e.getString("membernum"));
            }
        }));
        HashMap<String, DynamicObject> orgs = new HashMap<String, DynamicObject>(16);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id, number, longnumber", (QFilter[])new QFBuilder("model", "=", (Object)this._ctx.getModelVo().id).add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index).add("number", "in", orgNums).toArray()).values().forEach(org -> orgs.put(org.getString("number"), (DynamicObject)org));
        return orgs;
    }

    private void initBizData(Collection<DynamicObject> udfs) {
        if (udfs == null || udfs.size() == 0) {
            return;
        }
        this.udfsDimNums.clear();
        udfs.forEach(u -> {
            DynamicObjectCollection entry = u.getDynamicObjectCollection("entryentity");
            HashMap<String, Set<String>> udfsDimNumsForRemove = new HashMap<String, Set<String>>();
            for (DynamicObject dy : entry) {
                String dimNum = dy.getString("dimensionnum");
                String memberNum = dy.getString("membernum");
                DynamicObject custom = dy.getDynamicObject("propertyvalue");
                boolean isCustom = custom != null;
                int membBound = dy.getInt("membbound");
                Set dimMembSet = this.udfsDimNums.computeIfAbsent(dimNum, k -> new HashSet());
                dimMembSet.add(isCustom + "|" + (isCustom ? custom.getLong("id") + "@" + custom.getString("longnumber") : memberNum) + "|" + membBound);
                Set dimMembSetForRemove = udfsDimNumsForRemove.computeIfAbsent(dimNum, k -> new HashSet());
                dimMembSetForRemove.add(isCustom + "|" + (isCustom ? custom.getLong("id") + "@" + custom.getString("longnumber") : memberNum) + "|" + membBound);
            }
            this.clearCvtData(udfsDimNumsForRemove);
        });
    }

    private String getYearAndPeriod(String formula, ICvtContext ctx) {
        String exp = formula.substring(2, formula.length() - 2);
        String[] splitArr = exp.split(",");
        String syear = "";
        String speriod = "";
        String sourceyear = "";
        String sourcesperiod = "";
        for (String s : splitArr) {
            if (!s.contains(".")) continue;
            String[] temp = VDmFormula.splitDimAndMemb(s);
            String left = temp[0].substring(1);
            String right = temp[1].substring(0, temp[1].length() - 1);
            if ("FY".equals(left)) {
                syear = right;
                sourceyear = s;
                continue;
            }
            if (!"P".equals(left)) continue;
            speriod = right;
            sourcesperiod = s;
        }
        if (StringUtils.isNotEmpty((CharSequence)syear)) {
            Optional p = PeriodUtils.trans2SpecificFy((String)ctx.getModelVo().number, (String)ctx.getCvtYearVo().number, (String)syear);
            if (p.isPresent()) {
                syear = (String)p.get();
            }
        } else {
            syear = ctx.getCvtYearVo().number;
        }
        if (StringUtils.isNotEmpty((CharSequence)speriod)) {
            if ("LastPeriod".equals(speriod)) {
                String[] a = PeriodUtils.getLastPeriodIncludeYear((String)ctx.getModelVo().number, (String)syear, (String)ctx.getCvtPeriodVo().number, (boolean)true);
                syear = a[0];
                speriod = a[1];
            } else if ("CurrentPeriod".equals(speriod)) {
                speriod = ctx.getPrePeriod();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)syear)) {
            formula = StringUtils.isEmpty((CharSequence)sourceyear) ? formula.replace(")", ",\"FY." + syear + "\")") : formula.replace(sourceyear, "\"FY." + syear + "\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)speriod)) {
            formula = formula.replace(sourcesperiod, "\"P." + speriod + "\"");
        }
        return formula;
    }

    private void clearCvtData(Map<String, Set<String>> udfsDimNumsForRemove) {
        if (this._ctx.getSrcCurrencyVo().number.equals(this._ctx.getCvtCurrencyVo().number)) {
            return;
        }
        RunScriptBuilder run = new RunScriptBuilder(this._ctx.getModelVo().number);
        run.setSourceEnum(OlapSourceEnum.T2);
        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.SCENE_DIM, (Object)this._ctx.getScenarioVo().number));
        run.appendEqualSign();
        run.appendStr("null");
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, this._ctx.getCvtCurrencyVo().number);
        run.addDimensionScope(PresetConstant.AUDITTRIAL_DIM, "EntityInput");
        run.addDimensionScope(PresetConstant.ENTITY_DIM, this._ctx.getCvtOrgVo().number);
        run.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getCvtYearVo().number);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getCvtPeriodVo().number);
        run.addDimensionScope(PresetConstant.PROCESS_DIM, Objects.equals(this._ctx.getProcess(), "Rpt") ? "IRpt" : this._ctx.getProcess());
        for (Map.Entry<String, Set<String>> entry : udfsDimNumsForRemove.entrySet()) {
            String dimNum = entry.getKey();
            if (dimNum.equals(PresetConstant.ENTITY_DIM) || dimNum.equals(PresetConstant.SCENE_DIM)) continue;
            Set<String> boundSet = entry.getValue();
            run.addDimensionScope(dimNum, this.getDimNumbers(boundSet, dimNum).toArray(new String[0]));
        }
        run.runScript();
    }

    private Set<String> getMembersNum(String dimNum, String memberInfo, int membBound, boolean isCustom) {
        Map membs = this.membNum2Ids.computeIfAbsent(dimNum, k -> new HashMap(16));
        String entityNum = DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNum);
        Long modelId = this._ctx.getModelVo().id;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String memstr = null;
        if (isCustom) {
            memstr = memberInfo;
        } else {
            IDNumberTreeNode node;
            memstr = (String)membs.get(memberInfo);
            if (memstr == null && (node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberInfo)) != IDNumberTreeNode.NotFoundTreeNode) {
                memstr = node.getId() + "@" + node.getLongNumber();
                membs.put(memberInfo, memstr);
            }
        }
        Set<String> numberSet = new HashSet<String>(16);
        if (memstr != null) {
            String[] split = memstr.split("@");
            String membRangeKey = "userdefinedformula|" + split[0] + "|" + membBound;
            numberSet = (Set)GlobalCacheServiceHelper.getOrLoadNode((String)membRangeKey, () -> {
                HashSet temp = new HashSet(16);
                new MembRangeItem(entityNum, Long.valueOf(split[0]), split[1], isCustom ? null : memberInfo, RangeEnum.getRangeByVal((int)membBound), isCustom, (Object)this._ctx.getModelVo().id).matchItems(c -> temp.add(c.number));
                return temp;
            });
        }
        return numberSet;
    }

    @Override
    public Set<String> doConvert() {
        return this.errorMsgs;
    }

    @Override
    protected String[] handleAcctFilter(String ... membs) {
        String[] accountNums = this.getDimFilter(PresetConstant.ACCOUNT_DIM);
        return super.handleAcctFilter(accountNums);
    }

    @Override
    protected boolean isGenerateLogic() {
        return true;
    }

    @Override
    protected void userdefinedAcctFilter(QFBuilder qf) {
        qf.add("isleaf", "=", (Object)"1");
    }

    @Override
    protected String[] getExchangeTypeFilter() {
        return this.getDimFilter(PresetConstant.CHANGETYPE_DIM);
    }

    @Override
    protected void handleUserDefinedFilter(SQLBuilder sql) {
        this.udfsDimNums.forEach((dimNumber, boundSet) -> {
            if (PresetConstant.ENTITY_DIM.equals(dimNumber) || PresetConstant.SCENE_DIM.equals(dimNumber) || PresetConstant.FY_DIM.equals(dimNumber) || PresetConstant.PERIOD_DIM.equals(dimNumber) || PresetConstant.CURRENCY_DIM.equals(dimNumber) || PresetConstant.ACCOUNT_DIM.equals(dimNumber) || PresetConstant.CHANGETYPE_DIM.equals(dimNumber) || PresetConstant.AUDITTRIAL_DIM.equals(dimNumber) && this._ctx.getConvertAudittrial() != null || PresetConstant.PROCESS_DIM.equals(dimNumber)) {
                return;
            }
            String[] dimFilter = this.getDimFilter((String)dimNumber);
            if (dimFilter != null) {
                sql.replaceOrAddFilter((String)dimNumber, dimFilter);
            }
        });
    }

    private String[] getDimFilter(String dimNumber) {
        Set<String> boundSet = this.udfsDimNums.get(dimNumber);
        if (boundSet != null) {
            return this.getDimNumbers(boundSet, dimNumber).toArray(new String[0]);
        }
        return null;
    }

    private Set<String> getDimNumbers(Set<String> boundSet, String dimNumber) {
        HashSet<String> members = new HashSet<String>();
        for (String bound : boundSet) {
            String[] split = bound.split("\\|");
            boolean isCustom = Boolean.parseBoolean(split[0]);
            if (!isCustom && Integer.parseInt(split[2]) == RangeEnum.VALUE_10.getValue()) {
                members.add(split[1]);
                continue;
            }
            Set<String> membersNum = this.getMembersNum(dimNumber, split[1], Integer.parseInt(split[2]), isCustom);
            members.addAll(membersNum);
        }
        return members;
    }

    @Override
    protected CalculateEngineProxy getCalculateEngine(Map<String, Object> kvMap, Recorder<CvtFactorExpress> crrFormula, Recorder<Boolean> recorder) {
        CalContext calctx = new CalContext(this._ctx.getModelVo().number, this._ctx.getCvtOrgVo().number, this._ctx.getCvtYearVo().number, this._ctx.getCvtPeriodVo().number, this._ctx.getScenarioVo().number, this._ctx.getCvtCurrencyVo().number);
        calctx.setProperty(DimTypesEnum.PROCESS.getShortNumber(), this._ctx.getProcess());
        final CalculateService calculateService = new CalculateService(calctx);
        calculateService.get_ctx().setExternalDataProvider(new CvtDataProvider(this._ctx, kvMap, crrFormula, recorder, this._metadata.getColIndex(PresetConstant.CURRENCY_DIM)));
        return new CalculateEngineProxy(calculateService){

            public Object calculate(String express) {
                return calculateService.singleCalculate(express);
            }
        };
    }

    @Override
    protected String[] getDimParams(Row row) {
        String[] data = super.getDimParams(row);
        String[] selectDimKes = this._ctx.getSelectDimKes();
        String[] keys = new String[selectDimKes.length];
        int size = selectDimKes.length;
        for (int i = 0; i < size; ++i) {
            keys[i] = "Entity".equals(selectDimKes[i]) ? this._ctx.getRealOrgNum() : row.getString(selectDimKes[i]);
            this.dimAndMemb.put(selectDimKes[i], keys[i]);
        }
        return data;
    }

    @Override
    protected CvtEquation genEquation(String[] params) {
        String srcCurrencyNum = this._ctx.getSrcCurrencyVo().number;
        String accountNum = this.dimAndMemb.get(PresetConstant.ACCOUNT_DIM);
        String changeTypeNum = this.dimAndMemb.get(PresetConstant.CHANGETYPE_DIM);
        for (DynamicObject dy : this.udfs) {
            DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
            boolean isOK = this.isInScopeForUserDefinedFormula(entry, this.dimAndMemb);
            if (!isOK) continue;
            String formula = dy.getString("cvtformulaechoed");
            CvtFactor leftEquation = CvtFactorFactory.instance(CvtFactorEnum.CurrInputCvtAmount, params);
            if (StringUtils.isBlank((CharSequence)formula)) {
                return new CvtEquation(leftEquation, null);
            }
            formula = formula.replace("\"C.EC\"", "\"C." + srcCurrencyNum + "\"");
            formula = formula.replace("Inv(\"\"", "Inv(\"" + this._ctx.getCvtOrgVo().number + "\"");
            formula = this.rightsHandle(accountNum, changeTypeNum, formula);
            CvtFactorExpress rightEquation = this.handleFormula(formula, params);
            return new CvtEquation(leftEquation, rightEquation);
        }
        return null;
    }

    private CvtFactorExpress handleFormula(String orginFormula, String[] params) {
        String result = orginFormula;
        List<IFormula> formulas = ChkFormulaServiceHelper.getIFormulaList(orginFormula, VFormula.getVName());
        if (formulas != null && formulas.size() > 0) {
            Iterator<IFormula> iterator = formulas.iterator();
            while (iterator.hasNext()) {
                String curFormula = iterator.next().toString();
                if (!curFormula.contains("\"P.CurrentPeriod\"") && !curFormula.contains("\"P.LastPeriod\"") && !curFormula.contains("\"FY.LastYear\"") && !curFormula.contains("\"FY.CurrentYear\"")) continue;
                String replacedformula = this.getYearAndPeriod(curFormula, this._ctx);
                result = Pattern.compile(curFormula, 16).matcher(result).replaceFirst(replacedformula);
            }
        }
        formulas = ChkFormulaServiceHelper.getIFormulaList(orginFormula, CvtFormula.getCVTName());
        CvtFactorExpress rightEquation = new CvtFactorExpress(result);
        if (formulas != null && formulas.size() > 0) {
            for (IFormula curFormula : formulas) {
                String[] number = ((ParamItem)curFormula.getParamList().get(0)).toString().split("@");
                String englishName = number[1];
                CvtFactorEnum cvt = CvtFactorEnum.getCvtFactorEnumByName((String)englishName);
                if (cvt == null) continue;
                rightEquation.appendOnlyFactor(CvtFactorFactory.instance(cvt, params));
            }
        }
        return rightEquation;
    }

    public boolean isInScopeForUserDefinedFormula(DynamicObjectCollection dimEntry, Map<String, String> dimAndMembMap) {
        boolean isOK = true;
        HashSet<String> checked = new HashSet<String>(16);
        if (this._ctx.getConvertAudittrial() != null) {
            checked.add("AuditTrail");
        }
        int size = dimEntry.size();
        List entry = (List)dimEntry.clone();
        entry.sort((o1, o2) -> {
            if (o1.getLong("id") > o2.getLong("id")) {
                return 1;
            }
            return -1;
        });
        for (int i = 0; i < size; ++i) {
            DynamicObject e = (DynamicObject)entry.get(i);
            String dimNum = e.getString("dimensionnum");
            if (checked.contains(dimNum)) continue;
            DynamicObject custom = e.getDynamicObject("propertyvalue");
            boolean isCustom = custom != null;
            String enterMemb = dimAndMembMap.get(dimNum);
            if (!isCustom && e.getInt("membbound") == RangeEnum.VALUE_10.getValue()) {
                if (e.getString("membernum").equals(enterMemb)) {
                    checked.add(dimNum);
                    continue;
                }
                if (i != size - 1 && (i >= size - 1 || ((DynamicObject)entry.get(i + 1)).getString("dimensionnum").equals(dimNum))) continue;
                isOK = false;
                break;
            }
            Set<String> membersNum = this.getMembersNum(dimNum, isCustom ? custom.getLong("id") + "@" + custom.getString("longnumber") : e.getString("membernum"), e.getInt("membbound"), isCustom);
            if (membersNum.contains(enterMemb)) {
                checked.add(dimNum);
                continue;
            }
            if (i != size - 1 && (i >= size - 1 || ((DynamicObject)entry.get(i + 1)).getString("dimensionnum").equals(dimNum))) continue;
            isOK = false;
            break;
        }
        return isOK;
    }

    public String getConvertRateNumber(Map<Integer, List<DynamicObject>> udfsGroup) {
        Collection<Pair<String, String[]>> scopes = this._ctx.getScopes();
        HashMap<String, String> dimAndMembMap = new HashMap<String, String>(scopes.size());
        for (Pair<String, String[]> pair : scopes) {
            dimAndMembMap.put((String)pair.p1, ((String[])pair.p2)[0]);
        }
        String rateNumber = null;
        if (udfsGroup == null || udfsGroup.isEmpty()) {
            return null;
        }
        NavigableMap descendingMap = ((TreeMap)udfsGroup).descendingMap();
        for (List udfs : descendingMap.values()) {
            for (DynamicObject dy : udfs) {
                String[] split;
                DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
                boolean isOK = this.isInScopeForUserDefinedFormula(entry, dimAndMembMap);
                if (!isOK) continue;
                String formula = dy.getString("convertformula");
                if (StringUtils.isBlank((CharSequence)formula)) {
                    return null;
                }
                for (String item : split = this.splitFormula(formula)) {
                    if (StringUtils.isBlank((CharSequence)item) || !SysMembConstant.rateNumbers.contains(item)) continue;
                    rateNumber = item;
                    return rateNumber;
                }
                for (String item : split) {
                    if (StringUtils.isBlank((CharSequence)item) || !this.ifContains(item)) continue;
                    return ONLY_HAS_CVT_NUMBER;
                }
            }
        }
        return null;
    }

    private boolean ifContains(String item) {
        List currentUsage = CvtFactorEnum4Edit.getCurrentUsage();
        for (CvtFactorEnum4Edit cvtFactorEnum4Edit : currentUsage) {
            String number = cvtFactorEnum4Edit.getNumber();
            if (!number.equals(item)) continue;
            return true;
        }
        return false;
    }

    public String[] splitFormula(String formula) {
        return formula.replaceAll("\\+", "!").replaceAll("\\-", "!").replaceAll("\\*", "!").replaceAll("\\/", "!").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("=", "!").replaceAll(">", "!").replaceAll(">=", "!").replaceAll("<", "!").replaceAll("<=", "!").replaceAll("<>", "!").split("!");
    }

    private String rightsHandle(String accountNum, String changeTypeNum, String formula) {
        boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this._ctx.getModelVo().id));
        if (this.accountNum2Type.containsKey(accountNum)) {
            formula = formula.replace("CurrPeriodSumAmount", "temp1");
            formula = formula.replace("PrePeriodSumAmount", "temp2");
            formula = formula.replace("beginPeriodSumAmount", "temp3");
            formula = formula.replace("PreEndPeriodSumAmount", "temp4");
            formula = formula.replace("EndPeriodSumAmount", "temp5");
            formula = this._ctx.isFirstPeriod() ? (existChangeTypeDimension && "EndingBalance".equals(changeTypeNum) ? formula.replace("PeriodSumAmount", "(EndPeriodSumAmount-BeginYSumAmount)") : formula.replace("PeriodSumAmount", "CurrPeriodSumAmount")) : formula.replace("PeriodSumAmount", "(CurrPeriodSumAmount-PrePeriodSumAmount)");
            formula = formula.replace("temp1", "CurrPeriodSumAmount");
            formula = formula.replace("temp2", "PrePeriodSumAmount");
            formula = formula.replace("temp3", "beginPeriodSumAmount");
            formula = formula.replace("temp4", "PreEndPeriodSumAmount");
            formula = formula.replace("temp5", "EndPeriodSumAmount");
            formula = existChangeTypeDimension && "EndingBalance".equals(changeTypeNum) ? formula.replace("PeriodYDTSumAmount", "(EndPeriodSumAmount-BeginYSumAmount)") : formula.replace("PeriodYDTSumAmount", "CurrPeriodSumAmount");
        }
        return formula;
    }

    @Override
    protected boolean willGoBizConvertLogic() {
        return true;
    }

    @Override
    protected String[] getAccountTypeEnumFilterVals() {
        return null;
    }

    @Override
    public Set<String> afterConvert() {
        Map<Integer, List<DynamicObject>> udfsGroup = this.getUserDefinedFormulasGroup();
        if (udfsGroup == null || udfsGroup.isEmpty()) {
            return this.errorMsgs;
        }
        udfsGroup.forEach((priority, list) -> {
            this.saveValPairs.clear();
            this.equations.clear();
            this.udfs = list;
            this.initBizData((Collection<DynamicObject>)list);
            this.errorMsgs.addAll(super.doConvert());
            this.saveCvtValues2CubeDb(this.saveValPairs, OlapSourceEnum.T2);
        });
        return this.errorMsgs;
    }

    @Override
    protected void addSaveValPair(Pair<String[], Object> p) {
        this.saveValPairs.add(p);
    }
}

