/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.ctx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.FixScopeParameter;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryService;
import kd.fi.bcm.business.convert.util.ConvertSchemeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ConvertFormulaEnum;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class CvtContext
implements ICvtContext {
    private SimpleVo modelVo;
    private SimpleVo cvtCurrVo;
    private BaseData baseData;
    private Boolean parallelConvert;
    private Map<String, Pair<String, String[]>> scopes = new HashMap<String, Pair<String, String[]>>(16);
    private List<String> selectDimKeys;
    private Map<String, ExchangeEnum> acctExchangeCache = new HashMap<String, ExchangeEnum>(16);
    private Map<String, ChangewayEnum> changeTypeWayCache = new HashMap<String, ChangewayEnum>(16);
    private boolean willBeConvert = true;
    private boolean isForceExec = false;
    private FixScopeParameter fixScopeParameter;
    private List<Pair<String[], Object>> saveValPairs = new ArrayList<Pair<String[], Object>>(10);
    private DChangeTypeEnum dchangeTypeEnum = null;
    private String prePeriod;
    private String prePeriodFy;
    private Map<String, ConvertFormulaEnum> convertFormulaType;
    private String[] exchangeTypeDefaultFilter;
    private String orgRelaMemb;
    private boolean isNeedMonitorDataStatus = true;
    private Map<Object, Object> userDefineData;
    private Object templateId;
    private String convertAudittrial;
    private String cvtDiffAudittrial;
    private IDNumberTreeNode entityInputTraDif = null;
    private McStatus status;
    private Boolean periodStatus;
    private List<String> noclearChangeTypes;

    public CvtContext() {
    }

    public CvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter) {
        this(modelVo, cvtCurrVo, fixScopeParameter, null, false);
    }

    public CvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, boolean isForceExec) {
        this(modelVo, cvtCurrVo, fixScopeParameter, null, isForceExec);
    }

    public CvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, String process, boolean isForceExec) {
        this.modelVo = modelVo;
        this.cvtCurrVo = cvtCurrVo;
        this.fixScopeParameter = fixScopeParameter;
        this.isForceExec = isForceExec;
        this.initProcess(process);
        this.init();
        this.initPcFlowStatus();
    }

    public CvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, String process, boolean isForceExec, Boolean parallelConvert) {
        this(modelVo, cvtCurrVo, fixScopeParameter, process, isForceExec);
        this.parallelConvert = parallelConvert;
    }

    private void initProcess(String process) {
        this.put("process", process);
    }

    private void init() {
        this.addFixedScope();
        this.initCondition();
        if (this.isConvertAll() && !this.isForceExec() && ConvertUtil.isConvertFinish(this.modelVo.number, this.getScenarioVo().number, this.getCvtYearVo().number, this.getCvtPeriodVo().number, this.getCvtOrgVo().number, this.getSrcCurrencyVo().number, this.getProcess(), this.getCvtCurrencyVo().number)) {
            this.setWillBeNotConvert();
        }
    }

    protected void initCondition() {
        this.initQueryScenarioInputChangeType();
        this.initConvertFormulaType();
        this.initExchangeTypeDefaultFilter();
        this.baseData = new BaseData(this.getModelVo(), this.getScenarioVo(), this.getCvtYearVo(), this.getCvtPeriodVo());
    }

    protected void initConvertFormulaType() {
        IDNumberTreeNode tmp;
        BaseConvertFormula baseConvertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula(this.getModelVo().id, this.getScenarioVo().id);
        this.convertFormulaType = new HashMap<String, ConvertFormulaEnum>(16);
        this.convertFormulaType.put("balance", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getBalance()));
        this.convertFormulaType.put("profitloss", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getProfitloss()));
        this.convertFormulaType.put("rights", ConvertFormulaEnum.getConvertFormulaByIndex((int)baseConvertFormula.getRights()));
        this.convertAudittrial = baseConvertFormula.getConvertAudittrial();
        this.cvtDiffAudittrial = baseConvertFormula.getCvtDiffAudittrial();
        if (MemberReader.isExistAuditTrailDimension((long)this.getModelVo().id) && (tmp = MemberReader.findMemberByNumber((String)this.getModelVo().number, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)"EntityInputTraDif")).getId() != -1L) {
            this.entityInputTraDif = tmp;
        }
    }

    protected void initExchangeTypeDefaultFilter() {
        this.exchangeTypeDefaultFilter = this.queryCanCvtChangeType();
    }

    protected void initQueryScenarioInputChangeType() {
        this.dchangeTypeEnum = ExchangeQueryService.queryScenarioInputChangType(this);
    }

    private String[] queryCanCvtChangeType() {
        ArrayList nums = new ArrayList(10);
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelVo().id);
        qf.add("isleaf", "=", (Object)"1");
        qf.add("changeway", "not in", Arrays.asList(ChangewayEnum.NONE.index, ChangewayEnum.ACCOUNT.index, ChangewayEnum.EARLYYEARTURN.index));
        if (MemberReader.isExistChangeTypeDimension((String)this.getModelVo().number)) {
            qf.add("number", "!=", (Object)"BFLY");
            qf.add("number", "!=", (Object)"BOP");
        }
        BusinessDataServiceHelper.loadFromCache((String)"bcm_changetypemembertree", (String)"number", (QFilter[])qf.toArray()).values().forEach(d -> nums.add(d.getString("number")));
        return nums.toArray(new String[0]);
    }

    protected void addFixedScope() {
        this.fixScopeParameter.iterator().forEachRemaining(c -> this.addScope(((DimTypesEnum)c.getKey()).getNumber(), (Pair<String, String[]>)Pair.onePair((Object)((DimTypesEnum)c.getKey()).getNumber(), (Object)this.toStringArray(((SimpleVo)c.getValue()).number))));
    }

    protected final String[] toStringArray(String ... s) {
        return s;
    }

    @Override
    public void addScope(String dimNum, Pair<String, String[]> scope) {
        this.scopes.put(dimNum, scope);
    }

    @Override
    public SimpleVo getCvtCurrencyVo() {
        return this.cvtCurrVo;
    }

    @Override
    public Collection<SimpleVo> getCvtCurrencyVos() {
        return null;
    }

    @Override
    public SimpleVo getSrcCurrencyVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.CURRENCY);
    }

    @Override
    public Collection<SimpleVo> getSrcCurrencyVos() {
        return null;
    }

    @Override
    public SimpleVo getCvtOrgVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.ENTITY);
    }

    @Override
    public Collection<SimpleVo> getCvtOrgVos() {
        return null;
    }

    @Override
    public SimpleVo getModelVo() {
        return this.modelVo;
    }

    @Override
    public SimpleVo getCvtYearVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.YEAR);
    }

    @Override
    public SimpleVo getCvtPeriodVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.PERIOD);
    }

    @Override
    public SimpleVo getScenarioVo() {
        return this.fixScopeParameter.getFixScopeByDimType(DimTypesEnum.SCENARIO);
    }

    @Override
    public BaseData getBaseData() {
        return this.baseData;
    }

    @Override
    public Collection<Pair<String, String[]>> getScopes() {
        return this.scopes.values();
    }

    protected boolean containsScope(String dimKey) {
        return this.scopes.containsKey(dimKey);
    }

    protected void removeScope(String dimKey) {
        Pair<String, String[]> remove = this.scopes.remove(dimKey);
        this.put("scopes_" + dimKey, remove);
    }

    @Override
    public String[] getSelectDimKes() {
        if (this.selectDimKeys == null) {
            this.selectDimKeys = DimensionServiceHelper.getDimensionNumListByModel(this.modelVo.id);
        }
        return this.selectDimKeys.toArray(new String[0]);
    }

    @Override
    public String[] getMeasures() {
        return new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
    }

    @Override
    public String[] getFixDims() {
        ArrayList dims = new ArrayList(10);
        this.fixScopeParameter.iterator().forEachRemaining(e -> dims.add(((DimTypesEnum)e.getKey()).getNumber()));
        return dims.toArray(new String[0]);
    }

    @Override
    public Map<String, String> getFixDim2MembNumber() {
        HashMap<String, String> fixDim2MembNumber = new HashMap<String, String>(5);
        this.fixScopeParameter.iterator().forEachRemaining(e -> {
            String number = ((DimTypesEnum)e.getKey()).getNumber();
            if (number.equals(DimTypesEnum.CURRENCY.getNumber())) {
                fixDim2MembNumber.put(number, this.cvtCurrVo.number);
            } else {
                fixDim2MembNumber.put(number, ((SimpleVo)e.getValue()).number);
            }
        });
        return fixDim2MembNumber;
    }

    @Override
    public void add2cacheAccountCvtExchange(Map<String, ExchangeEnum> cacheItems) {
        this.acctExchangeCache.putAll(cacheItems);
    }

    @Override
    public void add2CacheChangeTypeChangeWay(Map<String, ChangewayEnum> cacheItems) {
        this.changeTypeWayCache.putAll(cacheItems);
    }

    @Override
    public ExchangeEnum getCvtExchangeOfAccount(String acctNum) {
        return this.acctExchangeCache.get(acctNum);
    }

    @Override
    public ChangewayEnum getChangeWayOfChangeType(String changeTypeNum) {
        return this.changeTypeWayCache.get(changeTypeNum);
    }

    @Override
    public boolean willBeConvert() {
        return this.willBeConvert;
    }

    protected void setWillBeNotConvert() {
        this.willBeConvert = false;
    }

    @Override
    public boolean isForceExec() {
        return this.isForceExec;
    }

    @Override
    public void addSaveValPair(Pair<String[], Object> p) {
        this.saveValPairs.add(p);
    }

    @Override
    public List<Pair<String[], Object>> getSaveValPairs() {
        return this.saveValPairs;
    }

    @Override
    public DChangeTypeEnum getScenarioInputChangType() {
        return this.dchangeTypeEnum;
    }

    @Override
    public String getPrePeriod() {
        if (this.prePeriod == null) {
            this.initPrePeriodAndFy();
        }
        return this.prePeriod;
    }

    @Override
    public String getFyOfPrePeriod() {
        if (this.prePeriodFy == null) {
            this.initPrePeriodAndFy();
        }
        return this.prePeriodFy;
    }

    private void initPrePeriodAndFy() {
        String[] lastMonthPeriod = PeriodUtils.getLastPeriodIncludeYear((String)this.getModelVo().number, (String)this.getCvtYearVo().number, (String)this.getCvtPeriodVo().number, (boolean)true);
        this.prePeriod = lastMonthPeriod[1];
        this.prePeriodFy = lastMonthPeriod[0];
    }

    @Override
    public ConvertFormulaEnum getConvertFormulaEnumByType(String type) {
        return this.convertFormulaType.get(type);
    }

    @Override
    public String[] getExchangeTypeFilter() {
        return this.exchangeTypeDefaultFilter;
    }

    @Override
    public String getRelaWithParentMemb() {
        if (StringUtils.isEmpty((String)this.orgRelaMemb)) {
            this.orgRelaMemb = new OrgRelaMembSupplier(this.getCvtOrgVo().id, this.getCvtOrgVo().number, this.getModelVo().id).access(this.getCvtOrgVo().number);
        }
        return this.orgRelaMemb;
    }

    @Override
    public void removeHasQueryAccountCvtExchange(Set<String> newList) {
        if (newList == null) {
            return;
        }
        newList.removeAll(this.acctExchangeCache.keySet());
    }

    @Override
    public void removeHasQueryChangeTypeChangeWay(Set<String> newList) {
        if (newList == null) {
            return;
        }
        newList.removeAll(this.changeTypeWayCache.keySet());
    }

    @Override
    public boolean isNeedMonitorDataStatus() {
        return this.isNeedMonitorDataStatus;
    }

    @Override
    public void setNeedMonitorDataStatus(boolean isMonitored) {
        this.isNeedMonitorDataStatus = isMonitored;
    }

    @Override
    public boolean isFirstPeriod() {
        return PeriodUtils.isFirstPeriod((String)this.getModelVo().number, (String)this.getCvtPeriodVo().number);
    }

    @Override
    public boolean filterRecord(Row row, String ... acctType) {
        return false;
    }

    @Override
    public <K, V> void put(K k, V v) {
        if (this.userDefineData == null) {
            this.userDefineData = new HashMap<Object, Object>(16);
        }
        this.userDefineData.put(k, v);
    }

    @Override
    public <K, V> V get(K k) {
        if (this.userDefineData == null) {
            return null;
        }
        return (V)this.userDefineData.get(k);
    }

    @Override
    public SimpleVo switchCvtCurrencyVo(SimpleVo newVal) {
        SimpleVo oldVal = this.cvtCurrVo;
        this.cvtCurrVo = newVal;
        return oldVal;
    }

    public void setTemplateId(Object templateId) {
        this.templateId = templateId;
    }

    @Override
    public Object getTemplateId() {
        return this.templateId;
    }

    @Override
    public List<String> getNoClearChangeType() {
        if (this.noclearChangeTypes == null) {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelVo().id);
            if (MemberReader.isExistChangeTypeDimension((String)this.getModelVo().number)) {
                qfBuilder.add("number", "in", (Object)new String[]{"BOP"});
            }
            qfBuilder.or("changeway", "=", (Object)ChangewayEnum.EARLYYEARTURN.index);
            this.noclearChangeTypes = BusinessDataServiceHelper.loadFromCache((String)"bcm_changetypemembertree", (String)"number", (QFilter[])qfBuilder.toArray()).values().stream().map(d -> d.getString("number")).collect(Collectors.toList());
        }
        return this.noclearChangeTypes;
    }

    @Override
    public String getConvertAudittrial() {
        return this.convertAudittrial;
    }

    @Override
    public String getCvtDiffAudittrial() {
        return this.cvtDiffAudittrial;
    }

    @Override
    public IDNumberTreeNode getEntityInputTraDif() {
        return this.entityInputTraDif;
    }

    @Override
    public boolean isConvertAll() {
        return true;
    }

    @Override
    public String getProcess() {
        return this.get("process") != null ? (String)this.get("process") : "Rpt";
    }

    private void initPcFlowStatus() {
        IDNumberTreeNode orgNode;
        Long orgId = this.getCvtOrgVo().id;
        String orgNumber = this.getCvtOrgVo().number;
        if (orgNumber.contains("_") && (orgNode = MemberReader.findEntityMemberByNum((String)this.getModelVo().number, (String)(orgNumber = orgNumber.split("_")[0]))).getId() > 0L) {
            orgId = orgNode.getId();
        }
        String currencyNum = this.getCvtCurrencyVo() == null ? this.getSrcCurrencyVo().number : this.getCvtCurrencyVo().number;
        this.status = McStatus.getMcStatusByCurrencyNumber(this.getModelVo().id, orgId, this.getScenarioVo().id, this.getCvtYearVo().id, this.getCvtPeriodVo().id, currencyNum);
        this.periodStatus = PeriodSettingHelper.checkPeriodStatus(this.getModelVo().id, orgNumber, this.getScenarioVo().id, this.getCvtYearVo().id, this.getCvtPeriodVo().id, "datastatus");
    }

    @Override
    public boolean checkECFlowStatusIsSubmit() {
        if (this.status == null) {
            this.initPcFlowStatus();
        }
        return !this.status.getFlow().isSubmit();
    }

    @Override
    public boolean checkPcFlowStatusIsSubmit() {
        if (this.status == null) {
            this.initPcFlowStatus();
        }
        return this.status.getPcFlow().isSubmit();
    }

    @Override
    public boolean checkPeriodStatusIsOpen() {
        if (this.periodStatus == null) {
            this.initPcFlowStatus();
        }
        return this.periodStatus;
    }

    public void setModelVo(SimpleVo modelVo) {
        this.modelVo = modelVo;
    }

    public void setCvtCurrVo(SimpleVo cvtCurrVo) {
        this.cvtCurrVo = cvtCurrVo;
    }

    public void setFixScopeParameter(FixScopeParameter fixScopeParameter) {
        this.fixScopeParameter = fixScopeParameter;
    }

    @Override
    public boolean parallelConvert() {
        if (this.parallelConvert == null) {
            return OrgRelaProcessMembPool.isRelaProcess((String)this.getProcess());
        }
        return this.parallelConvert;
    }

    public void setParallelConvert(Boolean parallelConvert) {
        this.parallelConvert = parallelConvert;
    }
}

