/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.ctx;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.formula.calculate.IExternalDataProvider;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.enums.CvtFactorEnum;

public class CvtDataProvider
implements IExternalDataProvider {
    private Map<String, Object> kvMap;
    private Recorder<CvtFactorExpress> crrFormula;
    private Recorder<Boolean> recorder;
    private ICvtContext _ctx;
    private int currencyIndex;

    public CvtDataProvider(ICvtContext _ctx, Map<String, Object> kvMap, Recorder<CvtFactorExpress> crrFormula, Recorder<Boolean> recorder, int currencyIndex) {
        this.kvMap = kvMap;
        this.crrFormula = crrFormula;
        this.recorder = recorder;
        this._ctx = _ctx;
        this.currencyIndex = currencyIndex;
    }

    @Override
    public Object get(String key) {
        CvtFactorEnum cvtenum = CvtFactorEnum.getCvtFactorEnumByName((String)key);
        if (cvtenum != null) {
            String srcNum = this._ctx.getSrcCurrencyVo().number;
            String orgNum = this._ctx.getRealOrgNum();
            String cvtCurr = ((CvtFactorExpress)this.crrFormula.getRecord()).getFactors().get(key).getParams()[this.currencyIndex];
            if (SysMembConstant.rateNumbers.contains(key)) {
                RateModel rm = ConvertUtil.getExchangeRateDetail(this._ctx.getBaseData(), orgNum, srcNum, cvtCurr);
                RateModel rateModel = rm;
                BigDecimal rate = rateModel.getRateByNumber(key);
                if (rate == null || BigDecimal.ZERO.compareTo(rate) == 0) {
                    return BigDecimal.ZERO;
                }
                return rateModel.isMultiply() ? rate : BigDecimal.ONE.divide(rate, 15, RoundingMode.HALF_UP);
            }
            if (SysMembConstant.preRateNumbers.contains(key)) {
                BaseData preBaseData = this._ctx.getBaseData().getPreBaseData();
                RateModel prerm = ConvertUtil.getExchangeRateDetail(preBaseData, orgNum, srcNum, cvtCurr);
                RateModel rateModel = prerm;
                BigDecimal rate = rateModel.getRateByNumber(key.replaceFirst("pre", ""));
                if (rate == null || BigDecimal.ZERO.compareTo(rate) == 0) {
                    return BigDecimal.ZERO;
                }
                return rateModel.isMultiply() ? rate : BigDecimal.ONE.divide(rate, 15, RoundingMode.HALF_UP);
            }
            if (this.kvMap == null || this.kvMap.size() == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal val = (BigDecimal)this.kvMap.get(String.join((CharSequence)"|", ((CvtFactorExpress)this.crrFormula.getRecord()).getFactors().get(key).getParams()));
            if (val != null) {
                this.recorder.setRecord((Object)Boolean.TRUE);
            }
            return val == null ? BigDecimal.ZERO : val;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public boolean containsKey(String key) {
        return CvtFactorEnum.getCvtFactorEnumByName((String)key) != null;
    }
}

