/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.ctx;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.formula.calculate.IExternalDataProvider;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.sql.util.QCfilterUtils;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class RateFormulaProvider
implements IExternalDataProvider {
    private ICalContext _ctx;
    private DynamicObject curobj;
    private Map<Long, List<DynamicObject>> data;
    private HashMap<String, DynamicObject> premap = new HashMap(16);

    public RateFormulaProvider(ICalContext _ctx) {
        this._ctx = _ctx;
        this.initPremap();
    }

    public void setCurobj(DynamicObject curobj) {
        this.curobj = curobj;
    }

    public List<DynamicObject> getData() {
        ArrayList<DynamicObject> origins = new ArrayList<DynamicObject>(this.data.size());
        if (LongUtil.isvalidLong((Object)this._ctx.getOrgId())) {
            origins.addAll((Collection)this.data.get(this._ctx.getOrgId()));
        } else {
            origins.addAll(this.data.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return origins;
    }

    public Map<Long, List<DynamicObject>> getOriginData() {
        return this.data;
    }

    public List<DynamicObject> getMainData() {
        ArrayList<DynamicObject> origins = new ArrayList<DynamicObject>(this.data.size());
        if (LongUtil.isvalidLong((Object)this._ctx.getOrgId())) {
            if (this.data.get(this._ctx.getOrgId()) != null) {
                origins.addAll(this.data.get(this._ctx.getOrgId()).stream().filter(s -> s.getLong("fromid") == 0L).collect(Collectors.toList()));
            }
        } else {
            origins.addAll(this.data.values().stream().flatMap(Collection::stream).filter(s -> s.getLong("fromid") == 0L).collect(Collectors.toList()));
        }
        return origins;
    }

    public void setOriginData(Map<Long, List<DynamicObject>> data) {
        this.data = data;
    }

    public String getCurKey() {
        return this.curobj.getString("entity.id") + "-" + this.curobj.getString("source.id") + "-" + this.curobj.getString("target.id");
    }

    private void initPremap() {
        DynamicObjectCollection pres = this.getPreFyAndPeriodObj();
        pres.stream().forEach(s -> this.premap.put(s.getString("entity") + "-" + s.getString("source") + "-" + s.getString("target"), (DynamicObject)s));
    }

    private DynamicObjectCollection getPreFyAndPeriodObj() {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this._ctx.getModelId());
        qfBuilder.and(new QFBuilder("scene", "=", (Object)this._ctx.getScenarioId()));
        QFBuilder builder = QCfilterUtils.getFyAndPeriodFilter(this._ctx.getModelId().toString(), this._ctx.getYearId().toString(), this._ctx.getPeriodId().toString(), "-1");
        qfBuilder.and(builder);
        Set ratefields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        return QueryServiceHelper.query((String)"bcm_exchagerate", (String)String.join((CharSequence)",", ratefields), (QFilter[])qfBuilder.toArray());
    }

    @Override
    public Object get(String key) {
        CvtFactorEnum cvtenum = CvtFactorEnum.getCvtFactorEnumByName((String)key);
        Long formId = this.curobj.getLong("fromid");
        BigDecimal result = BigDecimal.ZERO;
        if (cvtenum != null) {
            if (SysMembConstant.rateNumbers.contains(key)) {
                String realNumber = ExchangeRateShareSceneHelper.getRealRateNumber(key);
                result = formId == 0L ? this.curobj.getBigDecimal(realNumber) : this.getMutualVaule(formId, realNumber);
            } else if (SysMembConstant.preRateNumbers.contains(key)) {
                DynamicObject preobj = this.premap.get(this.getCurKey());
                if (preobj != null) {
                    String realNumber = ExchangeRateShareSceneHelper.getRealRateNumber(key.replaceFirst("pre", ""));
                    result = formId == 0L ? preobj.getBigDecimal(realNumber) : this.getMutualVaule(formId, realNumber);
                }
            } else if ("CurYearAvgRate".equalsIgnoreCase(key)) {
                result = this.calPresetRate(this.curobj, formId);
            }
            return result;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calPresetRate(DynamicObject curobj, Long formId) {
        BigDecimal beginY = curobj.getBigDecimal("beginyear");
        Long modelId = curobj.getLong("model.id");
        Long sceneId = curobj.getLong("scene.id");
        Long fyId = curobj.getLong("fy.id");
        Long entityId = curobj.getLong("entity.id");
        String periodNumber = curobj.getString("period.number");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Optional node = PeriodUtils.getNodeByNumber((String)modelNumber, (String)periodNumber);
        if (node.isPresent()) {
            String relatedNumber = (String)((IDNumberTreeNode)node.get()).getProperty("relatednumber");
            periodNumber = StringUtils.isNotEmpty((String)relatedNumber) ? relatedNumber : periodNumber;
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and("scene", "=", (Object)sceneId);
        qfBuilder.and("fy", "=", (Object)fyId);
        qfBuilder.and("period.number", "<=", (Object)periodNumber);
        qfBuilder.and("period.isadjust", "=", (Object)"0");
        qfBuilder.and("entity", "=", (Object)entityId);
        qfBuilder.and("source", "=", (Object)curobj.getLong("source.id"));
        qfBuilder.and("target", "=", (Object)curobj.getLong("target.id"));
        DynamicObjectCollection obj = QueryServiceHelper.query((String)"bcm_exchagerate", (String)"period.number,periodend", (QFilter[])qfBuilder.toArray(), (String)"period");
        int count = Integer.parseInt(periodNumber.substring(3)) + 1;
        BigDecimal sum = obj.stream().map(s -> s.getBigDecimal("periodend")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal result = this.getMutualVaule(beginY.add(sum), BigDecimal.valueOf(count));
        if (result == BigDecimal.ZERO) {
            return BigDecimal.ZERO;
        }
        return formId == 0L ? result : this.getMutualVaule(BigDecimal.ONE, result);
    }

    public DynamicObject getMutualObj(Long id) {
        Optional<DynamicObject> optional = this.getData().stream().filter(s -> s.getLong("fromid") == id.longValue()).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    @Override
    public boolean containsKey(String key) {
        return CvtFactorEnum.getCvtFactorEnumByName((String)key) != null;
    }

    private BigDecimal getMutualVaule(Long formId, String realNumber) {
        DynamicObject mutualobj = this.getCurObj(formId);
        if (mutualobj == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal obj = mutualobj.getBigDecimal(realNumber);
        if (obj.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.ONE.divide(obj, 15, RoundingMode.HALF_UP);
    }

    private BigDecimal getMutualVaule(BigDecimal one, BigDecimal originValue) {
        if (originValue.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return one.divide(originValue, 15, RoundingMode.HALF_UP);
    }

    public DynamicObject getCurObj(Long id) {
        Optional<DynamicObject> optional = this.getData().stream().filter(s -> s.getLong("id") == id.longValue()).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static int getPrecision(DynamicObject obj) {
        if (obj.get("precision") == null || obj.getInt("precision") == 0) {
            return 0;
        }
        if (obj.getInt("precision") > 15) {
            return 15;
        }
        return obj.getInt("precision");
    }
}

