/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.ctx;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import kd.fi.bcm.business.convert.ctx.CvtContext;
import kd.fi.bcm.business.convert.ctx.FixScopeParameter;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.ConvertScopeUtil;

public class ReportCvtContext
extends CvtContext {
    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, Object templateId) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
        this.addOtherScope(TemplateServiceHelper.getTemplateModelById(templateId));
    }

    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter, TemplateModel model) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
        this.addOtherScope(model);
    }

    public ReportCvtContext(SimpleVo modelVo, SimpleVo cvtCurrVo, FixScopeParameter fixScopeParameter) {
        super(modelVo, cvtCurrVo, fixScopeParameter);
    }

    protected void addCommonScope(TemplateModel model) {
        this.setTemplateId(model.getId());
        model.getViewPointDimensionEntries().forEach(v -> {
            String dimNum = v.getDimension().getNumber();
            if (!this.containsScope(dimNum)) {
                this.addScope(v.getDimension().getNumber(), (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)this.toStringArray(v.getMember().getNumber())));
            }
        });
        model.getPageDimensionEntries().forEach(p -> {
            String dimNum = p.getDimension().getNumber();
            if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                ArrayList scopeMembs = new ArrayList(10);
                p.getMembers().forEach(m -> new MembRangeItem(m.getDataEntityNumber(), (Long)m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)model.getModelId()).matchItems(c -> scopeMembs.add(c.number)));
                if (!scopeMembs.isEmpty()) {
                    this.addScope(dimNum, (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)scopeMembs.toArray(new String[0])));
                }
            }
        });
        model.getPagePropEntries().forEach(p -> {
            String dimNum = p.getDimension().getNumber();
            if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                ArrayList scopeMembs = new ArrayList(10);
                p.getAllMembProperties().forEach(m -> new MembRangeItem(p.getDimension().getMemberEntityNumber(), (Long)m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), true, (Object)model.getModelId()).matchItems(c -> scopeMembs.add(c.number)));
                if (!scopeMembs.isEmpty()) {
                    this.addScope(dimNum, (Pair<String, String[]>)Pair.onePair((Object)dimNum, (Object)scopeMembs.toArray(new String[0])));
                }
            }
        });
    }

    private void addOtherScope(TemplateModel model) {
        boolean isFalse = false;
        this.addCommonScope(model);
        HashMultimap set = HashMultimap.create();
        Recorder hasCross = new Recorder((Object)isFalse);
        model.getAreaRangeEntries().forEach(e -> {
            e.getRowDimEntries().forEach(r -> {
                String dimNum = r.getDimension().getNumber();
                if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                    r.getMembers().forEach(m -> set.put((Object)r.getDimension().getNumber(), (Object)m.getNumber()));
                }
            });
            e.getColDimEntries().forEach(c -> {
                String dimNum = c.getDimension().getNumber();
                if (!this.containsScope(dimNum) && this.isIncludeDim(dimNum)) {
                    c.getMembers().forEach(m -> set.put((Object)c.getDimension().getNumber(), (Object)m.getNumber()));
                }
            });
            if (!((Boolean)hasCross.getRecord()).booleanValue()) {
                hasCross.setRecord((Object)(!e.getRowDimEntries().isEmpty() && !e.getColDimEntries().isEmpty() ? 1 : 0));
            }
        });
        if (set.isEmpty() && !((Boolean)hasCross.getRecord()).booleanValue()) {
            this.setWillBeNotConvert();
        } else {
            set.asMap().forEach((key, value) -> this.addScope((String)key, (Pair<String, String[]>)Pair.onePair((Object)key, (Object)value.toArray(new String[0]))));
        }
        if (MemberReader.isExistChangeTypeDimension((long)model.getModelId())) {
            this.removeScope(DimTypesEnum.CHANGETYPE.getNumber());
        }
    }

    protected boolean isIncludeDim(String dimNum) {
        return ConvertScopeUtil.isIncludeDim((String)dimNum);
    }

    @Override
    public boolean isConvertAll() {
        return false;
    }
}

