/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.extend;

import java.util.Objects;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class ConvertBaseUnit {
    private BaseData baseData;
    private SimpleVo org;
    private String targetCurrency;
    private String process;

    public ConvertBaseUnit(BaseData baseData, SimpleVo org, String process, String targetCurrency) {
        this.baseData = baseData;
        this.org = org;
        this.process = process;
        this.targetCurrency = targetCurrency;
    }

    public ConvertBaseUnit(Long modelId, String sceneNum, String fyNum, String periodNum, SimpleVo org, String process, String orginCurrency, String targetCurrency) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNum, (String)sceneNum);
        IDNumberTreeNode fyNode = MemberReader.findFyMemberByNum((String)modelNum, (String)fyNum);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum);
        this.baseData = new BaseData(modelId, sceneNode, fyNode, periodNode);
        this.org = org;
        this.process = process;
        this.targetCurrency = targetCurrency;
    }

    public SimpleVo getOrg() {
        return this.org;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public String getProcess() {
        return this.process;
    }

    public int hashCode() {
        return Objects.hashCode(this.baseData.toString() + this.org + this.process + this.targetCurrency);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConvertBaseUnit) {
            ConvertBaseUnit other = (ConvertBaseUnit)obj;
            return Objects.equals(other.baseData, this.baseData) && Objects.equals(other.org, this.org) && Objects.equals(other.process, this.process) && Objects.equals(other.targetCurrency, this.targetCurrency);
        }
        return super.equals(obj);
    }

    public BaseData getBaseData() {
        return this.baseData;
    }
}

