/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.extend;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.extend.ConvertBaseUnit;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;

public class ConvertUnitsUtil {
    private Map<String, Boolean> periodMap = new HashMap<String, Boolean>(16);
    private Map<Long, McStatus> statusMap;
    private Set<ConvertBaseUnit> convertBaseUnits = new HashSet<ConvertBaseUnit>(16);

    public void addConvertBaseUnit(ConvertBaseUnit baseUnit) {
        this.convertBaseUnits.add(baseUnit);
    }

    public Set<String> batchConvert() {
        ArrayList<Callable<Set>> tasks = new ArrayList<Callable<Set>>(this.convertBaseUnits.size());
        HashSet<String> result = new HashSet<String>(this.convertBaseUnits.size());
        for (ConvertBaseUnit s2 : this.convertBaseUnits) {
            BaseData baseData = s2.getBaseData();
            Long modelId = baseData.getModel().id;
            String sceneNum = baseData.getScene().number;
            String fyNum = baseData.getYear().number;
            String periodNum = baseData.getPeriod().number;
            String entityNum = s2.getOrg().number;
            String processNum = s2.getProcess();
            String cvtCurrency = s2.getTargetCurrency();
            tasks.add(() -> ConvertServiceHelper.convert4ProcessSpilt(modelId, sceneNum, fyNum, periodNum, entityNum, processNum, cvtCurrency, true));
        }
        if (tasks.size() > 0) {
            List results = ThreadPoolService.runInConvertWaiting4Thread(tasks.toArray(new Callable[0]));
            results.forEach(s -> result.addAll((Collection<String>)s));
        }
        return result;
    }

    public void initData() {
        Map<BaseData, List<ConvertBaseUnit>> sorteBaseUnitsdMap = this.convertBaseUnits.stream().collect(Collectors.groupingBy(s -> s.getBaseData()));
        for (Map.Entry<BaseData, List<ConvertBaseUnit>> baseUnits : sorteBaseUnitsdMap.entrySet()) {
            BaseData baseData = baseUnits.getKey();
            List<ConvertBaseUnit> convertBaseUnits = baseUnits.getValue();
            if (convertBaseUnits == null || convertBaseUnits.isEmpty()) continue;
            Long modelId = baseData.getModel().id;
            Long sceneId = baseData.getScene().id;
            Long periodId = baseData.getPeriod().id;
            Long fyId = baseData.getYear().id;
            Boolean periodOpen = ConfigServiceHelper.getBoolParam(modelId, "CM012");
            Map<String, List<ConvertBaseUnit>> groupedData = convertBaseUnits.stream().collect(Collectors.groupingBy(s -> s.getTargetCurrency()));
            for (Map.Entry<String, List<ConvertBaseUnit>> data : groupedData.entrySet()) {
                List<ConvertBaseUnit> groupUnits = data.getValue();
                if (groupUnits == null || groupUnits.isEmpty()) continue;
                Set<String> orgNums = groupUnits.stream().map(s -> s.getOrg().number).collect(Collectors.toSet());
                Set<Long> orgIds = groupUnits.stream().map(s -> s.getOrg().id).collect(Collectors.toSet());
                if (orgIds == null || orgIds.isEmpty()) continue;
                ExchangeQueryHelper.getMultiRateDatasByOrgIds(baseData, orgIds, new ArrayList<String>(), new ArrayList<String>());
                this.statusMap = MergeStatusHelper.batchGetMcStatus(modelId, sceneId, fyId, periodId, orgIds, data.getKey());
                for (ConvertBaseUnit convertBaseUnit : groupUnits) {
                    McStatus status = this.statusMap.get(convertBaseUnit.getOrg().id);
                    if (status != null && status.getPcFlow().isSubmit()) {
                        convertBaseUnits.remove(convertBaseUnit);
                    }
                    if (!periodOpen.booleanValue()) continue;
                    Map<String, Boolean> originPeriodMap = PeriodSettingHelper.batchCheckPeriodStatus2(modelId, orgNums, Sets.newHashSet((Object[])new Long[]{sceneId}), Sets.newHashSet((Object[])new Long[]{fyId}), Sets.newHashSet((Object[])new Long[]{periodId}), "datastatus");
                    originPeriodMap.forEach((k, v) -> {
                        String[] keys = k.split("\\;");
                        this.periodMap.put(keys[0], (Boolean)v);
                    });
                    if (this.periodMap.get(convertBaseUnit.getOrg().number) != null && this.periodMap.get(convertBaseUnit.getOrg().number) != Boolean.FALSE) continue;
                    convertBaseUnits.remove(convertBaseUnit);
                }
            }
        }
    }
}

