/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.extend;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.extend.ExtConvertBaseUnit;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.util.CollectionUtil;

public class ExtConvertUnitsUtil {
    private final List<ExtConvertBaseUnit> extConvertBaseUnits;
    private Map<Long, ExtendsModel> extendsModelMap;
    private Boolean isPeriodOpenValid = Boolean.FALSE;
    private final Map<String, Boolean> periodMap = new HashMap<String, Boolean>(16);
    private Map<Long, McStatus> statusMap;

    public ExtConvertUnitsUtil(List<ExtConvertBaseUnit> extConvertBaseUnits) {
        this.extConvertBaseUnits = extConvertBaseUnits;
        this.initExtModels();
        this.initStatus();
        this.initRateData();
    }

    public List<ExtConvertBaseUnit> getEffectiveExtConvertBaseUnit() {
        this.extConvertBaseUnits.removeIf(s -> {
            if (!this.getOrgPeriodStatusByNum(s.getOrg().number).booleanValue()) {
                return true;
            }
            return this.getOrgCvtCurrencyStatusById(s.getOrg().id);
        });
        return this.extConvertBaseUnits;
    }

    public Map<SimpleVo, Collection<SimpleVo>> groupByExtModelOrgs() {
        HashMultimap extModelOrgs = HashMultimap.create();
        this.getEffectiveExtConvertBaseUnit().forEach(arg_0 -> ExtConvertUnitsUtil.lambda$groupByExtModelOrgs$2((Multimap)extModelOrgs, arg_0));
        return extModelOrgs.asMap();
    }

    public String getTargetCurrency() {
        if (this.extConvertBaseUnits == null || this.extConvertBaseUnits.isEmpty()) {
            return "";
        }
        return this.extConvertBaseUnits.get(0).getTargetCurrency();
    }

    public BaseData getBaseData() {
        if (this.extConvertBaseUnits == null || this.extConvertBaseUnits.isEmpty()) {
            return BaseData.EMPTY_BASEDATA;
        }
        return this.extConvertBaseUnits.get(0).getBaseData();
    }

    private void initExtModels() {
        if (this.extConvertBaseUnits == null || this.extConvertBaseUnits.isEmpty()) {
            return;
        }
        HashSet extModels = new HashSet(16);
        this.extConvertBaseUnits.forEach(s -> extModels.addAll(s.getExtModels()));
        Set<Long> extModelIds = extModels.stream().map(s -> s.id).collect(Collectors.toSet());
        this.extendsModelMap = ExtDataUtil.initExtendsModels(extModelIds);
    }

    public ExtendsModel getExtModelById(Long extModelId) {
        if (this.extendsModelMap == null || this.extendsModelMap.get(extModelId) == null) {
            return new ExtendsModel(extModelId);
        }
        return this.extendsModelMap.get(extModelId);
    }

    private void initStatus() {
        if (this.extConvertBaseUnits == null || this.extConvertBaseUnits.isEmpty()) {
            return;
        }
        BaseData baseData = this.getBaseData();
        Long modelId = baseData.getModel().id;
        Long sceneId = baseData.getScene().id;
        Long periodId = baseData.getPeriod().id;
        Long fyId = baseData.getYear().id;
        Set<String> orgNums = this.extConvertBaseUnits.stream().map(s -> s.getOrg().number).collect(Collectors.toSet());
        Set<Long> orgIds = this.extConvertBaseUnits.stream().map(s -> s.getOrg().id).collect(Collectors.toSet());
        this.statusMap = MergeStatusHelper.batchGetMcStatus(modelId, sceneId, fyId, periodId, orgIds, this.getTargetCurrency());
        this.isPeriodOpenValid = ConfigServiceHelper.getBoolParam(modelId, "CM012");
        if (!this.isPeriodOpenValid.booleanValue()) {
            return;
        }
        Map<String, Boolean> originPeriodMap = PeriodSettingHelper.batchCheckPeriodStatus2(modelId, orgNums, Sets.newHashSet((Object[])new Long[]{sceneId}), Sets.newHashSet((Object[])new Long[]{fyId}), Sets.newHashSet((Object[])new Long[]{periodId}), "datastatus");
        originPeriodMap.forEach((k, v) -> {
            String[] keys = k.split("\\;");
            this.periodMap.put(keys[0], (Boolean)v);
        });
    }

    private void initRateData() {
        if (this.extConvertBaseUnits == null || this.extConvertBaseUnits.isEmpty()) {
            return;
        }
        BaseData baseData = this.getBaseData();
        HashSet<SimpleVo> orgs = new HashSet<SimpleVo>(this.extConvertBaseUnits.size());
        this.extConvertBaseUnits.forEach(s -> orgs.add(s.getOrg()));
        if (CollectionUtil.isEmpty(orgs)) {
            return;
        }
        ExchangeQueryHelper.getMultiRateDatas(baseData, orgs, new ArrayList<String>(), new ArrayList<String>());
    }

    public Boolean getOrgPeriodStatusByNum(String orgNum) {
        if (!this.isPeriodOpenValid.booleanValue()) {
            return Boolean.TRUE;
        }
        Boolean result = this.periodMap.get(orgNum);
        return result == null ? Boolean.FALSE : result;
    }

    public Boolean getOrgCvtCurrencyStatusById(Long orgId) {
        McStatus status = this.statusMap.get(orgId);
        if (status != null && status.getPcFlow().isSubmit()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static /* synthetic */ void lambda$groupByExtModelOrgs$2(Multimap extModelOrgs, ExtConvertBaseUnit s) {
        s.getExtModels().forEach(v -> extModelOrgs.put(v, (Object)s.getOrg()));
    }
}

