/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.factor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class CvtDiffModel {
    private String leftformla;
    private ExpressStatus rightStatus;
    private Map<String, ExpressStatus> ternaryStatus;
    private BigDecimal rightresult;
    private String accountNumber;
    private String changeTypeNumber;
    private String[] leftParams;
    private List<String> userDefinedDim = new ArrayList<String>(10);

    public CvtDiffModel(String leftformla, ExpressStatus rightStatus, ICvtContext ctx, Map<String, Integer> dimOrderMap) {
        this.leftformla = leftformla;
        this.rightStatus = rightStatus;
        this.initDefinedDim(ctx);
        this.makeUpLeftParams(ctx, dimOrderMap);
    }

    public CvtDiffModel(String leftformla, Map<String, ExpressStatus> ternaryStatus, ICvtContext ctx, Map<String, Integer> dimOrderMap) {
        this.leftformla = leftformla;
        this.ternaryStatus = ternaryStatus;
        this.initDefinedDim(ctx);
        this.makeUpLeftParams(ctx, dimOrderMap);
    }

    private void initDefinedDim(ICvtContext ctx) {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber,dseq,issysdimension", (QFilter[])new QFBuilder().add("model.number", "=", (Object)ctx.getModelVo().number).toArray()).values().forEach(e -> {
            if (!e.getBoolean("issysdimension")) {
                this.userDefinedDim.add(e.getString("shortnumber"));
            }
        });
    }

    public boolean setRightresult(CalculateService service) {
        boolean is = true;
        try {
            boolean ifValue;
            this.rightresult = this.rightStatus != null ? new BigDecimal(service.evalExpress(this.rightStatus).toString()) : ((ifValue = ((Boolean)service.evalExpress(this.ternaryStatus.get("first"))).booleanValue()) ? new BigDecimal(service.evalExpress(this.ternaryStatus.get("second")).toString()) : new BigDecimal(service.evalExpress(this.ternaryStatus.get("third")).toString()));
        }
        catch (Exception e) {
            this.rightresult = BigDecimal.ZERO;
            is = false;
        }
        return is;
    }

    public BigDecimal getRightresult() {
        return this.rightresult;
    }

    public String getLeftAccountNumber() {
        return this.accountNumber;
    }

    public String getLeftChangeTypeNumber() {
        return this.changeTypeNumber;
    }

    public String[] getLeftParams() {
        return this.leftParams;
    }

    private void makeUpLeftParams(ICvtContext _ctx, Map<String, Integer> dimOrderMap) {
        String[] split = this.leftformla.replaceAll("V\\(", "").replaceAll("\\)", "").replaceAll("\"", "").split(",");
        ArrayList<String> all = new ArrayList<String>(10);
        all.addAll(Arrays.asList(split));
        if (!this.leftformla.contains("\"FY.")) {
            all.add("FY." + _ctx.getCvtYearVo().number);
        }
        if (!this.leftformla.contains("\"P.")) {
            all.add("P." + _ctx.getCvtPeriodVo().number);
        }
        if (dimOrderMap.containsKey("MC") && !this.leftformla.contains("\"MC.")) {
            all.add("MC." + _ctx.getCvtOrgVo().number);
        }
        all.removeIf(a -> {
            String[] s = VFormula.splitDimAndMemb(a);
            return DimTypesEnum.SCENARIO.getShortNumber().equals(s[0]) || DimTypesEnum.ENTITY.getShortNumber().equals(s[0]) || DimTypesEnum.CURRENCY.getShortNumber().equals(s[0]);
        });
        all.sort((p1, p2) -> {
            String s1 = VFormula.splitDimAndMemb(p1)[0];
            String s2 = VFormula.splitDimAndMemb(p2)[0];
            return (Integer)dimOrderMap.get(s1) - (Integer)dimOrderMap.get(s2);
        });
        ArrayList params = new ArrayList(10);
        HashSet dimKeys = new HashSet(16);
        all.forEach(a -> {
            String[] s = VFormula.splitDimAndMemb(a);
            boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((String)_ctx.getModelVo().number);
            boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((String)_ctx.getModelVo().number);
            if (DimTypesEnum.AUDITTRIAL.getShortNumber().equals(s[0]) && existAuditTrailDimension) {
                params.add(_ctx.getCvtDiffAudittrial());
            } else {
                params.add(s[1]);
            }
            if (DimTypesEnum.ACCOUNT.getShortNumber().equals(s[0])) {
                this.accountNumber = s[1];
            } else if (DimTypesEnum.CHANGETYPE.getShortNumber().equals(s[0]) && existChangeTypeDimension) {
                this.changeTypeNumber = s[1];
            }
            dimKeys.add(s[0]);
        });
        this.userDefinedDim.forEach(u -> {
            if (!dimKeys.contains(u)) {
                params.add(u + "None");
            }
        });
        this.leftParams = params.toArray(new String[0]);
    }
}

