/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.factor;

import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.convert.factor.CvtFactor;

public class CvtFactorExpress {
    private Map<String, CvtFactor> factors = new HashMap<String, CvtFactor>(16);
    private String formula;

    public CvtFactorExpress(CvtFactor first) {
        this.factors.put(first.output(), first);
        this.formula = first.output();
    }

    public CvtFactorExpress(String formula) {
        this.formula = formula;
    }

    public CvtFactorExpress add(CvtFactor f) {
        this.factors.put(f.output(), f);
        this.append2Formula(f, "+");
        return this;
    }

    public CvtFactorExpress append(CvtFactor f) {
        this.factors.put(f.output(), f);
        this.append2Formula(f);
        return this;
    }

    public void appendOnlyFactor(CvtFactor f) {
        this.factors.put(f.output(), f);
    }

    public CvtFactorExpress subtract(CvtFactor f) {
        this.factors.put(f.output(), f);
        this.append2Formula(f, "-");
        return this;
    }

    public CvtFactorExpress multiply(CvtFactor f) {
        this.factors.put(f.output(), f);
        this.append2Formula(f, "*");
        return this;
    }

    public CvtFactorExpress divide(CvtFactor f) {
        this.factors.put(f.output(), f);
        this.append2Formula(f, "/");
        return this;
    }

    public CvtFactorExpress addSign(String sign) {
        this.formula = this.formula + sign;
        return this;
    }

    public Map<String, CvtFactor> getFactors() {
        return this.factors;
    }

    private void append2Formula(CvtFactor f, String oprt) {
        this.formula = this.formula + oprt + f.output();
    }

    private void append2Formula(CvtFactor f) {
        this.formula = this.formula + f.output();
    }

    public String getFormula() {
        return this.formula;
    }
}

