/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.factor;

import java.util.Objects;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.common.PresetConstant;

public class CvtFactorParser {
    public static String[] parseParamsByFactor(CvtFactor factor, MDResultSetMetaData metadata, ICvtContext ctx) {
        String[] params = factor.getParams();
        String convertAudittrial = ctx.getConvertAudittrial();
        String beforeConvertAudittrial = convertAudittrial != null ? "ATTotal" : null;
        switch (factor.getFactor()) {
            case PeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PeriodSumCvtAmount: 
            case PeriodInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case PeriodAdjCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ADJE", metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "RAdj", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PeriodYDTSumAmount: 
            case PeriodYDTInputAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PreYDTSumCvtAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PeriodYDTSumCvtAmount: 
            case PeriodYDTInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case EndPeriodInputCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case EndPeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PreEndPeriodSumCvtAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PreBeginYSumCvtAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case BeginYSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case BflySumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BFLY", metadata);
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case BeginYSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BBOY", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PreEndPeriodSumAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayChangeTypeBy(params, "EndingBalance", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PeriodYDTAdjAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayAudittrialBy(params, "ADJE", metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "RAdj", metadata, ctx);
                break;
            }
            case Rate: 
            case PreRate: 
            case BOYRate: 
            case BOYAverageRate: 
            case BOYUserdefinedRate: 
            case ClosingRate: 
            case AverageRate: 
            case UserdefinedRate: 
            case BOYUserdefinedRate1: 
            case UserdefinedRate1: 
            case BOYUserdefinedRate2: 
            case UserdefinedRate2: 
            case BOYUserdefinedRate3: 
            case UserdefinedRate3: 
            case BOYUserdefinedRate4: 
            case UserdefinedRate4: 
            case BOYUserdefinedRate5: 
            case UserdefinedRate5: 
            case BOYUserdefinedRate6: 
            case UserdefinedRate6: 
            case BOYUserdefinedRate7: 
            case UserdefinedRate7: 
            case BOYUserdefinedRate8: 
            case UserdefinedRate8: 
            case BOYUserdefinedRate9: 
            case UserdefinedRate9: 
            case BOYUserdefinedRate10: 
            case UserdefinedRate10: {
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case preBOYRate: 
            case preBOYAverageRate: 
            case preBOYUserdefinedRate: 
            case preClosingRate: 
            case preAverageRate: 
            case preUserdefinedRate: 
            case preBOYUserdefinedRate1: 
            case preUserdefinedRate1: 
            case preBOYUserdefinedRate2: 
            case preUserdefinedRate2: 
            case preBOYUserdefinedRate3: 
            case preUserdefinedRate3: 
            case preBOYUserdefinedRate4: 
            case preUserdefinedRate4: 
            case preBOYUserdefinedRate5: 
            case preUserdefinedRate5: 
            case preBOYUserdefinedRate6: 
            case preUserdefinedRate6: 
            case preBOYUserdefinedRate7: 
            case preUserdefinedRate7: 
            case preBOYUserdefinedRate8: 
            case preUserdefinedRate8: 
            case preBOYUserdefinedRate9: 
            case preUserdefinedRate9: 
            case preBOYUserdefinedRate10: 
            case preUserdefinedRate10: {
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                break;
            }
            case PreYDTAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PreYDTCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PeriodYDTAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PeriodYDTCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "YTD", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case PeriodCurrPeriodAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case PeriodCurrPeriodCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "CurrentPeriod", metadata);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case beginPeriodSumAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BOP", metadata);
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getSrcCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case beginPeriodInputCvtAmount: 
            case beginPeriodSumCvtAmount: {
                CvtFactorParser.replayChangeTypeBy(params, "BOP", metadata);
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case CurrPeriodSumAmount: {
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                break;
            }
            case CurrPeriodSumCvtAmount: 
            case CurrInputCvtAmount: {
                CvtFactorParser.replayAudittrialBy(params, convertAudittrial, metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "IRpt", metadata, ctx);
                break;
            }
            case PrePeriodSumCvtAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayAudittrialBy(params, "ATTotal", metadata, ctx);
                CvtFactorParser.replayCurrencyBy(params, ctx.getCvtCurrencyVo().number, metadata);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            case PrePeriodSumAmount: {
                if (ctx.getFyOfPrePeriod() == null) {
                    factor.setEffective(false);
                    break;
                }
                CvtFactorParser.replayAudittrialBy(params, beforeConvertAudittrial, metadata, ctx);
                CvtFactorParser.replayProcessBy(params, "Rpt", metadata, ctx);
                CvtFactorParser.replayPeriodBy(params, ctx.getFyOfPrePeriod(), ctx.getPrePeriod(), metadata, ctx.getModelVo().number);
                break;
            }
            default: {
                throw new CvtExchangeException(String.format("not support CvtFactor:%s", factor.getFactor().name()));
            }
        }
        factor.setParams(params);
        return params;
    }

    public static void replaceBy(String[] src, int idx, String instr) {
        src[idx] = instr;
    }

    public static void replayCurrencyBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.CURRENCY_DIM), instr);
    }

    public static void replayPeriodBy(String[] src, String instrFy, String instrPeriod, MDResultSetMetaData metadata, String modelNumber) {
        String year = src[metadata.getColIndex(PresetConstant.FY_DIM)];
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.PERIOD_DIM), instrPeriod);
        if (!Objects.equals(instrFy, year)) {
            CvtFactorParser.replayFyBy(src, instrFy, metadata);
        }
    }

    public static void replayFyBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.FY_DIM), instr);
    }

    public static void replayChangeTypeBy(String[] src, String instr, MDResultSetMetaData metadata) {
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.CHANGETYPE_DIM), instr);
    }

    public static void replayAudittrialBy(String[] src, String instr, MDResultSetMetaData metadata, ICvtContext ctx) {
        if (ctx.get("isGenConvertor") != null && ((Boolean)ctx.get("isGenConvertor")).booleanValue() || ctx.parallelConvert() || ctx.getConvertAudittrial() == null) {
            return;
        }
        if (instr != null) {
            CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.AUDITTRIAL_DIM), instr);
        }
    }

    public static void replayProcessBy(String[] src, String instr, MDResultSetMetaData metadata, ICvtContext ctx) {
        if (ctx.get("isGenConvertor") != null && ((Boolean)ctx.get("isGenConvertor")).booleanValue() || ctx.parallelConvert()) {
            return;
        }
        CvtFactorParser.replaceBy(src, metadata.getColIndex(PresetConstant.PROCESS_DIM), instr);
    }

    public static String getParamValueByMetaData(String[] params, String dimNum, MDResultSetMetaData metadata) {
        return params[metadata.getColIndex(dimNum)];
    }
}

