/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.query;

import java.util.Objects;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class BaseData {
    public static BaseData EMPTY_BASEDATA = new BaseData(new SimpleVo("", 0L), new SimpleVo("", 0L), new SimpleVo("", 0L), new SimpleVo("", 0L));
    private SimpleVo model;
    private SimpleVo scene;
    private SimpleVo year;
    private SimpleVo period;

    public BaseData(SimpleVo model, SimpleVo scene, SimpleVo year, SimpleVo period) {
        this.model = model;
        this.scene = scene;
        this.year = year;
        this.period = period;
    }

    public BaseData(ICvtContext context) {
        this.model = context.getModelVo();
        this.scene = context.getScenarioVo();
        this.year = context.getCvtYearVo();
        this.period = context.getCvtPeriodVo();
    }

    public BaseData(FixedItem context) {
        this.model = SimpleVo.newOne(context.getModel());
        this.scene = SimpleVo.newOne(context.getScenario());
        this.year = SimpleVo.newOne(context.getFy());
        this.period = SimpleVo.newOne(context.getPeriod());
    }

    public BaseData(Long modelId, Pair<Long, String> scene, Pair<Long, String> year, Pair<Long, String> period) {
        this.model = new SimpleVo(this.getCube(modelId), modelId);
        this.scene = new SimpleVo((String)scene.p2, (Long)scene.p1);
        this.year = new SimpleVo((String)year.p2, (Long)year.p1);
        this.period = new SimpleVo((String)period.p2, (Long)period.p1);
    }

    public BaseData(Long modelId, SimpleItem scene, SimpleItem year, SimpleItem period) {
        this.model = new SimpleVo(this.getCube(modelId), modelId);
        this.scene = new SimpleVo(scene.getNumber(), (Long)scene.getId());
        this.year = new SimpleVo(year.getNumber(), (Long)year.getId());
        this.period = new SimpleVo(period.getNumber(), (Long)period.getId());
    }

    public BaseData(String cube, IDNumberTreeNode scene, IDNumberTreeNode year, IDNumberTreeNode period) {
        Long modelId = MemberReader.findModelIdByNum((String)cube);
        this.model = new SimpleVo(cube, modelId);
        this.scene = new SimpleVo(scene.getNumber(), scene.getId());
        this.year = new SimpleVo(year.getNumber(), year.getId());
        this.period = new SimpleVo(period.getNumber(), period.getId());
    }

    public BaseData(Long modelId, IDNumberTreeNode scene, IDNumberTreeNode year, IDNumberTreeNode period) {
        this.model = new SimpleVo(this.getCube(modelId), modelId);
        this.scene = new SimpleVo(scene.getNumber(), scene.getId());
        this.year = new SimpleVo(year.getNumber(), year.getId());
        this.period = new SimpleVo(period.getNumber(), period.getId());
    }

    public BaseData(Long modelId, Long sceneId, Long yearId, Long periodId) {
        IDNumberTreeNode snode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        IDNumberTreeNode fnode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        IDNumberTreeNode pnode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        this.model = new SimpleVo(this.getCube(modelId), modelId);
        this.scene = new SimpleVo(snode.getNumber(), snode.getId());
        this.year = new SimpleVo(fnode.getNumber(), fnode.getId());
        this.period = new SimpleVo(pnode.getNumber(), pnode.getId());
    }

    public SimpleVo getModel() {
        return this.model;
    }

    public void setModel(SimpleVo model) {
        this.model = model;
    }

    public SimpleVo getScene() {
        return this.scene;
    }

    public void setScene(SimpleVo scene) {
        this.scene = scene;
    }

    public SimpleVo getYear() {
        return this.year;
    }

    public void setYear(SimpleVo year) {
        this.year = year;
    }

    public SimpleVo getPeriod() {
        return this.period;
    }

    public void setPeriod(SimpleVo period) {
        this.period = period;
    }

    public int hashCode() {
        return Objects.hashCode(this.getCube() + this.scene.number + this.year.number + this.period.number);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseData) {
            BaseData other = (BaseData)obj;
            return Objects.equals(other.getCube(), this.getCube()) && Objects.equals(other.scene.number, this.scene.number) && Objects.equals(other.year.number, this.year.number) && Objects.equals(other.period.number, this.period.number);
        }
        return super.equals(obj);
    }

    public final String getCube(Long modelId) {
        return MemberReader.findModelNumberById((Object)modelId);
    }

    public String getCube() {
        return MemberReader.findModelNumberById((Object)this.model.id);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.model.number + this.scene.number + this.year.number + this.period.number;
    }

    public BaseData getPreBaseData() {
        if (this == EMPTY_BASEDATA) {
            return EMPTY_BASEDATA;
        }
        String periodNum = this.period.number;
        String fyNum = this.year.number;
        String cube = this.getCube();
        String[] fyAndPeriod = PeriodUtils.getLastPeriodIncludeYear((String)cube, (String)fyNum, (String)periodNum, (boolean)Boolean.TRUE);
        if (StringUtils.isBlank((CharSequence)fyAndPeriod[0]) || StringUtils.isBlank((CharSequence)fyAndPeriod[1])) {
            return EMPTY_BASEDATA;
        }
        IDNumberTreeNode fyNode = MemberReader.findFyMemberByNum((String)cube, (String)fyAndPeriod[0]);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)cube, (String)fyAndPeriod[1]);
        return new BaseData(SimpleVo.newOne(cube, this.model.id), this.scene, new SimpleVo(fyNode.getNumber(), fyNode.getId()), new SimpleVo(periodNode.getNumber(), periodNode.getId()));
    }
}

