/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryService;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class ExchangeQueryHelper {
    private static ExchangeQueryService service = new ExchangeQueryService();
    public static final String RATE_CACHE_PREFIX = "ratecache_";

    private static String getSelectFields() {
        return "beginyear,periodend,average,userdefine,boyaveragerate,boyuserdefinedrate,fromid,precision,entity.number,userdefinedrate1,userdefinedrate2,userdefinedrate3,userdefinedrate4,userdefinedrate5,userdefinedrate6,userdefinedrate7,userdefinedrate8,userdefinedrate9,userdefinedrate10,boyuserdefinedrate1,boyuserdefinedrate2,boyuserdefinedrate3,boyuserdefinedrate4,boyuserdefinedrate5,boyuserdefinedrate6,boyuserdefinedrate7,boyuserdefinedrate8,boyuserdefinedrate9,boyuserdefinedrate10,entity,model,model.number,scene,fy,period,scene.number,fy.number,period.number,triangle";
    }

    public static ModelRate getModeRate(BaseData baseData) {
        String key = RATE_CACHE_PREFIX + baseData.toString();
        return (ModelRate)GlobalCacheServiceHelper.getCommonCache().getOrLoad(key, () -> new ModelRate(baseData));
    }

    public static String getRateSchemaByOrg(String modelNum, String scene, String fy, String period, String orgNum) {
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNum, (String)scene);
        IDNumberTreeNode fyNode = MemberReader.findFyMemberByNum((String)modelNum, (String)fy);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)period);
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgNum);
        BaseData baseData = new BaseData(modelId, sceneNode, fyNode, periodNode);
        RateSchema curSchema = ExchangeQueryHelper.getRateSchemaByOrg(baseData, SimpleVo.newOne(entityNode));
        return curSchema.getRateSchemaNumber();
    }

    public static RateSchema getRateSchemaByOrg(BaseData baseData, SimpleVo org) {
        if (org == null || org.id == 0L || org.id == -1L || baseData == null || baseData == BaseData.EMPTY_BASEDATA) {
            return RateSchema.EMPTY_RATE_SCHEMA;
        }
        ModelRate modelRate = ExchangeQueryHelper.getModeRate(baseData);
        RateSchema schema = modelRate.getRateSchema(org.id);
        if (schema != null && schema != RateSchema.EMPTY_RATE_SCHEMA) {
            return schema;
        }
        Pair<Boolean, Long> data = service.queryOrgRate(baseData, org);
        IDNumberTreeNode rateEntity = MemberReader.findEntityMemberById((Long)baseData.getModel().id, (Long)((Long)data.p2));
        if (rateEntity == IDNumberTreeNode.NotFoundTreeNode) {
            return RateSchema.EMPTY_RATE_SCHEMA;
        }
        schema = new RateSchema(baseData, rateEntity);
        modelRate.addOrg2RateSchema(org, (Boolean)data.p1, schema);
        return schema;
    }

    public static Boolean getAutoConvertByOrg(BaseData baseData, SimpleVo org) {
        ModelRate modelRate = ExchangeQueryHelper.getModeRate(baseData);
        return modelRate.getAutoConvertByOrg(org);
    }

    public static Map<Long, RateSchema> getRateSchemaByOrgs(BaseData baseData, Collection<SimpleVo> orgs) {
        if (CollectionUtil.isEmpty(orgs)) {
            return Collections.emptyMap();
        }
        ModelRate modelRate = ExchangeQueryHelper.getModeRate(baseData);
        Map<Long, Pair<Boolean, Long>> data = service.queryOrgRate(baseData, orgs);
        HashSet<SimpleVo> rateSet = new HashSet<SimpleVo>(orgs.size());
        for (SimpleVo org : orgs) {
            Long orgId = org.id;
            Pair<Boolean, Long> rate = data.get(orgId);
            IDNumberTreeNode rateEntity = MemberReader.findEntityMemberById((Long)baseData.getModel().id, (Long)((Long)rate.p2));
            rateSet.add(SimpleVo.newOne(rateEntity));
            modelRate.addOrgId2RateId(orgId, (Boolean)rate.p1, (Long)rate.p2);
        }
        rateSet.forEach(s -> {
            RateSchema schema = new RateSchema(baseData, (SimpleVo)s);
            modelRate.addRateSchemas(schema);
        });
        return modelRate.getorgId2Schemas();
    }

    public static RateModel getRateData(BaseData baseData, Long orgId, String srcCurrency, String tgtCurrency) {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)baseData.getModel().id, (Long)orgId);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        return ExchangeQueryHelper.getRateData(baseData, SimpleVo.newOne(node.getNumber(), orgId), srcCurrency, tgtCurrency);
    }

    public static RateModel getRateData(BaseData baseData, SimpleVo org, String srcCurrency, String tgtCurrency) {
        if (baseData == null || baseData == BaseData.EMPTY_BASEDATA || MemberReader.findProcessMemberByNum((String)baseData.getCube(), (String)srcCurrency) == IDNumberTreeNode.NotFoundTreeNode || MemberReader.findCurrencyMemberByNum((String)baseData.getCube(), (String)tgtCurrency) == IDNumberTreeNode.NotFoundTreeNode) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        RateSchema schema = ExchangeQueryHelper.getRateSchemaByOrg(baseData, org);
        return schema.getRateModelBySrcTgt(srcCurrency, tgtCurrency);
    }

    public static RateModel getRateData(BaseData baseData, Long orgId, String srcCurrency, String tgtCurrency, Boolean iscurPeriod) {
        if (!iscurPeriod.booleanValue()) {
            baseData = baseData.getPreBaseData();
        }
        RateModel rm = ExchangeQueryHelper.getRateData(baseData, orgId, srcCurrency, tgtCurrency);
        return rm;
    }

    public static RateModel getRateData(BaseData baseData, SimpleVo org, String srcCurrency, String tgtCurrency, Boolean iscurPeriod) {
        if (!iscurPeriod.booleanValue()) {
            baseData = baseData.getPreBaseData();
        }
        RateModel rm = ExchangeQueryHelper.getRateData(baseData, org, srcCurrency, tgtCurrency);
        return rm;
    }

    public static RateModel getRateData(RateSchema rateSchema, String srcCurrencyNum, String cvtCurrencyNum) {
        RateModel rm = service.queryExchange(rateSchema.getBaseData(), rateSchema.getRateEntity(), srcCurrencyNum, cvtCurrencyNum);
        if (rm == null || rm == RateModel.EMPTY_RATE_MODEL) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        rateSchema.addSrc2TgtRate(srcCurrencyNum, cvtCurrencyNum, rm);
        return rm;
    }

    public static Map<Long, RateModel> getMultiRateData(BaseData baseData, Collection<SimpleVo> orgs, String srcCurrency, String tgtCurrency) {
        if (baseData == null || baseData == BaseData.EMPTY_BASEDATA || StringUtils.isBlank((CharSequence)srcCurrency) || StringUtils.isBlank((CharSequence)tgtCurrency)) {
            return Collections.emptyMap();
        }
        Map<Long, RateSchema> org2schemas = ExchangeQueryHelper.getRateSchemaByOrgs(baseData, orgs);
        String modelNum = baseData.getCube();
        IDNumberTreeNode src = MemberReader.findProcessMemberByNum((String)modelNum, (String)srcCurrency);
        IDNumberTreeNode tgt = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)tgtCurrency);
        service.queryExchange(baseData, org2schemas, SimpleVo.newOne(src), SimpleVo.newOne(tgt));
        HashMap<Long, RateModel> org2rate = new HashMap<Long, RateModel>(org2schemas.size());
        org2schemas.forEach((k, v) -> {
            RateModel rateModel = v.getRateModelBySrcTgt(srcCurrency, tgtCurrency);
            if (rateModel != null) {
                org2rate.put((Long)k, rateModel);
            }
        });
        return org2rate;
    }

    public static Map<Long, RateSchema> getMultiRateDatasByOrgIds(BaseData baseData, Collection<Long> orgIds, Collection<String> srcCurrencys, Collection<String> tgtCurrencys) {
        HashSet<SimpleVo> orgVos = new HashSet<SimpleVo>(orgIds.size());
        Long modelId = baseData.getModel().id;
        orgIds.forEach(s -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)s);
            if (IDNumberTreeNode.NotFoundTreeNode == node) {
                return;
            }
            orgVos.add(SimpleVo.newOne(node));
        });
        return ExchangeQueryHelper.getMultiRateDatas(baseData, orgVos, srcCurrencys, tgtCurrencys);
    }

    public static Map<Long, RateSchema> getMultiRateDatas(BaseData baseData, Collection<SimpleVo> orgs, Collection<String> srcCurrencys, Collection<String> tgtCurrencys) {
        if (srcCurrencys == null) {
            srcCurrencys = new ArrayList<String>();
        }
        if (tgtCurrencys == null) {
            tgtCurrencys = new ArrayList<String>();
        }
        Map<Long, RateSchema> org2schemas = ExchangeQueryHelper.getRateSchemaByOrgs(baseData, orgs);
        String modelNum = MemberReader.findModelNumberById((Object)baseData.getModel().id);
        ArrayList<SimpleVo> svos = new ArrayList<SimpleVo>(srcCurrencys.size());
        ArrayList<SimpleVo> tvos = new ArrayList<SimpleVo>(tgtCurrencys.size());
        srcCurrencys.forEach(s -> {
            IDNumberTreeNode src = MemberReader.findProcessMemberByNum((String)modelNum, (String)s);
            svos.add(SimpleVo.newOne(src.getNumber(), src.getId()));
        });
        tgtCurrencys.forEach(s -> {
            IDNumberTreeNode tgt = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)s);
            tvos.add(SimpleVo.newOne(tgt.getNumber(), tgt.getId()));
        });
        service.queryExchange(baseData, org2schemas, svos, tvos);
        return org2schemas;
    }

    public static RateModel generateRateModel(DynamicObject ratedot, String sceneNumber, String srcNum, String tgtNum) {
        boolean isMultiply;
        DynamicObject rightObj = null;
        long fromId = ratedot.getLong("fromid");
        if (fromId == 0L) {
            rightObj = ratedot;
            isMultiply = true;
        } else {
            isMultiply = false;
            QFilter qfilter = new QFilter("id", "=", (Object)fromId);
            rightObj = QueryServiceHelper.queryOne((String)"bcm_exchagerate", (String)ExchangeQueryHelper.getSelectFields(), (QFilter[])new QFilter[]{qfilter});
            if (rightObj == null) {
                throw new CvtExchangeException(ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u6709\u8bef", (String)"ExchangeQueryService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>(32);
        rateMap.put("BOYRate", rightObj.getBigDecimal("beginyear"));
        rateMap.put("BOYAverageRate", rightObj.getBigDecimal("boyaveragerate"));
        rateMap.put("BOYUserdefinedRate", rightObj.getBigDecimal("boyuserdefinedrate"));
        rateMap.put("ClosingRate", rightObj.getBigDecimal("periodend"));
        rateMap.put("AverageRate", rightObj.getBigDecimal("average"));
        rateMap.put("UserdefinedRate", rightObj.getBigDecimal("userdefine"));
        for (int i = 1; i <= 10; ++i) {
            rateMap.put("BOYUserdefinedRate" + i, rightObj.getBigDecimal("boyuserdefinedrate" + i));
            rateMap.put("UserdefinedRate" + i, rightObj.getBigDecimal("userdefinedrate" + i));
        }
        RateModel ratemodel = new RateModel(rightObj.getBigDecimal("beginyear"), rightObj.getBigDecimal("boyaveragerate"), rightObj.getBigDecimal("boyuserdefinedrate"), rightObj.getBigDecimal("periodend"), rightObj.getBigDecimal("average"), rightObj.getBigDecimal("userdefine"), rateMap, isMultiply, rightObj.getInt("precision"), rightObj.getString("entity.number"));
        ratemodel.setTag(ratedot.getString("model.number") + sceneNumber + ratedot.getString("fy.number") + ratedot.getString("period.number") + ratedot.getString("entity.number") + srcNum + tgtNum);
        return ratemodel;
    }

    public static void clearRateCache(BaseData baseData) {
        String key = RATE_CACHE_PREFIX + baseData.toString();
        CacheGenFactory.getCommonCache().invalidateStartsWithKey(key);
    }

    public static void clearRateCache(String modelNum) {
        String key = RATE_CACHE_PREFIX + modelNum;
        CacheGenFactory.getCommonCache().invalidateStartsWithKey(key);
    }

    public static RateModel getRateModel(BaseData baseData, SimpleVo org, String srcCurrency, String tgtCurrency, Boolean iscurPeriod) {
        if (!iscurPeriod.booleanValue()) {
            baseData = baseData.getPreBaseData();
        }
        RateModel rm = ExchangeQueryHelper.getRateData(baseData, org, srcCurrency, tgtCurrency);
        return rm;
    }

    public static Boolean getAutoConvert(Long modelId, Long sceneId, Long fyId, Long periodId, SimpleVo curorg) {
        IDNumberTreeNode snode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        IDNumberTreeNode fnode = MemberReader.findFyMemberById((Long)modelId, (Long)fyId);
        IDNumberTreeNode pnode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        BaseData baseData = new BaseData(modelId, snode, fnode, pnode);
        return ExchangeQueryHelper.getAutoConvertByOrg(baseData, curorg);
    }

    public static Boolean getAutoConvert(BaseData baseData, Long orgId) {
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((Long)baseData.getModel().id, (Long)orgId);
        return ExchangeQueryHelper.getAutoConvertByOrg(baseData, SimpleVo.newOne(enode));
    }

    public static Pair<Boolean, Long> queryOrgRate(BaseData baseData, SimpleVo curorg) {
        return service.queryOrgRate(baseData, curorg);
    }

    public static Map<Long, Pair<Boolean, Long>> queryOrgRate(BaseData baseData, Collection<SimpleVo> curorgs) {
        return service.queryOrgRate(baseData, curorgs);
    }

    public static Map<Long, Pair<Boolean, Long>> queryOrgRate(Long modelId, Long sceneId, Long fyId, Long periodId, Collection<SimpleVo> curorgs) {
        IDNumberTreeNode snode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        IDNumberTreeNode fnode = MemberReader.findFyMemberById((Long)modelId, (Long)fyId);
        IDNumberTreeNode pnode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        BaseData baseData = new BaseData(modelId, snode, fnode, pnode);
        return service.queryOrgRate(baseData, curorgs);
    }
}

