/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.query;

import com.google.common.collect.Lists;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class ExchangeQueryService {
    private static final String RatePreset = "RatePreset";

    public RateModel queryExchange(RateSchema rateSchema, String srcCurrencyNum, String cvtCurrencyNum) {
        return this.queryExchange(rateSchema.getBaseData(), rateSchema.getRateEntity(), srcCurrencyNum, cvtCurrencyNum);
    }

    public RateModel queryExchange(BaseData baseData, SimpleVo rateSchema, String srcCurrencyNum, String cvtCurrencyNum) {
        if (baseData == null || baseData == BaseData.EMPTY_BASEDATA) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        Long modelId = baseData.getModel().id;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode snode = MemberReader.findProcessMemberByNum((String)modelNum, (String)srcCurrencyNum);
        IDNumberTreeNode tnode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)cvtCurrencyNum);
        if (IDNumberTreeNode.NotFoundTreeNode == snode || IDNumberTreeNode.NotFoundTreeNode == tnode) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        DynamicObject ratedot = this.queryExchange(baseData, rateSchema, SimpleVo.newOne(srcCurrencyNum, snode.getId()), SimpleVo.newOne(cvtCurrencyNum, tnode.getId()));
        if (ratedot == null) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        return ExchangeQueryHelper.generateRateModel(ratedot, baseData.getScene().number, srcCurrencyNum, cvtCurrencyNum);
    }

    private String getSelectFields() {
        return "beginyear,periodend,average,userdefine,boyaveragerate,boyuserdefinedrate,fromid,precision,entity.number,source.number,target.number,userdefinedrate1,userdefinedrate2,userdefinedrate3,userdefinedrate4,userdefinedrate5,userdefinedrate6,userdefinedrate7,userdefinedrate8,userdefinedrate9,userdefinedrate10,boyuserdefinedrate1,boyuserdefinedrate2,boyuserdefinedrate3,boyuserdefinedrate4,boyuserdefinedrate5,boyuserdefinedrate6,boyuserdefinedrate7,boyuserdefinedrate8,boyuserdefinedrate9,boyuserdefinedrate10,entity,model,model.number,scene,fy,period,scene.number,fy.number,period.number,triangle";
    }

    public DynamicObject queryExchange(BaseData baseData, SimpleVo rateSchema, SimpleVo srcCurrency, SimpleVo cvtCurrency) {
        Long modelId = baseData.getModel().id;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String sceneNumber = baseData.getScene().number;
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)modelNum, (String)sceneNumber);
        Long scenarioid = node.getId();
        Long yearid = baseData.getYear().id;
        Long periodid = baseData.getPeriod().id;
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        QFilter scenarioqfilter = new QFilter("scene", "=", (Object)scenarioid);
        QFilter yearfilter = new QFilter("fy", "=", (Object)yearid);
        QFilter periodfilter = new QFilter("period", "=", (Object)periodid);
        QFilter cvtorgfilter = new QFilter("entity", "=", (Object)rateSchema.id);
        if (ExchangeRateShareSceneHelper.isInRateShare(String.valueOf(rateSchema.id), String.valueOf(scenarioid)).booleanValue()) {
            scenarioqfilter = new QFilter("scene", "=", (Object)0L);
        }
        QFilter srcCurrencyfilter = new QFilter("source", "=", (Object)srcCurrency.id);
        QFilter cvtCurrencyfilter = new QFilter("target", "=", (Object)cvtCurrency.id);
        String selectFields = this.getSelectFields();
        QFilter[] queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, cvtorgfilter, srcCurrencyfilter, cvtCurrencyfilter};
        return QueryServiceHelper.queryOne((String)"bcm_exchagerate", (String)selectFields, (QFilter[])queryqfilter);
    }

    public void queryExchange(BaseData baseData, Map<Long, RateSchema> org2schemas, SimpleVo srcCurrency, SimpleVo cvtCurrency) {
        Long modelId = baseData.getModel().id;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String sceneNum = baseData.getScene().number;
        HashMap org2schemaId = new HashMap(org2schemas.size());
        org2schemas.forEach((k, v) -> org2schemaId.put(k, v.getRateSchemaId()));
        HashSet<RateSchema> rateSchemas = new HashSet<RateSchema>(org2schemas.values());
        Map<Long, RateSchema> schemaId2Schema = rateSchemas.stream().collect(Collectors.toMap(s -> s.getRateSchemaId(), s -> s));
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)modelNum, (String)sceneNum);
        Set<Long> shareIds = ExchangeRateShareSceneHelper.getRateShareIdsApplyScene(org2schemaId.values(), node.getId());
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        QFilter scenarioqfilter = new QFilter("scene", "=", (Object)node.getId());
        QFilter yearfilter = new QFilter("fy", "=", (Object)baseData.getYear().id);
        QFilter periodfilter = new QFilter("period", "=", (Object)baseData.getPeriod().id);
        shareIds.stream().forEach(s -> org2schemaId.computeIfPresent(s, (k, v) -> (Long)org2schemaId.remove(k)));
        QFilter orgfilter = new QFilter("entity", "in", org2schemaId.values());
        QFilter srcCurrencyfilter = new QFilter("source", "=", (Object)srcCurrency.id);
        QFilter cvtCurrencyfilter = new QFilter("target", "=", (Object)cvtCurrency.id);
        String selectFields = this.getSelectFields();
        QFilter[] queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, orgfilter, srcCurrencyfilter, cvtCurrencyfilter};
        DynamicObjectCollection ratedots = QueryServiceHelper.query((String)"bcm_exchagerate", (String)selectFields, (QFilter[])queryqfilter);
        if (shareIds.size() > 0) {
            scenarioqfilter = new QFilter("scene", "=", (Object)0L);
            orgfilter = new QFilter("entity", "in", shareIds);
            queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, orgfilter, srcCurrencyfilter, cvtCurrencyfilter};
            ratedots.addAll((Collection)QueryServiceHelper.query((String)"bcm_exchagerate", (String)selectFields, (QFilter[])queryqfilter));
        }
        for (DynamicObject onerate : ratedots) {
            Long rateSchemeId = onerate.getLong("entity");
            RateModel rm = ExchangeQueryHelper.generateRateModel(onerate, node.getNumber(), srcCurrency.number, cvtCurrency.number);
            RateSchema rateSchema = schemaId2Schema.get(rateSchemeId);
            rateSchema.addSrc2TgtRate(srcCurrency.number, cvtCurrency.number, rm);
        }
    }

    public void queryExchange(BaseData baseData, Map<Long, RateSchema> org2schemas, Collection<SimpleVo> srcCurrency, Collection<SimpleVo> cvtCurrency) {
        Long modelId = baseData.getModel().id;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String scenarioNum = baseData.getScene().number;
        Set srcIds = srcCurrency.stream().map(s -> s.id).collect(Collectors.toSet());
        Set tgtIds = cvtCurrency.stream().map(s -> s.id).collect(Collectors.toSet());
        HashMap org2schemaId = new HashMap(org2schemas.size());
        org2schemas.forEach((k, v) -> org2schemaId.put(k, v.getRateSchemaId()));
        HashSet<RateSchema> rateSchemas = new HashSet<RateSchema>(org2schemas.values());
        Map<Long, RateSchema> schemaId2Schema = rateSchemas.stream().collect(Collectors.toMap(s -> s.getRateSchemaId(), s -> s));
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)modelNum, (String)scenarioNum);
        Set<Long> shareIds = ExchangeRateShareSceneHelper.getRateShareIdsApplyScene(org2schemaId.values(), node.getId());
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        QFilter scenarioqfilter = new QFilter("scene", "=", (Object)node.getId());
        QFilter yearfilter = new QFilter("fy", "=", (Object)baseData.getYear().id);
        QFilter periodfilter = new QFilter("period", "=", (Object)baseData.getPeriod().id);
        shareIds.stream().forEach(s -> org2schemaId.computeIfPresent(s, (k, v) -> (Long)org2schemaId.remove(k)));
        QFilter cvtorgfilter = new QFilter("entity", "in", org2schemaId.values());
        if (!srcIds.isEmpty()) {
            modelqfilter.and(new QFilter("source", "in", srcIds));
        }
        if (!tgtIds.isEmpty()) {
            modelqfilter.and(new QFilter("target", "in", tgtIds));
        }
        String selectFields = this.getSelectFields();
        QFilter[] queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, cvtorgfilter};
        DynamicObjectCollection ratedots = QueryServiceHelper.query((String)"bcm_exchagerate", (String)selectFields, (QFilter[])queryqfilter);
        if (shareIds.size() > 0) {
            scenarioqfilter = new QFilter("scene", "=", (Object)0L);
            cvtorgfilter = new QFilter("entity", "in", shareIds);
            queryqfilter = new QFilter[]{modelqfilter, scenarioqfilter, yearfilter, periodfilter, cvtorgfilter};
            ratedots.addAll((Collection)QueryServiceHelper.query((String)"bcm_exchagerate", (String)selectFields, (QFilter[])queryqfilter));
        }
        for (DynamicObject onerate : ratedots) {
            Long rateSchemeId = onerate.getLong("entity");
            String srcNum = onerate.getString("source.number");
            String tgtNum = onerate.getString("target.number");
            RateModel rm = ExchangeQueryHelper.generateRateModel(onerate, node.getNumber(), srcNum, tgtNum);
            RateSchema rateSchema = schemaId2Schema.get(rateSchemeId);
            rateSchema.addSrc2TgtRate(srcNum, tgtNum, rm);
        }
    }

    public Pair<Boolean, Long> queryOrgRate(BaseData baseData, SimpleItem curorg) {
        SimpleVo org = new SimpleVo(curorg.getNumber(), (Long)curorg.getId());
        return this.queryOrgRate(baseData, org);
    }

    public Pair<Boolean, Long> queryOrgRate(BaseData baseData, Pair<Long, String> curorg) {
        SimpleVo org = new SimpleVo((String)curorg.p2, (Long)curorg.p1);
        return this.queryOrgRate(baseData, org);
    }

    public Pair<Boolean, Long> queryOrgRate(BaseData baseData, SimpleVo curorg) {
        Long modelId = baseData.getModel().id;
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)curorg.id, (String)"bcm_entitymembertree", (String)"number, level");
        boolean isLevel2 = org.getInt("level") == 2;
        QFilter modelQfilter = new QFilter("model", "=", (Object)modelId);
        QFilter status = new QFilter("status", "=", (Object)"1");
        ArrayList specialrates = new ArrayList(10);
        String selectStr = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_specialrate").getAllFields().keySet());
        Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_specialrate", (String)selectStr, (QFilter[])new QFilter[]{status, modelQfilter})).sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject dy1, DynamicObject dy2) {
                return dy2.getBigDecimal("executionorder").compareTo(dy1.getBigDecimal("executionorder"));
            }
        }).forEach(o -> specialrates.add(o));
        LinkedHashMap<Integer, List<DynamicObject>> seqGroup = new LinkedHashMap<Integer, List<DynamicObject>>(specialrates.size());
        for (DynamicObject dy : specialrates) {
            Integer priority = dy.getInt("executionorder");
            List list = seqGroup.computeIfAbsent(priority, k -> new ArrayList(10));
            list.add(dy);
        }
        Map<Long, Map<String, Object>> specialRateSchema = this.handleSeqRates(baseData, seqGroup, Lists.newArrayList((Object[])new Long[]{curorg.id}));
        Map<String, Object> map = specialRateSchema.get(curorg.id);
        if (map != null && map.size() > 0) {
            return new Pair((Object)((Boolean)map.get("isautoconvert")), (Object)((Long)map.get("exchangerate")));
        }
        QFilter scenarioQfilter = new QFilter("scenario", "=", (Object)0);
        DynamicObject baseFormula = BusinessDataServiceHelper.loadSingle((String)"bcm_basecvtformula", (String)"exchangerate.id, isautoconvert", (QFilter[])new QFilter[]{modelQfilter, scenarioQfilter});
        if (baseFormula != null) {
            return new Pair((Object)(isLevel2 ? false : baseFormula.getBoolean("isautoconvert")), (Object)baseFormula.getLong("exchangerate.id"));
        }
        QFilter orgNumberQfilter = new QFilter("number", "=", (Object)RatePreset);
        DynamicObject presetorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{modelQfilter, orgNumberQfilter});
        if (presetorg != null) {
            return new Pair((Object)(isLevel2 ? Boolean.FALSE : Boolean.TRUE), (Object)presetorg.getLong("id"));
        }
        throw new CvtExchangeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u901a\u7528\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeQueryService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public Map<Long, Pair<Boolean, Long>> queryOrgRate(BaseData baseData, Collection<SimpleVo> curorgs) {
        QFilter orgNumberQfilter;
        DynamicObject presetorg;
        HashMap<Long, Pair<Boolean, Long>> result = new HashMap<Long, Pair<Boolean, Long>>();
        Long modelId = baseData.getModel().id;
        Set<Long> orgIds = curorgs.stream().map(s -> s.id).filter(s -> s != -1L).collect(Collectors.toSet());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number, level", (QFilter[])new QFilter("id", "in", orgIds).toArray(), (String)"number, level");
        QFilter modelQfilter = new QFilter("model", "=", (Object)modelId);
        QFilter status = new QFilter("status", "=", (Object)"1");
        ArrayList specialrates = new ArrayList(10);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_specialrate", (QFilter[])new QFilter[]{status, modelQfilter}).values().stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject dy1, DynamicObject dy2) {
                return dy2.getBigDecimal("executionorder").compareTo(dy1.getBigDecimal("executionorder"));
            }
        }).forEach(o -> specialrates.add(o));
        TreeMap<Integer, List<DynamicObject>> seqGroup = new TreeMap<Integer, List<DynamicObject>>();
        for (DynamicObject dy : specialrates) {
            Integer priority = dy.getInt("executionorder");
            List list = seqGroup.computeIfAbsent(priority, k -> new ArrayList(10));
            list.add(dy);
        }
        Map<Long, Map<String, Object>> specialRateSchema = this.handleSeqRates(baseData, seqGroup, orgIds);
        specialRateSchema.forEach((k, v) -> result.put((Long)k, (Pair<Boolean, Long>)new Pair((Object)((Boolean)v.get("isautoconvert")), (Object)LongUtil.toLong(v.get("exchangerate")))));
        orgs.removeIf(s -> result.containsKey(s.getLong("id")));
        QFilter scenarioQfilter = new QFilter("scenario", "=", (Object)0);
        DynamicObject baseFormula = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_basecvtformula", (String)"exchangerate.id, isautoconvert", (QFilter[])new QFilter[]{modelQfilter, scenarioQfilter});
        if (baseFormula != null) {
            Iterator iterator = orgs.iterator();
            while (iterator.hasNext()) {
                DynamicObject s2 = (DynamicObject)iterator.next();
                boolean isLevel2 = s2.getInt("level") == 2;
                Pair pair = new Pair((Object)(isLevel2 ? false : baseFormula.getBoolean("isautoconvert")), (Object)baseFormula.getLong("exchangerate.id"));
                result.put(s2.getLong("id"), (Pair<Boolean, Long>)pair);
                iterator.remove();
            }
        }
        if ((presetorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{modelQfilter, orgNumberQfilter = new QFilter("number", "=", (Object)RatePreset)})) != null) {
            Iterator iterator = orgs.iterator();
            while (iterator.hasNext()) {
                DynamicObject s3 = (DynamicObject)iterator.next();
                boolean isLevel2 = s3.getInt("level") == 2;
                Pair pair = new Pair((Object)(isLevel2 ? Boolean.FALSE : Boolean.TRUE), (Object)presetorg.getLong("id"));
                result.put(s3.getLong("id"), (Pair<Boolean, Long>)pair);
                iterator.remove();
            }
        } else {
            throw new CvtExchangeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u901a\u7528\u6c47\u7387\u65b9\u6848\u3002", (String)"ExchangeQueryService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return result;
    }

    public static DChangeTypeEnum queryScenarioInputChangType(ICvtContext ctx) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_scenemembertree", (String)"dchangetype", (QFilter[])new QFBuilder().add("id", "=", (Object)ctx.getScenarioVo().id).toArray());
        return DChangeTypeEnum.valueof((String)dyna.getString("dchangetype"));
    }

    private Map<Long, Map<String, Object>> handleSeqRates(BaseData baseData, Map<Integer, List<DynamicObject>> seqRates, Collection<Long> orgIds) {
        for (List<DynamicObject> rates : seqRates.values()) {
            Map<Long, Map<String, Object>> result;
            if (rates.size() < 1 || (result = this.geMatchedRateScheme(baseData, rates, orgIds)) == null) continue;
            return result;
        }
        return Collections.emptyMap();
    }

    private Map<Long, Map<String, Object>> geMatchedRateScheme(BaseData baseData, List<DynamicObject> rates, Collection<Long> orgIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(8);
        Long modelId = baseData.getModel().id;
        Long scenarioId = baseData.getScene().id;
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
        HashMap<String, Constable> rateScheme = new HashMap<String, Constable>(4);
        for (Long orgId : orgIds) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            for (DynamicObject rate : rates) {
                DynamicObjectCollection effectives = rate.getDynamicObjectCollection("effective");
                if (rate.getDynamicObject("scenario") != null && rate.getDynamicObject("scenario").getLong("id") != scenarioId.longValue() || !ConvertDifferenceHandle.isApply(baseData.getYear().id, baseData.getPeriod().id, effectives, yearIdsList)) continue;
                DynamicObjectCollection entryentity = rate.getDynamicObjectCollection("entryentity");
                if (entryentity.isEmpty()) {
                    rateScheme.put("exchangerate", Long.valueOf(rate.getLong("exchangerate.id")));
                    rateScheme.put("isautoconvert", Boolean.valueOf(rate.getBoolean("isautoconvert")));
                }
                for (DynamicObject member : entryentity) {
                    boolean isCustom = member.getDynamicObject("propertyid") != null;
                    HashSet temp = new HashSet(16);
                    new MembRangeItem(member.getDynamicObject("dimension").getString("membermodel"), (Long)member.getLong("memberid"), null, RangeEnum.getRangeByVal((int)member.getInt("membbound")), isCustom, (Object)modelId).matchItems(c -> temp.add(c.number));
                    if (IDNumberTreeNode.NotFoundTreeNode == node || !temp.contains(node.getNumber())) continue;
                    rateScheme.put("exchangerate", Long.valueOf(rate.getLong("exchangerate.id")));
                    rateScheme.put("isautoconvert", Boolean.valueOf(rate.getBoolean("isautoconvert")));
                }
            }
            if (rateScheme.size() <= 0) continue;
            result.put(orgId, rateScheme);
        }
        return result;
    }
}

