/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class ModelRate {
    private static String PREFIX = "modelRate";
    BaseData baseData;
    private Map<Long, Pair<Boolean, Long>> orgId2rateScema = new ConcurrentHashMap<Long, Pair<Boolean, Long>>(16);
    private Map<Long, RateSchema> rateSchemas = new ConcurrentHashMap<Long, RateSchema>(16);

    public ModelRate(BaseData baseData) {
        this.baseData = baseData;
    }

    public RateSchema getRateSchemaByOrgNum(String orgNum) {
        String modelNum = MemberReader.findModelNumberById((Object)this.baseData.getModel().id);
        IDNumberTreeNode enode = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgNum);
        if (IDNumberTreeNode.NotFoundTreeNode == enode) {
            return RateSchema.EMPTY_RATE_SCHEMA;
        }
        Pair<Boolean, Long> rate = this.orgId2rateScema.get(enode.getId());
        if (rate != null) {
            return this.rateSchemas.get(rate.p2);
        }
        Pair<Boolean, Long> data = ExchangeQueryHelper.queryOrgRate(this.baseData, SimpleVo.newOne(enode));
        this.orgId2rateScema.put(enode.getId(), data);
        IDNumberTreeNode rateNode = MemberReader.findEntityMemberById((Long)this.baseData.getModel().id, (Long)((Long)data.p2));
        RateSchema rateSchema = new RateSchema(this.baseData, SimpleVo.newOne(rateNode));
        this.rateSchemas.put((Long)data.p2, rateSchema);
        return this.rateSchemas.get(data.p2);
    }

    public Boolean getAutoConvertByOrgId(Long orgId) {
        String modelNum = MemberReader.findModelNumberById((Object)this.baseData.getModel().id);
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId);
        return this.getAutoConvertByOrg(SimpleVo.newOne(enode));
    }

    public Boolean getAutoConvertByOrgNum(String orgNum) {
        String modelNum = MemberReader.findModelNumberById((Object)this.baseData.getModel().id);
        IDNumberTreeNode enode = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgNum);
        return this.getAutoConvertByOrg(SimpleVo.newOne(enode));
    }

    public Boolean getAutoConvertByOrg(SimpleVo curorg) {
        if (curorg == null || curorg.id == 0L || curorg.id == -1L || this.baseData == null || this.baseData == BaseData.EMPTY_BASEDATA) {
            return Boolean.FALSE;
        }
        Pair<Boolean, Long> data = this.orgId2rateScema.get(curorg.id);
        if (data != null) {
            return (Boolean)data.p1;
        }
        data = ExchangeQueryHelper.queryOrgRate(this.baseData, curorg);
        this.orgId2rateScema.put(curorg.id, data);
        IDNumberTreeNode rateNode = MemberReader.findEntityMemberById((Long)this.baseData.getModel().id, (Long)((Long)data.p2));
        RateSchema rateSchema = new RateSchema(this.baseData, SimpleVo.newOne(rateNode));
        this.rateSchemas.put((Long)data.p2, rateSchema);
        return (Boolean)data.p1;
    }

    public RateSchema getRateSchemaByOrgId(Long orgId) {
        if (orgId == 0L || orgId == -1L || this.baseData == null || this.baseData == BaseData.EMPTY_BASEDATA) {
            return RateSchema.EMPTY_RATE_SCHEMA;
        }
        String modelNum = MemberReader.findModelNumberById((Object)this.baseData.getModel().id);
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId);
        if (IDNumberTreeNode.NotFoundTreeNode == enode) {
            return RateSchema.EMPTY_RATE_SCHEMA;
        }
        Pair<Boolean, Long> rate = this.orgId2rateScema.get(enode.getId());
        if (rate != null) {
            return this.rateSchemas.get(rate.p2);
        }
        Pair<Boolean, Long> data = ExchangeQueryHelper.queryOrgRate(this.baseData, SimpleVo.newOne(enode));
        this.orgId2rateScema.put(enode.getId(), data);
        IDNumberTreeNode rateNode = MemberReader.findEntityMemberById((Long)this.baseData.getModel().id, (Long)((Long)data.p2));
        RateSchema rateSchema = new RateSchema(this.baseData, SimpleVo.newOne(rateNode));
        this.rateSchemas.put((Long)data.p2, rateSchema);
        return this.rateSchemas.get(data.p2);
    }

    public RateSchema getRateSchema(Long orgId) {
        return this.getRateSchemaByOrgId(orgId);
    }

    public Boolean getAutoCounvert(Long orgId) {
        return this.getAutoConvertByOrgId(orgId);
    }

    public Map<Long, RateSchema> getorgId2Schemas() {
        HashMap<Long, RateSchema> org2Schema = new HashMap<Long, RateSchema>(this.orgId2rateScema.size());
        this.orgId2rateScema.forEach((k, v) -> org2Schema.put((Long)k, this.rateSchemas.get(v.p2)));
        return org2Schema;
    }

    public void addOrg2RateSchema(SimpleVo org, Boolean isAutoConvert, RateSchema schema) {
        this.orgId2rateScema.put(org.id, (Pair<Boolean, Long>)new Pair((Object)isAutoConvert, (Object)schema.getRateSchemaId()));
        this.rateSchemas.put(schema.getRateSchemaId(), schema);
    }

    public void addOrgId2RateId(Long orgId, Boolean isAutoConvert, Long schemaId) {
        this.orgId2rateScema.put(orgId, (Pair<Boolean, Long>)new Pair((Object)isAutoConvert, (Object)schemaId));
    }

    public void addRateSchemas(Collection<RateSchema> datas) {
        Map<Long, RateSchema> schemaMap = datas.stream().collect(Collectors.toMap(s -> s.getRateEntity().id, s -> s));
        this.rateSchemas.putAll(schemaMap);
    }

    public void addRateSchemas(RateSchema data) {
        this.rateSchemas.put(data.getRateSchemaId(), data);
    }

    public BaseData getBaseData() {
        return this.baseData;
    }

    public int hashCode() {
        return Objects.hashCode(PREFIX + this.baseData.getModel().number + this.baseData.getScene().number + this.baseData.getYear().number + this.baseData.getPeriod().number);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelRate) {
            ModelRate other = (ModelRate)obj;
            BaseData data = other.getBaseData();
            return Objects.equals(this.getBaseData(), data);
        }
        return super.equals(obj);
    }
}

