/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.query;

import java.util.Map;
import java.util.Objects;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import org.apache.commons.collections.map.MultiKeyMap;

public class RateSchema {
    private BaseData baseData;
    private SimpleVo rateEntity;
    private MultiKeyMap detailRates = new MultiKeyMap();
    public static final RateSchema EMPTY_RATE_SCHEMA = new RateSchema();

    private RateSchema() {
    }

    public RateSchema(BaseData data, Long rateEntityId) {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)data.getModel().id, (Long)rateEntityId);
        String entitNum = node.getNumber();
        this.baseData = data;
        this.rateEntity = SimpleVo.newOne(entitNum, rateEntityId);
    }

    public RateSchema(BaseData data, SimpleVo rateEntity) {
        this.baseData = data;
        this.rateEntity = rateEntity;
    }

    public RateSchema(BaseData data, IDNumberTreeNode rateEntity) {
        this.baseData = data;
        this.rateEntity = SimpleVo.newOne(rateEntity.getNumber(), rateEntity.getId());
    }

    public void addSrc2TgtRate(String srcCurrency, String tgtCurrency, RateModel rm) {
        this.detailRates.put((Object)srcCurrency, (Object)tgtCurrency, (Object)rm);
    }

    public void addRateSchemaMap(MultiKeyMap rates) {
        this.detailRates.putAll((Map)rates);
    }

    public RateModel getRateModelBySrcTgt(String srcCurrency, String tgtCurrency) {
        if (this == EMPTY_RATE_SCHEMA) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        RateModel rm = (RateModel)this.detailRates.get((Object)srcCurrency, (Object)tgtCurrency);
        if (rm != null && rm != RateModel.EMPTY_RATE_MODEL) {
            return rm;
        }
        rm = ExchangeQueryHelper.getRateData(this, srcCurrency, tgtCurrency);
        if (rm != null && rm != RateModel.EMPTY_RATE_MODEL) {
            this.addSrc2TgtRate(srcCurrency, tgtCurrency, rm);
            return rm;
        }
        return RateModel.EMPTY_RATE_MODEL;
    }

    public Long getRateSchemaId() {
        return this.rateEntity.id;
    }

    public String getRateSchemaNumber() {
        return this.rateEntity.number;
    }

    public BaseData getBaseData() {
        return this.baseData;
    }

    public void setBaseData(BaseData data) {
        this.baseData = data;
    }

    public SimpleVo getRateEntity() {
        return this.rateEntity;
    }

    public int hashCode() {
        return Objects.hash(this.baseData, this.rateEntity.number);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RateSchema) {
            RateSchema other = (RateSchema)obj;
            return Objects.equals(other.rateEntity, this.rateEntity) && Objects.equals(other.baseData, this.baseData);
        }
        return super.equals(obj);
    }
}

