/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class ConvertSchemeServiceHelper {
    public static PairList<Long, String> getOrgConvertPath(BaseData baseData, Long orgId) {
        boolean isautoconvert = ExchangeQueryHelper.getAutoConvert(baseData, orgId);
        return ConvertSchemeServiceHelper.getOrgConvertPath(baseData, orgId, isautoconvert);
    }

    private static PairList<Long, String> getOrgConvertPath(BaseData baseData, Long orgId, boolean isAutoConvert) {
        PairList path = new PairList();
        Long modelId = baseData.getModel().id;
        if (isAutoConvert) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)orgNode.getCurrency());
            if (currencyNode == IDNumberTreeNode.NotFoundTreeNode) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u7684\u9ed8\u8ba4\u5e01 %2$s \u4e0d\u5b58\u5728\u5e01\u522b\u7ef4\u5ea6\u6210\u5458\u4e2d\u3002", (String)"ConvertSchemeServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber(), orgNode.getCurrency()));
            }
            path.addPair((Object)currencyNode.getId(), (Object)currencyNode.getCurrency());
            IDNumberTreeNode parentNode = orgNode.getParent();
            if (parentNode.getCurrency() != null && parentNode.getNumber().equals("Entity")) {
                IDNumberTreeNode parentCurrencyNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)parentNode.getCurrency());
                if (parentCurrencyNode == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7236\u7ea7\u7ec4\u7ec7 %1$s \u7684\u9ed8\u8ba4\u5e01 %2$s \u4e0d\u5b58\u5728\u5e01\u522b\u7ef4\u5ea6\u6210\u5458\u4e2d\u3002", (String)"ConvertSchemeServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), parentNode.getNumber(), parentNode.getCurrency()));
                }
                if (!currencyNode.getNumber().equals(parentCurrencyNode.getNumber())) {
                    path.addPair((Object)parentCurrencyNode.getId(), (Object)parentCurrencyNode.getNumber());
                    return path;
                }
            }
        }
        path.toList().clear();
        return path;
    }

    public static BaseConvertFormula getBaseConvertFormula(long modelId, long scenarioId) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("scenario", "=", (Object)0);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_basecvtformula", (String)"id, balance, profitloss, rights, convertmodel, convertaudittrial, cvtdiffaudittrial", (QFilter[])builder.toArray());
        if (object != null) {
            QFBuilder qf;
            BaseConvertFormula bcf = new BaseConvertFormula();
            bcf.setBalance(object.getInt("balance"));
            bcf.setProfitloss(object.getInt("profitloss"));
            bcf.setRights(object.getInt("rights"));
            if (object.getString("convertmodel").equals("1")) {
                if (object.getDynamicObject("convertAudittrial") != null) {
                    bcf.setConvertAudittrial(object.getDynamicObject("convertAudittrial").getString("number"));
                } else {
                    qf = new QFBuilder("model", "=", (Object)modelId);
                    qf.add("number", "=", (Object)"EntityInput");
                    qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                    if (QueryServiceHelper.exists((String)"bcm_audittrialmembertree", (QFilter[])qf.toArray())) {
                        bcf.setConvertAudittrial("EntityInput");
                    }
                }
            }
            if (object.getDynamicObject("cvtdiffaudittrial") != null) {
                bcf.setCvtDiffAudittrial(object.getDynamicObject("cvtdiffaudittrial").getString("number"));
            } else {
                qf = new QFBuilder("model", "=", (Object)modelId);
                qf.add("number", "=", (Object)"TraDif");
                qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                if (QueryServiceHelper.exists((String)"bcm_audittrialmembertree", (QFilter[])qf.toArray())) {
                    bcf.setCvtDiffAudittrial("TraDif");
                }
            }
            return bcf;
        }
        return BaseConvertFormula.getDefaultValue(modelId);
    }
}

