/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.util;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.convert.ConvertService;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.convertor.CvtInfluenceConvertor;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowCurrPeriodGenYDT;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowYDTGenCurrPeriod;
import kd.fi.bcm.business.convert.convertor.UserDefinedFormulaConvertor;
import kd.fi.bcm.business.convert.ctx.CvtContext;
import kd.fi.bcm.business.convert.ctx.CvtContext4Adjust;
import kd.fi.bcm.business.convert.ctx.CvtContext4InvElim;
import kd.fi.bcm.business.convert.ctx.FixScopeParameter;
import kd.fi.bcm.business.convert.ctx.GeneratorContext;
import kd.fi.bcm.business.convert.ctx.ReportCvtContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ConvertStatusEnum;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.convert.ConvertOrgScopeEnum;
import kd.fi.bcm.common.msservice.param.ConvertParam;
import kd.fi.bcm.common.util.QFBuilder;

public class ConvertServiceHelper {
    private static final Log logger = LogFactory.getLog(ConvertServiceHelper.class);
    private static String[] toCvtProcess = new String[]{"Rpt", "ADJ", "CADJ", "EOE", "EICA", "EIT", "ECF", "EOther", "EJE", "CCADJ", "DEJE", "DADJ"};

    public static Set<String> convert(ConvertParam cvtparam) {
        FixScopeParameter fixScopeParam = ConvertServiceHelper.paramToFixScopeParam(cvtparam);
        SimpleVo currency = fixScopeParam.getFixScopeByDimType(DimTypesEnum.CURRENCY);
        if (Objects.equals("OC", currency.number) || Objects.equals("OC", cvtparam.getCvtCurrency().p2)) {
            String msg = String.format(ResManager.loadKDString((String)"\u539f\u5e01\u4e0d\u6267\u884c\u6298\u7b97\u3002", (String)"AbstractConvertService_5", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]);
            return Sets.newHashSet((Object[])new String[]{msg});
        }
        CvtContext ctx = new CvtContext(SimpleVo.newOne((String)cvtparam.getModel().p2, (Long)cvtparam.getModel().p1), SimpleVo.newOne((String)cvtparam.getCvtCurrency().p2, (Long)cvtparam.getCvtCurrency().p1), fixScopeParam, cvtparam.isForceExec());
        for (Map.Entry e : cvtparam.getScope().entrySet()) {
            ctx.addScope((String)e.getKey(), (Pair<String, String[]>)Pair.onePair(e.getKey(), e.getValue()));
        }
        ctx.setNeedMonitorDataStatus(cvtparam.isNeedMonitorDataStatus());
        ConvertService converter = new ConvertService(ctx);
        Set<String> errorMsgs = converter.convert();
        return errorMsgs;
    }

    public static Set<String> convert(TemplateModel template, ConvertParam cvtparam) {
        FixScopeParameter fixScopeParam = ConvertServiceHelper.paramToFixScopeParam(cvtparam);
        SimpleVo currency = fixScopeParam.getFixScopeByDimType(DimTypesEnum.CURRENCY);
        if (currency != null && "OC".equals(currency.number) || "OC".equals(cvtparam.getCvtCurrency().p2)) {
            return new HashSet<String>(0);
        }
        ReportCvtContext ctx = new ReportCvtContext(SimpleVo.newOne((String)cvtparam.getModel().p2, (Long)cvtparam.getModel().p1), SimpleVo.newOne((String)cvtparam.getCvtCurrency().p2, (Long)cvtparam.getCvtCurrency().p1), fixScopeParam, template);
        for (Map.Entry e : cvtparam.getScope().entrySet()) {
            ctx.addScope((String)e.getKey(), (Pair<String, String[]>)Pair.onePair(e.getKey(), e.getValue()));
        }
        ConvertService converter = new ConvertService(ctx);
        Set<String> errorMsgs = converter.convert();
        return errorMsgs;
    }

    public static String getUserDefindedRateNumber(List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene, Map<String, String[]> scopeMap, Map<Integer, List<DynamicObject>> seqUserDefGroupNotFilter) {
        Pair cvtCurrency = Pair.onePair((Object)cvtPaths.get((int)1).p1, (Object)cvtPaths.get((int)1).p2);
        ConvertParam cvtparam = new ConvertParam(null, cvtCurrency, model);
        cvtparam.addFixScope(PresetConstant.ENTITY_DIM, (String)entity.p2, (Long)entity.p1);
        cvtparam.addFixScope(PresetConstant.FY_DIM, (String)fy.p2, (Long)fy.p1);
        cvtparam.addFixScope(PresetConstant.PERIOD_DIM, (String)period.p2, (Long)period.p1);
        cvtparam.addFixScope(PresetConstant.SCENE_DIM, (String)scene.p2, (Long)scene.p1);
        cvtparam.addFixScope(PresetConstant.CURRENCY_DIM, (String)cvtPaths.get((int)0).p2, (Long)cvtPaths.get((int)0).p1);
        cvtparam.getScope().putAll(scopeMap);
        FixScopeParameter fixScopeParam = ConvertServiceHelper.paramToFixScopeParam(cvtparam);
        CvtContext4Adjust ctx = new CvtContext4Adjust(SimpleVo.newOne((String)cvtparam.getModel().p2, (Long)cvtparam.getModel().p1), SimpleVo.newOne((String)cvtparam.getCvtCurrency().p2, (Long)cvtparam.getCvtCurrency().p1), fixScopeParam);
        for (Map.Entry e : cvtparam.getScope().entrySet()) {
            ctx.addScope((String)e.getKey(), (Pair<String, String[]>)Pair.onePair(e.getKey(), e.getValue()));
        }
        UserDefinedFormulaConvertor userDefinedFormulaConvertor = new UserDefinedFormulaConvertor(ctx);
        return userDefinedFormulaConvertor.getConvertRateNumber(seqUserDefGroupNotFilter);
    }

    public static Set<String> convertByPath(TemplateModel template, List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene) {
        HashSet<String> errorMsgs = new HashSet<String>(10);
        for (int i = 0; i < cvtPaths.size() - 1; ++i) {
            Pair<Long, String> srcCurrency = cvtPaths.get(i);
            Pair<Long, String> cvtCurrency = cvtPaths.get(i + 1);
            ConvertParam cvtparam = new ConvertParam((Object)template.getId(), cvtCurrency, model);
            cvtparam.addFixScope(PresetConstant.ENTITY_DIM, (String)entity.p2, (Long)entity.p1);
            cvtparam.addFixScope(PresetConstant.FY_DIM, (String)fy.p2, (Long)fy.p1);
            cvtparam.addFixScope(PresetConstant.PERIOD_DIM, (String)period.p2, (Long)period.p1);
            cvtparam.addFixScope(PresetConstant.SCENE_DIM, (String)scene.p2, (Long)scene.p1);
            cvtparam.addFixScope(PresetConstant.CURRENCY_DIM, (String)srcCurrency.p2, (Long)srcCurrency.p1);
            errorMsgs.addAll(ConvertServiceHelper.convert(template, cvtparam));
        }
        return errorMsgs;
    }

    public static boolean generateDataOfCurrPeriodOrYDT(TemplateModel template, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scenario, Pair<Long, String> currency, boolean isNeedMonitorDataStatus) {
        FixScopeParameter scopeParam = new FixScopeParameter();
        scopeParam.addFixScope(DimTypesEnum.ENTITY, SimpleVo.newOne((String)entity.p2, (Long)entity.p1));
        scopeParam.addFixScope(DimTypesEnum.YEAR, SimpleVo.newOne((String)fy.p2, (Long)fy.p1));
        scopeParam.addFixScope(DimTypesEnum.PERIOD, SimpleVo.newOne((String)period.p2, (Long)period.p1));
        scopeParam.addFixScope(DimTypesEnum.SCENARIO, SimpleVo.newOne((String)scenario.p2, (Long)scenario.p1));
        scopeParam.addFixScope(DimTypesEnum.CURRENCY, SimpleVo.newOne((String)currency.p2, (Long)currency.p1));
        GeneratorContext ctx = template == null ? new GeneratorContext(SimpleVo.newOne((String)model.p2, (Long)model.p1), SimpleVo.newOne((String)currency.p2, (Long)currency.p1), scopeParam) : new GeneratorContext(SimpleVo.newOne((String)model.p2, (Long)model.p1), SimpleVo.newOne((String)currency.p2, (Long)currency.p1), scopeParam, template);
        ctx.setNeedMonitorDataStatus(isNeedMonitorDataStatus);
        if (DChangeTypeEnum.YTD == ctx.getScenarioInputChangType()) {
            return new LossOrCashFlowYDTGenCurrPeriod(ctx, 1).generate();
        }
        if (DChangeTypeEnum.CurrentPeriods == ctx.getScenarioInputChangType()) {
            return new LossOrCashFlowCurrPeriodGenYDT(ctx, 1).generate();
        }
        return false;
    }

    public static boolean generateDataOfCurrPeriodOrYDT(Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scenario, Pair<Long, String> currency, boolean isNeedMonitorDataStatus) {
        return ConvertServiceHelper.generateDataOfCurrPeriodOrYDT(null, model, entity, fy, period, scenario, currency, isNeedMonitorDataStatus);
    }

    public static boolean generateBeginPeriodCarry(TemplateModel template, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scenario, Pair<Long, String> currency) {
        FixScopeParameter scopeParam = new FixScopeParameter();
        scopeParam.addFixScope(DimTypesEnum.ENTITY, SimpleVo.newOne((String)entity.p2, (Long)entity.p1));
        scopeParam.addFixScope(DimTypesEnum.YEAR, SimpleVo.newOne((String)fy.p2, (Long)fy.p1));
        scopeParam.addFixScope(DimTypesEnum.PERIOD, SimpleVo.newOne((String)period.p2, (Long)period.p1));
        scopeParam.addFixScope(DimTypesEnum.SCENARIO, SimpleVo.newOne((String)scenario.p2, (Long)scenario.p1));
        scopeParam.addFixScope(DimTypesEnum.CURRENCY, SimpleVo.newOne((String)currency.p2, (Long)currency.p1));
        GeneratorContext ctx = template == null ? new GeneratorContext(SimpleVo.newOne((String)model.p2, (Long)model.p1), null, scopeParam) : new GeneratorContext(SimpleVo.newOne((String)model.p2, (Long)model.p1), null, scopeParam, template);
        return new CvtInfluenceConvertor(ctx, false).generate();
    }

    public static PairList<Long, String> getOrgConvertPath(BaseData baseData, SimpleVo orgv) {
        Long modelId = baseData.getModel().id;
        boolean isAutoConvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData, orgv);
        PairList path = new PairList();
        if (isAutoConvert) {
            DynamicObject org = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgv.id, baseData.getYear().id, baseData.getPeriod().id);
            String orgECNumber = org.getString("currency.number");
            if (StringUtils.isEmpty((Object)orgECNumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %s \u9ed8\u8ba4\u5e01\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u9ed8\u8ba4\u5e01\u3002", (String)"ConvertServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), org.getString("number")));
            }
            DynamicObject currencyEC = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("number", "=", (Object)orgECNumber).toArray());
            if (currencyEC == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u7ec4\u7ec7 %1$s \u7684\u9ed8\u8ba4\u5e01 %2$s\uff0c\u8bf7\u7ef4\u62a4\u5e01\u79cd\u7ef4\u5ea6\u6210\u5458\u3002", (String)"ConvertServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), org.getString("number"), orgECNumber));
            }
            path.addPair((Object)currencyEC.getLong("id"), (Object)currencyEC.getString("number"));
            DynamicObject perant = OrgCurrencyServiceHelper.getParentOrgModelAndCurrency(orgv.id, baseData.getYear().id, baseData.getPeriod().id);
            if (perant.getString("currency.number") != null) {
                DynamicObject currencyPC = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("number", "=", (Object)perant.getString("currency.number")).toArray());
                if (!currencyEC.getString("number").equals(currencyPC.getString("number"))) {
                    path.addPair((Object)currencyPC.getLong("id"), (Object)currencyPC.getString("number"));
                    return path;
                }
            }
        }
        path.toList().clear();
        return path;
    }

    public static Set<String> getAllConvertTargetCurNumSet(long modelId, long sceneId, long yearId, long periodId, long orgId) {
        return (Set)ThreadCache.get((Object)("getAllConvertCurrencyNumber" + modelId + sceneId + yearId + periodId + orgId), () -> {
            HashSet<String> convertCurrencyNumberSet = new HashSet<String>(16);
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
                logger.error("getAllConvertCurrency: org is not exist, modelId = {}, orgId = {}", (Object)modelId, (Object)orgId);
                return convertCurrencyNumberSet;
            }
            if ("Entity".equals(orgNode.getNumber())) {
                logger.error("getAllConvertCurrency: org is Entity, modelId = {}, orgId = {}", (Object)modelId, (Object)orgId);
                return convertCurrencyNumberSet;
            }
            boolean isRootOrg = "Entity".equals(orgNode.getParent().getNumber());
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("status", "=", (Object)"1");
            String selectField = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_specialrate").getAllFields().keySet());
            DynamicObject[] specialRatePlan = BusinessDataServiceHelper.load((String)"bcm_specialrate", (String)selectField, (QFilter[])filter.toArray(), (String)"executionorder desc");
            LinkedHashMap<Integer, List> specialRatePlanByOrderMap = new LinkedHashMap<Integer, List>(specialRatePlan.length);
            for (DynamicObject dy : specialRatePlan) {
                Integer execOrder = dy.getInt("executionorder");
                List list = specialRatePlanByOrderMap.computeIfAbsent(execOrder, k -> new ArrayList(10));
                list.add(dy);
            }
            DynamicObject targetRatePlan = null;
            List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
            block1: for (List planGroupList : specialRatePlanByOrderMap.values()) {
                planGroupList.sort(new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return Long.compare(o2.getLong("id"), o1.getLong("id"));
                    }
                });
                for (DynamicObject ratePlan : planGroupList) {
                    DynamicObjectCollection effectSettingList = ratePlan.getDynamicObjectCollection("effective");
                    if (ratePlan.getDynamicObject("scenario") != null && ratePlan.getDynamicObject("scenario").getLong("id") != sceneId || !ConvertDifferenceHandle.isApply(yearId, periodId, effectSettingList, yearIdsList)) continue;
                    DynamicObjectCollection entryEntity = ratePlan.getDynamicObjectCollection("entryentity");
                    if (entryEntity.isEmpty()) {
                        targetRatePlan = ratePlan;
                        break block1;
                    }
                    for (DynamicObject member : entryEntity) {
                        boolean isCustom = member.getDynamicObject("propertyid") != null;
                        HashSet temp = new HashSet(16);
                        new MembRangeItem(member.getDynamicObject("dimension").getString("membermodel"), (Long)member.getLong("memberid"), null, RangeEnum.getRangeByVal((int)member.getInt("membbound")), isCustom, (Object)modelId).matchItems(c -> temp.add(c.number));
                        if (!temp.contains(orgNode.getNumber())) continue;
                        targetRatePlan = ratePlan;
                        break block1;
                    }
                }
            }
            long rateOrgId = 0L;
            boolean isAutoConvert = true;
            if (targetRatePlan == null) {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and("scenario", "=", (Object)0);
                DynamicObject basicRate = BusinessDataServiceHelper.loadSingle((String)"bcm_basecvtformula", (String)"exchangerate.id, isautoconvert", (QFilter[])qFilter.toArray());
                if (basicRate != null) {
                    rateOrgId = basicRate.getLong("exchangerate.id");
                    isAutoConvert = basicRate.getBoolean("isautoconvert");
                } else {
                    QFilter defaultRateFilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"RatePreset");
                    DynamicObject ratePreset = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"id,number,name", (QFilter[])defaultRateFilter.toArray());
                    if (ratePreset == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u627e\u4e0d\u5230\u901a\u7528\u6c47\u7387\u65b9\u6848\u3002", (String)"ConvertServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[]{orgNode.getNumber()}));
                    }
                    rateOrgId = ratePreset.getLong("id");
                }
            } else {
                rateOrgId = targetRatePlan.getLong("exchangerate.id");
                isAutoConvert = targetRatePlan.getBoolean("isautoconvert");
            }
            if (rateOrgId > 0L && isAutoConvert) {
                IDNumberTreeNode baseOrgNode = orgNode.getBaseTreeNode();
                List shareNodes = baseOrgNode.getShareNodes();
                shareNodes.add(baseOrgNode);
                String yearNumber = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
                FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, sceneId, yearNumber, periodId);
                Map<Long, String> effectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(filterOrgStructParam, shareNodes.stream().map(IDNumberTreeNode::getId).collect(Collectors.toList()));
                Table<String, String, Boolean> isMergeMap = MergeControlHelper.getAllStructInfoForTable(modelId, sceneId, yearId, periodId);
                for (IDNumberTreeNode shareNode : shareNodes) {
                    if (!effectiveOrgMap.containsKey(shareNode.getId())) continue;
                    IDNumberTreeNode parent = shareNode.getParent();
                    MergeDataSourceEnum mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)sceneId, (Object)yearId, (Object)periodId, parent.getId());
                    boolean isSIRpt = mergeDataSourceEnum.getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex());
                    Boolean isMerge = (Boolean)isMergeMap.get((Object)parent.getNumber(), (Object)shareNode.getNumber());
                    if (!isSIRpt || Boolean.FALSE.equals(isMerge) || orgNode.getCurrency().equals(parent.getCurrency()) || parent.getCurrency() == null) continue;
                    convertCurrencyNumberSet.add(parent.getCurrency());
                }
            }
            return convertCurrencyNumberSet;
        });
    }

    public static PairList<Long, String> getOrgConvertPath(FixedItem commonItem) {
        if (commonItem.getModelId() > 0L && commonItem.getOrgId() > 0L && commonItem.getScenarioId() > 0L && commonItem.getFyId() > 0L && commonItem.getPeriodId() > 0L) {
            BaseData baseData = new BaseData((Long)commonItem.getModel().getId(), commonItem.getScenario(), commonItem.getFy(), commonItem.getPeriod());
            return ConvertServiceHelper.getOrgConvertPath(baseData, SimpleVo.newOne(commonItem.getOrg()));
        }
        return new PairList();
    }

    public static Set<String> getAutoPCByOrgNum(String cube, String orgNumber, String sceneNumber, String yearNumber, String periodNumber) {
        HashSet<String> currencys = new HashSet<String>(8);
        ArrayList<SimpleVo> orgVos = new ArrayList<SimpleVo>(16);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)cube, (String)orgNumber);
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
            // empty if block
        }
        orgNode.getShareNodes().forEach(s -> orgVos.add(SimpleVo.newOne(s.getNumber(), s.getId())));
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)cube, (String)sceneNumber);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)cube, (String)yearNumber);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)cube, (String)periodNumber);
        if (IDNumberTreeNode.NotFoundTreeNode == sceneNode || IDNumberTreeNode.NotFoundTreeNode == yearNode || IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            // empty if block
        }
        BaseData baseData = new BaseData(cube, sceneNode, yearNode, periodNode);
        Map<Long, Pair<Boolean, Long>> result = ExchangeQueryHelper.queryOrgRate(baseData, orgVos);
        result.forEach((k, v) -> {
            DynamicObject parent;
            if (Objects.equals(v.p1, Boolean.TRUE) && (parent = OrgCurrencyServiceHelper.getParentOrgModelAndCurrency(k, yearNode.getId(), periodNode.getId())).getString("currency.number") != null) {
                currencys.add(parent.getString("currency.number"));
            }
        });
        return currencys;
    }

    public static Set<String> convertByPath(long templateId, List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene) {
        return ConvertServiceHelper.convertByPath(TemplateServiceHelper.getTemplateModelById(templateId), cvtPaths, model, entity, fy, period, scene);
    }

    public static Set<String> convertByPath(List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene) {
        return ConvertServiceHelper.convertByPath(cvtPaths, model, entity, fy, period, scene, true);
    }

    public static Set<String> convertByPath(List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene, boolean isNeedMonitorDataStatus) {
        return ConvertServiceHelper.convertByPath(cvtPaths, model, entity, fy, period, scene, true, true);
    }

    public static Set<String> convertByPath(List<Pair<Long, String>> cvtPaths, Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> scene, boolean isNeedMonitorDataStatus, boolean isForceExec) {
        HashSet<String> errorMsg = new HashSet<String>(16);
        if (cvtPaths != null && cvtPaths.size() == 2) {
            Pair<Long, String> srcCurrency = cvtPaths.get(0);
            Pair<Long, String> cvtCurrency = cvtPaths.get(1);
            ConvertParam cvtparam = new ConvertParam(null, cvtCurrency, model);
            cvtparam.setNeedMonitorDataStatus(isNeedMonitorDataStatus);
            cvtparam.addFixScope(PresetConstant.ENTITY_DIM, (String)entity.p2, (Long)entity.p1);
            cvtparam.addFixScope(PresetConstant.FY_DIM, (String)fy.p2, (Long)fy.p1);
            cvtparam.addFixScope(PresetConstant.PERIOD_DIM, (String)period.p2, (Long)period.p1);
            cvtparam.addFixScope(PresetConstant.SCENE_DIM, (String)scene.p2, (Long)scene.p1);
            cvtparam.addFixScope(PresetConstant.CURRENCY_DIM, (String)srcCurrency.p2, (Long)srcCurrency.p1);
            cvtparam.setForceExec(isForceExec);
            errorMsg.addAll(ConvertServiceHelper.convert(cvtparam));
        }
        return errorMsg;
    }

    public static Set<String> convert4ProcessSpilt(Long model, String scene, String fy, String period, String entityNum, String process, String cvtCurrency, boolean isNeedMonitorDataStatus) {
        IDNumberTreeNode proNode;
        if ("OC".equals(cvtCurrency) || "PC".equals(cvtCurrency) || "EC".equals(cvtCurrency) || "DC".equals(cvtCurrency)) {
            return new HashSet<String>(0);
        }
        String modelNum = MemberReader.findModelNumberById((Object)model);
        IDNumberTreeNode processNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Process", (String)process);
        List detailProcess = processNode.getAllChildren().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toList());
        detailProcess.add(process);
        if (detailProcess.contains("ERpt") || detailProcess.contains("IRpt")) {
            detailProcess.add("Rpt");
        }
        if (detailProcess.contains("EJE") && !(proNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Process", (String)"EJE")).isLeaf()) {
            detailProcess.add("EJE");
        }
        HashSet<String> errorMsg = new HashSet<String>();
        IDNumberTreeNode orgNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Entity", (String)entityNum);
        IDNumberTreeNode sceneNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Scenario", (String)scene);
        IDNumberTreeNode fyNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Year", (String)fy);
        IDNumberTreeNode periodNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Period", (String)period);
        IDNumberTreeNode cvtNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Currency", (String)cvtCurrency);
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode || sceneNode == IDNumberTreeNode.NotFoundTreeNode || fyNode == IDNumberTreeNode.NotFoundTreeNode || periodNode == IDNumberTreeNode.NotFoundTreeNode || cvtNode == IDNumberTreeNode.NotFoundTreeNode) {
            return errorMsg;
        }
        if (orgNode.isLeaf()) {
            detailProcess.remove("DADJ");
            detailProcess.remove("DEJE");
        }
        String cvtPathPrefixKey = "convert4ProcessSpilt_" + model + "_" + scene + "_" + fy + "_" + period + "_";
        boolean isConvertOrgRel = ConfigServiceHelper.getBoolParam(model, "isConvertOrgRelaProcessMemb");
        for (String cvtProcess : toCvtProcess) {
            if (!cvtProcess.equals("Rpt") && !cvtProcess.equals("ADJ") && !isConvertOrgRel || !detailProcess.contains(cvtProcess)) continue;
            errorMsg.addAll((Collection)BcmThreadCache.get((Object)cvtPathPrefixKey, (Object)entityNum, (Object)cvtProcess, (Object)cvtCurrency, () -> {
                try {
                    FixScopeParameter scopeParam = new FixScopeParameter();
                    if (OrgRelaProcessMembPool.isRelaProcess((String)cvtProcess)) {
                        scopeParam.addFixScope(DimTypesEnum.ENTITY, SimpleVo.newOne(orgNode.getParent_SonNumber(), orgNode.getId()));
                    } else {
                        scopeParam.addFixScope(DimTypesEnum.ENTITY, SimpleVo.newOne(orgNode.getNumber(), orgNode.getId()));
                    }
                    scopeParam.addFixScope(DimTypesEnum.YEAR, SimpleVo.newOne(fyNode.getNumber(), fyNode.getId()));
                    scopeParam.addFixScope(DimTypesEnum.PERIOD, SimpleVo.newOne(periodNode.getNumber(), periodNode.getId()));
                    scopeParam.addFixScope(DimTypesEnum.SCENARIO, SimpleVo.newOne(sceneNode.getNumber(), sceneNode.getId()));
                    String cvtBeforeCurrency = orgNode.getCurrency();
                    if (OrgRelaProcessMembPool.isRelaProcess((String)cvtProcess) && orgNode.getParent() != null && !"Entity".equals(orgNode.getParent().getNumber())) {
                        cvtBeforeCurrency = orgNode.getParent().getCurrency();
                    }
                    scopeParam.addFixScope(DimTypesEnum.CURRENCY, SimpleVo.newOne(cvtBeforeCurrency, BcmThreadCache.findMemberByNum((String)modelNum, (String)"Currency", (String)cvtCurrency).getId()));
                    CvtContext4InvElim ctx = new CvtContext4InvElim(SimpleVo.newOne(modelNum, model), SimpleVo.newOne(cvtNode.getNumber(), cvtNode.getId()), scopeParam, cvtProcess);
                    ctx.setNeedMonitorDataStatus(isNeedMonitorDataStatus);
                    return new ConvertService(ctx).convert();
                }
                catch (Throwable t) {
                    return Collections.singleton(AdjustmentServiceHelper.toString_Adj(t));
                }
            }));
        }
        return errorMsg;
    }

    public static FixScopeParameter paramToFixScopeParam(ConvertParam cvtparam) {
        FixScopeParameter scopeParam = new FixScopeParameter();
        cvtparam.getFixScopeParam().forEach((dimNum, memb) -> scopeParam.addFixScope(DimTypesEnum.getDimTypesEnumByNumber((String)dimNum), SimpleVo.newOne((String)memb.p1, (Long)memb.p2)));
        return scopeParam;
    }

    public static boolean checkCanDisplayFormula(Long modelId, String accountType, String changeWay, String changeTypeMember, String exchange) {
        ExchangeEnum exchangeEnum;
        if (StringUtils.isEmpty((Object)accountType) || StringUtils.isEmpty((Object)changeWay) || StringUtils.isEmpty((Object)changeTypeMember) || StringUtils.isEmpty((Object)exchange)) {
            return false;
        }
        switch (ChangewayEnum.getChangewayEnumByIndex((String)changeWay)) {
            case EARLYYEARTURN: 
            case ACCOUNT: 
            case NONE: {
                return false;
            }
        }
        if (AccountTypeEnum.LOSS == AccountTypeEnum.getEnum((String)accountType) && MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)modelId)) && !"YTD".equals(changeTypeMember)) {
            switch (ChangewayEnum.getChangewayEnumByIndex((String)changeWay)) {
                case THIS: 
                case CREATE: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return (exchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)exchange)) == null || exchangeEnum != ExchangeEnum.NONE;
    }

    public static List<Pair<Long, String>> getCurrectCvtPath(List<Pair<Long, String>> cvtPaths, long entityId, Long yearId, Long periodId) {
        DynamicObject currency = null;
        ArrayList<Pair<Long, String>> result = new ArrayList<Pair<Long, String>>(10);
        for (Pair<Long, String> path : cvtPaths) {
            if (((String)path.p2).equals("EC")) {
                if (currency == null) {
                    currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)entityId, yearId, periodId);
                }
                result.add((Pair<Long, String>)Pair.onePair((Object)currency.getLong("id"), (Object)currency.getString("number")));
                continue;
            }
            result.add(path);
        }
        return result;
    }

    public static void updateConvertStatus(String modelNum, String sceneNum, String yearNum, String periodNum, String orgNum, String currencyNum, String processNum, String cvtCurrencyNum) {
        HashSet<Map<String, String>> rows = new HashSet<Map<String, String>>(1);
        HashMap<String, String> row = new HashMap<String, String>(6);
        row.put(PresetConstant.SCENE_DIM, sceneNum);
        row.put(PresetConstant.FY_DIM, yearNum);
        row.put(PresetConstant.PERIOD_DIM, periodNum);
        row.put(PresetConstant.ENTITY_DIM, orgNum);
        row.put(PresetConstant.CURRENCY_DIM, currencyNum);
        row.put(PresetConstant.PROCESS_DIM, processNum);
        rows.add(row);
        ConvertServiceHelper.updateConvertStatusBatch(modelNum, rows, cvtCurrencyNum);
    }

    public static void updateConvertStatusBatch(String cube, Set<Map<String, String>> rows) {
        ConvertServiceHelper.updateConvertStatusBatch(cube, rows, null);
    }

    public static void updateConvertStatusBatch(String cube, Set<Map<String, String>> rows, String cvtCurrencyNum) {
        ConvertUtil.updateConvertStatusBatch(cube, rows, cvtCurrencyNum);
    }

    public static void updateConvertStatusBatch(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        StringBuilder sb = new StringBuilder("update t_bcm_convertstatus");
        sb.append(" set fstatus='").append(ConvertStatusEnum.UPDATED.getIndex()).append("' where fmodelid = ").append(modelId);
        if (scenarioId != null) {
            sb.append(" and fsceneid = ").append(scenarioId);
        }
        if (yearId != null) {
            sb.append(" and fyearid = ").append(yearId);
        }
        if (periodId != null) {
            sb.append(" and fperiodid = ").append(periodId);
        }
        DB.execute((DBRoute)new DBRoute("bcm"), (String)sb.toString());
    }

    public static boolean isSingleOrgConvert(String cvtOrgScope) {
        return !ConvertOrgScopeEnum.DIRECT_SUB_ORG.getScope().equals(cvtOrgScope) && !ConvertOrgScopeEnum.ALL_SUB_ORG.getScope().equals(cvtOrgScope);
    }
}

