/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ConvertStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class ConvertStatusHelper {
    public static void resetConvertStatus(long modelId, long orgId, long scenarioId, long yearId, long periodId, String processNumber) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode processMember = MemberReader.findProcessMemberByNum((String)modelNumber, (String)processNumber);
        if (processMember != null) {
            ConvertStatusHelper.resetConvertStatus(modelId, orgId, scenarioId, yearId, periodId, processMember.getId());
        }
    }

    public static void resetConvertStatus(long modelId, long orgId, long scenarioId, long yearId, long periodId, long processId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
        long baseOrgId = orgId;
        if (orgNode.isShare()) {
            baseOrgId = orgNode.getBaseTreeNode().getId();
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("entity", "=", (Object)baseOrgId).add("scene", "=", (Object)scenarioId).add("year", "=", (Object)yearId).add("period", "=", (Object)periodId).add("process", "=", (Object)processId);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_convertstatus", (String)"scene.id, scene.number, year.id, year.number, period.id, period.number, entity.id, entity.number, currency.id, currency.number, process.id, process.number, cvtcurrency.id, cvtcurrency.number, status, modifier, modifytime", (QFilter[])qfBuilder.toArray());
        if (dos != null && dos.length > 0) {
            for (DynamicObject dynamicObject : dos) {
                dynamicObject.set("status", (Object)ConvertStatusEnum.UPDATED.getIndex());
                dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])dos);
        }
    }
}

