/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.util;

import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ConvertStatusEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class ConvertUtil {
    public static BigDecimal convert(BaseData baseData, String orgNum, String srcNum, String tgtNum, String account, String changeType, ExchangeEnum exc, ChangewayEnum ct, BigDecimal oriVal) {
        RateModel rm = ConvertUtil.getExchangeRateDetail(baseData, orgNum, srcNum, tgtNum);
        if (rm == null || rm == RateModel.EMPTY_RATE_MODEL) {
            return BigDecimal.ZERO;
        }
        BigDecimal rate = ConvertUtil.getRate(account, changeType, exc, ct, rm);
        if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = rm.isMultiply() ? oriVal.multiply(rate).setScale(rm.getPrecision(), RoundingMode.HALF_UP) : oriVal.divide(rate, rm.getPrecision(), RoundingMode.HALF_UP);
        return result;
    }

    public static RateModel getExchangeRateDetail(BaseData baseData, String orgNum, String srcNum, String tgtNum) {
        if (baseData == null || baseData == BaseData.EMPTY_BASEDATA) {
            return RateModel.EMPTY_RATE_MODEL;
        }
        return (RateModel)ThreadCache.get((Object)(baseData + orgNum + srcNum + tgtNum), () -> {
            ModelRate modelRate = ExchangeQueryHelper.getModeRate(baseData);
            RateSchema rateSchema = modelRate.getRateSchemaByOrgNum(orgNum);
            return rateSchema.getRateModelBySrcTgt(srcNum, tgtNum);
        });
    }

    public static BigDecimal getRate(String acctNum, String chgTypeNum, ExchangeEnum exc, ChangewayEnum incw, RateModel rm) {
        if (exc == null || incw == null || rm == null) {
            return BigDecimal.ZERO;
        }
        if ("BOP".equals(chgTypeNum)) {
            incw = ChangewayEnum.End;
        }
        ChangewayEnum cw = incw;
        return (BigDecimal)ThreadCache.get((Object)(acctNum + chgTypeNum + exc.name() + cw.name() + rm.getTag()), () -> {
            BigDecimal rate = null;
            String msg = exc.getName();
            switch (exc) {
                case TERMINAL: {
                    if (ChangewayEnum.End == cw || ChangewayEnum.CREATE == cw || ChangewayEnum.THIS == cw) {
                        rate = rm.getPeriodendRate();
                        break;
                    }
                    if (ChangewayEnum.EARLYYEARADJUST != cw) break;
                    rate = rm.getBeginyearRate();
                    msg = ResManager.loadKDString((String)"\u5e74\u521d\u6c47\u7387", (String)"ConvertUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case AVERAGE: {
                    if (ChangewayEnum.End == cw || ChangewayEnum.CREATE == cw || ChangewayEnum.THIS == cw) {
                        rate = rm.getAverageRate();
                        break;
                    }
                    if (ChangewayEnum.EARLYYEARADJUST != cw) break;
                    rate = rm.getBeginyearAvgRate();
                    msg = ResManager.loadKDString((String)"\u5e74\u521d\u5e73\u5747\u6c47\u7387", (String)"ConvertUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case UserdefinedRate: {
                    if (ChangewayEnum.EARLYYEARADJUST == cw) {
                        rate = rm.getBeginyearUfRate();
                        msg = ResManager.loadKDString((String)"\u5e74\u521d\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"ConvertUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]);
                        break;
                    }
                    rate = rm.getUserdefineRate();
                    break;
                }
                case ONE: {
                    rate = BigDecimal.ONE;
                }
            }
            BigDecimal userdefinedN = rm.getRateByNumber(exc.name());
            if (rate == null && Objects.nonNull(userdefinedN)) {
                rate = rm.getRateByNumber(exc.name());
            }
            if (rate == null || rate.compareTo(BCMConstant.Zero) == 0) {
                throw new CvtExchangeException(String.format(ResManager.loadKDString((String)"\u79d1\u76ee[%1$s],\u53d8\u52a8\u7c7b\u578b[%2$s]\u8bbe\u7f6e\u7684[%3$s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6c47\u7387\u7ba1\u7406\u4e2d\u7ef4\u62a4\u5bf9\u5e94\u6c47\u7387\u3002", (String)"ConvertUtil_11", (String)"fi-bcm-business", (Object[])new Object[0]), acctNum, chgTypeNum, msg));
            }
            return rate;
        });
    }

    public static BigDecimal getRate(RateModel rm, ExchangeEnum exchangeEnum) {
        return (BigDecimal)ThreadCache.get((Object)("extRateNumber" + rm.getTag() + exchangeEnum.name()), () -> {
            BigDecimal rate = null;
            switch (exchangeEnum) {
                case TERMINAL: {
                    rate = rm.getPeriodendRate();
                    break;
                }
                case AVERAGE: {
                    rate = rm.getAverageRate();
                    break;
                }
                case UserdefinedRate: {
                    rate = rm.getUserdefineRate();
                    break;
                }
                case ONE: {
                    rate = BigDecimal.ONE;
                }
            }
            BigDecimal userdefinedN = rm.getRateByNumber(exchangeEnum.name());
            if (rate == null && Objects.nonNull(userdefinedN)) {
                rate = rm.getRateByNumber(exchangeEnum.name());
            }
            return rate;
        });
    }

    public static String[] copyArr(String[] src) {
        String[] copy = new String[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }

    public static Long convertObjToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        return (Long)obj;
    }

    public static Set<Long> convertListToLong(Collection<String> list) {
        HashSet<Long> result = new HashSet<Long>(list.size());
        for (String s : list) {
            result.add(Long.valueOf(s));
        }
        return result;
    }

    public static Set<Long> convertObjsToLongs(Collection<Object> list) {
        HashSet<Long> result = new HashSet<Long>(list.size());
        for (Object s : list) {
            result.add(ConvertUtil.convertObjToLong(s));
        }
        return result;
    }

    public static Set<Long> convertArrayToLong(Object[] array) {
        HashSet<Long> result = new HashSet<Long>(array.length);
        for (Object s : array) {
            if (s == null || !StringUtils.isNotEmpty((CharSequence)s.toString())) continue;
            result.add(ConvertUtil.convertObjToLong(s));
        }
        return result;
    }

    public static Long convertStrToLong(String str) {
        if (str == null) {
            return 0L;
        }
        return Long.valueOf(str);
    }

    public static Set<Long> convertObjsToLongArray(Collection<String> list) {
        HashSet<Long> result = new HashSet<Long>(list.size());
        for (String s : list) {
            result.add(ConvertUtil.convertObjToLong(s));
        }
        return result;
    }

    public static Set<String> convertLongListToStringList(Object[] list) {
        HashSet<String> result = new HashSet<String>(list.length);
        for (Object s : list) {
            result.add("" + s);
        }
        return result;
    }

    public static boolean isConvertFinish(String model, String scene, String year, String period, String entity, String currency, String process, String cvtCurrency) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)MemberReader.findModelIdByNum((String)model));
        qf.add("scene", "=", (Object)MemberReader.findScenaMemberByNum((String)model, (String)scene).getId());
        qf.add("year", "=", (Object)MemberReader.findFyMemberByNum((String)model, (String)year).getId());
        qf.add("period", "=", (Object)MemberReader.findPeriodMemberByNum((String)model, (String)period).getId());
        qf.add("currency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)model, (String)currency).getId());
        qf.add("process", "=", (Object)MemberReader.findProcessMemberByNum((String)model, (String)process).getId());
        qf.add("orgwithparent", "=", (Object)entity);
        qf.add("cvtcurrency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)model, (String)cvtCurrency).getId());
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_convertstatus", (String)"id,status", (QFilter[])qf.toArray(), (String)"modifytime desc");
        if (collections.size() > 0) {
            DynamicObject status = (DynamicObject)collections.get(0);
            if (collections.size() > 1) {
                int count = collections.size();
                HashSet<Long> deleteIds = new HashSet<Long>(count);
                for (int i = 1; i < count; ++i) {
                    deleteIds.add(((DynamicObject)collections.get(i)).getLong("id"));
                }
                QFilter qFilter = new QFilter("id", "in", deleteIds);
                DeleteServiceHelper.delete((String)"bcm_convertstatus", (QFilter[])qFilter.toArray());
            }
            return status.getInt("status") == ConvertStatusEnum.FINISH.getIndex();
        }
        return false;
    }

    public static void updateConvertStatusBatch(String cube, Set<Map<String, String>> rows, String cvtCurrency) {
        boolean isCvt = cvtCurrency != null;
        HashMap<String, Set> filters = new HashMap<String, Set>();
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        for (Map<String, String> row : rows) {
            for (Map.Entry<String, String> entry : row.entrySet()) {
                Set members = filters.computeIfAbsent(entry.getKey(), k -> new HashSet());
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)cube, (String)entry.getKey(), (String)entry.getValue());
                members.add(node.getId());
                if (!PresetConstant.ENTITY_DIM.equals(entry.getKey())) continue;
                orgNumberSet.add(entry.getValue());
            }
        }
        Long modelId = MemberReader.findModelIdByNum((String)cube);
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        if (!orgNumberSet.isEmpty()) {
            qf.add("orgwithparent", "in", orgNumberSet);
        }
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String field = entry.getKey();
            if (PresetConstant.SCENE_DIM.equals(field)) {
                field = "scene";
            } else if (PresetConstant.ENTITY_DIM.equals(field)) continue;
            if (((Set)((Object)entry.getValue())).isEmpty()) continue;
            qf.add(field, "in", (Object)entry.getValue());
        }
        if (isCvt) {
            qf.add("cvtcurrency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)cube, (String)cvtCurrency).getId());
        }
        ArrayList<DynamicObject> listToUpdate = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(10);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_convertstatus", (String)"scene.id, scene.number, year.id, year.number, period.id, period.number, entity.id, entity.number, orgwithparent,currency.id, currency.number, process.id, process.number, cvtcurrency.id, cvtcurrency.number, status, modifier, modifytime", (QFilter[])qf.toArray());
        HashMultimap existMap = HashMultimap.create();
        for (DynamicObject dyn : dos) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put(PresetConstant.SCENE_DIM, dyn.getString("scene.number"));
            row.put(PresetConstant.FY_DIM, dyn.getString("year.number"));
            row.put(PresetConstant.PERIOD_DIM, dyn.getString("period.number"));
            row.put(PresetConstant.ENTITY_DIM, dyn.getString("orgwithparent"));
            row.put(PresetConstant.CURRENCY_DIM, dyn.getString("currency.number"));
            row.put(PresetConstant.PROCESS_DIM, dyn.getString("process.number"));
            existMap.put(row, (Object)dyn);
        }
        if (isCvt) {
            for (Map map : rows) {
                if (Objects.equals(map.get(PresetConstant.CURRENCY_DIM), cvtCurrency)) continue;
                Collection existDyn = existMap.get((Object)map);
                if (!existDyn.isEmpty()) {
                    for (DynamicObject dynamicObject : existDyn) {
                        dynamicObject.set("status", (Object)ConvertStatusEnum.FINISH.getIndex());
                        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                        dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                        listToUpdate.add(dynamicObject);
                    }
                    continue;
                }
                DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"bcm_convertstatus");
                info.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                info.set("model", (Object)modelId);
                info.set("scene", (Object)MemberReader.findScenaMemberByNum((String)cube, (String)((String)map.get(PresetConstant.SCENE_DIM))).getId());
                info.set("year", (Object)MemberReader.findFyMemberByNum((String)cube, (String)((String)map.get(PresetConstant.FY_DIM))).getId());
                info.set("period", (Object)MemberReader.findPeriodMemberByNum((String)cube, (String)((String)map.get(PresetConstant.PERIOD_DIM))).getId());
                info.set("currency", (Object)MemberReader.findCurrencyMemberByNum((String)cube, (String)((String)map.get(PresetConstant.CURRENCY_DIM))).getId());
                info.set("cvtcurrency", (Object)MemberReader.findCurrencyMemberByNum((String)cube, (String)cvtCurrency).getId());
                info.set("entity", (Object)MemberReader.findEntityMemberByNum((String)cube, (String)((String)map.get(PresetConstant.ENTITY_DIM))).getId());
                info.set("process", (Object)MemberReader.findProcessMemberByNum((String)cube, (String)((String)map.get(PresetConstant.PROCESS_DIM))).getId());
                info.set("orgwithparent", map.get(PresetConstant.ENTITY_DIM));
                info.set("status", (Object)ConvertStatusEnum.FINISH.getIndex());
                info.set("modifier", (Object)RequestContext.get().getUserId());
                info.set("modifytime", (Object)TimeServiceHelper.now());
                arrayList.add(info);
            }
        } else {
            for (Map map : rows) {
                Collection existDyn;
                if (map.get(PresetConstant.CURRENCY_DIM) == null || (existDyn = existMap.get((Object)map)).isEmpty()) continue;
                for (DynamicObject dynamicObject : existDyn) {
                    dynamicObject.set("status", (Object)ConvertStatusEnum.UPDATED.getIndex());
                    dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                    dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                    listToUpdate.add(dynamicObject);
                }
            }
        }
        if (listToUpdate.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])listToUpdate.toArray(new DynamicObject[0]));
        }
        if (arrayList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
        }
    }

    public static boolean checkFromReportAndNoExchange(ExecuteContext coverttxt) {
        BaseData baseData = new BaseData((Long)coverttxt.getModel().getId(), coverttxt.getScenario(), coverttxt.getFy(), coverttxt.getPeriod());
        RateSchema exchangeRate = ExchangeQueryHelper.getRateSchemaByOrg(baseData, SimpleVo.newOne(coverttxt.getOrg()));
        List<Pair<Long, String>> paths = coverttxt.getNowPaths();
        RateModel rm = exchangeRate.getRateModelBySrcTgt((String)paths.get((int)0).p2, (String)paths.get((int)1).p2);
        if (rm == RateModel.EMPTY_RATE_MODEL) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void handleCurrency(String cubeNumber, DynamicObject[] rows, Set<String> handleCols) {
        if (rows == null || rows.length == 0 || handleCols == null || handleCols.isEmpty()) {
            return;
        }
        for (DynamicObject row : rows) {
            String account = row.getString("account");
            String currency = row.getString("currency");
            String scene = row.getString("scenario");
            Integer scale = ConvertUtil.getCurrencyScale(cubeNumber, scene, currency, account);
            handleCols.forEach(v -> {
                BigDecimal data = row.getBigDecimal(v);
                if (Objects.nonNull(data) && BigDecimal.ZERO.compareTo(data) != 0 && scale <= 15) {
                    row.set(v, (Object)CurrencyScaleHandler.handleByScaleEnum(data, scale));
                }
            });
        }
    }

    public static Integer getCurrencyScale(String cubeNumber, String scenarioMember, String currencyMember, String accountMember) {
        if (StringUtils.isEmpty((CharSequence)accountMember)) {
            return CurrencyScaleHandler.getCurrencyScale(scenarioMember, currencyMember, cubeNumber);
        }
        Long modelId = MemberReader.findModelIdByNum((String)cubeNumber);
        Map<String, Integer> accountMap = CurrencyScaleHandler.getAccountScale(modelId);
        if (accountMap.get(accountMember) != null) {
            return accountMap.get(accountMember);
        }
        return CurrencyScaleHandler.getCurrencyScale(scenarioMember, currencyMember, cubeNumber);
    }
}

