/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.util;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ConvertStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ExtConvertUtil {
    public static final String SPLIT = "|";

    public static boolean isFinish(String model, String scenario, String year, String period, String entity, String currency, String process, String dataModel) {
        Map res = (Map)ThreadCache.get((Object)ExtConvertUtil.getCacheKey(model, scenario, year, period, entity, currency, process), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)MemberReader.findModelIdByNum((String)model));
            qf.add("scenario", "=", (Object)scenario);
            qf.add("year", "=", (Object)year);
            qf.add("period", "=", (Object)period);
            qf.add("entity", "=", (Object)MemberReader.findEntityMemberByNum((String)model, (String)entity).getParent_SonNumber());
            qf.add("currency", "=", (Object)currency);
            qf.add("process", "=", (Object)process);
            DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_extconvertstatus", (String)"id,datamodel,status", (QFilter[])qf.toArray(), (String)"modifytime desc");
            ArrayList<Long> deleteIds = new ArrayList<Long>(10);
            if (!collections.isEmpty()) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                for (DynamicObject collection : collections) {
                    if (map.containsKey(collection.getString("datamodel"))) {
                        deleteIds.add(collection.getLong("id"));
                        continue;
                    }
                    map.put(collection.getString("datamodel"), collection.getInt("status") == ConvertStatusEnum.FINISH.getIndex());
                }
                if (!deleteIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)"bcm_extconvertstatus", (QFilter[])new QFilter("id", "in", deleteIds).toArray());
                }
                return map;
            }
            return Collections.emptyMap();
        });
        return res.getOrDefault(dataModel, false);
    }

    public static void updateConvertStatus(String model, String scenario, String year, String period, String entity, String currency, String process, List<String> dataModels, ConvertStatusEnum statusEnum) {
        QFBuilder qf = new QFBuilder();
        Long modelId = MemberReader.findModelIdByNum((String)model);
        qf.add("model", "=", (Object)modelId);
        qf.add("scenario", "=", (Object)scenario);
        qf.add("year", "=", (Object)year);
        qf.add("period", "=", (Object)period);
        String parentSonNumber = MemberReader.findEntityMemberByNum((String)model, (String)entity).getParent_SonNumber();
        qf.add("entity", "=", (Object)parentSonNumber);
        if (currency != null) {
            qf.add("currency", "=", (Object)currency);
        }
        qf.add("process", "=", (Object)process);
        if (CollectionUtils.isNotEmpty(dataModels)) {
            qf.add("datamodel", "in", dataModels);
        }
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_extconvertstatus", (String)"id,datamodel,status,modifier,modifytime", (QFilter[])qf.toArray());
        HashMultimap existMap = HashMultimap.create();
        for (DynamicObject doc : docs) {
            existMap.put((Object)doc.getString("datamodel"), (Object)doc);
        }
        if (currency == null || CollectionUtils.isEmpty(dataModels) && !existMap.isEmpty()) {
            for (DynamicObject doc : docs) {
                doc.set("status", (Object)statusEnum.getIndex());
                doc.set("modifier", (Object)RequestContext.get().getCurrUserId());
                doc.set("modifytime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])docs);
        } else {
            ArrayList res1 = new ArrayList(10);
            ArrayList<DynamicObject> res2 = new ArrayList<DynamicObject>(10);
            for (String dataModel : dataModels) {
                Collection loads = existMap.get((Object)dataModel);
                if (CollectionUtils.isNotEmpty((Collection)loads)) {
                    loads.forEach(load -> {
                        load.set("status", (Object)statusEnum.getIndex());
                        load.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        load.set("modifytime", (Object)TimeServiceHelper.now());
                        res1.add(load);
                    });
                    continue;
                }
                DynamicObject newOne = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extconvertstatus");
                newOne.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newOne.set("model", (Object)modelId);
                newOne.set("scenario", (Object)scenario);
                newOne.set("year", (Object)year);
                newOne.set("period", (Object)period);
                newOne.set("currency", (Object)currency);
                newOne.set("entity", (Object)parentSonNumber);
                newOne.set("process", (Object)process);
                newOne.set("status", (Object)statusEnum.getIndex());
                newOne.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newOne.set("modifytime", (Object)TimeServiceHelper.now());
                newOne.set("datamodel", (Object)dataModel);
                res2.add(newOne);
            }
            if (!res1.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])res1.toArray(new DynamicObject[0]));
            }
            if (!res2.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])res2.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void updateConvertStatusBatch(String model, String scenario, String year, String period, String currency, String process, Map<String, List<String>> orgModelMap, ConvertStatusEnum statusEnum) {
        QFBuilder qf = new QFBuilder();
        Long modelId = MemberReader.findModelIdByNum((String)model);
        qf.add("model", "=", (Object)modelId);
        qf.add("scenario", "=", (Object)scenario);
        qf.add("year", "=", (Object)year);
        qf.add("period", "=", (Object)period);
        List entities = orgModelMap.keySet().stream().map(org -> MemberReader.findEntityMemberByNum((String)model, (String)org).getParent_SonNumber()).collect(Collectors.toList());
        qf.add("entity", "=", entities);
        if (currency != null) {
            qf.add("currency", "=", (Object)currency);
        }
        qf.add("process", "=", (Object)process);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_extconvertstatus", (String)"id,entity,datamodel,status,modifier,modifytime", (QFilter[])qf.toArray());
        if (currency == null) {
            for (DynamicObject doc : docs) {
                doc.set("status", (Object)statusEnum.getIndex());
                doc.set("modifier", (Object)RequestContext.get().getCurrUserId());
                doc.set("modifytime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])docs);
        } else {
            HashMap<String, DynamicObject> exisOrgMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject doc : docs) {
                exisOrgMap.put(doc.getString("entity") + SPLIT + doc.getString("datamodel"), doc);
            }
            ArrayList<DynamicObject> res1 = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> res2 = new ArrayList<DynamicObject>(10);
            for (Map.Entry<String, List<String>> entry : orgModelMap.entrySet()) {
                String parentSonNumber = MemberReader.findEntityMemberByNum((String)model, (String)entry.getKey()).getParent_SonNumber();
                for (String extModel : entry.getValue()) {
                    DynamicObject load = (DynamicObject)exisOrgMap.get(parentSonNumber + SPLIT + extModel);
                    if (load != null) {
                        load.set("status", (Object)statusEnum.getIndex());
                        load.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        load.set("modifytime", (Object)TimeServiceHelper.now());
                        res1.add(load);
                        continue;
                    }
                    DynamicObject newOne = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extconvertstatus");
                    newOne.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                    newOne.set("model", (Object)modelId);
                    newOne.set("scenario", (Object)scenario);
                    newOne.set("year", (Object)year);
                    newOne.set("period", (Object)period);
                    newOne.set("currency", (Object)currency);
                    newOne.set("entity", (Object)parentSonNumber);
                    newOne.set("process", (Object)process);
                    newOne.set("status", (Object)statusEnum.getIndex());
                    newOne.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    newOne.set("modifytime", (Object)TimeServiceHelper.now());
                    newOne.set("datamodel", (Object)extModel);
                    res2.add(newOne);
                }
            }
            if (!res1.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])res1.toArray(new DynamicObject[0]));
            }
            if (!res2.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])res2.toArray(new DynamicObject[0]));
            }
        }
    }

    private static String getCacheKey(String ... params) {
        StringJoiner sj = new StringJoiner(SPLIT);
        for (String param : params) {
            sj.add(param);
        }
        return sj.toString();
    }
}

