/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.datacollet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DimmensionMappingEnum;

public class DimensionMapModel {
    private long modelId;
    private String icNumber;

    public DimensionMapModel(long modelId) {
        this.modelId = modelId;
        this.icNumber = DimTypesEnum.INTERCOMPANY.getNumber();
    }

    public String getIcId() {
        return this.icNumber;
    }

    public Map<String, String> getDimMapKeyAsOther() {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter modQ = new QFilter("model", "=", (Object)this.modelId);
        QFilter filter = new QFilter("isfloat", "=", (Object)Character.valueOf('1'));
        QFilter[] qs = new QFilter[]{modQ, filter};
        DynamicObjectCollection c1 = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.number,dimensionmap.number", (QFilter[])qs);
        for (DynamicObject c : c1) {
            String key = c.getString("dimensionmap.number");
            String value = c.getString("dimension.number");
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            map.put(key, value);
        }
        return map;
    }

    public HashMultimap<String, String> getDimMapKeyAsCommonAssist(List<ViewPointDimensionEntry> viewPointDimensionEntries, List<PageDimensionEntry> pageDimensionEntries, Map<String, String> commonMems) {
        HashMultimap result = HashMultimap.create();
        QFilter modQ = new QFilter("model", "=", (Object)this.modelId);
        QFilter filter = new QFilter("isfloat", "=", (Object)Character.valueOf(DimmensionMappingEnum.COMMON.getIndex()));
        QFilter[] qs = new QFilter[]{modQ, filter};
        DynamicObjectCollection dimensionMaps = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.number, commonassist", (QFilter[])qs);
        ArrayList<String> pageViewPointDims = new ArrayList<String>(10);
        if (!viewPointDimensionEntries.isEmpty()) {
            for (ViewPointDimensionEntry viewPointDimensionEntry : viewPointDimensionEntries) {
                if (null == viewPointDimensionEntry.getDimension()) continue;
                pageViewPointDims.add(viewPointDimensionEntry.getDimension().getNumber());
            }
        }
        if (!pageDimensionEntries.isEmpty()) {
            for (PageDimensionEntry pageDimensionEntry : pageDimensionEntries) {
                if (null == pageDimensionEntry.getDimension()) continue;
                pageViewPointDims.add(pageDimensionEntry.getDimension().getNumber());
            }
        }
        for (DynamicObject dynamicObject : dimensionMaps) {
            String bcmDim = dynamicObject.getString("dimension.number");
            String commonassistStr = dynamicObject.getString("commonassist");
            if (!pageViewPointDims.contains(bcmDim)) continue;
            JSONObject commonAssist = JSON.parseObject((String)commonassistStr);
            result.put((Object)commonAssist.getString("commonAssistKey"), (Object)commonMems.get(bcmDim));
        }
        return result;
    }

    private Map<String, String> getUnFloatDimMapKeyAsOther() {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter modQ = new QFilter("model", "=", (Object)this.modelId);
        QFilter filter = new QFilter("isfloat", "!=", (Object)Character.valueOf('1'));
        QFilter[] qs = new QFilter[]{modQ, filter};
        DynamicObjectCollection c1 = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.number,dimensionmap.number", (QFilter[])qs);
        for (DynamicObject c : c1) {
            String key = c.getString("dimensionmap.number");
            String value = c.getString("dimension.number");
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            map.put(key, value);
        }
        return map;
    }

    public String getCommonDimen(Map<String, String> viewPointDimen) {
        Map<String, String> unfloatDimMap = this.getUnFloatDimMapKeyAsOther();
        HashMap<String, List> commonDimen = new HashMap<String, List>(16);
        unfloatDimMap.forEach((k, v) -> {
            if (viewPointDimen.get(v) != null) {
                ArrayList members = new ArrayList(1);
                members.add(viewPointDimen.get(v));
                commonDimen.put((String)k, members);
            }
        });
        StringBuilder sb = new StringBuilder();
        commonDimen.forEach((k, v) -> {
            if (v != null && !v.isEmpty()) {
                sb.append((String)k).append("|").append(org.apache.commons.lang3.StringUtils.join((Iterable)v, (String)",")).append("|");
            }
        });
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public boolean isReplaceOrg() {
        Map<String, String> unfloatDimMap = this.getUnFloatDimMapKeyAsOther();
        return unfloatDimMap.containsValue("Entity");
    }
}

