/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.basedata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.ISupportGZip;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public class MultiF7Results
implements Serializable,
ISupportGZip {
    private static final long serialVersionUID = 1L;
    private List<MultiF7Result> list = new ArrayList<MultiF7Result>();
    private DynamicObject dimDy;

    public List<MultiF7Result> getList() {
        return this.list;
    }

    public DynamicObject getDimDy() {
        return this.dimDy;
    }

    public void setDimDy(DynamicObject dimDy) {
        this.dimDy = dimDy;
    }

    public static MultiF7Results buildParam(DynamicObjectCollection doc) {
        return MultiF7Results.buildMultiF7Results(doc, 0L);
    }

    public static MultiF7Results buildMultiF7Results(DynamicObjectCollection doc, long cslId) {
        if (doc == null) {
            return null;
        }
        MultiF7Results mps = new MultiF7Results();
        for (int i = 0; i < doc.size(); ++i) {
            MultiF7Result mp = new MultiF7Result();
            mp.setId(((DynamicObject)doc.get(i)).getLong(4));
            mp.setName(((DynamicObject)doc.get(i)).getString(3));
            mp.setScope(((DynamicObject)doc.get(i)).getInt(5));
            mp.setNumber(((DynamicObject)doc.get(i)).getString(2));
            mp.setPid(((DynamicObject)doc.get(i)).getLong(6));
            if (cslId != 0L) {
                mp.setCslscheme(cslId);
            }
            mps.getList().add(mp);
        }
        return mps;
    }

    public static MultiF7Results buildParam(DynamicObjectCollection doc, long modelid) {
        if (doc == null) {
            return null;
        }
        MultiF7Results mps = new MultiF7Results();
        for (int i = 0; i < doc.size(); ++i) {
            MultiF7Result mp = new MultiF7Result();
            mp.setId(((DynamicObject)doc.get(i)).getLong(4));
            mp.setName(((DynamicObject)doc.get(i)).getString(3));
            if (((DynamicObject)doc.get(i)).getInt(5) >= RangeEnum.VALUE_10000.getValue()) {
                DynamicObject dy = MultiF7Results.getStaticMember(modelid, ((DynamicObject)doc.get(i)).getInt(5));
                mp.setText(dy.getString("name"));
            }
            mp.setScope(((DynamicObject)doc.get(i)).getInt(5));
            mp.setNumber(((DynamicObject)doc.get(i)).getString(2));
            mp.setPid(((DynamicObject)doc.get(i)).getLong(6));
            mps.getList().add(mp);
        }
        return mps;
    }

    public static MultiF7Results buildParam(List<Member> members, long modelid) {
        if (members == null) {
            return null;
        }
        MultiF7Results mps = new MultiF7Results();
        for (int i = 0; i < members.size(); ++i) {
            MultiF7Result mp = new MultiF7Result();
            mp.setId(members.get(i).getId());
            mp.setName(members.get(i).getName());
            if (members.get(i).getScope() >= RangeEnum.VALUE_10000.getValue()) {
                DynamicObject dy = MultiF7Results.getStaticMember(modelid, members.get(i).getScope());
                mp.setText(dy.getString("name"));
            }
            mp.setScope(members.get(i).getScope());
            mp.setNumber(members.get(i).getNumber());
            mps.getList().add(mp);
        }
        return mps;
    }

    public static MultiF7Results buildParamForFd(List<FilterDimMember> filterDimMembers, long modelId) {
        if (filterDimMembers == null) {
            return null;
        }
        MultiF7Results mps = new MultiF7Results();
        filterDimMembers.forEach(filterDimMember -> {
            MultiF7Result mp = new MultiF7Result();
            String name = filterDimMember.getName();
            String number = filterDimMember.getNumber();
            if (filterDimMember.isCustom()) {
                MembProperty membProperty = filterDimMember.getMembProperty();
                CustomProperty customProperty = membProperty.getCustomProperty();
                mp.setPid(customProperty.getId());
                name = customProperty.getName() + ":" + membProperty.getName();
                number = customProperty.getNumber() + ":" + membProperty.getNumber();
            }
            mp.setName(name);
            mp.setNumber(number);
            mp.setId(filterDimMember.getId());
            mp.setScope(filterDimMember.getScope());
            if (filterDimMember.getScope() >= RangeEnum.VALUE_10000.getValue()) {
                DynamicObject dy = MultiF7Results.getStaticMember(modelId, filterDimMember.getScope());
                mp.setText(dy.getString("name"));
            }
            mps.getList().add(mp);
        });
        return mps;
    }

    public static MultiF7Results buildParam(List<MembProperty> MembPropertys, long modelid, boolean is) {
        if (MembPropertys == null) {
            return null;
        }
        MultiF7Results mps = new MultiF7Results();
        for (int i = 0; i < MembPropertys.size(); ++i) {
            MultiF7Result mp = new MultiF7Result();
            mp.setId(MembPropertys.get(i).getId());
            mp.setName(MembPropertys.get(i).getName());
            if (MembPropertys.get(i).getScope() >= RangeEnum.VALUE_10000.getValue()) {
                DynamicObject dy = MultiF7Results.getStaticMember(modelid, MembPropertys.get(i).getScope());
                mp.setText(dy.getString("name"));
            }
            mp.setScope(MembPropertys.get(i).getScope());
            mp.setNumber(MembPropertys.get(i).getNumber());
            if (MembPropertys.get(i).getCustomProperty() != null) {
                mp.setPid(MembPropertys.get(i).getCustomProperty().getId());
                mp.setNumber(MembPropertys.get(i).getCustomProperty().getNumber() + ":" + MembPropertys.get(i).getNumber());
                mp.setName(MembPropertys.get(i).getCustomProperty().getName() + ":" + MembPropertys.get(i).getNumber());
            }
            mps.getList().add(mp);
        }
        return mps;
    }

    public String getShowText(boolean isContainNumber) {
        StringBuilder sb = new StringBuilder();
        this.getList().forEach(mp -> {
            if (isContainNumber) {
                sb.append(mp.getNumber());
            }
            if (mp.getPid() == 0L || !isContainNumber) {
                if (isContainNumber) {
                    sb.append(" ");
                }
                if (mp.getScope() >= RangeEnum.VALUE_10000.getValue()) {
                    RangeEnum.buildScopeShowName((StringBuilder)sb, (String)mp.getText(), (int)mp.getScope());
                } else {
                    RangeEnum.buildScopeShowName((StringBuilder)sb, (String)mp.getName(), (int)mp.getScope());
                }
            } else {
                sb.append(',');
            }
        });
        if (StringUtils.isNotEmpty((String)sb.toString())) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public String getShowText() {
        return this.getShowText(false);
    }

    public List<Map<String, String>> toList() {
        ArrayList<Map<String, String>> resultlist = new ArrayList<Map<String, String>>();
        this.list.forEach(mp -> resultlist.add(mp.toMap()));
        return resultlist;
    }

    public static DynamicObject getStaticMember(long modelid, int membscope) {
        QFilter idFilter = new QFilter("modelid", "=", (Object)modelid);
        QFilter fmembscope = new QFilter("membscope", "=", (Object)membscope);
        QFilter[] filters = new QFilter[]{idFilter, fmembscope};
        DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_memberlist", (String)"id,name,number,dimensionid,membscope", (QFilter[])filters);
        return member;
    }

    public static MultiF7Results buildParam(long modelId, List<DynaMembScopeInfo> dynaMembScopeInfoList) {
        if (dynaMembScopeInfoList == null) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        dynaMembScopeInfoList.forEach(e -> {
            if (e.isCustom() && !e.getMember().getNumber().equals(SystemVarsEnum.PR_NONE.getNumber())) {
                ids.add(((DimMember)e.getMember()).getId());
            }
        });
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        HashMap<Long, Pair<String, String>> membPromap = new HashMap<Long, Pair<String, String>>(16);
        HashMap<Long, Pair<String, String>> cusPromap = new HashMap<Long, Pair<String, String>>(16);
        MultiF7Results.preDataForDp(ids, modelId, idMap, membPromap, cusPromap);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        MultiF7Results mps = new MultiF7Results();
        for (int i = 0; i < dynaMembScopeInfoList.size(); ++i) {
            DynaMembScopeInfo dynaMembScopeInfo = dynaMembScopeInfoList.get(i);
            mps.getList().add(MultiF7Results.buildMultiF7Result(modelNum, dynaMembScopeInfo, dynaMembScopeInfo.getMember().getDimension().getNumber(), idMap, membPromap, cusPromap));
        }
        return mps;
    }

    public String getMemberSettingForMDQA() {
        StringBuilder idStr = new StringBuilder();
        for (MultiF7Result f7Result : this.list) {
            idStr.append(f7Result.getId()).append(';').append(f7Result.getScope());
            if (f7Result.getPid() != 0L) {
                idStr.append(';').append("isProp");
                if (f7Result.getCslscheme() != 0L) {
                    idStr.append(';').append(f7Result.getCslscheme());
                }
            }
            idStr.append(',');
        }
        if (idStr.length() != 0) {
            idStr = idStr.deleteCharAt(idStr.lastIndexOf(","));
        }
        return idStr.toString();
    }

    public static MultiF7Results buildMultiF7Results(String[] memList, long modelId, String dimNum) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (String mem : memList) {
            boolean isCustom;
            String[] temMem = mem.split(";");
            boolean bl = isCustom = temMem.length >= 3;
            if (!isCustom || SystemVarsEnum.PR_NONE.getId().equals(temMem[0])) continue;
            ids.add(LongUtil.toLong((Object)temMem[0]));
        }
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        HashMap<Long, Pair<String, String>> membPromap = new HashMap<Long, Pair<String, String>>(16);
        HashMap<Long, Pair<String, String>> cusPromap = new HashMap<Long, Pair<String, String>>(16);
        MultiF7Results.preDataForDp(ids, modelId, idMap, membPromap, cusPromap);
        MultiF7Results mps = new MultiF7Results();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (String mem : memList) {
            mps.getList().add(MultiF7Results.buildMultiF7Result(modelNum, mem, dimNum, idMap, membPromap, cusPromap));
        }
        return mps;
    }

    private static void preDataForDp(List<Long> ids, long modelId, Map<Long, Long> idMap, Map<Long, Pair<String, String>> membPromap, Map<Long, Pair<String, String>> cusPromap) {
        if (!ids.isEmpty()) {
            QFilter modelQf = new QFilter("model", "=", (Object)modelId);
            QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,name,number,propertyid", (QFilter[])new QFilter[]{modelQf, new QFilter("id", "in", ids)}).forEach(e -> {
                idMap.put(e.getLong("id"), e.getLong("propertyid"));
                membPromap.put(e.getLong("id"), Pair.onePair((Object)e.getString("name"), (Object)e.getString("number")));
            });
            if (!idMap.isEmpty()) {
                QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,name", (QFilter[])new QFilter[]{modelQf, new QFilter("id", "in", idMap.values())}).forEach(e -> cusPromap.put(e.getLong("id"), Pair.onePair((Object)e.getString("name"), (Object)e.getString("number"))));
            }
        }
    }

    private static MultiF7Result buildMultiF7Result(String modelNum, Object obj, String dimNum, Map<Long, Long> idMap, Map<Long, Pair<String, String>> membPromap, Map<Long, Pair<String, String>> cusPromap) {
        MultiF7Result f7Result = new MultiF7Result();
        long id = 0L;
        int scope = 10;
        boolean isCustom = false;
        String cslId = null;
        Long pId = null;
        String number = "";
        String name = "";
        if (obj instanceof String) {
            String[] temMem = ((String)obj).split(";");
            id = LongUtil.toLong((Object)temMem[0]);
            scope = temMem.length > 1 ? Integer.parseInt(temMem[1]) : RangeEnum.VALUE_10.getValue();
            isCustom = temMem.length >= 3;
            String string = cslId = temMem.length == 4 ? temMem[3] : null;
            if (SystemVarsEnum.PR_NONE.getId().equals(Long.toString(id))) {
                pId = 10L;
            }
        } else if (obj instanceof DynaMembScopeInfo) {
            DynaMembScopeInfo dynaMembScopeInfo = (DynaMembScopeInfo)obj;
            IDimMember member = dynaMembScopeInfo.getMember();
            id = member.getId();
            isCustom = dynaMembScopeInfo.isCustom();
            if (member.getNumber().equals(SystemVarsEnum.PR_NONE.getNumber())) {
                pId = 10L;
            }
            scope = dynaMembScopeInfo.getRangeId();
            name = member.getName();
            number = member.getNumber();
        }
        if (id != 0L) {
            f7Result.setId(id);
            f7Result.setScope(scope);
            if (isCustom) {
                if (pId != null) {
                    f7Result.setPid(pId);
                    name = SystemVarsEnum.PR_NONE.getName();
                    number = SystemVarsEnum.PR_NONE.getNumber();
                } else if (idMap.get(id) != null) {
                    pId = idMap.get(id);
                    f7Result.setPid(pId);
                    if (StringUtils.isNotEmpty((String)cslId)) {
                        f7Result.setCslscheme(LongUtil.toLong((Object)cslId));
                    }
                    Pair<String, String> pair = membPromap.get(id);
                    Pair<String, String> cusPair = cusPromap.get(pId);
                    if (pair != null && cusPair != null) {
                        number = (String)cusPair.p2 + ":" + (String)pair.p2;
                        name = (String)cusPair.p1 + ":" + (String)pair.p1;
                    }
                } else {
                    ThreadCache.put((Object)"customnotfind", (Object)true);
                }
            } else {
                IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)id);
                if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
                    number = treeNode.getNumber();
                    name = treeNode.getName();
                } else {
                    ThreadCache.put((Object)"customnotfind", (Object)true);
                }
            }
            f7Result.setNumber(number);
            f7Result.setName(name);
        }
        return f7Result;
    }

    public void addMultiResultSet(MultiF7Result f7Result) {
        this.getList().add(f7Result);
    }
}

