/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DimensionMsgCache {
    private Map<String, Dimension> dims;
    private long modelId;

    public DimensionMsgCache(long modelId) {
        this.modelId = modelId;
        this.cacheDim();
    }

    public long getDimId(String number) {
        Dimension d = this.getDimension(number);
        if (d != null) {
            return d.getId();
        }
        return 0L;
    }

    public String getName(String number) {
        Dimension d = this.getDimension(number);
        if (d != null) {
            return d.getName();
        }
        return "";
    }

    public int getSeq(String number) {
        Dimension d = this.getDimension(number);
        if (d != null) {
            return d.getSeq();
        }
        return -1;
    }

    public String getNUmberById(long id) {
        for (Dimension v : this.dims.values()) {
            if (v.id != id) continue;
            return v.number;
        }
        return null;
    }

    public List<String> getAllDimension() {
        ArrayList<String> dimNUmber = new ArrayList<String>();
        this.dims.values().forEach(d -> dimNUmber.add(((Dimension)d).number));
        return dimNUmber;
    }

    private Dimension getDimension(String number) {
        for (Map.Entry<String, Dimension> entry : this.dims.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(number)) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<Dimension> getAllDimensionMsg() {
        return new ArrayList<Dimension>(this.dims.values());
    }

    private void cacheDim() {
        if (this.dims == null) {
            Object object = ThreadCache.get((Object)("dim" + this.modelId));
            if (object == null) {
                this.dims = new HashMap<String, Dimension>();
                QFilter qf = QFilter.of((String)"model =?", (Object[])new Object[]{this.modelId});
                Map colls = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id,number,name,dseq", (QFilter[])new QFilter[]{qf});
                if (colls.size() > 0) {
                    colls.values().forEach(dim -> {
                        Dimension dimension = new Dimension();
                        dimension.id = dim.getLong("id");
                        dimension.number = dim.getString("number");
                        dimension.name = dim.getString("name");
                        dimension.seq = dim.getInt("dseq");
                        this.dims.put(dimension.number, dimension);
                    });
                }
                ThreadCache.put((Object)("dim" + this.modelId), this.dims);
            } else {
                this.dims = (Map)object;
            }
        }
    }

    public static class Dimension {
        private long id;
        private String number;
        private String name;
        private int seq;

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public long getId() {
            return this.id;
        }

        public int getSeq() {
            return this.seq;
        }
    }
}

