/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public class MemberMsgCache {
    private Map<String, Map<String, Integer>> indexMap;
    private List<Map<String, Object>> result;
    private long modelId;
    private Map<String, Multimap<String, Object>> filter;
    private Map<Long, Map<String, Object>> idresult;
    private boolean isIdAsKey;
    private boolean needLongNumber;
    private String customKey;
    private Map<String, String> selectfiled;
    private Map<String, QFilter> customFilters;

    public MemberMsgCache(long modelId) {
        this.modelId = modelId;
        this.indexMap = new HashMap<String, Map<String, Integer>>();
        this.filter = new HashMap<String, Multimap<String, Object>>();
        this.idresult = new HashMap<Long, Map<String, Object>>();
        this.selectfiled = new HashMap<String, String>();
        this.customFilters = new HashMap<String, QFilter>();
    }

    public void setNeedLongNumber(boolean needLongNumber) {
        this.needLongNumber = needLongNumber;
    }

    public void setIdAsKey(boolean idAsKey) {
        this.isIdAsKey = idAsKey;
    }

    public void setCustomKey(String customKey) {
        this.customKey = customKey;
    }

    public Object getMsg(String dimNum, String key, String filed) {
        this.cacheDimMem(dimNum);
        Map<String, Integer> map = this.getMap(dimNum);
        Integer o = map.get(key);
        if (o != null) {
            Map<String, Object> msg = this.result.get(o);
            return msg.get(filed);
        }
        return "";
    }

    public Object getMsg(String dimNum, long id, String filed) {
        this.isIdAsKey = true;
        this.cacheDimMem(dimNum);
        Map<String, Object> map = this.idresult.get(id);
        if (map != null) {
            return map.get(filed);
        }
        return "";
    }

    public void cacheOthersDimMem(String entity, Object ssid) {
        Map<String, Integer> mapObj = this.getMap(entity);
        if (this.result == null) {
            this.result = new ArrayList<Map<String, Object>>();
        }
        int index = this.result.size();
        if (mapObj == null) {
            String select;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            QFilter qf = QFilter.of((String)"1 = ?", (Object[])new Object[]{1});
            QFilter customFilter = this.getFilter(true, entity);
            if (EntityMetadataCache.getDataEntityType((String)entity).getAllFields().get("ssid") != null && ssid != null) {
                qf.and(QFilter.of((String)"ssid = ?", (Object[])new Object[]{ssid}));
            }
            if (customFilter != null) {
                qf.and(customFilter);
            }
            String string = select = this.isIdAsKey ? "id,number,name" : "number,name";
            if (this.needLongNumber) {
                select = select + ",longnumber";
            }
            Map doc = BusinessDataServiceHelper.loadFromCache((String)entity, (String)select, (QFilter[])new QFilter[]{qf});
            if (this.isIdAsKey) {
                if (doc != null) {
                    for (DynamicObject obj : doc.values()) {
                        HashMap<String, String> msg = new HashMap<String, String>();
                        msg.put("name", obj.getString("name"));
                        msg.put("number", obj.getString("number"));
                        this.idresult.put(obj.getLong("id"), msg);
                    }
                    this.indexMap.put(entity, new HashMap());
                }
            } else {
                if (doc != null) {
                    for (DynamicObject obj : doc.values()) {
                        HashMap<String, String> msg = new HashMap<String, String>();
                        map.put(obj.getString("number"), index);
                        msg.put("name", obj.getString("name"));
                        msg.put("number", obj.getString("number"));
                        this.result.add(msg);
                        ++index;
                    }
                }
                this.indexMap.put(entity, map);
            }
        }
    }

    private void cacheDimMem(String dimNum) {
        Map<String, Integer> mapObj = this.getMap(dimNum);
        if (this.result == null) {
            this.result = new ArrayList<Map<String, Object>>();
        }
        int index = this.result.size();
        if (mapObj == null) {
            String select;
            QFilter qFilter;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            QFilter qf = QFilter.of((String)"model = ? and dimension.number = ?", (Object[])new Object[]{this.modelId, dimNum});
            QFilter customFilter = this.getFilter(false, dimNum);
            if (customFilter != null) {
                qf.and(customFilter);
            }
            if (null != (qFilter = this.customFilters.get(dimNum))) {
                qf.and(qFilter);
            }
            String string = select = this.isIdAsKey ? "id,number,name" : "number,name";
            if (this.selectfiled.get(dimNum) != null) {
                select = this.selectfiled.get(dimNum);
            }
            if (this.needLongNumber) {
                select = select + ",longnumber";
            }
            Map doc = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)select, (QFilter[])new QFilter[]{qf});
            if (this.isIdAsKey) {
                if (doc != null) {
                    for (DynamicObject obj : doc.values()) {
                        HashMap<String, Object> msg = new HashMap<String, Object>();
                        for (String filed : select.split(",")) {
                            if ("id".equals(filed)) {
                                msg.put(filed, obj.getLong(filed));
                                continue;
                            }
                            msg.put(filed, obj.getString(filed));
                        }
                        if (this.needLongNumber) {
                            msg.put("longnumber", obj.getString("longnumber"));
                        }
                        this.idresult.put(obj.getLong("id"), msg);
                    }
                    this.indexMap.put(dimNum, new HashMap());
                }
            } else {
                if (doc != null) {
                    for (DynamicObject obj : doc.values()) {
                        HashMap<String, Object> msg = new HashMap<String, Object>();
                        if (this.customKey != null) {
                            map.put(obj.getString(this.customKey), index);
                        } else {
                            map.put(obj.getString("number"), index);
                        }
                        for (String filed : select.split(",")) {
                            if ("id".equals(filed)) {
                                msg.put(filed, obj.getLong(filed));
                                continue;
                            }
                            msg.put(filed, obj.getString(filed));
                        }
                        if (this.needLongNumber) {
                            msg.put("longnumber", obj.getString("longnumber"));
                        }
                        this.result.add(msg);
                        ++index;
                    }
                }
                this.indexMap.put(dimNum, map);
            }
        }
    }

    private Map<String, Integer> getMap(String dimNum) {
        return this.indexMap.get(dimNum);
    }

    private QFilter getFilter(boolean isOthers, String dimNumn) {
        Multimap<String, Object> fils = this.filter.get(dimNumn);
        if (null != fils) {
            QFilter qf = new QFilter("1", "=", (Object)1);
            for (String filed : fils.keySet()) {
                if (fils.get((Object)filed).size() > 100) continue;
                if ("id".equals(filed)) {
                    if (isOthers && EntityMetadataCache.getDataEntityType((String)dimNumn).getPrimaryKey().getPropertyType() == String.class) {
                        qf.and(filed, "in", (Object)fils.get((Object)filed));
                        continue;
                    }
                    ArrayList params = new ArrayList();
                    fils.get((Object)filed).forEach(m -> {
                        params.add(Long.parseLong(m.toString()));
                        qf.and(filed, "in", (Object)params);
                    });
                    continue;
                }
                qf.and(filed, "in", (Object)fils.get((Object)filed));
            }
            return qf;
        }
        return null;
    }

    public void setFilter(String dimNum, String filed, Object value) {
        if (!this.filter.containsKey(dimNum)) {
            HashMultimap map = HashMultimap.create();
            this.filter.put(dimNum, (Multimap<String, Object>)map);
        }
        Multimap<String, Object> mulMap = this.filter.get(dimNum);
        mulMap.put((Object)filed, value);
    }

    public void addCustomFilter(String dimNum, QFilter filter) {
        if (!this.customFilters.containsKey(dimNum)) {
            this.customFilters.put(dimNum, filter);
        } else {
            this.customFilters.get(dimNum).and(filter);
        }
    }

    public void setSelectfiled(String dimNum, String selects) {
        this.selectfiled.put(dimNum, selects);
    }

    public long getModelId() {
        return this.modelId;
    }
}

