/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public class MemberNumToIdCache {
    private Map<String, Multimap<String, Long>> result;
    private long modelId;
    private Map<String, Multimap<String, Object>> filter;
    private String customkey;
    private boolean needStoragetype = false;
    private Map<Long, Integer> storagetype;

    public MemberNumToIdCache(long modelId) {
        this.modelId = modelId;
        this.result = new HashMap<String, Multimap<String, Long>>();
        this.filter = new HashMap<String, Multimap<String, Object>>();
        this.storagetype = new HashMap<Long, Integer>();
    }

    public void setCustomkey(String customkey) {
        this.customkey = customkey;
    }

    public void setNeedStoragetype(boolean needStoragetype) {
        this.needStoragetype = needStoragetype;
    }

    public Set<Long> getIds(String dimNum, String memNum) {
        this.cacheDimMem(dimNum);
        Multimap<String, Long> mulmap = this.result.get(dimNum);
        Collection o = mulmap.get((Object)memNum);
        if (o != null) {
            Set ids = (Set)o;
            return ids;
        }
        return null;
    }

    private void cacheDimMem(String dimNum) {
        Multimap<String, Long> mapObj = this.result.get(dimNum);
        if (mapObj == null) {
            HashMultimap map = HashMultimap.create();
            QFilter qf = QFilter.of((String)"model = ? and dimension.number = ?", (Object[])new Object[]{this.modelId, dimNum});
            QFilter customFilter = this.getFilter(dimNum);
            if (customFilter != null) {
                qf.and(customFilter);
            }
            String select = this.needStoragetype ? "name,number,id,storagetype" : "name,number,id";
            Map doc = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)select, (QFilter[])new QFilter[]{qf});
            if (doc != null) {
                for (DynamicObject obj : doc.values()) {
                    if (this.customkey != null) {
                        map.put((Object)obj.getString(this.customkey), (Object)obj.getLong("id"));
                    } else {
                        map.put((Object)obj.getString("number"), (Object)obj.getLong("id"));
                    }
                    if (!this.needStoragetype) continue;
                    this.storagetype.put(obj.getLong("id"), obj.getInt("storagetype"));
                }
            }
            this.result.put(dimNum, (Multimap<String, Long>)map);
        }
    }

    private QFilter getFilter(String dimNumn) {
        Multimap<String, Object> fils = this.filter.get(dimNumn);
        if (null != fils) {
            QFilter qf = new QFilter("1", "=", (Object)1);
            for (String filed : fils.keySet()) {
                qf.and(filed, "in", (Object)fils.get((Object)filed));
            }
            return qf;
        }
        return null;
    }

    public void setFilter(String dimNum, String filed, Object value) {
        if (!this.filter.containsKey(dimNum)) {
            HashMultimap map = HashMultimap.create();
            this.filter.put(dimNum, (Multimap<String, Object>)map);
        }
        Multimap<String, Object> mulMap = this.filter.get(dimNum);
        mulMap.put((Object)filed, value);
    }

    public int getStoreType(long id) {
        return this.storagetype.get(id);
    }
}

