/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.datalock;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.util.BatchProcessHelper;
import org.apache.commons.collections4.CollectionUtils;

public class DataLockHelper {
    public static long getLockDim(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("isstage", "=", (Object)true);
        DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])filter.toArray());
        return dim == null ? 0L : dim.getLong("id");
    }

    public static int getPlanMaxSeq(long modelId, long sceneId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scenario", "=", (Object)sceneId);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_datalockplanentity", (String)"dseq", (QFilter[])filter.toArray(), (String)"dseq desc", (int)1);
        return docs.size() == 0 ? 0 : ((DynamicObject)docs.get(0)).getInt("dseq");
    }

    public static Pair<Long, Set<String>> getStageSetting(long modelId, long sceneId, long yearId, long periodId, long stageId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scenario", "=", (Object)sceneId);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_datalockplanentity", (String)"id,number,dseq,entryentity,entryentity.year,entryentity.yearscope,entryentity.periods", (QFilter[])filter.toArray(), (String)"dseq asc");
        if (docs == null || docs.length == 0) {
            return null;
        }
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        if (IDNumberTreeNode.NotFoundTreeNode == yearNode || IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            return null;
        }
        long planId = DataLockHelper.getPlanId(modelId, yearId, periodId, docs);
        if (planId == 0L) {
            return null;
        }
        QFilter filters = new QFilter("plan", "=", (Object)planId);
        filters.and("submitstage", "=", (Object)stageId);
        Set numbers = QueryServiceHelper.query((String)"bcm_datalocksettingentity", (String)"number", (QFilter[])filters.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toSet());
        return Pair.onePair((Object)planId, numbers);
    }

    public static Long getDataLockPlanId(long modelId, long sceneId, long yearId, long periodId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scenario", "=", (Object)sceneId);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_datalockplanentity", (String)"id,number,dseq,entryentity,entryentity.year,entryentity.yearscope,entryentity.periods", (QFilter[])filter.toArray(), (String)"dseq asc");
        if (docs == null || docs.length == 0) {
            return 0L;
        }
        return DataLockHelper.getPlanId(modelId, yearId, periodId, docs);
    }

    private static Long getPlanId(long modelId, long yearId, long periodId, DynamicObject[] docs) {
        for (DynamicObject plan : docs) {
            DynamicObjectCollection effectivePeriod = plan.getDynamicObjectCollection("entryentity");
            for (DynamicObject ep : effectivePeriod) {
                HashSet<Long> years = new HashSet<Long>(16);
                HashSet periodIds = new HashSet(16);
                String scope = ep.getString("yearscope");
                long effectiveYear = ep.getLong("year.id");
                if (effectiveYear == 0L) {
                    years.addAll(MemberReader.getAllNodeFromCache((String)"bcm_fymembertree", (Object)modelId).values().stream().filter(f -> f.isLeaf()).map(y -> y.getId()).collect(Collectors.toSet()));
                } else {
                    years.addAll(DataLockHelper.getEffectiveYears(modelId, effectiveYear, YearScopeEnum.getEnumByType((String)scope)));
                }
                DynamicObjectCollection periods = ep.getDynamicObjectCollection("periods");
                if (periods.size() == 0) {
                    periodIds.addAll(MemberReader.getAllNodeFromCache((String)"bcm_periodmembertree", (Object)modelId).values().stream().filter(f -> f.isLeaf()).map(y -> y.getId()).collect(Collectors.toSet()));
                } else {
                    periodIds.addAll(periods.stream().map(m -> m.getLong("fbasedataid.id")).collect(Collectors.toSet()));
                }
                if (!years.contains(yearId) || !periodIds.contains(periodId)) continue;
                return plan.getLong("id");
            }
        }
        return 0L;
    }

    public static Set<Long> getEffectiveYears(long modelId, long effectiveYearId, YearScopeEnum scope) {
        Map allNode = MemberReader.getAllNodeFromCache((String)"bcm_fymembertree", (Object)modelId);
        List allYear = allNode.values().stream().filter(f -> f.isLeaf()).collect(Collectors.toList());
        Collections.sort(allYear, Comparator.comparing(o -> o.getdSeq()));
        HashSet<Object> result = new HashSet<Object>(16);
        IDNumberTreeNode effectiveNode = MemberReader.findFyMemberById((Long)modelId, (Long)effectiveYearId);
        switch (scope) {
            case ALLYEAR: {
                result.addAll(allYear);
                break;
            }
            case BEFOREYEAR: {
                result.addAll(allYear.stream().filter(a -> a.getdSeq() <= effectiveNode.getdSeq()).collect(Collectors.toSet()));
                break;
            }
            case AFTERYEAR: {
                result.addAll(allYear.stream().filter(a -> a.getdSeq() >= effectiveNode.getdSeq()).collect(Collectors.toSet()));
                break;
            }
            default: {
                result.add(effectiveNode);
            }
        }
        return result.stream().map(m -> m.getId()).collect(Collectors.toSet());
    }

    public static void deleteStageSetting(long modelId, Set<String> numbers) {
        if (DataLockHelper.getLockDim(modelId) == 0L || CollectionUtils.isEmpty(numbers)) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("number", "in", numbers);
        DeleteServiceHelper.delete((String)"bcm_datalocksettingentity", (QFilter[])filter.toArray());
    }

    public static Map<String, Long> getEditSetting(long modelId, long planId) {
        if (modelId == 0L || planId == 0L) {
            return new HashMap<String, Long>(0);
        }
        String cacheKey = "getStageSetting#" + modelId + "#" + planId;
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("plan", "=", (Object)planId);
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_datalocksettingentity", (String)"id,number,plan.id,editstage.id,submitstage.id", (QFilter[])filter.toArray());
            if (docs == null || docs.size() == 0) {
                return new HashMap(0);
            }
            HashMap result = new HashMap(docs.size());
            docs.forEach(d -> result.put(d.getString("number"), d.getLong("editstage.id")));
            return Collections.unmodifiableMap(result);
        });
    }

    public static Map<Long, DynamicObject> getSceneEnableStages(long modelId) {
        String cacheKey = "getDataLockScene#" + modelId;
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_datalockscene", (String)"id,number,name,scenario.id", (QFilter[])filter.toArray());
            if (docs == null || docs.size() == 0) {
                return new HashMap(0);
            }
            HashMap result = new HashMap(docs.size());
            docs.forEach(d -> result.put(d.getLong("id"), d));
            return result;
        });
    }

    public static DynamicObject getSceneEnableStage(long modelId, long sceneId, String number) {
        return DataLockHelper.getSceneEnableStages(modelId).values().stream().filter(s -> sceneId == s.getLong("scenario.id") && number.equals(s.getString("number"))).findFirst().orElse(null);
    }

    public static DynamicObject getDataLockPlan(long modelId, String number) {
        return (DynamicObject)ThreadCache.get((Object)("getDataLockPlan#" + modelId + "#" + number), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("number", "=", (Object)number);
            return QueryServiceHelper.queryOne((String)"bcm_datalockplanentity", (String)"id,number,scenario.id,dimension.number", (QFilter[])filter.toArray());
        });
    }

    public static void synchroStageSetting(long modelId) {
        BatchProcessHelper.handleAsync(() -> {
            block23: {
                long dimId = DataLockHelper.getLockDim(modelId);
                if (dimId == 0L) {
                    return;
                }
                try (DLock lock = DLock.create((String)("DataLockHelper_synchroStageSetting_" + modelId)).fastMode();){
                    if (!lock.tryLock()) break block23;
                    try {
                        String modelNum = MemberReader.findModelNumberById((Object)modelId);
                        String dimNum = MemberReader.getDimensionNumById((long)dimId);
                        try {
                            TimeUnit.SECONDS.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        IDNumberTreeNode rootNode = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)dimNum);
                        QFilter filter = new QFilter("model", "=", (Object)modelId);
                        DynamicObjectCollection plans = QueryServiceHelper.query((String)"bcm_datalockplanentity", (String)"id,number", (QFilter[])filter.toArray(), (String)"dseq");
                        if (plans == null || plans.size() == 0) {
                            return;
                        }
                        QFilter mFilter = new QFilter("model", "=", (Object)modelId);
                        plans.forEach(plan -> {
                            HashMap<String, Long> result = new HashMap<String, Long>(16);
                            long planId = plan.getLong("id");
                            HashMap stageSetting = Maps.newHashMap(DataLockHelper.getEditSetting(modelId, planId));
                            DataLockHelper.searchNullStage(rootNode, stageSetting, result);
                            QFilter pFilter = new QFilter("plan", "=", (Object)planId);
                            QFilter nFilter1 = new QFilter("number", "in", result.keySet());
                            Set existSetting = QueryServiceHelper.query((String)"bcm_datalocksettingentity", (String)"id,number", (QFilter[])new QFilter[]{mFilter, pFilter, nFilter1}).stream().map(m -> m.getString("number")).collect(Collectors.toSet());
                            if (!existSetting.isEmpty()) {
                                QFilter nFilter2 = new QFilter("number", "in", existSetting);
                                DynamicObject[] stages = BusinessDataServiceHelper.load((String)"bcm_datalocksettingentity", (String)"id,number,editstage,modifier,modifytime", (QFilter[])new QFilter[]{mFilter, pFilter, nFilter2});
                                Arrays.stream(stages).forEach(u -> {
                                    u.set("editstage", result.get(u.getString("number")));
                                    u.set("modifier", (Object)RequestContext.get().getCurrUserId());
                                    u.set("modifytime", (Object)TimeServiceHelper.now());
                                });
                                SaveServiceHelper.update((DynamicObject[])stages);
                            }
                            ArrayList newStages = new ArrayList(16);
                            result.forEach((k, v) -> {
                                if (!existSetting.contains(k)) {
                                    DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_datalocksettingentity"));
                                    obj.set("model", (Object)modelId);
                                    obj.set("plan", (Object)planId);
                                    obj.set("number", k);
                                    obj.set("editstage", v);
                                    obj.set("creator", (Object)RequestContext.get().getCurrUserId());
                                    obj.set("createtime", (Object)TimeServiceHelper.now());
                                    obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                                    obj.set("modifytime", (Object)TimeServiceHelper.now());
                                    newStages.add(obj);
                                }
                            });
                            SaveServiceHelper.save((DynamicObject[])newStages.toArray(new DynamicObject[0]));
                            GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getStageSetting#" + modelId + "#" + planId);
                        });
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        });
    }

    private static void searchNullStage(IDNumberTreeNode parentNode, Map<String, Long> stageSetting, Map<String, Long> result) {
        long parentStage = stageSetting.getOrDefault(parentNode.getNumber(), 0L);
        parentNode.getChildren().forEach(child -> {
            String number = child.getNumber();
            if (parentStage != 0L && (stageSetting.get(number) == null || (Long)stageSetting.get(number) == 0L)) {
                result.put(number, parentStage);
                stageSetting.put(number, parentStage);
            }
            DataLockHelper.searchNullStage(child, stageSetting, result);
        });
    }
}

