/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.datalock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.CollectionUtil;

public class LockScope
implements Serializable {
    private static final long serialVersionUID = 7436879202567011423L;
    private static final String KEY_SEPARATOR = "_";
    private boolean isDataLock = true;
    private Set<String> archLocks = new HashSet<String>(16);
    private final Map<String, Map<String, Map<String, List<Pair<String, String>>>>> lockMemberMap = new HashMap<String, Map<String, Map<String, List<Pair<String, String>>>>>();

    public Pair<Boolean, List<Pair<String, String>>> isLock(String yearNum, String periodNum, String currencyNum, String entity, String lockDimNum) {
        if (!this.isDataLock()) {
            return Pair.onePair((Object)false, Collections.emptyList());
        }
        if (this.archLocks.contains(this.getDataKey(yearNum, periodNum, null))) {
            return Pair.onePair((Object)true, Collections.emptyList());
        }
        Map<String, Map<String, List<Pair<String, String>>>> entityMap = this.lockMemberMap.get(this.getDataKey(yearNum, periodNum, currencyNum));
        if (entityMap == null || entityMap.isEmpty()) {
            return Pair.onePair((Object)false, Collections.emptyList());
        }
        String entityNum = entity.contains(KEY_SEPARATOR) ? entity.split(KEY_SEPARATOR)[0] : entity;
        Map<String, List<Pair<String, String>>> lockDimMap = entityMap.get(entityNum);
        if (lockDimMap == null || lockDimMap.isEmpty()) {
            return Pair.onePair((Object)false, Collections.emptyList());
        }
        List<Pair<String, String>> stageSchemeList = lockDimMap.get(lockDimNum);
        if (CollectionUtil.isEmpty(stageSchemeList)) {
            return Pair.onePair((Object)false, Collections.emptyList());
        }
        return Pair.onePair((Object)true, stageSchemeList);
    }

    private String getDataKey(String yearNum, String periodNum, String currencyNum) {
        String dataKey = yearNum + KEY_SEPARATOR + periodNum;
        if (currencyNum != null) {
            dataKey = dataKey + KEY_SEPARATOR + currencyNum;
        }
        return dataKey;
    }

    public void initData(List<DynamicObject> archDynList, List<DynamicObject> antiArchDynList, DynamicObjectCollection orgDoc) {
        if (!CollectionUtil.isEmpty(archDynList)) {
            archDynList.forEach(e -> this.archLocks.add(this.getDataKey(e.getString("year"), e.getString("period"), null)));
        }
        HashMap<Long, Set> scopeOrgMap = new HashMap<Long, Set>(16);
        if (orgDoc != null && !orgDoc.isEmpty()) {
            for (DynamicObject item : orgDoc) {
                scopeOrgMap.computeIfAbsent(item.getLong("lockscope.id"), v -> new HashSet(16)).add(item.getString("org"));
            }
        }
        if (!CollectionUtil.isEmpty(antiArchDynList)) {
            for (DynamicObject dyn : antiArchDynList) {
                Map ypcMap = this.lockMemberMap.computeIfAbsent(this.getDataKey(dyn.getString("year"), dyn.getString("period"), dyn.getString("currency")), v -> new HashMap(16));
                Set lockDimMembers = (Set)SerializationUtils.fromJsonString((String)dyn.getString("lockdim"), Set.class);
                Set entityNums = scopeOrgMap.getOrDefault(dyn.getLong("id"), new HashSet(1));
                for (String entityNum : entityNums) {
                    Map entityMap = ypcMap.computeIfAbsent(entityNum, v -> new HashMap(16));
                    for (String lockDimMember : lockDimMembers) {
                        List stageSchemeList = entityMap.computeIfAbsent(lockDimMember, v -> new ArrayList(16));
                        stageSchemeList.add(Pair.onePair((Object)dyn.getString("stage.name"), (Object)dyn.getString("scheme.name")));
                    }
                }
            }
        }
    }

    public boolean isDataLock() {
        return this.isDataLock;
    }

    public void setDataLock(boolean dataLock) {
        this.isDataLock = dataLock;
    }
}

