/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.datalock;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustApplicationLocker;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.LockScopeTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLockOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class LockScopeServiceHelper {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, LockScopeServiceHelper.class);
    public static final int MAX_SCOPE_NAME_LENGTH = 49;

    public static LockScope queryLockScope(long modelId, String sceneNum, Set<String> yearNums, Set<String> periodNums, Set<String> currencyNums) {
        return (LockScope)ThreadCache.get((Object)("QUERY_LOCK_SCOPE" + modelId + sceneNum + yearNums + periodNums + currencyNums), () -> {
            DynamicObjectCollection doc;
            LockScope lockScope = new LockScope();
            Long lockDim = DataLockHelper.getLockDim(modelId);
            if (lockDim == null || lockDim == 0L) {
                lockScope.setDataLock(false);
                return lockScope;
            }
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("scene", "=", (Object)sceneNum);
            qf.add("year", "in", (Object)yearNums);
            qf.add("period", "in", (Object)periodNums);
            if (!CollectionUtils.isEmpty((Collection)currencyNums)) {
                currencyNums.add(" ");
                qf.add("currency", "in", (Object)currencyNums);
            }
            if (CollectionUtils.isEmpty((Collection)(doc = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,currency,stage.name,scheme.name,lockdim,type", (QFilter[])qf.toArray())))) {
                return lockScope;
            }
            HashSet archRecords = new HashSet(16);
            ArrayList<DynamicObject> archDynList = new ArrayList<DynamicObject>(16);
            doc.stream().filter(e -> LockScopeTypeEnum.ARCHIVING.getValue().equals(e.getString("type"))).forEach(e -> {
                archRecords.add(LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null));
                archDynList.add((DynamicObject)e);
            });
            HashSet antiArchScopeIds = new HashSet(16);
            ArrayList<DynamicObject> antiArchDynList = new ArrayList<DynamicObject>(16);
            doc.stream().filter(e -> !archRecords.contains(LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null))).forEach(e -> {
                antiArchScopeIds.add(e.getLong("id"));
                antiArchDynList.add((DynamicObject)e);
            });
            DynamicObjectCollection orgDoc = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id,org", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", antiArchScopeIds)});
            lockScope.initData(archDynList, antiArchDynList, orgDoc);
            return lockScope;
        });
    }

    public static void mergeCommit(long modelId, long sceneId, long yearId, long periodId, long stageId, List<Pair<String, String>> currencyOrgs) {
        if (CollectionUtils.isEmpty(currencyOrgs)) {
            return;
        }
        Pair<Long, Set<String>> schemeLockMember = DataLockHelper.getStageSetting(modelId, sceneId, yearId, periodId, stageId);
        if (schemeLockMember.p1 == null || (Long)schemeLockMember.p1 == 0L || CollectionUtils.isEmpty((Collection)((Collection)schemeLockMember.p2))) {
            logger.error(String.format("%s_%s_%s_%s_%s\uff0c\u6ca1\u6709\u627e\u5230\u9501\u5b9a\u7684\u65b9\u6848\u6216\u8005\u6210\u5458", modelId, sceneId, yearId, periodId, stageId));
            return;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)sceneId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        if (LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u667a\u80fd\u5408\u5e76\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"LockScopeServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()));
        }
        long schemeId = (Long)schemeLockMember.p1;
        Set lockMembers = (Set)schemeLockMember.p2;
        String lockDimMembers = SerializationUtils.toJsonString((Object)lockMembers);
        String[] lockMembersArray = lockMembers.toArray(new String[0]);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        HashMap<String, Set> currencyOrgMap = new HashMap<String, Set>(16);
        for (Pair<String, String> item2 : currencyOrgs) {
            currencyOrgMap.computeIfAbsent((String)item2.p1, k -> new HashSet(16)).add(item2.p2);
        }
        AdjustApplicationLocker locker = new AdjustApplicationLocker(AdjustLockOperTypeEnum.LockScopeLocker);
        currencyOrgMap.keySet().stream().map(item -> LockScopeServiceHelper.getLockKey(modelNum, sceneNode, yearNode, periodNode, stageId, item)).forEach(lockKey -> locker.addPreparedLockKey((String)lockKey, ResManager.loadKDString((String)"\u63d0\u4ea4\u5206\u9636\u6bb5\u9501\u5b9a", (String)"LockScopeServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0])));
        try {
            Map<String, Boolean> lockRes = locker.batchRequest();
            for (Map.Entry<String, Boolean> kv : lockRes.entrySet()) {
                if (kv.getValue().booleanValue()) continue;
                logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0clockKey=" + kv.getKey());
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LockScopeServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> insertDoc = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> updateDoc = new ArrayList<DynamicObject>(16);
            ArrayList<Tuple> orgRecs = new ArrayList<Tuple>(16);
            DynamicObject[] lockScopeDoc = LockScopeServiceHelper.getLockScope(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), stageId, currencyOrgMap.keySet());
            HashMap dbRecMap = new HashMap(16);
            HashSet<Long> lockScopeIds = new HashSet<Long>(16);
            Arrays.stream(lockScopeDoc).forEach(e -> {
                dbRecMap.put(LockScopeServiceHelper.getUniqueKey(sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), stageId, e.getString("currency")), e);
                lockScopeIds.add(e.getLong("id"));
            });
            Map<Long, Set<String>> lockOrgMap = LockScopeServiceHelper.getLockOrgNums(lockScopeIds);
            for (Map.Entry kv : currencyOrgMap.entrySet()) {
                String olapScopeName = LockScopeServiceHelper.getUniqueKey(sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), stageId, (String)kv.getKey());
                DynamicObject dyn = (DynamicObject)dbRecMap.get(olapScopeName);
                if (dyn != null) {
                    updateDoc.add(dyn);
                    dyn.set("scheme", (Object)schemeId);
                    dyn.set("lockdim", (Object)lockDimMembers);
                    orgRecs.add(Tuple.create((Object)dyn, kv.getValue(), (Object)false));
                    continue;
                }
                DynamicObject newDyn = LockScopeServiceHelper.createLockScopeDyn(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), stageId, (String)kv.getKey(), schemeId, lockDimMembers, LockScopeTypeEnum.NORMAL);
                insertDoc.add(newDyn);
                orgRecs.add(Tuple.create((Object)newDyn, kv.getValue(), (Object)true));
            }
            Long maxCount = ParamSettingServiceHelper.getInt((long)modelId, (String)"lockDataSize");
            if ((long)(LockScopeServiceHelper.getOlapLockSize(modelNum) + insertDoc.size()) > maxCount) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u5e93\u9501\u5b9a\u8bb0\u5f55\u5df2\u6ee1%s\u6761\uff0c\u8bf7\u5148\u64cd\u4f5c\u671f\u95f4\u5f52\u6863\u540e\u518d\u63d0\u4ea4\u7ec4\u7ec7\u6d41\u7a0b\u3002", (String)"LockScopeServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), maxCount));
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.update((DynamicObject[])updateDoc.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])insertDoc.toArray(new DynamicObject[0]));
                    ArrayList<DynamicObject> orgDoc = new ArrayList<DynamicObject>(16);
                    HashMap<String, Map<String, String[]>> insetLockDimScopes = new HashMap<String, Map<String, String[]>>(16);
                    HashMap<String, Map<String, String[]>> updateLockDimScopes = new HashMap<String, Map<String, String[]>>(16);
                    for (Tuple item3 : orgRecs) {
                        Map<String, String[]> lockDimMap;
                        for (String orgNum : (Set)item3.p2) {
                            DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_lockscopeorg");
                            newDyn.set("model", (Object)modelId);
                            newDyn.set("lockscope", (Object)((DynamicObject)item3.p1).getLong("id"));
                            newDyn.set("org", (Object)orgNum);
                            orgDoc.add(newDyn);
                        }
                        String olapScopeName = ((DynamicObject)item3.p1).getString("scopename");
                        if (((Boolean)item3.p3).booleanValue()) {
                            lockDimMap = LockScopeServiceHelper.createLockDimScope(modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), ((DynamicObject)item3.p1).getString("currency"), (Set)item3.p2, lockDimension, lockMembersArray);
                            insetLockDimScopes.put(olapScopeName, lockDimMap);
                            continue;
                        }
                        Set orgNumSet = lockOrgMap.getOrDefault(((DynamicObject)item3.p1).getLong("id"), new HashSet(1));
                        orgNumSet.addAll((Collection)item3.p2);
                        lockDimMap = LockScopeServiceHelper.createLockDimScope(modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), ((DynamicObject)item3.p1).getString("currency"), orgNumSet, lockDimension, lockMembersArray);
                        updateLockDimScopes.put(olapScopeName, lockDimMap);
                    }
                    SaveServiceHelper.save((DynamicObject[])orgDoc.toArray(new DynamicObject[0]));
                    if (!CollectionUtils.isEmpty(insetLockDimScopes)) {
                        OlapServiceHelper.createLockDataScope(modelNum, insetLockDimScopes);
                    }
                    if (!CollectionUtils.isEmpty(updateLockDimScopes)) {
                        OlapServiceHelper.updateLockDataScope(modelNum, updateLockDimScopes);
                    }
                }
                catch (Throwable t) {
                    tx.markRollback();
                    logger.error(String.format("%s_%s_%s_%s\uff0c\u64cd\u4f5c\u5206\u9636\u6bb5\u9501\u5b9a\u8303\u56f4\u51fa\u9519\u3002", modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()), t);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5206\u9636\u6bb5\u9501\u5b9a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
            throw new KDBizException(e2.getMessage());
        }
        finally {
            locker.batchRelease();
        }
    }

    private static int getOlapLockSize(String modelNum) {
        String setString = OlapServiceHelper.queryLockScope(modelNum);
        int size = 0;
        try {
            Set allScopeNames = (Set)SerializationUtils.fromJsonString((String)setString, Set.class);
            size = allScopeNames.size();
        }
        catch (Exception e) {
            logger.error("Serialize.formJsonString error, setString=" + setString, (Throwable)e);
        }
        return size;
    }

    public static String getLockDimNumber(long modelId) {
        Long lockDim = DataLockHelper.getLockDim(modelId);
        if (lockDim == null || lockDim == 0L) {
            logger.error(String.format("\u4f53\u7cfb\uff1a%s\uff0c\u6ca1\u6709\u627e\u5230\u9501\u5b9a\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", modelId));
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9501\u5b9a\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"LockScopeServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return MemberReader.getDimensionNumById((long)lockDim);
    }

    public static String getLockDimNumber_HasEmpty(long modelId) {
        Long lockDim = DataLockHelper.getLockDim(modelId);
        if (lockDim == null || lockDim == 0L) {
            return "";
        }
        return MemberReader.getDimensionNumById((long)lockDim);
    }

    public static boolean isExistLockDim(long modelId) {
        Long lockDim = DataLockHelper.getLockDim(modelId);
        return lockDim != null && lockDim != 0L;
    }

    public static void mergeBack(long modelId, long sceneId, long yearId, long periodId, long stageId, List<Pair<String, String>> currencyOrgs) {
        if (CollectionUtils.isEmpty(currencyOrgs)) {
            return;
        }
        Pair<Long, Set<String>> schemeLockMember = DataLockHelper.getStageSetting(modelId, sceneId, yearId, periodId, stageId);
        if (schemeLockMember.p1 == null || (Long)schemeLockMember.p1 == 0L || CollectionUtils.isEmpty((Collection)((Collection)schemeLockMember.p2))) {
            logger.error(String.format("%s_%s_%s_%s_%s\uff0c\u6ca1\u6709\u627e\u5230\u9501\u5b9a\u7684\u65b9\u6848\u6216\u8005\u6210\u5458", modelId, sceneId, yearId, periodId, stageId));
            return;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)sceneId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        if (LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6253\u56de\u667a\u80fd\u5408\u5e76\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"LockScopeServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()));
        }
        long schemeId = (Long)schemeLockMember.p1;
        Set lockMembers = (Set)schemeLockMember.p2;
        String lockDimMembers = SerializationUtils.toJsonString((Object)lockMembers);
        String[] lockMembersArray = lockMembers.toArray(new String[0]);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        HashMap<String, Set> currencyOrgMap = new HashMap<String, Set>(16);
        for (Pair<String, String> item2 : currencyOrgs) {
            currencyOrgMap.computeIfAbsent((String)item2.p1, k -> new HashSet(16)).add(item2.p2);
        }
        AdjustApplicationLocker locker = new AdjustApplicationLocker(AdjustLockOperTypeEnum.LockScopeLocker);
        currencyOrgMap.keySet().stream().map(item -> LockScopeServiceHelper.getLockKey(modelNum, sceneNode, yearNode, periodNode, stageId, item)).forEach(lockKey -> locker.addPreparedLockKey((String)lockKey, ResManager.loadKDString((String)"\u6253\u56de\u5206\u9636\u6bb5\u9501\u5b9a", (String)"LockScopeServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0])));
        try {
            Map<String, Boolean> lockRes = locker.batchRequest();
            for (Map.Entry<String, Boolean> kv : lockRes.entrySet()) {
                if (kv.getValue().booleanValue()) continue;
                logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0clockKey=" + kv.getKey());
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LockScopeServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            DynamicObject[] lockScopeDoc = LockScopeServiceHelper.getLockScope(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), stageId, currencyOrgMap.keySet());
            if (lockScopeDoc == null || lockScopeDoc.length == 0) {
                logger.error(String.format("%s_%s_%s_%s_%s\uff0c\u6ca1\u6709\u627e\u5230\u9501\u5b9a\u8bb0\u5f55\u3002", modelId, sceneId, yearId, periodId, stageId));
                return;
            }
            Set<Long> lockScopeIds = Arrays.stream(lockScopeDoc).map(e -> e.getLong("id")).collect(Collectors.toSet());
            Map<Long, Set<DynamicObject>> lockOrgMap = LockScopeServiceHelper.getLockOrgs(lockScopeIds);
            ArrayList<DynamicObject> updateDoc = new ArrayList<DynamicObject>(16);
            HashSet<Long> needToDelScope = new HashSet<Long>(16);
            HashSet<Long> needToDelOrg = new HashSet<Long>(16);
            HashSet<String> dropSopeNames = new HashSet<String>(16);
            HashMap<String, Map<String, String[]>> lockScopeMap = new HashMap<String, Map<String, String[]>>(16);
            for (DynamicObject dyn : lockScopeDoc) {
                Set delOrgs = (Set)currencyOrgMap.get(dyn.getString("currency"));
                if (CollectionUtils.isEmpty((Collection)delOrgs)) continue;
                Set<DynamicObject> dbOrgs = lockOrgMap.get(dyn.getLong("id"));
                if (CollectionUtils.isEmpty(dbOrgs)) {
                    dropSopeNames.add(dyn.getString("scopename"));
                    needToDelScope.add(dyn.getLong("id"));
                    continue;
                }
                Iterator<DynamicObject> it = dbOrgs.iterator();
                while (it.hasNext()) {
                    DynamicObject orgDyn = it.next();
                    if (!delOrgs.contains(orgDyn.getString("org"))) continue;
                    needToDelOrg.add(orgDyn.getLong("id"));
                    it.remove();
                }
                if (CollectionUtils.isEmpty(dbOrgs)) {
                    dropSopeNames.add(dyn.getString("scopename"));
                    needToDelScope.add(dyn.getLong("id"));
                    continue;
                }
                dyn.set("scheme", (Object)schemeId);
                dyn.set("lockdim", (Object)lockDimMembers);
                updateDoc.add(dyn);
                lockScopeMap.put(dyn.getString("scopename"), LockScopeServiceHelper.createLockDimScope(modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), dyn.getString("currency"), dbOrgs.stream().map(e -> e.getString("org")).collect(Collectors.toSet()), lockDimension, lockMembersArray));
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.update((DynamicObject[])updateDoc.toArray(new DynamicObject[0]));
                    DeleteServiceHelper.delete((String)"bcm_lockscope", (QFilter[])new QFilter[]{new QFilter("id", "in", needToDelScope)});
                    DeleteServiceHelper.delete((String)"bcm_lockscopeorg", (QFilter[])new QFilter[]{new QFilter("id", "in", needToDelOrg)});
                    if (!CollectionUtils.isEmpty(dropSopeNames)) {
                        OlapServiceHelper.dropLockDataScope(modelNum, dropSopeNames);
                    }
                    if (!CollectionUtils.isEmpty(lockScopeMap)) {
                        OlapServiceHelper.updateLockDataScope(modelNum, lockScopeMap);
                    }
                }
                catch (Throwable t) {
                    tx.markRollback();
                    logger.error(String.format("%s_%s_%s_%s\uff0c\u64cd\u4f5c\u5206\u9636\u6bb5\u9501\u5b9a\u8303\u56f4\u51fa\u9519\u3002", modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()), t);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5206\u9636\u6bb5\u9501\u5b9a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
            throw new KDBizException(e2.getMessage());
        }
        finally {
            locker.batchRelease();
        }
    }

    public static void archiving(long modelId, long secneId, long yearId, long periodId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)secneId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        if (LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber())) {
            logger.error(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\uff1a%s\uff0c\u5df2\u5b58\u5728\u5f52\u6863\u8bb0\u5f55\uff0c\u8df3\u8fc7\u5f52\u6863\u3002", (String)"LockScopeServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), modelId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u60c5\u666f%2$s\u8d22\u5e74%3$s\u671f\u95f4\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u518d\u64cd\u4f5c\u5f52\u6863\u3002", (String)"LockScopeServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), sceneNode.getName(), yearNode.getName(), periodNode.getName()));
        }
        DynamicObjectCollection lockScopes = LockScopeServiceHelper.getAllLockScope(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber());
        if (CollectionUtils.isEmpty((Collection)lockScopes)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u60c5\u666f%2$s\u8d22\u5e74%3$s\u671f\u95f4\uff0c\u4e0d\u5b58\u5728\u5206\u6bb5\u9501\u5b9a\u8bb0\u5f55\uff0c\u65e0\u6cd5\u64cd\u4f5c\u5f52\u6863\u3002", (String)"LockScopeServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), sceneNode.getName(), yearNode.getName(), periodNode.getName()));
        }
        Set<String> scopeNames = lockScopes.stream().map(e -> e.getString("scopename")).collect(Collectors.toSet());
        DynamicObject lockScopeDyn = LockScopeServiceHelper.createLockScopeDyn(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), null, null, null, null, LockScopeTypeEnum.ARCHIVING);
        HashMap<String, Map<String, String[]>> lockDimScopes = new HashMap<String, Map<String, String[]>>(1);
        lockDimScopes.put(lockScopeDyn.getString("scopename"), LockScopeServiceHelper.createLockDimScope(modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), null, null, lockDimension, null));
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{lockScopeDyn});
                if (!CollectionUtils.isEmpty(scopeNames)) {
                    OlapServiceHelper.dropLockDataScope(modelNum, scopeNames);
                }
                if (!lockDimScopes.isEmpty()) {
                    OlapServiceHelper.createLockDataScope(modelNum, lockDimScopes);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error(String.format("%s_%s_%s_%s\uff0c\u5f52\u6863\u51fa\u9519\u3002", modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()), t);
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u9636\u6bb5\u9501\u5b9a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void antiArchiving(long modelId, long secneId, long yearId, long periodId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)secneId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        if (!LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber())) {
            logger.error(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\uff1a%s\uff0c\u6ca1\u6709\u5b58\u5728\u5f52\u6863\u8bb0\u5f55\uff0c\u8df3\u8fc7\u53cd\u5f52\u6863\u3002", (String)"LockScopeServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), modelId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u60c5\u666f%2$s\u8d22\u5e74%3$s\u671f\u95f4\uff0c\u4e0d\u5b58\u5728\u5df2\u5f52\u6863\u7684\u5206\u6bb5\u9501\u5b9a\u8bb0\u5f55\uff0c\u65e0\u6cd5\u64cd\u4f5c\u53cd\u5f52\u6863\u3002", (String)"LockScopeServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), sceneNode.getName(), yearNode.getName(), periodNode.getName()));
        }
        DynamicObjectCollection lockScopes = LockScopeServiceHelper.getAllLockScope(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber());
        Map<Long, Set<String>> lockOrgMap = LockScopeServiceHelper.getLockOrgNums(lockScopes.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        HashMap<String, Map<String, String[]>> lockDimScopes = new HashMap<String, Map<String, String[]>>(16);
        String archScopeName = "";
        Long archScopeId = 0L;
        for (DynamicObject dyn : lockScopes) {
            if (LockScopeTypeEnum.ARCHIVING.getValue().equals(dyn.getString("type"))) {
                archScopeName = dyn.getString("scopename");
                archScopeId = dyn.getLong("id");
                continue;
            }
            Set lockdim = (Set)SerializationUtils.fromJsonString((String)dyn.getString("lockdim"), Set.class);
            lockDimScopes.put(dyn.getString("scopename"), LockScopeServiceHelper.createLockDimScope(modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), dyn.getString("currency"), lockOrgMap.getOrDefault(dyn.getLong("id"), new HashSet(1)), lockDimension, lockdim.toArray(new String[0])));
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_lockscope", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)archScopeId)});
                if (!StringUtils.isBlank((CharSequence)archScopeName)) {
                    OlapServiceHelper.dropLockDataScope(modelNum, Sets.newHashSet((Object[])new String[]{archScopeName}));
                }
                if (!lockDimScopes.isEmpty()) {
                    OlapServiceHelper.createLockDataScope(modelNum, lockDimScopes);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error(String.format("%s_%s_%s_%s\uff0c\u5f52\u6863\u51fa\u9519\u3002", modelNum, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber()), t);
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u9636\u6bb5\u9501\u5b9a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void addOrgToLockScope(long modelId, Map<String, Set<String>> orgMap) {
        if (orgMap == null) {
            return;
        }
        if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
            return;
        }
        orgMap.remove("Entity");
        if (orgMap.isEmpty()) {
            return;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("lockscope.model", "=", (Object)modelId);
        qf.add("org", "in", orgMap.keySet());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id,org", (QFilter[])qf.toArray());
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return;
        }
        HashMap<Long, Set> lockOrgMap = new HashMap<Long, Set>(16);
        for (DynamicObject dyn : doc) {
            lockOrgMap.computeIfAbsent(dyn.getLong("lockscope.id"), k -> new HashSet(16)).add(dyn.getString("org"));
        }
        DynamicObjectCollection lockScopeDoc = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,scopename,type", (QFilter[])new QFilter[]{new QFilter("id", "in", lockOrgMap.keySet())});
        Set archRecords = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,scopename", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("type", "=", (Object)LockScopeTypeEnum.ARCHIVING.getValue())}).stream().map(e -> LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null)).collect(Collectors.toSet());
        List antiArchScope = lockScopeDoc.stream().filter(e -> !archRecords.contains(LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null))).map(e -> Pair.onePair((Object)e.getLong("id"), (Object)e.getString("scopename"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(antiArchScope)) {
            return;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        HashMap<String, Map<String, String[]>> lockDimScopes = new HashMap<String, Map<String, String[]>>(16);
        for (Pair item : antiArchScope) {
            Set parents = (Set)lockOrgMap.get(item.p1);
            if (CollectionUtils.isEmpty((Collection)parents)) continue;
            HashSet<String> parentChilds = new HashSet<String>(16);
            for (String parent : parents) {
                Set<String> childs = orgMap.get(parent);
                if (CollectionUtils.isEmpty(childs)) continue;
                childs.forEach(e -> parentChilds.add(parent + "_" + e));
            }
            if (CollectionUtils.isEmpty(parentChilds)) continue;
            lockDimScopes.put((String)item.p2, LockScopeServiceHelper.createMemberLockScope(parentChilds, lockDimension, null));
        }
        if (!lockDimScopes.isEmpty()) {
            OlapServiceHelper.addLockDataScopeMember(modelNum, lockDimScopes);
        }
    }

    public static void removeOrgToLockScope(long modelId, Set<String> orgNums) {
        if (orgNums == null || orgNums.isEmpty()) {
            return;
        }
        if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
            return;
        }
        Set inDbOrgNums = orgNums.stream().map(e -> e.contains("_") ? e.split("_")[0] : e).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add("lockscope.model", "=", (Object)modelId);
        qf.add("org", "in", inDbOrgNums);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id,org", (QFilter[])qf.toArray());
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return;
        }
        HashSet<Long> lockScopeIds = new HashSet<Long>(16);
        HashSet<Long> lockOrgIds = new HashSet<Long>(16);
        for (DynamicObject dyn : doc) {
            lockScopeIds.add(dyn.getLong("lockscope.id"));
            lockOrgIds.add(dyn.getLong("id"));
        }
        DynamicObjectCollection lockScopeDoc = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,scopename,type", (QFilter[])new QFilter[]{new QFilter("id", "in", lockScopeIds)});
        Set archRecords = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scene,year,period,scopename", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("type", "=", (Object)LockScopeTypeEnum.ARCHIVING.getValue())}).stream().map(e -> LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null)).collect(Collectors.toSet());
        Set antiArchScopes = lockScopeDoc.stream().filter(e -> !archRecords.contains(LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null))).map(e -> e.getString("scopename")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(lockOrgIds) && CollectionUtils.isEmpty(antiArchScopes)) {
            return;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        Map<String, Map<String, String[]>> lockDimScopes = antiArchScopes.stream().collect(Collectors.toMap(k -> k, v -> LockScopeServiceHelper.createMemberLockScope(orgNums, lockDimension, null), (e1, e2) -> e2));
        try (TXHandle tx = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(lockOrgIds)) {
                    DeleteServiceHelper.delete((String)"bcm_lockscopeorg", (QFilter[])new QFilter[]{new QFilter("id", "in", lockOrgIds)});
                }
                Set haveOrgscopeIds = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", lockScopeIds)}).stream().map(e -> e.getLong("lockscope.id")).collect(Collectors.toSet());
                lockScopeIds.removeAll(haveOrgscopeIds);
                if (!CollectionUtils.isEmpty(lockScopeIds)) {
                    DeleteServiceHelper.delete((String)"bcm_lockscope", (QFilter[])new QFilter[]{new QFilter("id", "in", lockScopeIds)});
                }
                if (!lockDimScopes.isEmpty()) {
                    OlapServiceHelper.dropLockDataScopeMember(modelNum, lockDimScopes);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error(String.format("%s_%s_\uff0c\u5220\u9664\u7ec4\u7ec7\uff0c\u66f4\u65b0\u9501\u5b9a\u8303\u56f4\u51fa\u9519\u3002", modelNum, orgNums), t);
                throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u9501\u5b9a\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void deleteOrgMergeControlRecord(long modelId, Set<String> orgNums) {
        try (TXHandle tx = TX.required();){
            try {
                Set deleteOrgNumberSet = orgNums.stream().filter(r -> !r.contains("_")).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(deleteOrgNumberSet)) {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and("orgnumber", "in", deleteOrgNumberSet);
                    DeleteServiceHelper.delete((String)"bcm_mergecontrolstatus", (QFilter[])qFilter.toArray());
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                logger.error("delete mergecontrol record error:\n" + e);
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea7\u8054\u5220\u9664\u5408\u5e76\u6d41\u7a0b\u63a7\u5236\u8bb0\u5f55\u5931\u8d25\u3002", (String)"LockScopeServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void removeLockDimMember(long modelId, Set<String> delNums) {
        if (CollectionUtils.isEmpty(delNums)) {
            return;
        }
        if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
            return;
        }
        DynamicObject[] lockScopeDoc = BusinessDataServiceHelper.load((String)"bcm_lockscope", (String)"id,scene,year,period,scopename,lockdim,type", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        if (lockScopeDoc == null || lockScopeDoc.length == 0) {
            return;
        }
        Set archScopes = Arrays.stream(lockScopeDoc).filter(e -> LockScopeTypeEnum.ARCHIVING.getValue().equals(e.getString("type"))).map(e -> LockScopeServiceHelper.getCombineKey(e.getString("scene"), e.getString("year"), e.getString("period"), null)).collect(Collectors.toSet());
        HashSet<Long> needToDelScopeIds = new HashSet<Long>(16);
        HashSet<String> needToUpdateScope = new HashSet<String>(16);
        HashSet<String> needToDeleteScope = new HashSet<String>(16);
        ArrayList<DynamicObject> needToUpdate = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyn : lockScopeDoc) {
            if (LockScopeTypeEnum.ARCHIVING.getValue().equals(dyn.getString("type"))) continue;
            Set lockdim = (Set)SerializationUtils.fromJsonString((String)dyn.getString("lockdim"), Set.class);
            int orginSize = lockdim.size();
            lockdim.removeAll(delNums);
            if (lockdim.size() == orginSize) continue;
            if (lockdim.isEmpty()) {
                needToDelScopeIds.add(dyn.getLong("id"));
                needToDeleteScope.add(dyn.getString("scopename"));
                continue;
            }
            dyn.set("lockdim", (Object)SerializationUtils.toJsonString((Object)lockdim));
            needToUpdate.add(dyn);
            if (archScopes.contains(LockScopeServiceHelper.getCombineKey(dyn.getString("scene"), dyn.getString("year"), dyn.getString("period"), null))) continue;
            needToUpdateScope.add(dyn.getString("scopename"));
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String lockDimension = LockScopeServiceHelper.getLockDimNumber(modelId);
        Map<String, Map<String, String[]>> lockDimScopes = needToUpdateScope.stream().collect(Collectors.toMap(k -> k, v -> LockScopeServiceHelper.createMemberLockScope(null, lockDimension, delNums)));
        try (TXHandle tx = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(needToUpdate)) {
                    SaveServiceHelper.save((DynamicObject[])needToUpdate.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(needToDelScopeIds)) {
                    DeleteServiceHelper.delete((String)"bcm_lockscopeorg", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", needToDelScopeIds)});
                    DeleteServiceHelper.delete((String)"bcm_lockscope", (QFilter[])new QFilter[]{new QFilter("id", "in", needToDelScopeIds)});
                }
                if (!CollectionUtils.isEmpty(needToDeleteScope)) {
                    OlapServiceHelper.dropLockDataScope(modelNum, needToDeleteScope);
                }
                if (!lockDimScopes.isEmpty()) {
                    OlapServiceHelper.dropLockDataScopeMember(modelNum, lockDimScopes);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error(String.format("%s_%s\uff0c\u5220\u9664\u9501\u5b9a\u7ef4\u5ea6\u6210\u5458\uff0c\u66f4\u65b0\u9501\u5b9a\u8303\u56f4\u51fa\u9519\u3002", modelNum, delNums), t);
                throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u9501\u5b9a\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void removeDimMember(long modelId, String dimNum, Set<String> delMembers) {
        if (CollectionUtils.isEmpty(delMembers) || StringUtils.isBlank((CharSequence)dimNum)) {
            return;
        }
        if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
            return;
        }
        boolean isHaveDimNum = false;
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        switch (dimNum) {
            case "Scenario": {
                qf.add("scene", "in", delMembers);
                isHaveDimNum = true;
                break;
            }
            case "Year": {
                qf.add("year", "in", delMembers);
                isHaveDimNum = true;
                break;
            }
            case "Period": {
                qf.add("period", "in", delMembers);
                isHaveDimNum = true;
                break;
            }
            case "Currency": {
                qf.add("currency", "in", delMembers);
                isHaveDimNum = true;
            }
        }
        if (!isHaveDimNum) {
            logger.error(String.format("\u6ca1\u6709\u4f20\u5bf9\u7ef4\u5ea6\u7f16\u7801\uff0c\u7981\u6b62\u5220\u9664\u3002modelId=%s,dimNum=%s", modelId, dimNum));
            return;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,scopename", (QFilter[])qf.toArray());
        HashSet lockIds = new HashSet(16);
        HashSet<String> scopeNames = new HashSet<String>(16);
        doc.forEach(e -> {
            lockIds.add(e.getLong("id"));
            scopeNames.add(e.getString("scopename"));
        });
        try (TXHandle tx = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(lockIds)) {
                    DeleteServiceHelper.delete((String)"bcm_lockscope", (QFilter[])new QFilter[]{new QFilter("id", "in", lockIds)});
                    DeleteServiceHelper.delete((String)"bcm_lockscopeorg", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", lockIds)});
                }
                if (!CollectionUtils.isEmpty(scopeNames)) {
                    OlapServiceHelper.dropLockDataScope(MemberReader.findModelNumberById((Object)modelId), scopeNames);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error(String.format("%s_%s_%s\uff0c\u5220\u9664\u9501\u5b9a\u7ef4\u5ea6\u6210\u5458\uff0c\u66f4\u65b0\u9501\u5b9a\u8303\u56f4\u51fa\u9519\u3002", modelId, dimNum, delMembers), t);
                throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u9501\u5b9a\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    private static DynamicObjectCollection getAllLockScope(long modelId, String sceneNum, String yearNum, String periodNum) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("scene", "=", (Object)sceneNum);
        qf.add("year", "=", (Object)yearNum);
        qf.add("period", "=", (Object)periodNum);
        return QueryServiceHelper.query((String)"bcm_lockscope", (String)"id,currency,stage,scheme,scopename,lockdim,type", (QFilter[])qf.toArray());
    }

    public static boolean isExistArchiving(long modelId, String sceneNum, String yearNum, String periodNum) {
        return (Boolean)BcmThreadCache.get((Object)"isExistArchiving", (Object)modelId, (Object)sceneNum, (Object)yearNum, (Object)periodNum, () -> {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("scene", "=", (Object)sceneNum);
            qf.add("year", "=", (Object)yearNum);
            qf.add("period", "=", (Object)periodNum);
            qf.add("type", "=", (Object)LockScopeTypeEnum.ARCHIVING.getValue());
            return QueryServiceHelper.exists((String)"bcm_lockscope", (QFilter[])qf.toArray());
        });
    }

    private static Map<String, String[]> createMemberLockScope(Set<String> orgNums, String lockDimension, Set<String> lockDimMembers) {
        HashMap<String, String[]> dimMembers = new HashMap<String, String[]>(6);
        dimMembers.put("Scenario", null);
        dimMembers.put("Year", null);
        dimMembers.put("Period", null);
        dimMembers.put("Currency", null);
        dimMembers.put("Entity", orgNums == null || orgNums.isEmpty() ? null : orgNums.toArray(new String[0]));
        dimMembers.put(lockDimension, lockDimMembers == null || lockDimMembers.isEmpty() ? null : lockDimMembers.toArray(new String[0]));
        return dimMembers;
    }

    public static Map<Long, Set<String>> getLockOrgNums(Set<Long> lockScopeIds) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id,org", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", lockScopeIds)});
        HashMap<Long, Set<String>> reulst = new HashMap<Long, Set<String>>(16);
        if (doc != null && !doc.isEmpty()) {
            for (DynamicObject dyn : doc) {
                reulst.computeIfAbsent(dyn.getLong("lockscope.id"), v -> new HashSet(16)).add(dyn.getString("org"));
            }
        }
        return reulst;
    }

    public static Map<Long, Set<DynamicObject>> getLockOrgs(Set<Long> lockScopeIds) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_lockscopeorg", (String)"id,lockscope.id,org", (QFilter[])new QFilter[]{new QFilter("lockscope.id", "in", lockScopeIds)});
        HashMap<Long, Set<DynamicObject>> reulst = new HashMap<Long, Set<DynamicObject>>(16);
        if (doc != null && !doc.isEmpty()) {
            for (DynamicObject dyn : doc) {
                reulst.computeIfAbsent(dyn.getLong("lockscope.id"), v -> new HashSet(16)).add(dyn);
            }
        }
        return reulst;
    }

    private static Map<String, String[]> createLockDimScope(String modelNum, String sceneNum, String yearNum, String periodNum, String currency, Set<String> orgNums, String lockDimension, String[] lockDimMembers) {
        HashMap<String, String[]> dimMembers = new HashMap<String, String[]>(6);
        dimMembers.put("Scenario", new String[]{sceneNum});
        dimMembers.put("Year", new String[]{yearNum});
        dimMembers.put("Period", new String[]{periodNum});
        if (currency == null) {
            currency = "*";
        }
        dimMembers.put("Currency", new String[]{currency});
        if (orgNums != null) {
            Set<String> allOrgNums = LockScopeServiceHelper.getParentChilds(modelNum, orgNums);
            dimMembers.put("Entity", allOrgNums.toArray(new String[0]));
        } else {
            dimMembers.put("Entity", new String[]{"*"});
        }
        if (lockDimMembers != null) {
            dimMembers.put(lockDimension, lockDimMembers);
        } else {
            dimMembers.put(lockDimension, new String[]{"*"});
        }
        return dimMembers;
    }

    public static Set<String> getParentChilds(String modelNum, Set<String> orgNums) {
        HashSet<String> allOrgNums = new HashSet<String>(16);
        for (String parent : orgNums) {
            IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)modelNum, (String)parent);
            if (IDNumberTreeNode.NotFoundTreeNode == node) continue;
            allOrgNums.add(parent);
            if (node.isLeaf() || CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
            for (IDNumberTreeNode child : node.getChildren()) {
                allOrgNums.add(parent + "_" + child.getNumber());
            }
        }
        return allOrgNums;
    }

    private static DynamicObject createLockScopeDyn(long modelId, String sceneNum, String yearNum, String periodNum, Long stageId, String currency, Long schemeId, String lockdim, LockScopeTypeEnum type) {
        DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_lockscope");
        newDyn.set("model", (Object)modelId);
        newDyn.set("scene", (Object)sceneNum);
        newDyn.set("year", (Object)yearNum);
        newDyn.set("period", (Object)periodNum);
        if (currency != null) {
            newDyn.set("currency", (Object)currency);
        }
        if (stageId != null) {
            newDyn.set("stage", (Object)stageId);
        }
        if (schemeId != null) {
            newDyn.set("scheme", (Object)schemeId);
        }
        newDyn.set("combinekey", (Object)LockScopeServiceHelper.getCombineKey(sceneNum, yearNum, periodNum, currency));
        newDyn.set("scopename", (Object)LockScopeServiceHelper.getOlapScopeName(sceneNum, yearNum, periodNum, currency));
        if (lockdim != null) {
            newDyn.set("lockdim", (Object)lockdim);
        }
        newDyn.set("type", (Object)type.getValue());
        return newDyn;
    }

    public static String getOlapScopeName(String sceneNum, String yearNum, String periodNum, String currency) {
        String combineKey;
        ArrayList<String> items = new ArrayList<String>(5);
        items.add(sceneNum);
        items.add(yearNum);
        items.add(periodNum);
        if (currency != null) {
            items.add(currency);
        }
        if ((combineKey = String.join((CharSequence)"_", items)).length() > 43) {
            logger.error(String.format("\u9501\u5b9a\u8303\u56f4\u8d85\u8fc7\u4e86\u9650\u5b9a\u8303\u56f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002combineKey=%s", combineKey));
            throw new KDBizException(ResManager.loadKDString((String)"\u9501\u5b9a\u8303\u56f4\u540d\u79f0\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LockScopeServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String uid = String.valueOf(GlobalIdUtil.genGlobalLongId());
        int allLength = combineKey.length() + uid.length() + 1;
        if (allLength > 49) {
            int subIndex = allLength - 49;
            uid = uid.substring(subIndex);
        }
        return combineKey + "_" + uid;
    }

    private static DynamicObject[] getLockScope(long modelId, String sceneNum, String yearNum, String periodNum, long stageId, Set<String> currencys) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("scene", "=", (Object)sceneNum);
        qf.add("year", "=", (Object)yearNum);
        qf.add("period", "=", (Object)periodNum);
        qf.add("stage", "=", (Object)stageId);
        qf.add("currency", "in", currencys);
        return BusinessDataServiceHelper.load((String)"bcm_lockscope", (String)"id,currency,scheme,scopename,lockdim", (QFilter[])qf.toArray());
    }

    private static String getLockKey(String modelNum, IDNumberTreeNode sceneNode, IDNumberTreeNode yearNode, IDNumberTreeNode periodNode, long stageId, String currency) {
        return modelNum + "_" + sceneNode.getNumber() + "_" + yearNode.getNumber() + "_" + periodNode.getNumber() + "_" + currency + "_" + stageId;
    }

    public static String getCombineKey(String sceneNum, String yearNum, String periodNum, String currencyNum) {
        String combineKey = sceneNum + "_" + yearNum + "_" + periodNum;
        if (currencyNum != null) {
            combineKey = combineKey + "_" + currencyNum;
        }
        return combineKey;
    }

    public static String getUniqueKey(String sceneNum, String yearNum, String periodNum, long stageId, String currencyNum) {
        String combineKey = sceneNum + "_" + yearNum + "_" + periodNum;
        if (currencyNum != null) {
            combineKey = combineKey + "_" + currencyNum;
        }
        combineKey = combineKey + "_" + stageId;
        return combineKey;
    }
}

