/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.datalock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class StageServiceHelper {
    public static Map<String, Pair<String, String>> getModelDataLockStageInfoMap(Long modelId, Long sceneId) {
        return (Map)ThreadCache.get((Object)("DataLockStage" + modelId + sceneId), () -> {
            HashMap<String, Pair> dataLockStageInfoMap = new HashMap<String, Pair>(5);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("scenario", "=", (Object)sceneId);
            DynamicObjectCollection dataLockStage = QueryServiceHelper.query((String)"bcm_datalockscene", (String)"number,name,stage", (QFilter[])qFilter.toArray(), (String)"stage asc");
            for (DynamicObject dataLockItem : dataLockStage) {
                dataLockStageInfoMap.put(dataLockItem.getString("stage"), Pair.onePair((Object)dataLockItem.getString("number"), (Object)dataLockItem.getString("name")));
            }
            return dataLockStageInfoMap;
        });
    }

    public static List<Tuple<Long, String, String>> getDataLockStageItem(Long modelId, Long sceneId) {
        return (List)ThreadCache.get((Object)("DataLockStageItem" + modelId + sceneId), () -> {
            ArrayList<Tuple> stageItemList = new ArrayList<Tuple>(10);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("scenario", "=", (Object)sceneId);
            DynamicObjectCollection dataLockStage = QueryServiceHelper.query((String)"bcm_datalockscene", (String)"id,number,name,stage", (QFilter[])qFilter.toArray(), (String)"stage asc");
            for (DynamicObject dataLockItem : dataLockStage) {
                stageItemList.add(Tuple.create((Object)dataLockItem.getLong("id"), (Object)dataLockItem.getString("stage"), (Object)dataLockItem.getString("number")));
            }
            return stageItemList;
        });
    }

    public static Pair<Long, List<Tuple<Long, String, String>>> getDataLockPlanInfo(Long modelId, Long sceneId, Long yearId, Long period) {
        return (Pair)ThreadCache.get((Object)("DataLockPlanForMerge" + modelId + sceneId + yearId + period), () -> {
            QFilter filters;
            Set planStageIdSet;
            Long dataLockPlanId = DataLockHelper.getDataLockPlanId(modelId, sceneId, yearId, period);
            ArrayList<Tuple> stageItemList = new ArrayList<Tuple>(10);
            if (dataLockPlanId > 0L && !(planStageIdSet = QueryServiceHelper.query((String)"bcm_datalocksettingentity", (String)"submitstage", (QFilter[])(filters = new QFilter("plan", "=", (Object)dataLockPlanId)).toArray()).stream().map(m -> m.getLong("submitstage")).collect(Collectors.toSet())).isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", planStageIdSet);
                DynamicObjectCollection dataLockStage = QueryServiceHelper.query((String)"bcm_datalockscene", (String)"id,number,name,stage", (QFilter[])qFilter.toArray(), (String)"stage asc");
                for (DynamicObject dataLockItem : dataLockStage) {
                    stageItemList.add(Tuple.create((Object)dataLockItem.getLong("id"), (Object)dataLockItem.getString("stage"), (Object)dataLockItem.getString("name")));
                }
            }
            return Pair.onePair((Object)dataLockPlanId, stageItemList);
        });
    }

    public static DynamicObject getStageById(long stageId) {
        QFilter filter = new QFilter("id", "=", (Object)stageId);
        return QueryServiceHelper.queryOne((String)"bcm_datalockscene", (String)"id,number,name,stage", (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryModelSceneStages(Long modelId, Long sceneId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("scenario", "=", (Object)sceneId);
        return QueryServiceHelper.query((String)"bcm_datalockscene", (String)"id,number,name,stage", (QFilter[])filter.toArray(), (String)"stage");
    }

    public static boolean isExistLockPlan(Long modelId, Long sceneId, Long yearId, Long periodId) {
        return (Boolean)GlobalCacheServiceHelper.getOrLoadNode((String)("isExistLockPlan#" + modelId + sceneId + yearId + periodId), () -> {
            Pair<Long, List<Tuple<Long, String, String>>> dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo(modelId, sceneId, yearId, periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L && !((List)dataLockPlanInfo.p2).isEmpty()) {
                return true;
            }
            return false;
        });
    }

    public static boolean isLockArchive(Long modelId, Long sceneId, Long yearId, Long periodId) {
        return (Boolean)GlobalCacheServiceHelper.getOrLoadNode((String)("isLockArchive#" + modelId + sceneId + yearId + periodId), () -> {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
            IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
            if (IDNumberTreeNode.NotFoundTreeNode != sceneNode && IDNumberTreeNode.NotFoundTreeNode != yearNode && IDNumberTreeNode.NotFoundTreeNode != periodNode) {
                return LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber());
            }
            return false;
        });
    }
}

