/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.enumvalue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.enumvalue.EnumItem;
import kd.fi.bcm.business.dimension.enumvalue.Enumvalue;
import kd.fi.bcm.business.dimension.enumvalue.MemberEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class EnumItemServiceHelper {
    public static DynamicObjectCollection queryDimensionEnumItem(long modelId, long dimensionId) {
        QFBuilder filters = new QFBuilder();
        if (modelId != 0L) {
            filters.add("model", "=", (Object)modelId);
        } else {
            filters.add("dimension", "=", (Object)dimensionId);
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,name,datatype,dimension", (QFilter[])filters.toArray());
        return dcs;
    }

    public static DynamicObjectCollection queryEnumValue(Set<Long> ids) {
        QFBuilder filters = new QFBuilder();
        filters.add("enumitemid", "in", ids);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,enumvalue,masterid,enumitemid,name,datatype,dimension", (QFilter[])filters.toArray(), (String)"dseq");
        return dcs;
    }

    public static DynamicObjectCollection queryEnumValueByValueId(Set<Long> ids) {
        QFBuilder filters = new QFBuilder();
        filters.add("id", "in", ids);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,enumvalue,masterid,enumitemid,name,datatype,dimension", (QFilter[])filters.toArray(), (String)"dseq");
        return dcs;
    }

    public static Map<Long, EnumItem> getEnumItemMapVlaues(long modelId) {
        DynamicObjectCollection dcs = EnumItemServiceHelper.queryDimensionEnumItem(modelId, 0L);
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dc : dcs) {
            ids.add(dc.getLong("id"));
        }
        DynamicObjectCollection doc = EnumItemServiceHelper.queryEnumValue(ids);
        HashMap<Long, EnumItem> maps = new HashMap<Long, EnumItem>();
        for (DynamicObject dc : doc) {
            long enumitemid = dc.getLong("enumitemid");
            if (!maps.containsKey(enumitemid)) {
                EnumItem enumItem = new EnumItem(enumitemid, dc.getLong("dimension"), DataTypeEnum.valueOfBy((String)dc.getString("datatype")), dc.getString("name"));
                ArrayList<Enumvalue> enumvalues = new ArrayList<Enumvalue>();
                enumvalues.add(new Enumvalue(dc.getLong("id"), dc.getString("masterid"), dc.getString("enumvalue"), enumitemid));
                enumItem.setEnumvalues(enumvalues);
                maps.put(enumitemid, enumItem);
                continue;
            }
            Enumvalue enumvalue = new Enumvalue(dc.getLong("id"), dc.getString("masterid"), dc.getString("enumvalue"), enumitemid);
            ((EnumItem)maps.get(enumitemid)).getEnumvalues().add(enumvalue);
        }
        return maps;
    }

    public static Map<String, MemberEnum> getAllEnumDimensionMember(long modelId) {
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", (Object)modelId);
        filters.add("enumitem", ">", (Object)0);
        DynamicObjectCollection scenes = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id,number,dimension.id,dimension.number,enumitem", (QFilter[])filters.toArray());
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id,number,dimension.id,dimension.number,enumitem", (QFilter[])filters.toArray());
        DynamicObjectCollection changeTypes = QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"id,number,dimension.id,dimension.number,enumitem", (QFilter[])filters.toArray());
        DynamicObjectCollection definedMems = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"id,number,dimension.id,dimension.number,dimension,enumitem", (QFilter[])filters.toArray());
        Map<Long, EnumItem> item2Values = EnumItemServiceHelper.getEnumItemMapVlaues(modelId);
        HashMap<String, MemberEnum> maps = new HashMap<String, MemberEnum>();
        EnumItemServiceHelper.setMemEnumItem(scenes, item2Values, maps);
        EnumItemServiceHelper.setMemEnumItem(accounts, item2Values, maps);
        EnumItemServiceHelper.setMemEnumItem(changeTypes, item2Values, maps);
        EnumItemServiceHelper.setMemEnumItem(definedMems, item2Values, maps);
        return maps;
    }

    private static void setMemEnumItem(DynamicObjectCollection accounts, Map<Long, EnumItem> item2Values, Map<String, MemberEnum> maps) {
        for (DynamicObject a : accounts) {
            long id = a.getLong("id");
            long dimId = a.getLong("dimension.id");
            EnumItem enumItem = item2Values.get(a.getLong("enumitem"));
            if (enumItem == null) continue;
            DataTypeEnum dataTypeEnum = enumItem.getDataType();
            String dimNum = a.getString("dimension.number");
            String number = a.getString("number");
            MemberEnum memberEnum = new MemberEnum(id, number, dimId, dimNum, dataTypeEnum, enumItem);
            maps.put(dimNum + "|" + number, memberEnum);
        }
    }
}

