/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.cslscheme.CslSchemeTree;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.CslSchemeScopeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CslSchemeServiceHelper {
    private static final String CslSchemePermType_All = "0";
    private static final String CslSchemePermType_PermClass = "2";
    private static final String year = "year";
    private static final String period = "period";
    private static final String model = "model";
    private static final String cslscheme = "cslscheme";
    private static final String scenario = "scenario";

    public static void setDefaultNode(DynamicObject model, ApplicationTypeEnum app) {
        boolean isTrue = true;
        if (app == ApplicationTypeEnum.CM || app == ApplicationTypeEnum.RPT) {
            HashMap<String, Long> map = new HashMap<String, Long>(CslSchemeEnum.values().length);
            Date now = new Date();
            for (CslSchemeEnum schemeEnum : CslSchemeEnum.values()) {
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
                obj.set("number", (Object)schemeEnum.getNumber());
                obj.set("name", (Object)ResManager.getLocaleString((String)schemeEnum.getName(), (String)("CslSchemeEnum_" + schemeEnum.getNumber()), (String)"fi-bcm-business"));
                obj.set(model, model.get("id"));
                obj.set("isleaf", (Object)schemeEnum.isLeaf());
                obj.set("isenable", (Object)schemeEnum.isIsenable());
                obj.set("nodetype", (Object)schemeEnum.getNodetype());
                obj.set("level", (Object)schemeEnum.getLevel());
                obj.set("longnumber", (Object)schemeEnum.getLongnumber());
                RequestContext tx = RequestContext.get();
                obj.set("creater", (Object)tx.getUserId());
                obj.set("modifier", (Object)tx.getUserId());
                obj.set("createdate", (Object)now);
                obj.set("modifytime", (Object)now);
                obj.set("islegalorgview", (Object)isTrue);
                if (schemeEnum.getParent() != null) {
                    obj.set("parent", map.get(schemeEnum.getParent()));
                    obj.set("scope", (Object)CslSchemePermType_PermClass);
                } else {
                    obj.set("parent", (Object)0);
                    obj.set("scope", (Object)CslSchemePermType_All);
                }
                DynamicObject[] parent = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                map.put(schemeEnum.getNumber(), parent[0].getLong("id"));
            }
        }
    }

    public static Collection<Long> getEffectiveCslSchemeIds(String yearNum, String periodId, Set<String> schemeNum, Long modelId) {
        CslSchemeServiceHelper.checkArgsNotNull(modelId);
        Pair dateMilliScope = null;
        if (yearNum != null && CslSchemeServiceHelper.isValidePeriodAndYear(yearNum, periodId)) {
            yearNum = yearNum.substring(2);
            dateMilliScope = PeriodUtils.getDateMilliScope((String)yearNum, (long)Long.parseLong(periodId));
        }
        DynamicObjectCollection allSchemeDynCollection = CslSchemeServiceHelper.queryAllSchemes(schemeNum, modelId);
        Map<String, Long> id2NumberMapping = CslSchemeServiceHelper.selectVaildeSchemes(dateMilliScope, allSchemeDynCollection);
        return id2NumberMapping.values();
    }

    private static boolean isValidePeriodAndYear(String yearNum, String periodId) {
        return StringUtils.isNotEmpty((CharSequence)yearNum) && StringUtils.isNotEmpty((CharSequence)periodId);
    }

    public static DynamicObjectCollection queryAllSchemes(Set<String> schemeNum, Long modelId) {
        boolean isTrue = true;
        QFilter filter = QFilter.of((String)"model = ? and isenable = ?", (Object[])new Object[]{modelId, isTrue});
        if (schemeNum != null) {
            filter.and(new QFilter("number", "in", schemeNum));
        }
        DynamicObjectCollection allScheme = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, version, effectivedate, expirationdate", (QFilter[])filter.toArray(), (String)"version", (int)-1);
        return allScheme;
    }

    private static Map<String, Long> selectVaildeSchemes(Pair<Long, Long> dateMilliScope, DynamicObjectCollection allSchemeDynCollection) {
        HashMap id2NumberMapping = Maps.newHashMap();
        for (DynamicObject schemeDyn : allSchemeDynCollection) {
            String number = schemeDyn.getString("number");
            if (id2NumberMapping.containsKey(number)) continue;
            Date effectiveDate = schemeDyn.getDate("effectivedate");
            Date expirationDate = schemeDyn.getDate("expirationdate");
            Long startMilliSeconds = effectiveDate == null ? Long.MIN_VALUE : effectiveDate.getTime();
            Long endMilliSeconds = expirationDate == null ? Long.MAX_VALUE : expirationDate.getTime();
            if (dateMilliScope != null && !CslSchemeServiceHelper.isDateInScope(startMilliSeconds, endMilliSeconds, dateMilliScope)) continue;
            id2NumberMapping.put(number, schemeDyn.getLong("id"));
        }
        return id2NumberMapping;
    }

    private static boolean isDateInScope(Long startMilliSeconds, Long endMilliSeconds, Pair<Long, Long> dateMilliScope) {
        Long legalStartMilliSeconds = (Long)dateMilliScope.getLeft();
        Long legalEndMilliSeconds = (Long)dateMilliScope.getRight();
        return startMilliSeconds <= legalEndMilliSeconds && endMilliSeconds >= legalStartMilliSeconds;
    }

    private static void checkArgsNotNull(Object ... args) {
        if (args.length <= 0) {
            return;
        }
        for (Object arg : args) {
            if (!Objects.isNull(arg)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CslSchemeServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static Collection<Long> getAllEffectiveCslSchemeIds(String yearNum, String periodId, Long modelId) {
        return CslSchemeServiceHelper.getEffectiveCslSchemeIds(yearNum, periodId, null, modelId);
    }

    public static Collection<Long> getAllEffectiveCslSchemeIds(Long modelId) {
        return CslSchemeServiceHelper.getEffectiveCslSchemeIds(null, null, null, modelId);
    }

    public static QFilter genQueryFilter(QueryOrgParam param) {
        return param.genQueryFilter();
    }

    public static DynamicObjectCollection getOrgDynamicObjectCollection(QueryOrgParam param) {
        return param.getOrgDynamicObjectCollection();
    }

    public static DynamicObjectCollection getOrgCollection(QFilter[] filters, String selectFields, String orderBys) {
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])filters, (String)orderBys).values();
        DynamicObject first = values.isEmpty() ? null : (DynamicObject)values.stream().findFirst().get();
        DynamicObjectCollection colls = null;
        colls = first == null ? new DynamicObjectCollection() : new DynamicObjectCollection(first.getDynamicObjectType(), (Object)first);
        colls.addAll(values);
        return colls;
    }

    public static Long getRptDefaultSchemeId(long modelId) {
        QFilter filter = new QFilter(model, "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)CslSchemeEnum.Default.getNumber()));
        return (Long)GlobalCacheServiceHelper.getOrLoadNode((String)("DefaultSchemeId-" + modelId), () -> {
            DynamicObject defaultScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])filter.toArray());
            if (defaultScheme != null) {
                return defaultScheme.getLong("id");
            }
            return 0L;
        });
    }

    public static DynamicObjectCollection getTreeAllEntityContainShare(Collection<Long> selectedOrgIds) {
        DynamicObjectCollection belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"longnumber,model", (QFilter[])new QFilter("id", "in", selectedOrgIds).toArray());
        Set longnumbers = belongorgs.stream().map(v -> v.getString("longnumber")).collect(Collectors.toSet());
        long modelId = 0L;
        if (belongorgs != null && !belongorgs.isEmpty()) {
            modelId = ((DynamicObject)belongorgs.get(0)).getLong(model);
        }
        QFBuilder qfBuilder = new QFBuilder(model, "=", (Object)modelId);
        QFBuilder qFilter = new QFBuilder();
        for (String longnumber : longnumbers) {
            qFilter.or("longnumber", "=", (Object)longnumber);
            qFilter.or("longnumber", "like", (Object)(longnumber + '!' + "%"));
        }
        qfBuilder.and(qFilter);
        belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, name, isleaf, cslscheme, member, model, longnumber", (QFilter[])qfBuilder.toArray());
        return belongorgs;
    }

    public static DynamicObjectCollection filterOrgSetting(Object modelId, Object scenarioId, Object yearId, Object periodId, DynamicObjectCollection adShareGlobalSettings) {
        DynamicObjectCollection toDeleteDoc = new DynamicObjectCollection();
        block0: for (DynamicObject setting : adShareGlobalSettings) {
            HashMap<MembItem, Set<Long>> rItem2MembIds = new HashMap<MembItem, Set<Long>>(16);
            JSONArray scenes = JSON.parseArray((String)setting.getString(scenario).split("#")[1]);
            JSONArray years = JSON.parseArray((String)setting.getString(year).split("#")[1]);
            JSONArray periods = JSON.parseArray((String)setting.getString(period).split("#")[1]);
            CslSchemeServiceHelper.getMembRangeLongs(scenes, String.valueOf(modelId), rItem2MembIds);
            CslSchemeServiceHelper.getMembRangeLongs(years, String.valueOf(modelId), rItem2MembIds);
            CslSchemeServiceHelper.getMembRangeLongs(periods, String.valueOf(modelId), rItem2MembIds);
            for (Map.Entry membItemEntry : rItem2MembIds.entrySet()) {
                if ("bcm_scenemembertree".equals(((MembItem)membItemEntry.getKey()).entity) && !((Set)membItemEntry.getValue()).contains(scenarioId)) {
                    toDeleteDoc.add((Object)setting);
                    continue block0;
                }
                if ("bcm_fymembertree".equals(((MembItem)membItemEntry.getKey()).entity) && !((Set)membItemEntry.getValue()).contains(yearId)) {
                    toDeleteDoc.add((Object)setting);
                    continue block0;
                }
                if (!"bcm_periodmembertree".equals(((MembItem)membItemEntry.getKey()).entity) || ((Set)membItemEntry.getValue()).contains(periodId)) continue;
                toDeleteDoc.add((Object)setting);
                continue block0;
            }
        }
        return toDeleteDoc;
    }

    public static void getMembRangeLongs(JSONArray array, String modelId, Map<MembItem, Set<Long>> rItem2MembIds) {
        HashSet<Long> allMembIds = new HashSet<Long>(16);
        for (Object obj : array) {
            JSONObject membObj = (JSONObject)obj;
            long memberid = membObj.getLong("memberid");
            int scope = membObj.getInteger("scope");
            String entity = membObj.getString("entity");
            Set<Long> membIds = QueryMemberDetailsHelper.queryMemberIdsByRange(entity, memberid, scope, modelId, DetailTypeEnum.OTHERS);
            allMembIds.addAll(membIds);
            rItem2MembIds.put(new MembItem(entity, memberid, scope), allMembIds);
        }
    }

    public static Map<Long, IDNumberTreeNode> getOrgNodesFromCache(QueryOrgParam queryOrgParam) {
        return queryOrgParam.getOrgNodesFromCache();
    }

    public static void filterByPerm(DynamicObjectCollection queryNodes, Long modelId) {
        if (MemberPermHelper.isModelAdmin(modelId)) {
            return;
        }
        Set<Long> filterSet = CslSchemeServiceHelper.getNoPermCslSchemeIds(modelId);
        Iterator it = queryNodes.iterator();
        while (it.hasNext()) {
            DynamicObject next = (DynamicObject)it.next();
            long id = next.getLong("id");
            if (!filterSet.contains(id)) continue;
            it.remove();
        }
    }

    private static DynamicObjectCollection getCslScheme(Long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add(model, "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, name, parent, scope, creater", (QFilter[])qf.toArray(), (String)"level asc");
    }

    public static Set<Long> getCurrUserHavePermCslSchemeIdNotRateScheme(String modelId, boolean isIncludeRateScheme) {
        QFilter qFilter = new QFilter(model, "=", (Object)LongUtil.toLong((Object)modelId));
        if (!isIncludeRateScheme) {
            qFilter.and("number", "!=", (Object)"DefaultRateScheme");
        }
        qFilter.and(QFilter.of((String)"isenable = ? and nodetype = ?", (Object[])new Object[]{true, "1"}));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])qFilter.toArray());
        boolean isModelPerm = MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), modelId);
        if (!isModelPerm) {
            CslSchemeServiceHelper.filterByPerm(doc, LongUtil.toLong((Object)modelId));
        }
        HashSet<Long> cslSchemeIdSet = new HashSet<Long>(16);
        cslSchemeIdSet.add(0L);
        QFilter rootSchemeFilter = new QFilter(model, "=", (Object)LongUtil.toLong((Object)modelId));
        rootSchemeFilter.and("longnumber", "=", (Object)"root");
        DynamicObject rootScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])rootSchemeFilter.toArray());
        if (rootScheme != null) {
            cslSchemeIdSet.add(rootScheme.getLong("id"));
        }
        cslSchemeIdSet.addAll(doc.stream().map(r -> r.getLong("id")).collect(Collectors.toSet()));
        return cslSchemeIdSet;
    }

    public static Set<Long> getCurrUserHavePermCslSchemeIdWithScene(Long modelId, Long sceneId, boolean isIncludeRateScheme) {
        if (sceneId == 0L) {
            return CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme(String.valueOf(modelId), true);
        }
        HashSet<Long> cslSchemeIdSet = new HashSet<Long>(16);
        List<Long> havePermIds = DimensionServiceHelper.buildCslschemeFilter(modelId, sceneId);
        cslSchemeIdSet.addAll(havePermIds);
        if (isIncludeRateScheme) {
            QFilter qFilter = new QFilter(model, "=", (Object)modelId);
            qFilter.and("number", "=", (Object)"DefaultRateScheme");
            DynamicObject rateOrgScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])qFilter.toArray());
            if (null != rateOrgScheme) {
                cslSchemeIdSet.add(rateOrgScheme.getLong("id"));
            }
        }
        cslSchemeIdSet.add(0L);
        QFilter rootSchemeFilter = new QFilter(model, "=", (Object)LongUtil.toLong((Object)modelId));
        rootSchemeFilter.and("longnumber", "=", (Object)"root");
        DynamicObject rootScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])rootSchemeFilter.toArray());
        if (rootScheme != null) {
            cslSchemeIdSet.add(rootScheme.getLong("id"));
        }
        return cslSchemeIdSet;
    }

    public static Set<Long> getNoPermCslSchemeIds(Long modelId) {
        DynamicObjectCollection queryNodes = CslSchemeServiceHelper.getCslScheme(modelId);
        Map<Long, Integer> permMap = MemberPermHelper.getCslSchemePermission("bcm_cslscheme", modelId, queryNodes);
        HashSet<Long> filterSet = new HashSet<Long>();
        HashMap<Long, List> parentChildIds = new HashMap<Long, List>(16);
        for (DynamicObject node : queryNodes) {
            long parent = node.getLong("parent");
            if (parent != 0L) {
                List child = parentChildIds.computeIfAbsent(parent, x -> new ArrayList());
                child.add(node.getLong("id"));
            }
            Long useId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Integer perm = permMap.get(node.getLong("id"));
            if ((!CslSchemeScopeEnum.isOneSelfScope((String)node.getString("scope")) || useId.compareTo(node.getLong("creater")) == 0) && (perm == null || perm.compareTo(3) != 0)) continue;
            filterSet.add(node.getLong("id"));
        }
        queryNodes.forEach(next -> {
            long id = next.getLong("id");
            long parent = next.getLong("parent");
            if ((filterSet.contains(id) || filterSet.contains(parent)) && parentChildIds.get(id) != null) {
                filterSet.addAll((Collection)parentChildIds.get(id));
            }
        });
        return filterSet;
    }

    public static CslSchemeTree getCslSchemeTree(Long modelId, boolean isScheme, boolean noRate) {
        return CslSchemeServiceHelper.getCslSchemeTree(modelId, isScheme, 0L, noRate);
    }

    public static CslSchemeTree getCslSchemeTree(Long modelId, boolean isScheme, Long parentId, boolean noRateScheme) {
        DynamicObject parentNode;
        QFilter filters = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId});
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])filters.toArray())) {
            DynamicObject[] orgs = UpgradeServiceHelper.getOrgLevel2List(modelId);
            if (orgs.length == 0) {
                parentId = UpgradeServiceHelper.createRoot(modelId);
                Long id = DBServiceHelper.genGlobalLongId();
                DynamicObject temp = UpgradeServiceHelper.buildSingleScheme(modelId, parentId, id, "DefaultScheme");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u3010\u5e94\u7528\u4f53\u7cfb\u5217\u8868\u3011\u5347\u7ea7\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CslSchemeServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        if (!isScheme) {
            filters.and(QFilter.of((String)"nodetype = ?", (Object[])new Object[]{CslSchemePermType_All}));
        }
        if (parentId != null && parentId != 0L && (parentNode = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id, number, longnumber", (QFilter[])filters.toArray())) != null) {
            filters.and(new QFilter("longnumber", "like", (Object)(parentNode.getString("longnumber") + ".%")));
        }
        filters.and(QFilter.of((String)"isenable = ?", (Object[])new Object[]{true}));
        if (noRateScheme) {
            filters.and("number", "!=", (Object)"DefaultRateScheme");
        }
        DynamicObjectCollection queryNodes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, name, parent", (QFilter[])filters.toArray(), (String)"level, id");
        CslSchemeServiceHelper.reOrderScheme(queryNodes);
        CslSchemeServiceHelper.filterByPerm(queryNodes, modelId);
        if (queryNodes.size() <= 0) {
            return new CslSchemeTree(CslSchemePermType_All, ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"CslSchemeServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject rootNode = (DynamicObject)queryNodes.get(0);
        HashBasedTable nodes = HashBasedTable.create();
        HashMap id2TreeMapping = Maps.newHashMap();
        CslSchemeTree root = new CslSchemeTree(rootNode.getString("id"), rootNode.getString("name"));
        queryNodes.forEach(arg_0 -> CslSchemeServiceHelper.lambda$getCslSchemeTree$5((Table)nodes, id2TreeMapping, rootNode, root, arg_0));
        nodes.rowMap().forEach((k, v) -> {
            CslSchemeTree parentNode = (CslSchemeTree)id2TreeMapping.get(k);
            if (parentNode != null) {
                v.values().forEach(vl -> parentNode.addChild(vl));
            }
        });
        return root;
    }

    private static void reOrderScheme(DynamicObjectCollection queryNodes) {
        for (int i = 0; i < queryNodes.size(); ++i) {
            if (!"DefaultRateScheme".equalsIgnoreCase(((DynamicObject)queryNodes.get(i)).getString("number"))) continue;
            DynamicObject rateScheme = (DynamicObject)queryNodes.get(i);
            queryNodes.remove((Object)rateScheme);
            queryNodes.add((Object)rateScheme);
            break;
        }
    }

    public static boolean existScheme(Long schemeCatalogId) {
        DynamicObject schemeCatalog = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id, longnumber, model", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{schemeCatalogId}).toArray());
        if (schemeCatalog != null) {
            String number = schemeCatalog.getString("longnumber");
            Long modelId = schemeCatalog.getLong(model);
            return QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])QFilter.of((String)"model = ? and nodetype = ?", (Object[])new Object[]{modelId, "1"}).and(new QFilter("longnumber", "like", (Object)(number + ".%"))).toArray());
        }
        return false;
    }

    public static TreeNode addTreeNode2TreeView(long modelId, boolean hasScheme, TreeView treeView) {
        if (treeView == null) {
            return null;
        }
        treeView.deleteAllNodes();
        CslSchemeTree cslSchemeTree = CslSchemeServiceHelper.getCslSchemeTree(modelId, hasScheme, false);
        TreeNode root = cslSchemeTree.trans2TreeNode();
        root.iterate(1, node -> {
            node.setIsOpened(true);
            node.setExpend(true);
        });
        treeView.addNode(root);
        return root;
    }

    public static TreeNode addTreeNode(long modelId, boolean hasScheme, TreeView treeView, boolean noRate) {
        if (treeView == null) {
            return null;
        }
        treeView.deleteAllNodes();
        CslSchemeTree cslSchemeTree = CslSchemeServiceHelper.getCslSchemeTree(modelId, hasScheme, noRate);
        TreeNode root = cslSchemeTree.trans2TreeNode();
        root.iterate(1, node -> {
            node.setIsOpened(true);
            node.setExpend(true);
        });
        treeView.addNode(root);
        return root;
    }

    public static TreeNode addTreeNode2TreeView(long modelId, boolean hasScheme, TreeView treeView, boolean flag) {
        if (flag) {
            if (treeView == null) {
                return null;
            }
            treeView.deleteAllNodes();
            CslSchemeTree cslSchemeTree = CslSchemeServiceHelper.getCslSchemeTree(modelId, hasScheme, true);
            TreeNode root = cslSchemeTree.trans2TreeNode();
            root.iterate(1, node -> {
                node.setIsOpened(true);
                node.setExpend(true);
            });
            treeView.addNode(root);
            return root;
        }
        return CslSchemeServiceHelper.addTreeNode2TreeView(modelId, hasScheme, treeView);
    }

    public static void forceDeleteScheme(List<Long> cslIds) {
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, model.number, model.id", (QFilter[])new QFilter("id", "in", cslIds).toArray());
        ArrayListMultimap multimap = ArrayListMultimap.create();
        List<String> allEntityMembers = CslSchemeServiceHelper.getAllEntityMembers(cslIds, (Multimap<String, kd.fi.bcm.common.Pair<String, Integer>>)multimap);
        List entityWithOutMergeNode = allEntityMembers.stream().filter(v -> !v.contains("_")).collect(Collectors.toList());
        long modelId = ((DynamicObject)schemes.get(0)).getLong("model.id");
        boolean existsMyCompany = DimensionServiceHelper.existsMyCompanyDim(modelId);
        String modelNumber = ((DynamicObject)schemes.get(0)).getString("model.number");
        LinkedHashSet memberIds = Sets.newLinkedHashSet();
        CslSchemeServiceHelper.getAllShareId(cslIds, memberIds);
        PlatUtil.executeWithTXNew(arg_0 -> CslSchemeServiceHelper.lambda$forceDeleteScheme$18(cslIds, memberIds, modelId, entityWithOutMergeNode, existsMyCompany, allEntityMembers, modelNumber, (Multimap)multimap, arg_0));
    }

    private static void deleteSceneCsls(long modelId, List<Long> cslIds) {
        DynamicObject[] sceneDys;
        QFilter qf = new QFilter(model, "=", (Object)modelId);
        qf.and("level", "=", (Object)2);
        for (DynamicObject sceneDy : sceneDys = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"scenecslscheme", (QFilter[])qf.toArray())) {
            DynamicObjectCollection scClsDys = sceneDy.getDynamicObjectCollection("scenecslscheme");
            if (CollectionUtils.isEmpty((Collection)scClsDys)) continue;
            List newScCslDys = scClsDys.stream().filter(x -> !cslIds.contains(x.getLong("fbasedataid_id"))).collect(Collectors.toList());
            scClsDys.clear();
            scClsDys.addAll(newScCslDys);
        }
        SaveServiceHelper.save((DynamicObject[])sceneDys);
    }

    public static Set<Long> getAllShareId(List<Long> schemeIds, Set<Long> memberIds) {
        DynamicObjectCollection entityScheme = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreefrom(), (String)"id, number, member, parent.number, isleaf", (QFilter[])new QFilter("cslscheme_id", "in", schemeIds).and(QFilter.of((String)"storagetype = ?", (Object[])new Object[]{CslSchemePermType_PermClass})).toArray());
        entityScheme.forEach(en -> memberIds.add(en.getLong("member")));
        DynamicObjectCollection result = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreefrom(), (String)"id, number, parent.number, status", (QFilter[])QFilter.of((String)"storagetype = ?", (Object[])new Object[]{"3"}).and(new QFilter("member", "in", memberIds)).toArray());
        memberIds.clear();
        result.forEach(r -> memberIds.add(r.getLong("id")));
        return memberIds;
    }

    public static boolean checkExistMDData(List<Long> schemeIds) {
        DynamicObjectCollection schemeDyns = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, model.id, model.number", (QFilter[])new QFilter("id", "in", schemeIds).toArray());
        List<String> members = CslSchemeServiceHelper.getAllEntityMembers(schemeIds, null);
        if (members.size() <= 0) {
            return false;
        }
        SQLBuilder sqlBuilder = new SQLBuilder(((DynamicObject)schemeDyns.get(0)).getString("model.number"));
        String dimensionNum = DimEntityNumEnum.ENTITY.getNumber();
        sqlBuilder.addFilter(dimensionNum, members.toArray(new String[0]));
        sqlBuilder.addSelectField(dimensionNum);
        sqlBuilder.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sqlBuilder.setTop(2);
        sqlBuilder.setIncludeNull(false);
        MDResultSet queryData = OlapServiceHelper.queryData(sqlBuilder);
        return queryData.next();
    }

    private static List<String> getAllEntityMembers(List<Long> schemeIds, Multimap<String, kd.fi.bcm.common.Pair<String, Integer>> multimap) {
        DynamicObjectCollection entityScheme = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreefrom(), (String)"id, number, model, member, parent.number,parent.storagetype, isleaf, storagetype, aggoprt", (QFilter[])new QFilter(cslscheme, "in", schemeIds).and(new QFilter("status", "not in", (Object)new String[]{OrgStoreStatusEnum.REMOVE.getValue(), OrgStoreStatusEnum.DISABLE.getValue(), OrgStoreStatusEnum.TEMPSAVE.getValue()})).toArray());
        LinkedList allEntities = Lists.newLinkedList();
        entityScheme.forEach(en -> {
            String storageType;
            String number = en.getString("number");
            if (StorageTypeEnum.STORAGE.index.equals(en.getString("storagetype"))) {
                if (multimap != null) {
                    multimap.put((Object)en.getString("parent.number"), (Object)kd.fi.bcm.common.Pair.onePair((Object)number, (Object)en.getInt("aggoprt")));
                }
                allEntities.add(number);
            }
            if ((storageType = en.getString("parent.storagetype")) != null && !StorageTypeEnum.SHARE.index.equals(storageType)) {
                allEntities.add(en.getString("parent.number") + "_" + number);
            }
        });
        return allEntities;
    }

    public static DynamicObject getEntityOrgId(long modelId) {
        QFBuilder qf = new QFBuilder(model, "=", (Object)modelId);
        qf.add("number", "=", (Object)"Entity");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])qf.toArray());
    }

    public static boolean checkOrgIsRateOrgById(long modelId, long orgId) {
        QFBuilder qf = new QFBuilder(model, "=", (Object)modelId);
        qf.add("id", "=", (Object)orgId);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,cslscheme.number", (QFilter[])qf.toArray());
        if (null != org) {
            return "DefaultRateScheme".equals(org.getString("cslscheme.number"));
        }
        return false;
    }

    public static boolean existsScheme(Long modelId, Long schemeId) {
        return QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])QFilter.of((String)"id = ? and model = ?", (Object[])new Object[]{schemeId, modelId}).toArray());
    }

    public static DynamicObject getRateCslScheme(Long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add(model, "=", (Object)modelId);
        qf.and("number", "=", (Object)"DefaultRateScheme");
        return QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id, number, name, parent, scope, creater", (QFilter[])qf.toArray());
    }

    private static /* synthetic */ void lambda$forceDeleteScheme$18(List cslIds, Set memberIds, long modelId, List entityWithOutMergeNode, boolean existsMyCompany, List allEntityMembers, String modelNumber, Multimap multimap, TXHandle txHandle) {
        DynamicObjectCollection query;
        DeleteServiceHelper.delete((String)SysDimensionEnum.Entity.getMemberTreefrom(), (QFilter[])new QFilter(cslscheme, "in", (Object)cslIds).toArray());
        if (memberIds.size() > 0) {
            DeleteServiceHelper.delete((String)SysDimensionEnum.Entity.getMemberMemberModel(), (QFilter[])new QFilter("id", "in", (Object)memberIds).toArray());
        }
        QFilter[] deleteFilters = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}).and(new QFilter("number", "in", (Object)entityWithOutMergeNode)).toArray();
        Set<String> deleteMCNumbers = null;
        ArrayListMultimap multimapMC = ArrayListMultimap.create();
        if (existsMyCompany) {
            query = QueryServiceHelper.query((String)SysDimensionEnum.MyCompany.getMemberTreefrom(), (String)"member, number, parent.number, aggoprt", (QFilter[])deleteFilters);
            deleteMCNumbers = query.stream().map(v -> v.getString("number")).collect(Collectors.toSet());
            query.forEach(arg_0 -> CslSchemeServiceHelper.lambda$null$13((Multimap)multimapMC, arg_0));
            DeleteServiceHelper.delete((String)SysDimensionEnum.MyCompany.getMemberTreefrom(), (QFilter[])deleteFilters);
            DeleteServiceHelper.delete((String)SysDimensionEnum.MyCompany.getMemberMemberModel(), (QFilter[])new QFilter("id", "in", query.stream().map(v -> v.getLong("member")).collect(Collectors.toSet())).toArray());
        }
        query = QueryServiceHelper.query((String)SysDimensionEnum.InternalCompany.getMemberTreefrom(), (String)"member, number, parent.number, aggoprt", (QFilter[])deleteFilters);
        ArrayListMultimap multimapIC = ArrayListMultimap.create();
        Set<String> deleteICNumbers = query.stream().map(v -> v.getString("number")).collect(Collectors.toSet());
        query.forEach(arg_0 -> CslSchemeServiceHelper.lambda$null$16((Multimap)multimapIC, arg_0));
        DeleteServiceHelper.delete((String)SysDimensionEnum.InternalCompany.getMemberTreefrom(), (QFilter[])deleteFilters);
        DeleteServiceHelper.delete((String)SysDimensionEnum.InternalCompany.getMemberMemberModel(), (QFilter[])new QFilter("id", "in", query.stream().map(v -> v.getLong("member")).collect(Collectors.toSet())).toArray());
        DeleteServiceHelper.delete((String)"bcm_cslscheme", (QFilter[])new QFilter("id", "in", (Object)cslIds).toArray());
        CslSchemeServiceHelper.deleteSceneCsls(modelId, cslIds);
        if (allEntityMembers.size() > 0) {
            OlapServiceHelper.batchDropAggFactor(modelNumber, DimEntityNumEnum.ENTITY.getNumber(), (Multimap<String, kd.fi.bcm.common.Pair<String, Integer>>)multimap);
            OlapServiceHelper.batchDropDimensionMembersForce(modelNumber, DimEntityNumEnum.ENTITY.getNumber(), allEntityMembers);
        }
        if (deleteMCNumbers != null && deleteMCNumbers.size() > 0) {
            OlapServiceHelper.batchDropAggFactor(modelNumber, DimEntityNumEnum.MYCOMPANY.getNumber(), (Multimap<String, kd.fi.bcm.common.Pair<String, Integer>>)multimapMC);
            OlapServiceHelper.batchDropDimensionMembersForce(modelNumber, DimEntityNumEnum.MYCOMPANY.getNumber(), deleteMCNumbers);
        }
        if (deleteICNumbers != null && deleteICNumbers.size() > 0) {
            OlapServiceHelper.batchDropAggFactor(modelNumber, DimEntityNumEnum.INTERCOMPANY.getNumber(), (Multimap<String, kd.fi.bcm.common.Pair<String, Integer>>)multimapIC);
            OlapServiceHelper.batchDropDimensionMembersForce(modelNumber, DimEntityNumEnum.INTERCOMPANY.getNumber(), deleteICNumbers);
        }
    }

    private static /* synthetic */ void lambda$null$16(Multimap multimapIC, DynamicObject e) {
        multimapIC.put((Object)e.getString("parent.number"), (Object)kd.fi.bcm.common.Pair.onePair((Object)e.getString("number"), (Object)e.getInt("aggoprt")));
    }

    private static /* synthetic */ void lambda$null$13(Multimap multimapMC, DynamicObject e) {
        multimapMC.put((Object)e.getString("parent.number"), (Object)kd.fi.bcm.common.Pair.onePair((Object)e.getString("number"), (Object)e.getInt("aggoprt")));
    }

    private static /* synthetic */ void lambda$getCslSchemeTree$5(Table nodes, Map id2TreeMapping, DynamicObject rootNode, CslSchemeTree root, DynamicObject v) {
        CslSchemeTree node = new CslSchemeTree(v.getString("id"), v.getString("name"));
        nodes.put((Object)v.getLong("parent"), (Object)v.getLong("id"), (Object)node);
        id2TreeMapping.put(v.getLong("id"), node);
        if (v.getLong("parent") == rootNode.getLong("id")) {
            root.addChild(node);
        }
    }

    public static class MembItem {
        private String entity;
        private long memberId;
        private int scope;

        public String getEntity() {
            return this.entity;
        }

        public void setEntity(String entity) {
            this.entity = entity;
        }

        public long getMemberId() {
            return this.memberId;
        }

        public void setMemberId(long memberId) {
            this.memberId = memberId;
        }

        public int getScope() {
            return this.scope;
        }

        public void setScope(int scope) {
            this.scope = scope;
        }

        public MembItem(String entity, long memberId, int scope) {
            this.entity = entity;
            this.memberId = memberId;
            this.scope = scope;
        }
    }

    public static class QueryOrgParam {
        private String yearNum = "";
        private String periodId = "";
        private String sceneId = "";
        private String modelId = "";
        private Pair<Long, String> cslScheme;
        private Set<Long> cslSchemeSet;
        private Map<String, Object> params = new HashMap<String, Object>(16);
        private QFBuilder builder;
        private Predicate<IDNumberTreeNode> filterCondition = node -> true;
        private boolean needSchemeFilter = true;
        private boolean needSchemeModelFilter = true;
        private boolean isShowExchangeRate = false;
        private boolean includeExchangeRateMembers = false;
        private String selectFields = "id,name,number,parent,isleaf,storagetype,orgcode,currency,model,longnumber,copyfrom.id";

        private QueryOrgParam() {
        }

        public void setCslSchemeSet(Set<Long> cslSchemeSet) {
            this.cslSchemeSet = cslSchemeSet;
        }

        public Set<Long> getCslSchemeSet() {
            return this.cslSchemeSet;
        }

        public String getYearNum() {
            return this.yearNum;
        }

        public String getPeriodId() {
            return this.periodId;
        }

        public String getModelId() {
            return this.modelId;
        }

        public String getSceneId() {
            return this.sceneId;
        }

        public void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        public void set(String key, Object value) {
            this.params.put(key, value);
            switch (key) {
                case "cslscheme": {
                    this.cslScheme = (Pair)value;
                    break;
                }
                case "model": {
                    this.modelId = value == null ? null : String.valueOf(value);
                    break;
                }
                case "year": {
                    this.yearNum = value == null ? null : String.valueOf(value);
                    break;
                }
                case "period": {
                    this.periodId = value == null ? null : String.valueOf(value);
                    break;
                }
                case "scenario": {
                    this.sceneId = value == null ? null : String.valueOf(value);
                    break;
                }
            }
        }

        public QFilter[] getBuilder() {
            if (this.builder != null) {
                return this.builder.toArray();
            }
            return QFilter.of((String)"1 = 1", (Object[])new Object[0]).toArray();
        }

        public void setBuilder(QFBuilder builder) {
            this.builder = builder;
        }

        public static QueryOrgParam of(String key, Object value) {
            QueryOrgParam param = new QueryOrgParam();
            param.set(key, value);
            return param;
        }

        public boolean isNeedSchemeFilter() {
            return this.needSchemeFilter;
        }

        public void setNeedSchemeFilter(boolean needSchemeFilter) {
            this.needSchemeFilter = needSchemeFilter;
        }

        public boolean isNeedSchemeModelFilter() {
            return this.needSchemeModelFilter;
        }

        public void setNeedSchemeModelFilter(boolean needSchemeModelFilter) {
            this.needSchemeModelFilter = needSchemeModelFilter;
        }

        public boolean isShowExchangeRate() {
            return this.isShowExchangeRate;
        }

        public void setShowExchangeRate(boolean showExchangeRate) {
            this.isShowExchangeRate = showExchangeRate;
        }

        public String getSelectFields() {
            return this.selectFields;
        }

        public void setSelectFields(String selectFields) {
            CslSchemeServiceHelper.checkArgsNotNull(new Object[]{selectFields});
            this.selectFields = selectFields;
        }

        public void setYearNum(String yearNum) {
            this.yearNum = yearNum;
        }

        public void setPeriodId(String periodId) {
            this.periodId = periodId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public Pair<Long, String> getCslScheme() {
            return this.cslScheme;
        }

        public void setCslScheme(Pair<Long, String> cslScheme) {
            this.cslScheme = cslScheme;
        }

        public Predicate<IDNumberTreeNode> getFilterCondition() {
            return this.filterCondition;
        }

        public void setFilterCondition(Predicate<IDNumberTreeNode> filterCondition) {
            this.filterCondition = filterCondition;
        }

        public boolean isIncludeExchangeRateMembers() {
            return this.includeExchangeRateMembers;
        }

        public void setIncludeExchangeRateMembers(boolean includeExchangeRateMembers) {
            this.includeExchangeRateMembers = includeExchangeRateMembers;
        }

        public QFilter genQueryFilter() {
            if (StringUtils.isEmpty((CharSequence)this.modelId)) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            long realTypeModelId = -1L;
            realTypeModelId = Long.parseLong(this.modelId);
            QFilter filterModel = new QFilter(CslSchemeServiceHelper.model, "=", (Object)realTypeModelId);
            if (!this.needSchemeFilter) {
                return filterModel;
            }
            Collection<Object> effectiveCslSchemeIds = this.cslScheme != null ? Sets.newHashSet((Object[])new Long[]{(Long)this.cslScheme.getLeft()}) : (CollectionUtils.isNotEmpty(this.cslSchemeSet) ? this.cslSchemeSet : CslSchemeServiceHelper.getAllEffectiveCslSchemeIds(this.yearNum, this.periodId, realTypeModelId));
            if (!this.needSchemeModelFilter) {
                effectiveCslSchemeIds = Sets.newHashSet((Object[])new Long[]{0L});
            }
            if (this.isShowExchangeRate) {
                if (effectiveCslSchemeIds.size() == 0) {
                    return filterModel;
                }
                filterModel = filterModel.and(new QFilter(CslSchemeServiceHelper.cslscheme, "in", effectiveCslSchemeIds).or(QFilter.of((String)"number = ?", (Object[])new Object[]{"Entity"}).or("isexchangerate", "=", (Object)"1")));
            } else {
                filterModel = filterModel.and(new QFilter(CslSchemeServiceHelper.cslscheme, "in", effectiveCslSchemeIds).or(QFilter.of((String)"number = ?", (Object[])new Object[]{"Entity"})));
            }
            return filterModel;
        }

        private Map<Long, IDNumberTreeNode> getOrgNodesFromCache() {
            if (StringUtils.isEmpty((CharSequence)this.modelId)) {
                return new HashMap<Long, IDNumberTreeNode>();
            }
            long realTypeModelId = Long.parseLong(this.modelId);
            Map allOrgNodes = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (Object)realTypeModelId);
            if (!this.needSchemeFilter) {
                return new HashMap<Long, IDNumberTreeNode>(allOrgNodes);
            }
            Collection<Object> effectiveCslSchemeIds = !this.needSchemeModelFilter ? Sets.newHashSet((Object[])new Long[]{0L}) : (this.cslScheme != null ? Sets.newHashSet((Object[])new Long[]{(Long)this.cslScheme.getLeft()}) : (CollectionUtils.isNotEmpty(this.cslSchemeSet) ? this.cslSchemeSet : CslSchemeServiceHelper.getAllEffectiveCslSchemeIds(this.yearNum, this.periodId, realTypeModelId)));
            HashMap<Long, IDNumberTreeNode> filterOrgNodes = new HashMap<Long, IDNumberTreeNode>();
            if (this.isShowExchangeRate && effectiveCslSchemeIds.size() == 0) {
                allOrgNodes.forEach((id, node) -> {
                    if (this.filterCondition.test((IDNumberTreeNode)node) && this.dealExchangeRateMembers((IDNumberTreeNode)node)) {
                        filterOrgNodes.put((Long)id, (IDNumberTreeNode)node);
                    }
                });
                return filterOrgNodes;
            }
            allOrgNodes.forEach((id, node) -> {
                if (this.filterCondition.test((IDNumberTreeNode)node) && ("Entity".equals(node.getNumber()) || effectiveCslSchemeIds.contains((Long)node.getProperty("cslscheme.id"))) && this.dealExchangeRateMembers((IDNumberTreeNode)node)) {
                    filterOrgNodes.put((Long)id, (IDNumberTreeNode)node);
                }
            });
            return filterOrgNodes;
        }

        private boolean dealExchangeRateMembers(IDNumberTreeNode node) {
            return this.includeExchangeRateMembers || (Boolean)node.getProperty("isexchangerate") == false;
        }

        public DynamicObjectCollection getOrgDynamicObjectCollection() {
            QFilter filterModel = this.genQueryFilter();
            ExchageRateServiceHelper.delExchangeRatePlanFilter(filterModel, "bcm_entitymembertree");
            QFilter[] customFilter = this.getBuilder();
            customFilter = Arrays.copyOf(customFilter, customFilter.length + 1);
            customFilter[customFilter.length - 1] = filterModel;
            DynamicObjectCollection doc = CslSchemeServiceHelper.getOrgCollection(customFilter, this.selectFields, "dseq");
            if (CslSchemeServiceHelper.isValidePeriodAndYear(this.yearNum, this.periodId)) {
                FilterOrgStructParam param = new FilterOrgStructParam((long)LongUtil.toLong((Object)this.modelId), (long)LongUtil.toLong((Object)this.sceneId), this.yearNum, (long)LongUtil.toLong((Object)this.periodId));
                EntityVersioningUtil.filterOrgsByMergeStruct(param, (List<DynamicObject>)doc);
            }
            return doc;
        }
    }
}

