/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.struct.StructHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

@KSObject
public class DimensionServiceHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DimensionServiceHelper.class);
    public static final List<String> sortDims = Arrays.asList("entity", "account", "scenario", "year", "period", "process", "changetype", "audittrail", "internalcompany", "currency", "multigaap", "mycompany", "datasort");
    private static final Object[] MEMBS = new Object[]{"DataCollection", "TraDif", "EntityInputTraDif", "CWP", "AutoCWP", "LinkageJournal"};

    public static void initDimensionDyObject(DynamicObject dy) {
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        DimensionServiceHelper.initCommonDyObject(dy);
    }

    public static DynamicObject createDimensionObject() {
        return DimensionServiceHelper.createDybamicObjectWithId("bcm_dimension");
    }

    public static DynamicObject createDybamicObjectWithId(String entityName) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        return dynamicObject;
    }

    public static void initDimensionDyObject(DynamicObject dy, boolean withOrg) {
        DimensionServiceHelper.initDimensionDyObject(dy);
        if (withOrg) {
            RequestContext tx = RequestContext.get();
            dy.set("org", (Object)tx.getOrgId());
        }
    }

    public static void initDimensionDyObjectWithOrg(DynamicObject dy) {
        DimensionServiceHelper.initDimensionDyObject(dy, true);
    }

    public static void initRuleDyObject(DynamicObject dy) {
        DimensionServiceHelper.initCommonDyObject(dy);
    }

    public static void initCommonDyObject(DynamicObject dy) {
        long user = Long.parseLong(RequestContext.get().getUserId());
        Date createTime = DimensionServiceHelper.getCurrentDate();
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    private static Date getCurrentDate() {
        return (Date)ThreadCache.get((Object)"DimensionServiceHelper.getCurrentDate", () -> {
            LocalDateTime localDateTime = LocalDateTime.now();
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDateTime.atZone(zone).toInstant();
            return Date.from(instant);
        });
    }

    public static Collection<String> getMemberObjectFromMembers(List<DynamicObject> members) {
        ArrayList<String> collections = new ArrayList<String>(members.size());
        for (DynamicObject dynamicObject : members) {
            String object = dynamicObject.getString("number");
            collections.add(object);
        }
        return collections;
    }

    public static void initObject4BaseInfo(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)tx.getUserId());
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    public static void assemModifyField(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)tx.getUserId());
        dy.set("modifier", (Object)user);
    }

    public static DynamicObject getDimensionMessage(Object modelid, String entity, String selectFields, String dimsionNumber) {
        QFilter filter1 = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelid));
        QFilter filter2 = new QFilter("membermodel", "=", (Object)entity);
        QFilter[] filters = StringUtils.isEmpty((String)dimsionNumber) ? new QFilter[]{filter1, filter2} : new QFilter[]{filter1, filter2, new QFilter("number", "=", (Object)dimsionNumber)};
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
        return dy;
    }

    public static DynamicObject getDynamicObjectName(String number, long modelid, String entityid) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{filter, filter2};
        return QueryServiceHelper.queryOne((String)entityid, (String)"name", (QFilter[])filters);
    }

    public static DynamicObject getDynamicObject(String modelNum, String memberNum, String formEtity, String selectFields, long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder = modelNum == null ? qfBuilder.add("model.id", "=", (Object)modelId) : qfBuilder.add("model.number", "=", (Object)modelNum);
        qfBuilder.add("number", "=", (Object)memberNum);
        return BusinessDataServiceHelper.loadSingle((String)formEtity, (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject getModel(String modelNum, String selectFields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("number", "=", (Object)modelNum);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static Map<String, String> getDimensionNumMapped(Object modelId) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", modelId)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"DimensionServiceHelper.getDimensionNumMapped", (String)"bcm_dimension", (String)"number,issysdimension,fieldmapped", (QFilter[])filters, null);){
            for (Row d : ds) {
                String number = d.getString("number");
                if (!d.getBoolean("issysdimension").booleanValue()) {
                    result.put(number, d.getString("fieldmapped"));
                    continue;
                }
                result.put(number, number.toLowerCase(Locale.ENGLISH));
            }
        }
        return result;
    }

    public static List<String> getDimensionNumListByModel(Object modelId) {
        ArrayList<String> dimNums = new ArrayList<String>();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", modelId).toArray(), (String)"dseq").values().forEach(e -> dimNums.add(e.getString("number")));
        return dimNums;
    }

    public static List<Long> getDimensionIdListByModel(Object modelId) {
        ArrayList<Long> dimIds = new ArrayList<Long>();
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,issysdimension,number,shortnumber", (QFilter[])new QFBuilder().add("model", "=", modelId).toArray(), (String)"dseq");
        List<DynamicObject> dySortList = DimensionServiceHelper.sortDims(dims);
        dySortList.forEach(e -> dimIds.add(e.getLong("id")));
        return dimIds;
    }

    public static void getDimensionBymodelOnConsumer(long modelId, String selector, Consumer<DynamicObject> c) {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)selector, (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray(), (String)"dseq").values().forEach(c);
    }

    public static List<String> getUserDefineDimensionNumListByModel(Object modelId) {
        ArrayList<String> dimNums = new ArrayList<String>();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)"0").toArray()).values().forEach(e -> dimNums.add(e.getString("number")));
        return dimNums;
    }

    public static Map<String, String> getUserDefineDimensionNameAndMapByModel(Object modelId, boolean isShowName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,name,fieldmapped", (QFilter[])new QFBuilder().add("model", "=", modelId).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq").values();
        if (!isShowName) {
            for (DynamicObject dim : dims) {
                map.put(dim.getString("number"), dim.getString("fieldmapped"));
            }
        } else {
            for (DynamicObject dim : dims) {
                map.put(dim.getString("fieldmapped"), dim.getString("name"));
            }
        }
        return map;
    }

    public static Set<String> getExitUserDefinedDim(Object modelId) {
        return DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(modelId, true).keySet();
    }

    public static Map<String, String> getUserDefineDimensionNumAndNameByModel(Object modelId, boolean needSeq) {
        HashMap<String, String> dimNumAndName = new HashMap<String, String>(16);
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,name", (QFilter[])new QFBuilder().add("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq").values();
        int seq = 1;
        for (DynamicObject dim : dims) {
            if (needSeq) {
                dimNumAndName.put(dim.getString("number"), dim.getString("name") + "." + seq);
            } else {
                dimNumAndName.put(dim.getString("number"), dim.getString("name"));
            }
            ++seq;
        }
        return dimNumAndName;
    }

    public static long getIdByNum(String entity, long modelId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("number", "=", (Object)number);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id", (QFilter[])qfBuilder.toArray());
        return dy == null ? 0L : dy.getLong("id");
    }

    public static DynamicObject createCurrencyMemberWithoutOlap(long modelId, String modelNum, String cyNumber, String cyName, String className) {
        DynamicObject currency = ORM.create().newDynamicObject("bcm_currencymember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(currency);
        DimensionServiceHelper.initModelAndDimension(currency, DimTypesEnum.CURRENCY.getNumber(), modelId, className);
        QFilter filter1 = new QFilter("number", "=", (Object)cyNumber);
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)DimEntityNumEnum.CURRENCY.getEntityNum(), (QFilter[])filters)) {
            currency.set("number", (Object)cyNumber);
            currency.set("name", (Object)cyName);
            Object[] currencys = new Object[]{currency};
            currencys = BusinessDataWriter.save((IDataEntityType)currency.getDynamicObjectType(), (Object[])currencys);
            DynamicObject currencyTree = ORM.create().newDynamicObject("bcm_currencymembertree");
            DimensionServiceHelper.initDimensionDyObject(currencyTree);
            DimensionServiceHelper.initModelAndDimension(currencyTree, DimTypesEnum.CURRENCY.getNumber(), modelId, className);
            currencyTree.set("member", (Object)currency);
            currencyTree.set("number", currency.get("number"));
            currencyTree.set("name", currency.get("name"));
            currencyTree.set("storagetype", (Object)4);
            currencyTree.set("aggoprt", (Object)5);
            currencyTree.set("isleaf", (Object)1);
            currencyTree.set("level", (Object)2);
            long parentTreeid = QueryDimensionServiceHelper.getParentId(modelId, "bcm_currencymembertree", DimTypesEnum.CURRENCY.getNumber(), className);
            currencyTree.set("longnumber", (Object)(DimTypesEnum.CURRENCY.getNumber() + '!' + currencyTree.getString("number")));
            currencyTree.set("parent", (Object)parentTreeid);
            currencyTree.set("dseq", (Object)DimensionServiceHelper.getDSeq(parentTreeid, "bcm_currencymembertree", className));
            currencyTree.set("member", currencys[0]);
            currencyTree.set("issysmember", (Object)2);
            Object[] currencyTrees = new Object[]{currencyTree};
            BusinessDataWriter.save((IDataEntityType)currencyTree.getDynamicObjectType(), (Object[])currencyTrees);
            return currencyTree;
        }
        return null;
    }

    public static DynamicObject createCurrencyMember(long modelId, String modelNum, String cyNumber, String cyName, String className) {
        DynamicObject currency = ORM.create().newDynamicObject("bcm_currencymember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(currency);
        DimensionServiceHelper.initModelAndDimension(currency, DimTypesEnum.CURRENCY.getNumber(), modelId, className);
        QFilter filter1 = new QFilter("number", "=", (Object)cyNumber);
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)DimEntityNumEnum.CURRENCY.getEntityNum(), (QFilter[])filters)) {
            currency.set("number", (Object)cyNumber);
            currency.set("name", (Object)cyName);
            Object[] currencys = new Object[]{currency};
            currencys = BusinessDataWriter.save((IDataEntityType)currency.getDynamicObjectType(), (Object[])currencys);
            DynamicObject currencyTree = ORM.create().newDynamicObject("bcm_currencymembertree");
            DimensionServiceHelper.initDimensionDyObject(currencyTree);
            DimensionServiceHelper.initModelAndDimension(currencyTree, DimTypesEnum.CURRENCY.getNumber(), modelId, className);
            currencyTree.set("member", (Object)currency);
            currencyTree.set("number", currency.get("number"));
            currencyTree.set("name", currency.get("name"));
            currencyTree.set("storagetype", (Object)4);
            currencyTree.set("aggoprt", (Object)5);
            currencyTree.set("isleaf", (Object)1);
            currencyTree.set("level", (Object)2);
            long parentTreeid = QueryDimensionServiceHelper.getParentId(modelId, "bcm_currencymembertree", DimTypesEnum.CURRENCY.getNumber(), className);
            currencyTree.set("longnumber", (Object)(DimTypesEnum.CURRENCY.getNumber() + '!' + currencyTree.getString("number")));
            currencyTree.set("parent", (Object)parentTreeid);
            currencyTree.set("dseq", (Object)DimensionServiceHelper.getDSeq(parentTreeid, "bcm_currencymembertree", className));
            currencyTree.set("member", currencys[0]);
            currencyTree.set("issysmember", (Object)DimMemTypeEnum.IMPORTMEM.getIndex());
            Object[] currencyTrees = new Object[]{currencyTree};
            BusinessDataWriter.save((IDataEntityType)currencyTree.getDynamicObjectType(), (Object[])currencyTrees);
            OlapServiceHelper.createMember(modelNum, DimTypesEnum.CURRENCY.getNumber(), cyNumber, 5, DimTypesEnum.CURRENCY.getNumber());
            return currencyTree;
        }
        return null;
    }

    public static void createProcessMember(long modelId, String modelNumber, String cyNumber, String cyName, String className) {
        DynamicObject process = ORM.create().newDynamicObject("bcm_processmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(process);
        DimensionServiceHelper.initModelAndDimension(process, "TCF", modelId, className);
        QFilter filter1 = new QFilter("number", "=", (Object)cyNumber);
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])filters)) {
            process.set("number", (Object)cyNumber);
            process.set("name", (Object)cyName);
            Object[] processs = new Object[]{process};
            processs = BusinessDataWriter.save((IDataEntityType)process.getDynamicObjectType(), (Object[])processs);
            DynamicObject processTree = ORM.create().newDynamicObject("bcm_processmembertree");
            DimensionServiceHelper.initDimensionDyObject(processTree);
            DimensionServiceHelper.initModelAndDimension(processTree, DimTypesEnum.PROCESS.getNumber(), modelId, className);
            processTree.set("member", (Object)process);
            processTree.set("number", (Object)cyNumber);
            processTree.set("name", (Object)cyName);
            processTree.set("storagetype", (Object)4);
            processTree.set("aggoprt", (Object)5);
            processTree.set("isleaf", (Object)1);
            processTree.set("level", (Object)3);
            long parentTreeid = QueryDimensionServiceHelper.getParentId(modelId, "bcm_processmembertree", "TCF", className);
            processTree.set("longnumber", (Object)("Process!TCF!" + processTree.getString("number")));
            processTree.set("parent", (Object)parentTreeid);
            processTree.set("dseq", (Object)DimensionServiceHelper.getDSeq(parentTreeid, "bcm_processmembertree", className));
            processTree.set("member", processs[0]);
            processTree.set("issysmember", (Object)2);
            Object[] processTrees = new Object[]{processTree};
            BusinessDataWriter.save((IDataEntityType)processTree.getDynamicObjectType(), (Object[])processTrees);
            OlapServiceHelper.createMember(modelNumber, DimTypesEnum.PROCESS.getNumber(), cyNumber, 5, "TCF");
        }
    }

    public static void createProcessMember(long modelId, DynamicObject currencyTree, String modelNumber, String className) {
        DimensionServiceHelper.createProcessMember(modelId, modelNumber, currencyTree.getString("number"), currencyTree.getString("name"), className);
    }

    public static void initModelAndDimension(DynamicObject dy, String number, long modelId, String className) {
        DynamicObject modelOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        DynamicObject dimensionOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        modelOb.set("id", (Object)modelId);
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            String dimensionId = ((DynamicObject)dcs.get(0)).getString("id");
            dimensionOb.set("id", (Object)dimensionId);
        }
        dy.set("model", (Object)modelOb);
        dy.set("dimension", (Object)dimensionOb);
    }

    public static int getDSeq(long id, String entity, String className) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static LinkedHashMultimap<String, Map<String, String>> getNotSyncDimensionMember(long modelId) {
        logger.startWatch();
        LinkedHashMultimap multiMap = LinkedHashMultimap.create();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (modelId == 0L || StringUtils.isEmpty((String)modelNum)) {
            return multiMap;
        }
        MemberReader.getDimNumberMapNameById((long)modelId).keySet().forEach(dimNum -> {
            String dimEntity = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNum);
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("dimension.number", "=", dimNum);
            filter.and("storagetype", "!=", (Object)"3");
            filter.and("status", "=", (Object)"C");
            DynamicObjectCollection members = QueryServiceHelper.query((String)dimEntity, (String)"number,name", (QFilter[])filter.toArray());
            Map<String, String> memberMap = members.stream().collect(Collectors.toMap(d -> d.getString("number"), d -> d.getString("name"), (d1, d2) -> d1));
            List<String> olapMembers = OlapServiceHelper.getMembersOfDimFromOlap(dimNum, modelNum);
            if (dimNum.equals(DimTypesEnum.ENTITY.getNumber())) {
                olapMembers.removeIf(o -> o.contains("_") && !memberMap.containsKey(o));
            }
            HashMap olapMembersLowCase = new HashMap(olapMembers.size());
            olapMembers.forEach(memberNum -> olapMembersLowCase.put(memberNum.toLowerCase(Locale.ENGLISH), memberNum));
            logger.info("refresh olap data dimNum:" + dimNum + " size:" + members.size());
            memberMap.forEach((k, v) -> {
                String result = (String)olapMembersLowCase.remove(k.toLowerCase(Locale.ENGLISH));
                if (result == null) {
                    HashMap<String, String> notSyncRecord = new HashMap<String, String>(8);
                    notSyncRecord.put("num", (String)k);
                    notSyncRecord.put("name", (String)v);
                    multiMap.put(dimNum, notSyncRecord);
                } else if (!olapMembers.contains(k)) {
                    HashMap<String, String> notSyncRecord = new HashMap<String, String>(8);
                    notSyncRecord.put("numbers", k + "|" + DimensionServiceHelper.getOriginalNumber(olapMembers, k));
                    notSyncRecord.put("name", (String)v);
                    multiMap.put(dimNum, notSyncRecord);
                }
            });
        });
        logger.infoEnd("refresh olap data getNotSyncDimensionMember end.");
        return multiMap;
    }

    private static String getOriginalNumber(List<String> numbers, String lowerNumber) {
        return numbers.stream().filter(n -> n.equalsIgnoreCase(lowerNumber)).findFirst().orElse("");
    }

    public static Map<String, Map<String, DynamicObject>> queryAllDimMember(Collection<String> queryDims, Object modelId, String dimKeytype, String memberKeytype, String selectFields) {
        Objects.requireNonNull(queryDims);
        ArrayList lowercase = new ArrayList();
        queryDims.forEach(d -> lowercase.add(d.toLowerCase(Locale.ENGLISH)));
        return (Map)ThreadCache.get((Object)(dimKeytype + memberKeytype + selectFields + modelId + String.join((CharSequence)";", queryDims)), () -> {
            HashMap result = new HashMap(16);
            QFilter qFilter = new QFilter("model", "=", modelId);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"bcm", (String)"bcm_dimension", (String)"shortnumber,number", (QFilter[])new QFilter[]{qFilter}, null);
            Iterator iterator = ds.iterator();
            while (ds.hasNext()) {
                Row row = (Row)iterator.next();
                String number = row.getString("number");
                if (!lowercase.contains(number.toLowerCase(Locale.ENGLISH))) continue;
                String entityNum = DimensionServiceHelper.getDimMembEntityNumByShortNum(row.getString("shortnumber"));
                Collection members = BusinessDataServiceHelper.loadFromCache((String)entityNum, (String)selectFields, (QFilter[])new QFilter[]{qFilter}).values();
                HashMap dimMap = new HashMap(members.size());
                members.forEach(e -> dimMap.put(e.getString(memberKeytype), e));
                result.put(row.getString(dimKeytype), dimMap);
            }
            return result;
        });
    }

    public static Map<String, Map<String, DynamicObject>> queryDimShortNumbers(Collection<String> queryDims, Object modelId) {
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
        HashMap<String, Map<String, DynamicObject>> result = new HashMap<String, Map<String, DynamicObject>>(16);
        dimensionShortNumber2NumberMap.forEach((shortNum, number) -> {
            if (queryDims.contains(number.toLowerCase(Locale.ENGLISH))) {
                result.put((String)shortNum, Collections.emptyMap());
            }
        });
        return result;
    }

    public static DynamicObject queryDimensionMemberByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"id,name,dimension.name,dimension.number", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryMemberIdByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryMemberNameByNumber(String entityName, Object modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryDimensionNameByNumber(String dimNumber) {
        QFilter qf = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])new QFilter[]{qf});
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                return "bcm_entitymembertree";
            }
            case "account": {
                return "bcm_accountmembertree";
            }
            case "year": {
                return "bcm_fymembertree";
            }
            case "period": {
                return "bcm_periodmembertree";
            }
            case "scenario": {
                return "bcm_scenemembertree";
            }
            case "process": {
                return "bcm_processmembertree";
            }
            case "currency": {
                return "bcm_currencymembertree";
            }
            case "audittrail": {
                return "bcm_audittrialmembertree";
            }
            case "changetype": {
                return "bcm_changetypemembertree";
            }
            case "internalcompany": {
                return "bcm_icmembertree";
            }
            case "multigaap": {
                return "bcm_rulemembertree";
            }
            case "datatype": {
                return "eb_datetypemembertree";
            }
            case "datasort": {
                return "bcm_datasortmembertree";
            }
            case "mycompany": {
                return "bcm_mycompanymembertree";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    public static String getDimMembEntityNumByShortNum(String shortNum) {
        switch (shortNum) {
            case "E": {
                return "bcm_entitymembertree";
            }
            case "A": {
                return "bcm_accountmembertree";
            }
            case "S": {
                return "bcm_scenemembertree";
            }
            case "FY": {
                return "bcm_fymembertree";
            }
            case "P": {
                return "bcm_periodmembertree";
            }
            case "BP": {
                return "bcm_processmembertree";
            }
            case "C": {
                return "bcm_currencymembertree";
            }
            case "AT": {
                return "bcm_audittrialmembertree";
            }
            case "CT": {
                return "bcm_changetypemembertree";
            }
            case "MC": {
                return "bcm_mycompanymembertree";
            }
            case "IC": {
                return "bcm_icmembertree";
            }
            case "MG": {
                return "bcm_rulemembertree";
            }
            case "DS": {
                return "bcm_datasortmembertree";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    public static DynamicObject getMemberDy(String dimShortNum, long modelid, String memeberNumber) {
        String entity = DimensionServiceHelper.getDimMembEntityNumByShortNum(dimShortNum);
        DynamicObject dy = DimensionServiceHelper.queryMemberIdByNumber(entity, modelid, memeberNumber);
        return dy;
    }

    public static boolean checkSPConfig(boolean isBeforeSelect, DynamicObject scenarioDy, long modelId, IDataModel dataModel, String periodKey) {
        if (isBeforeSelect) {
            if (scenarioDy == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"DimensionServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioDy.getLong("id"));
            if (coll != null && coll.size() > 0) {
                boolean hasPeriod = dataModel.getDataEntityType().getProperties().containsKey((Object)periodKey);
                if (hasPeriod) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    public static void buildPeriodFilter(long modelId, long scenarioId, FormShowParameter showParameter) {
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioId);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        ArrayList list = new ArrayList();
        if (coll != null && coll.size() > 0) {
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    list.add(period.getLong("id"));
                }
            });
        }
        filter.and("id", "in", (Object)list.toArray());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"DimensionServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        showParameter.setCustomParam("periodFilter", (Object)ObjectSerialUtil.toByteSerialized((Object)filter));
    }

    public static DynamicObjectCollection getScenePeriod(long modelId, long scenarioId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("id", "=", (Object)scenarioId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            return new DynamicObjectCollection();
        }
        return dy.getDynamicObjectCollection("sceneperiod");
    }

    public static boolean checkScenePeriod(long modelId, long scenarioId, long periodId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("id", "=", (Object)scenarioId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            return false;
        }
        DynamicObjectCollection dc = dy.getDynamicObjectCollection("sceneperiod");
        for (DynamicObject obj : dc) {
            if (periodId != obj.getLong("fbasedataid_id")) continue;
            return true;
        }
        return false;
    }

    public static void hazySearch(long modelId, long scenarioId, BasedataEdit basedataEdit) {
        QFilter filter = DimensionServiceHelper.getFilter(modelId, scenarioId);
        if (filter != null) {
            basedataEdit.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{filter}));
        }
    }

    public static QFilter getFilter(long modelId, long scenarioId) {
        QFilter filter = null;
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, scenarioId);
        if (coll != null && coll.size() > 0) {
            ArrayList list = new ArrayList();
            filter = new QFilter("model", "=", (Object)modelId);
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    list.add(period.getLong("id"));
                }
            });
            filter.and("id", "in", (Object)list.toArray());
        }
        return filter;
    }

    public static String getDefaultScenarioNumber(long modelId, long templdateId) {
        QFBuilder qf = new QFBuilder("number", "=", (Object)"Actual");
        if (modelId != 0L) {
            qf.add("model", "=", (Object)modelId);
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"model", (QFilter[])new QFBuilder("id", "=", (Object)templdateId).toArray());
            if (dy == null) {
                return "MRpt";
            }
            qf.add("model", "=", (Object)dy.getLong("model"));
        }
        boolean isOldData = QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])qf.toArray());
        if (isOldData) {
            return "Actual";
        }
        return "MRpt";
    }

    public static String getDefaultScenarioNumber(long modelId, long templdateId, ApplicationTypeEnum app) {
        if (ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGBD == app || ApplicationTypeEnum.BGM == app) {
            return "NoScenario";
        }
        if (ApplicationTypeEnum.EB == app) {
            return "Budget";
        }
        QFBuilder qf = new QFBuilder("number", "=", (Object)"Actual");
        if (modelId != 0L) {
            qf.add("model", "=", (Object)modelId);
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"model", (QFilter[])new QFBuilder("id", "=", (Object)templdateId).toArray());
            if (dy == null) {
                return "MRpt";
            }
            qf.add("model", "=", (Object)dy.getLong("model"));
        }
        boolean isOldData = QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])qf.toArray());
        if (isOldData) {
            return "Actual";
        }
        return "MRpt";
    }

    public static DynamicObject getEbDefaultScenMember(Object modelId, String selectKeys, ApplicationTypeEnum app) {
        if (selectKeys == null || "".equals(selectKeys)) {
            selectKeys = "id,number,name";
        }
        String memberNumber = "NoScenario";
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)memberNumber);
        DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static DynamicObject getEbDefaultProcessMember(Object modelId, String selectKeys) {
        if (selectKeys == null || "".equals(selectKeys)) {
            selectKeys = "id,number,name";
        }
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)"IRpt");
        DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static DynamicObject getEbDefaultChangeTypeMember(Object modelId, String selectKeys) {
        if (selectKeys == null || "".equals(selectKeys)) {
            selectKeys = "id,number,name";
        }
        QFilter qModel = new QFilter("model", "=", modelId);
        QFilter qMemberNum = new QFilter("number", "=", (Object)"CurrentPeriod");
        DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_changetypemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qMemberNum, qModel});
        return member;
    }

    public static List<String> getRihtInfoAccount(long modelId) {
        QFBuilder filters = new QFBuilder();
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("accounttype", "=", (Object)AccountTypeEnum.RIGHTS.getOIndex()));
        filters.add(new QFilter("exchange", "=", (Object)ExchangeEnum.NONE.getOIndex()));
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_accountmembertree", (String)"number", (QFilter[])filters.toArray());
        ArrayList<String> ls = new ArrayList<String>(dys.length);
        for (DynamicObject dy : dys) {
            ls.add(dy.getString("number"));
        }
        return ls;
    }

    public static void afterCreateDim(long modelId, long dimId, long memberId, boolean isViewPoint) {
        DynamicObject[] oo;
        boolean isFalse = false;
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject[] dd : dcs) {
            ids.add(dd.getLong("id"));
        }
        for (DynamicObject obj : oo = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_templateentity"))) {
            boolean add2View = obj.getInt("templatetype") == TemplateTypeEnum.MSN.getType() ? isFalse : isViewPoint;
            DynamicObjectCollection dcss = obj.getDynamicObjectCollection(add2View ? "viewpointmembentry" : "pagemembentry");
            DynamicObject item = new DynamicObject(dcss.getDynamicObjectType());
            if (add2View) {
                item.set("viewdimension", (Object)dimId);
                item.set("viewmembid", (Object)memberId);
            } else {
                item.set("pagedimension", (Object)dimId);
                item.set("pagemembid", (Object)memberId);
                item.set("membbound", (Object)RangeEnum.VALUE_10.getValue());
            }
            item.set("seq", (Object)(dcss.size() + 1));
            dcss.add((Object)item);
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.save((DynamicObject[])oo, (OperateOption)op);
        for (DynamicObject t : oo) {
            TemplateServiceHelper.removeTemplateModelCacheByIds(modelId, t.getLong("id"));
        }
    }

    public static void saveDefaultData4RptAdjust(long modelId, long dimId, long memberId, String memberName) {
        DynamicObject[] doc;
        DynamicObject[] dy;
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        for (DynamicObject dd : dy = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"id,commembentry,commembentry.seq,commembentry.commembid,commembentry.comdimension", (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection comdim = dd.getDynamicObjectCollection("commembentry");
            DynamicObject newmember = new DynamicObject(comdim.getDynamicObjectType());
            newmember.set("seq", (Object)(comdim.size() + 1));
            newmember.set("commembid", (Object)memberId);
            newmember.set("comdimension", (Object)dimId);
            comdim.add((Object)newmember);
        }
        SaveServiceHelper.save((DynamicObject[])dy);
        for (DynamicObject dd : doc = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)("id, " + memberName), (QFilter[])new QFilter[]{filter})) {
            dd.set(memberName, (Object)memberId);
        }
        SaveServiceHelper.save((DynamicObject[])doc);
    }

    public static void addChkFormula(long modelId, String shortnumber, String dimMem) {
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"bcm_chkformulasetting", (String)"leftformula,lformulatemp,rightformula,rformulatemp", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        String[] properties = new String[]{"leftformula", "lformulatemp", "rightformula", "rformulatemp"};
        for (DynamicObject formula : formulas) {
            for (String property : properties) {
                String str = formula.getString(property);
                formula.set(property, (Object)ChkCheckServiceHelper.addDimToFormula(str, shortnumber, dimMem));
            }
        }
        SaveServiceHelper.save((DynamicObject[])formulas);
    }

    public static void addInvFormula(long modelId, String shortnumber, String dimMem) {
        DynamicObject[] temps;
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter("model", "=", (Object)modelId));
        for (DynamicObject temp : temps = BusinessDataServiceHelper.load((String)"bcm_invelimtemplate", (String)"invelimtplentry,invelimtplentry.ruleexprsource", (QFilter[])qf.toArray())) {
            for (DynamicObject invelimtplentry : temp.getDynamicObjectCollection("invelimtplentry")) {
                String fo = invelimtplentry.getString("ruleexprsource");
                fo = InvestServiceHelper.addDimToFormula(fo, shortnumber, dimMem);
                invelimtplentry.set("ruleexprsource", (Object)fo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])temps);
    }

    public static DynamicObject queryMyCompanyDim(long modelId) {
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MyCompany").toArray());
    }

    public static boolean existsMyCompanyDim(long modelId) {
        return QueryServiceHelper.exists((String)"bcm_dimension", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MyCompany").toArray());
    }

    public static boolean existsMGMultiGAAPDim(long modelId) {
        return QueryServiceHelper.exists((String)"bcm_dimension", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"MultiGAAP").toArray());
    }

    public static boolean existsTraDifMember(long modelId) {
        return QueryServiceHelper.exists((String)"bcm_audittrialmembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"TraDif").toArray());
    }

    public static boolean existsDimensionMember(long modelId, String metaMemberTree, String memberNumber) {
        return QueryServiceHelper.exists((String)metaMemberTree, (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)memberNumber).toArray());
    }

    public static boolean existsBPNoneMember(long modelId) {
        return QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"BPNone").toArray());
    }

    public static List<String> getAllDim(Long modelid) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelid).toArray(), (String)"dseq");
        ArrayList<String> allDim = new ArrayList<String>();
        dims.forEach(e -> allDim.add(e.getString("number")));
        return allDim;
    }

    public static void createATMember(List<DynamicObject> memberList, List<DynamicObject> memberTreeList, long modelId, long dimensionId, long parentId, String number, String name, String aggoprt, String description, int dseq, int level, String longnumber) {
        DynamicObject member = ORM.create().newDynamicObject("bcm_audittrialmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(member);
        member.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        member.set("number", (Object)number);
        member.set("name", (Object)name);
        member.set("model", (Object)modelId);
        member.set("dimension", (Object)dimensionId);
        memberList.add(member);
        DynamicObject memberTree = ORM.create().newDynamicObject("bcm_audittrialmembertree");
        DimensionServiceHelper.initDimensionDyObject(memberTree);
        memberTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        memberTree.set("member", (Object)member);
        memberTree.set("number", (Object)number);
        memberTree.set("longnumber", (Object)longnumber);
        memberTree.set("name", (Object)name);
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        memberTree.set("aggoprt", (Object)aggoprt);
        memberTree.set("description", (Object)description);
        memberTree.set("model", (Object)modelId);
        memberTree.set("dimension", (Object)dimensionId);
        memberTree.set("issysmember", (Object)1);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)level);
        memberTree.set("parent", (Object)parentId);
        memberTree.set("dseq", (Object)dseq);
        memberTreeList.add(memberTree);
    }

    public static void createProcessMember(List<DynamicObject> memberList, List<DynamicObject> memberTreeList, long modelId, long dimensionId, long parentId, String number, String name, String aggoprt, String description, int dseq, int level, String longnumber) {
        DynamicObject member = ORM.create().newDynamicObject("bcm_processmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(member);
        member.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        member.set("number", (Object)number);
        member.set("name", (Object)name);
        member.set("model", (Object)modelId);
        member.set("dimension", (Object)dimensionId);
        memberList.add(member);
        DynamicObject memberTree = ORM.create().newDynamicObject("bcm_processmembertree");
        DimensionServiceHelper.initDimensionDyObject(memberTree);
        memberTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        memberTree.set("member", (Object)member);
        memberTree.set("number", (Object)number);
        memberTree.set("longnumber", (Object)longnumber);
        memberTree.set("name", (Object)name);
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        memberTree.set("aggoprt", (Object)aggoprt);
        memberTree.set("description", (Object)description);
        memberTree.set("model", (Object)modelId);
        memberTree.set("dimension", (Object)dimensionId);
        memberTree.set("issysmember", (Object)1);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)level);
        memberTree.set("parent", (Object)parentId);
        memberTree.set("dseq", (Object)dseq);
        memberTreeList.add(memberTree);
    }

    public static void createICMember(List<DynamicObject> memberList, List<DynamicObject> memberTreeList, long modelId, long dimensionId, long parentId, String number, String name, String aggoprt, String description, int dseq, int level, String longnumber) {
        DynamicObject member = ORM.create().newDynamicObject("bcm_intercompanymember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg(member);
        member.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        member.set("number", (Object)number);
        member.set("name", (Object)name);
        member.set("model", (Object)modelId);
        member.set("dimension", (Object)dimensionId);
        memberList.add(member);
        DynamicObject memberTree = ORM.create().newDynamicObject("bcm_icmembertree");
        DimensionServiceHelper.initDimensionDyObject(memberTree);
        memberTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        memberTree.set("member", (Object)member);
        memberTree.set("number", (Object)number);
        memberTree.set("longnumber", (Object)longnumber);
        memberTree.set("name", (Object)name);
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        memberTree.set("aggoprt", (Object)aggoprt);
        memberTree.set("description", (Object)description);
        memberTree.set("model", (Object)modelId);
        memberTree.set("dimension", (Object)dimensionId);
        memberTree.set("issysmember", (Object)1);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)level);
        memberTree.set("parent", (Object)parentId);
        memberTree.set("dseq", (Object)dseq);
        memberTreeList.add(memberTree);
    }

    public static void lockUpgradeModel() {
        try (DLock lock = DLock.create((String)"CardTaskPlugin+DimensionServiceHelper");){
            if (lock.tryLock(10000L)) {
                DimensionServiceHelper.upgradeModel();
            }
        }
    }

    public static void upgradeModel() {
        QFilter appfilter = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.getOIndex()).or("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{appfilter});
        ArrayList<DynamicObject> atMemberList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> atMemberTreeList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> atChangeSeqMemberList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> pMemberList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> pMemberTreeList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> icMemberList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> icMemberTreeList = new ArrayList<DynamicObject>();
        Map<Long, Set<String>> atMaps = DimensionServiceHelper.getAllModelMembers(MEMBS, "bcm_audittrialmembertree");
        Map<Long, Set<String>> bpMaps = DimensionServiceHelper.getAllModelMembers(new Object[]{"CSTE"}, "bcm_processmembertree");
        Map<Long, Set<String>> icMaps = DimensionServiceHelper.getAllModelMembers(new Object[]{"ICOEntity"}, "bcm_icmembertree");
        for (DynamicObject model : doc) {
            long modelId = model.getLong("id");
            if (MemberReader.isExistAuditTrailDimension((long)modelId)) {
                DimensionServiceHelper.upgradeATTraDifMember(modelId, atMemberList, atMemberTreeList, atChangeSeqMemberList, atMaps);
            }
            DimensionServiceHelper.upgradeProcessMember(modelId, pMemberList, pMemberTreeList, bpMaps);
            DimensionServiceHelper.upgradeICMember(modelId, icMemberList, icMemberTreeList, icMaps);
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])atMemberList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])atMemberTreeList.toArray(new DynamicObject[0]));
                if (atChangeSeqMemberList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)atChangeSeqMemberList.get(0)).getDataEntityType(), (Object[])atChangeSeqMemberList.toArray(new DynamicObject[0]));
                }
                SaveServiceHelper.save((DynamicObject[])pMemberList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])pMemberTreeList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])icMemberList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])icMemberTreeList.toArray(new DynamicObject[0]));
                for (DynamicObject model : doc) {
                    String modelNum = model.getString("number");
                    long modelId = model.getLong("id");
                    if (atMaps.get(modelId) != null && atMaps.get(modelId).size() > 0 && OlapServiceHelper.isExistCube(modelNum)) {
                        OlapServiceHelper.batchCreateDimensionMembers(modelNum, "AuditTrail", atMaps.get(modelId).toArray(new String[0]));
                    }
                    if (bpMaps.get(modelId) != null && bpMaps.get(modelId).size() > 0 && OlapServiceHelper.isExistCube(modelNum)) {
                        OlapServiceHelper.createMember(modelNum, "Process", "CSTE", 1, "CT");
                    }
                    if (icMaps.get(modelId) == null || icMaps.get(modelId).size() <= 0 || !OlapServiceHelper.isExistCube(modelNum)) continue;
                    OlapServiceHelper.createMember(modelNum, "InternalCompany", "ICOEntity", 1, "ICTotal");
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    public static void upgradeATTraDifMember(Long modelId, List<DynamicObject> memberList, List<DynamicObject> memberTreeList, List<DynamicObject> atChangeSeqMemberList, Map<Long, Set<String>> atMaps) {
        DynamicObject[] dyATTotalAndADJE = BusinessDataServiceHelper.load((String)"bcm_audittrialmembertree", (String)"id, dimension.id, number, longnumber, dseq", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "in", (Object)new String[]{"ATTotal", "ADJE"}).toArray());
        if (dyATTotalAndADJE != null && dyATTotalAndADJE.length > 0) {
            boolean isExitDTCollect = false;
            boolean isExittraDif = false;
            boolean isExitiputTraDif = false;
            boolean isExitcwp = false;
            boolean isExitautoCwp = false;
            boolean isExitlj = false;
            if (atMaps.get(modelId) != null) {
                isExitDTCollect = atMaps.get(modelId).contains("DataCollection");
                isExittraDif = atMaps.get(modelId).contains("TraDif");
                isExitiputTraDif = atMaps.get(modelId).contains("EntityInputTraDif");
                isExitcwp = atMaps.get(modelId).contains("CWP");
                isExitautoCwp = atMaps.get(modelId).contains("AutoCWP");
                isExitlj = atMaps.get(modelId).contains("LinkageJournal");
            }
            for (DynamicObject dy : dyATTotalAndADJE) {
                if (dy.getString("number").equals("ATTotal")) {
                    String dtcollectLongnumber = "AuditTrail!ATTotal!DataCollection";
                    String traDifLongnumber = "AuditTrail!ATTotal!TraDif";
                    String iputTraDifLongnumber = "AuditTrail!ATTotal!EntityInputTraDif";
                    if (!isExitDTCollect) {
                        atMaps.get(modelId).add("DataCollection");
                        DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "DataCollection", ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6", (String)"DimensionServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.SKIP.sign, "", 2, 3, dtcollectLongnumber);
                    } else {
                        atMaps.get(modelId).remove("DataCollection");
                    }
                    if (!isExittraDif) {
                        atMaps.get(modelId).add("TraDif");
                        DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "TraDif", ResManager.loadKDString((String)"\u6298\u7b97\u5dee", (String)"DimensionServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 3, 3, traDifLongnumber);
                    } else {
                        atMaps.get(modelId).remove("TraDif");
                    }
                    if (!isExitiputTraDif) {
                        atMaps.get(modelId).add("EntityInputTraDif");
                        DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "EntityInputTraDif", ResManager.loadKDString((String)"\u6570\u636e\u8f93\u5165\uff08\u542b\u6298\u7b97\u5dee\uff09", (String)"DimensionServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.SKIP.sign, "", 4, 3, iputTraDifLongnumber);
                        continue;
                    }
                    atMaps.get(modelId).remove("EntityInputTraDif");
                    continue;
                }
                dy.set("dseq", (Object)5);
                String cwpLongnumber = "AuditTrail!ATTotal!CWP";
                String autoCwpLongnumber = "AuditTrail!ATTotal!AutoCWP";
                String ljLongnumber = "AuditTrail!ATTotal!LinkageJournal";
                if (!isExitcwp) {
                    atMaps.get(modelId).add("CWP");
                    DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "CWP", ResManager.loadKDString((String)"\u5e95\u7a3f\u5f0f", (String)"DimensionServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 4, 4, cwpLongnumber);
                } else {
                    atMaps.get(modelId).remove("CWP");
                }
                if (!isExitautoCwp) {
                    atMaps.get(modelId).add("AutoCWP");
                    DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "AutoCWP", ResManager.loadKDString((String)"\u81ea\u52a8\u5e95\u7a3f\u5f0f", (String)"DimensionServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 5, 4, autoCwpLongnumber);
                } else {
                    atMaps.get(modelId).remove("AutoCWP");
                }
                if (!isExitlj) {
                    atMaps.get(modelId).add("LinkageJournal");
                    DimensionServiceHelper.createATMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "LinkageJournal", ResManager.loadKDString((String)"\u8054\u52a8\u5206\u5f55", (String)"DimensionServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 6, 4, ljLongnumber);
                } else {
                    atMaps.get(modelId).remove("LinkageJournal");
                }
                atChangeSeqMemberList.add(dy);
            }
        }
    }

    public static void upgradeProcessMember(Long modelId, List<DynamicObject> memberList, List<DynamicObject> memberTreeList, Map<Long, Set<String>> bpMaps) {
        DynamicObject[] dyCT = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id, dimension.id, number, longnumber, dseq", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "in", (Object)new String[]{"CT"}).toArray());
        if (dyCT != null && dyCT.length > 0) {
            boolean isExitCSTE = false;
            if (bpMaps.get(modelId) != null) {
                isExitCSTE = bpMaps.get(modelId).contains("CSTE");
            }
            for (DynamicObject dy : dyCT) {
                String csteLongnumber = "Process!CT!CSTE";
                if (!isExitCSTE) {
                    HashSet set = Sets.newHashSet();
                    set.add("CSTE");
                    bpMaps.put(modelId, set);
                    DimensionServiceHelper.createProcessMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "CSTE", ResManager.loadKDString((String)"\u5408\u5e76\u5f55\u5165", (String)"DimensionServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 10, 3, csteLongnumber);
                    continue;
                }
                bpMaps.remove(modelId);
            }
        }
    }

    public static void upgradeICMember(Long modelId, List<DynamicObject> memberList, List<DynamicObject> memberTreeList, Map<Long, Set<String>> icMaps) {
        DynamicObject[] dyICO = BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)"id, dimension.id, number, longnumber, dseq", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "in", (Object)new String[]{"ICTotal"}).toArray());
        if (dyICO != null && dyICO.length > 0) {
            boolean isExitICO = false;
            if (icMaps.get(modelId) != null) {
                isExitICO = icMaps.get(modelId).contains("ICOEntity");
            }
            for (DynamicObject dy : dyICO) {
                String icLongnumber = "InternalCompany!ICTotal!ICOEntity";
                if (!isExitICO) {
                    HashSet set = Sets.newHashSet();
                    set.add("ICOEntity");
                    icMaps.put(modelId, set);
                    DimensionServiceHelper.createICMember(memberList, memberTreeList, modelId, dy.getLong("dimension.id"), dy.getLong("id"), "ICOEntity", ResManager.loadKDString((String)"\u5916\u90e8\u7ec4\u7ec7", (String)"DimensionServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), AggOprtEnum.ADD.sign, "", 4, 3, icLongnumber);
                    continue;
                }
                icMaps.remove(modelId);
            }
        }
    }

    public static boolean isExitMember(long modelId, long dimensionId, String number, String form) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("dimension", "=", (Object)dimensionId);
        qf.add("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)form, (QFilter[])qf.toArray());
    }

    public static Map<Long, Set<String>> getAllModelMembers(Object[] numbers, String form) {
        QFBuilder qf = new QFBuilder("number", "in", (Object)numbers);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)form, (String)"model.id,number", (QFilter[])qf.toArray());
        HashMap map = Maps.newHashMap();
        for (DynamicObject dy : doc) {
            Long modelId = dy.getLong("model.id");
            if (map.get(modelId) == null) {
                HashSet set = Sets.newHashSet();
                set.add(dy.getString("number"));
                map.put(modelId, set);
                continue;
            }
            ((Set)map.get(modelId)).add(dy.getString("number"));
        }
        return map;
    }

    public static String getMemberNumber(String entityNum, DynamicObject obj) {
        QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)obj.get("parent")));
        DynamicObject parent = QueryServiceHelper.queryOne((String)entityNum, (String)"number", (QFilter[])new QFilter[]{filter});
        return parent.getString("number");
    }

    public static String getMemberNumber(String entityNum, Object id) {
        if (id instanceof DynamicObject) {
            id = ((DynamicObject)id).get("id");
        }
        QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
        DynamicObject parent = QueryServiceHelper.queryOne((String)entityNum, (String)"number", (QFilter[])new QFilter[]{filter});
        if (parent == null) {
            return "";
        }
        return parent.getString("number");
    }

    public static Map<Long, String> getMemberNumber(String entityNum, List<Long> ids) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        if (ids == null || ids.size() == 0) {
            return map;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection parents = QueryServiceHelper.query((String)entityNum, (String)"id,number", (QFilter[])filter.toArray());
        if (parents == null || parents.size() == 0) {
            return map;
        }
        return parents.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("number")));
    }

    public static List<Long> getYearIdsByModel(long modelid) {
        Map fys = MemberReader.getAllNodeFromCache((String)"bcm_fymembertree", (Object)modelid);
        ArrayList fyList = new ArrayList(fys.values());
        Collections.sort(fyList, new Comparator<IDNumberTreeNode>(){

            @Override
            public int compare(IDNumberTreeNode o1, IDNumberTreeNode o2) {
                return o1.getdSeq() - o2.getdSeq();
            }
        });
        ArrayList<Long> yearIdsList = new ArrayList<Long>(fyList.size());
        for (IDNumberTreeNode dy : fyList) {
            yearIdsList.add(dy.getId());
        }
        return yearIdsList;
    }

    public static Map<String, List<String>> getScenePeriodMap(Long modelid) {
        DynamicObject[] dycol;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelid);
        for (DynamicObject dy : dycol = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"number, sceneperiod.number", (QFilter[])qfBuilder.toArray())) {
            map.computeIfAbsent(dy.getString("number"), k -> new ArrayList());
            if (dy.getDynamicObjectCollection("sceneperiod") == null) continue;
            dy.getDynamicObjectCollection("sceneperiod").forEach(e -> {
                if (e.getDynamicObject("fbasedataid") != null) {
                    ((List)map.get(dy.getString("number"))).add(e.getDynamicObject("fbasedataid").getString("number"));
                }
            });
        }
        return map;
    }

    public static boolean isDynamicComputing(long dimensionId) {
        DynamicObject dimensionObj = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"bcm_dimension", (String)"id, isexcdycompute");
        return dimensionObj.getBoolean("isexcdycompute");
    }

    public static boolean isCM02Model(long modelid) {
        return (Boolean)ThreadCache.get((Object)("isCM02Model:" + modelid), () -> {
            IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelid), (String)ElimTypeEnum.EIT.getNumber());
            return IDNumberTreeNode.NotFoundTreeNode == processNode || processNode == null;
        });
    }

    public static Map<Long, Pair<Long, String>> getCurrencyDynaByOrgIds(Long model, Long ... orgId) {
        QFilter qFilter = new QFilter("id", "in", (Object)orgId);
        QFilter filter2 = new QFilter("model", "=", (Object)model);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.serviceHelper.DimensionServiceHelper.getCurrencyDynaByOrgIds", (String)"bcm_entitymembertree", (String)"id orgid, currency.number currencynumber, model", (QFilter[])qFilter.toArray(), null);
        DataSet currencyDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.serviceHelper.DimensionServiceHelper.getCurrencyDynaByOrgIds", (String)"bcm_currencymembertree", (String)"id currencyid, number currencynumber", (QFilter[])filter2.toArray(), null);
        HashMap<Long, Pair<Long, String>> result = new HashMap<Long, Pair<Long, String>>();
        try (DataSet finish = orgDataSet.join(currencyDataSet).on("currencynumber", "currencynumber").select(new String[]{"orgid"}, new String[]{"currencyid", "currencynumber"}).finish();){
            finish.forEach(row -> result.put(row.getLong("orgid"), Pair.onePair((Object)row.getLong("currencyid"), (Object)row.getString("currencynumber"))));
        }
        return result;
    }

    public static DynamicObject[] loadMemberList(long modelId) {
        String selectProperties = "id,number,name,isdyn,isenable,modelid,dimensionid,creator,modifier,modifydate,bcmstaticlist,bcmdynamiclist,bcmstaticlist.memberid,bcmdynamiclist.member,bcmdynamiclist.base,bcmdynamiclist.range,bcmdynamiclist.formula_tag";
        QFilter qf = new QFilter("modelid", "=", (Object)modelId);
        return BusinessDataServiceHelper.load((String)"bcm_memberlist", (String)selectProperties, (QFilter[])qf.toArray());
    }

    public static DynamicObject[] loadMemberList(long modelId, Object[] ids) {
        String selectProperties = "id,number,name,isdyn,isenable,modelid,dimensionid,creator,modifier,modifydate,bcmstaticlist,bcmdynamiclist,bcmstaticlist.memberid,bcmdynamiclist.member,bcmdynamiclist.base,bcmdynamiclist.range,bcmdynamiclist.formula_tag";
        QFBuilder qb = new QFBuilder("modelid", "=", (Object)modelId);
        qb.add(new QFilter("id", "in", (Object)ids));
        return BusinessDataServiceHelper.load((String)"bcm_memberlist", (String)selectProperties, (QFilter[])qb.toArray());
    }

    public static Map<Long, Pair<Long, String>> getCurrencyDynaByOrgIds(long modelId, List<Long> entityIds) {
        QFilter qFilter = new QFilter("id", "in", entityIds);
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.serviceHelper.DimensionServiceHelper.getCurrencyDynaByOrgIds", (String)"bcm_entitymembertree", (String)"id orgid, currency.number currencynumber, model", (QFilter[])qFilter.toArray(), null);
        DataSet currencyDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.serviceHelper.DimensionServiceHelper.getCurrencyDynaByOrgIds", (String)"bcm_currencymembertree", (String)"id currencyid, number currencynumber", (QFilter[])filter2.toArray(), null);
        HashMap<Long, Pair<Long, String>> result = new HashMap<Long, Pair<Long, String>>();
        try (DataSet finish = orgDataSet.join(currencyDataSet).on("currencynumber", "currencynumber").select(new String[]{"orgid"}, new String[]{"currencyid", "currencynumber"}).finish();){
            finish.forEach(row -> result.put(row.getLong("orgid"), Pair.onePair((Object)row.getLong("currencyid"), (Object)row.getString("currencynumber"))));
        }
        return result;
    }

    public static List<String> getAdjATMember(long modelId) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number,datasource", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)modelId)});
        return doc.stream().filter(d -> d.getString("datasource").contains("4")).map(m -> m.getString("number")).collect(Collectors.toList());
    }

    private static List<DynamicObject> sortDims(DynamicObjectCollection dyObject) {
        List undifineDims = dyObject.stream().filter(x -> (Boolean)x.get("issysdimension") == false).collect(Collectors.toList());
        List presetDims = dyObject.stream().filter(x -> (Boolean)x.get("issysdimension")).collect(Collectors.toList());
        ArrayList<DynamicObject> sortedDims = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < sortDims.size(); ++i) {
            for (int j = 0; j < presetDims.size(); ++j) {
                String number = (String)((DynamicObject)presetDims.get(j)).get("number");
                if (!number.toLowerCase(Locale.ENGLISH).equals(sortDims.get(i))) continue;
                sortedDims.add((DynamicObject)presetDims.get(j));
            }
        }
        List sortedUndifineDims = undifineDims.stream().sorted((dim1, dim2) -> dim1.get("shortnumber").toString().compareToIgnoreCase(dim2.get("shortnumber").toString())).collect(Collectors.toList());
        sortedDims.addAll(sortedUndifineDims);
        return sortedDims;
    }

    public static void updateParentIsLeaf(String entityName, long modelId, long parentId) {
        DynamicObject[] parents;
        if (parentId == 0L) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("id", "=", (Object)parentId));
        filter.and(new QFilter("isleaf", "=", (Object)"1"));
        for (DynamicObject parent : parents = BusinessDataServiceHelper.load((String)entityName, (String)"isleaf", (QFilter[])new QFilter[]{filter})) {
            parent.set("isleaf", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])parents);
    }

    public static String getAllUseYear(long modelId) {
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        QFilter filter2 = new QFilter("level", "=", (Object)3);
        DynamicObjectCollection years = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFilter[]{filter1, filter2}, (String)"number");
        StringBuilder sb = new StringBuilder();
        if (years != null && years.size() > 0) {
            sb.append(",");
            years.forEach(y -> sb.append(y.getString("number")).append(","));
        }
        return sb.toString();
    }

    public static List<String> getAllYear(long modelId) {
        return (List)ThreadCache.get((Object)("queryModelYear" + modelId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("level", "=", (Object)3);
            DynamicObjectCollection years = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number", (QFilter[])filter.toArray(), (String)"number");
            return years.stream().map(r -> r.getString("number")).collect(Collectors.toList());
        });
    }

    public static List<String> getAllPeriod(long modelId) {
        return (List)ThreadCache.get((Object)("queryModelPeriod" + modelId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("level", ">=", (Object)2);
            filter.and("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentPeriod", "LastPeriod"}));
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])filter.toArray(), (String)"dseq");
            return periods.stream().map(r -> r.getString("number")).collect(Collectors.toList());
        });
    }

    public static List<String> existsNumber(String entityName, long modelId, long dimensionId, Set<String> numbers) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimensionId));
        filter.and(new QFilter("number", "in", numbers));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filter.toArray());
        return docs.stream().map(m -> m.getString("number")).collect(Collectors.toList());
    }

    public static Map<Long, Map<Long, String>> getCusValuesOfMems(long modelId, Set<Long> ids) {
        HashMap<Long, Map<Long, String>> result = new HashMap<Long, Map<Long, String>>(16);
        if (modelId == 0L || CollectionUtils.isEmpty(ids)) {
            return result;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("member", "in", ids));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_dimcustompro_value", (String)"id, member, custompro, value", (QFilter[])filter.toArray());
        docs.forEach(x -> {
            long member = x.getLong("member");
            String value = x.getString("value");
            if (StringUtils.isNotEmpty((String)value)) {
                Map cusId2Values = result.computeIfAbsent(member, k -> new HashMap(16));
                cusId2Values.put(x.getLong("custompro"), value);
            }
        });
        return result;
    }

    public static void syncCustomValuesOfMembers(long modelId, long dimId, String entityName, List<DynamicObject> listobj) {
        if (modelId == 0L || dimId == 0L || StringUtils.isEmpty((String)entityName) || CollectionUtils.isEmpty(listobj)) {
            return;
        }
        Set<Long> stoIds = listobj.stream().map(x -> Long.parseLong(StructHelper.getSourceId(x))).collect(Collectors.toSet());
        Map<Long, Map<Long, String>> cusValuesOfMems = DimensionServiceHelper.getCusValuesOfMems(modelId, stoIds);
        if (cusValuesOfMems.size() == 0) {
            return;
        }
        HashMap stoId2ShareIds = new HashMap(16);
        listobj.forEach(x -> {
            long stoId = Long.parseLong(StructHelper.getSourceId(x));
            stoId2ShareIds.computeIfAbsent(stoId, k -> new HashSet()).add(x.getLong("id"));
        });
        ArrayList cusDys = new ArrayList(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        cusValuesOfMems.forEach((k, v) -> {
            Set shareIds = (Set)stoId2ShareIds.get(k);
            if (v != null && v.size() > 0) {
                for (Map.Entry next : v.entrySet()) {
                    Long key = (Long)next.getKey();
                    String value = (String)next.getValue();
                    shareIds.forEach(shareId -> {
                        DynamicObject dy = DimensionServiceHelper.newCusValueDy(modelId, dimId, entityName, shareId, key, value, currUserId, date);
                        cusDys.add(dy);
                    });
                }
            }
        });
        if (cusDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])cusDys.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject newCusValueDy(long modelId, long dimId, String entityName, Long memId, Long key, String value, long currUserId, Date date) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimcustompro_value");
        dy.set("model", (Object)modelId);
        dy.set("dimension", (Object)dimId);
        dy.set("member", (Object)memId);
        dy.set("dimtype", (Object)entityName);
        dy.set("custompro", (Object)key);
        dy.set("value", (Object)value);
        dy.set("creator", (Object)currUserId);
        dy.set("modifier", (Object)currUserId);
        dy.set("createtime", (Object)date);
        dy.set("modifytime", (Object)date);
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        return dy;
    }

    private static List<DynamicObject> getSCConfig(long sceneId, long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("id", "=", (Object)sceneId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"scenecslscheme", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            return null;
        }
        return dy.getDynamicObjectCollection("scenecslscheme");
    }

    public static List<Long> buildCslschemeFilter(long modelId, long sceneId) {
        Set<Long> modelIds;
        ArrayList<Long> cslIds = new ArrayList<Long>(10);
        if (modelId == 0L || sceneId == 0L) {
            return cslIds;
        }
        List<DynamicObject> scConfigs = DimensionServiceHelper.getSCConfig(sceneId, modelId);
        if (scConfigs != null && scConfigs.size() > 0) {
            scConfigs.forEach(p -> {
                DynamicObject cslScheme = p.getDynamicObject("fbasedataid");
                if (cslScheme != null) {
                    cslIds.add(cslScheme.getLong("id"));
                }
            });
        }
        if (cslIds.size() > 0) {
            DimensionServiceHelper.filterEnableCslscheme(modelId, cslIds);
        }
        if (!(modelIds = MemberPermHelper.getLimitedModelListByUser()).contains(LongUtil.toLong((Object)modelId))) {
            cslIds.removeAll(CslSchemeServiceHelper.getNoPermCslSchemeIds(modelId));
        }
        return cslIds;
    }

    public static Set<Long> getSceneApplyOrgSchemeIds(long modelId, long sceneId) {
        return (Set)ThreadCache.get((Object)("SceneApplyOrgSchemeIds_" + modelId + "_" + sceneId), () -> {
            DynamicObjectCollection sceneApplyOrgSchemeList;
            HashSet orgSchemeIds = new HashSet(16);
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("id", "=", (Object)sceneId);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"scenecslscheme", (QFilter[])qfBuilder.toArray());
            if (dy != null && (sceneApplyOrgSchemeList = dy.getDynamicObjectCollection("scenecslscheme")) != null && !sceneApplyOrgSchemeList.isEmpty()) {
                sceneApplyOrgSchemeList.forEach(p -> {
                    DynamicObject cslScheme = p.getDynamicObject("fbasedataid");
                    if (cslScheme != null) {
                        orgSchemeIds.add(cslScheme.getLong("id"));
                    }
                });
            }
            return orgSchemeIds;
        });
    }

    private static void filterEnableCslscheme(long modelId, List<Long> cslIds) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("id", "in", cslIds);
        qf.and("isenable", "=", (Object)"0");
        DynamicObjectCollection cslDys = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])qf.toArray());
        cslIds.removeAll(cslDys.stream().map(x -> x.getLong("id")).collect(Collectors.toList()));
    }
}

