/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.DimProcessEntity;
import kd.fi.bcm.business.util.OlapUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class DynamicComputingServiceHelper {
    private static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DynamicComputingServiceHelper.class);

    public static void lockUpgradeModel(long modelId) {
        DLock lock = DLock.create((String)("lockUpgradeModel_" + modelId));
        if (lock.tryLock()) {
            try {
                ParamSettingServiceHelper.save((long)modelId, (String)ConfigEnum.CM006.getNumber(), value -> true);
                DynamicComputingServiceHelper.updateModel(modelId, MemberReader.findModelNumberById((Object)modelId));
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void lockUpgradeModelForChangeCM006(long modelId) {
        DLock lock = DLock.create((String)("lockUpgradeModelForChangeCM006" + modelId));
        if (lock.tryLock()) {
            try {
                ParamSettingServiceHelper.save((long)modelId, (String)ConfigEnum.CM006.getNumber(), value -> true);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void enableModelCM006(long modelId) {
        DLock lock = DLock.create((String)"DynamicComputingServiceHelper_Enable");
        if (lock.tryLock()) {
            try {
                ParamSettingServiceHelper.save((long)modelId, (String)"CM006", value -> true);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void syncModel(long modelId) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        String modelNum = model.getString("number");
        DynamicComputingServiceHelper.updateModelNoScene(modelId, modelNum);
        DynamicComputingServiceHelper.syncStorageTypeOfScene(modelNum);
    }

    private static void syncStorageTypeOfScene(String modelNum) {
        String dimNum = SysDimensionEnum.Scenario.getNumber();
        DynamicObjectCollection memCollection = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id, number,storagetype", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).and(new QFilter("dimension.number", "=", (Object)dimNum)).and(new QFilter("status", "!=", (Object)"A")).toArray());
        HashMap<String, MemberStorageTypes> storageMap = new HashMap<String, MemberStorageTypes>(memCollection.size());
        for (DynamicObject dyn : memCollection) {
            String storageType = dyn.getString("storagetype");
            String number = dyn.getString("number");
            if (StorageTypeEnum.SHARE.getOIndex().equals(storageType)) continue;
            if (storageType.equalsIgnoreCase("2") || storageType.equalsIgnoreCase("4")) {
                storageMap.put(number, MemberStorageTypes.Stored);
                continue;
            }
            if (!storageType.equalsIgnoreCase("5")) continue;
            storageMap.put(number, MemberStorageTypes.DynamicCalc);
        }
        OlapServiceHelper.batchAlterMemberStorageType(modelNum, dimNum, storageMap);
    }

    @Deprecated
    public static void upgradeAllModel() {
        QFilter appfilter = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.getOIndex()).or("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{appfilter});
        for (DynamicObject model : doc) {
            long modelId = model.getLong("id");
            String modelNum = model.getString("number");
            DynamicComputingServiceHelper.updateModel(modelId, modelNum);
        }
    }

    public static void updateModel(long modelId, String modelNum) {
        DynamicObjectCollection dimCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, memberform", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        BatchProcessHelper.handle((List)dimCollection, dimObj -> {
            String dimNum = dimObj.getString("number");
            LOG.info(String.format("sync_olap_model [%s] with dimension: [%s] begin", modelNum, dimNum));
            long tick = System.currentTimeMillis();
            DynamicComputingServiceHelper.repairModelByDim(modelNum, dimNum, true);
            LOG.info(String.format("sync_olap_model [%s] with dimension: [%s] cost time: %s", modelNum, dimNum, System.currentTimeMillis() - tick));
            return null;
        }, (Integer)DynamicComputingServiceHelper.getTimeoutSeconds(3600));
    }

    public static void updateModelNoScene(long modelId, String modelNum) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "!=", (Object)SysDimensionEnum.Scenario.getNumber());
        DynamicObjectCollection dimCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, memberform", (QFilter[])qFilter.toArray());
        BatchProcessHelper.handle((List)dimCollection, dimObj -> {
            String dimNum = dimObj.getString("number");
            LOG.info(String.format("sync_olap_model [%s] with dimension: [%s] begin", modelNum, dimNum));
            long tick = System.currentTimeMillis();
            DynamicComputingServiceHelper.repairModelByDim(modelNum, dimNum, true);
            LOG.info(String.format("sync_olap_model [%s] with dimension: [%s] cost time: %s", modelNum, dimNum, System.currentTimeMillis() - tick));
            return null;
        }, (Integer)DynamicComputingServiceHelper.getTimeoutSeconds(3600));
    }

    public static void repairModelByScope(String modelNum, String dimNum, boolean isAll, DynamicObjectCollection members) {
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        if (ICVersionServiceHelper.isICVersion(modelId, dimNum)) {
            BatchProcessHelper.handleAsync(() -> ICVersionServiceHelper.batchSynchroMemberSlowEvolving(modelId));
            return;
        }
        HashMap<String, MemberStorageTypes> storageMap = new HashMap<String, MemberStorageTypes>(members.size());
        HashMap<Long, PairList> parentChildrenMap = new HashMap<Long, PairList>(members.size());
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(members.size());
        for (DynamicObject dyn : members) {
            long pid = dyn.getLong("parent.id");
            String number = dyn.getString("number");
            if (pid != 0L) {
                parentChildrenMap.computeIfAbsent(pid, k -> new PairList()).addPair((Object)number, (Object)dyn.getInt("aggoprt"));
            }
            boolean isLeaf = dyn.getBoolean("isleaf");
            if (DimEntityNumEnum.INTERCOMPANY.getNumber().equals(dimNum) && isLeaf) continue;
            String storageType = dyn.getString("storagetype");
            if (StorageTypeEnum.SHARE.getOIndex().equals(storageType)) continue;
            long id = dyn.getLong("id");
            if (isAll) {
                parentChildrenMap.computeIfAbsent(id, k -> new PairList());
            }
            if (isAll || !isLeaf) {
                if (storageType.equalsIgnoreCase("2") || storageType.equalsIgnoreCase("4")) {
                    storageMap.put(number, MemberStorageTypes.Stored);
                } else if (storageType.equalsIgnoreCase("5")) {
                    storageMap.put(number, MemberStorageTypes.DynamicCalc);
                }
            }
            idNumberMap.put(id, number);
        }
        if (!storageMap.isEmpty()) {
            OlapServiceHelper.batchAlterMemberStorageType(modelNum, dimNum, storageMap);
        }
        HashMap<String, List<AggFactorMetadataItem>> aggMap = new HashMap<String, List<AggFactorMetadataItem>>(16);
        for (Map.Entry entry : parentChildrenMap.entrySet()) {
            String number = (String)idNumberMap.get(entry.getKey());
            if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
            PairList children = (PairList)entry.getValue();
            ArrayList<AggFactorMetadataItem> factorList = new ArrayList<AggFactorMetadataItem>(children.size());
            HashSet<Object> checkRepeat = new HashSet<Object>(children.size());
            for (Pair pair : children) {
                if (!checkRepeat.add(pair.p1)) continue;
                factorList.add(OlapUtils.createAggFactorMetadataItem((String)pair.p1, (Integer)pair.p2));
            }
            aggMap.put(number, factorList);
        }
        if (!aggMap.isEmpty()) {
            OlapServiceHelper.batchRepairAggFactor(modelNum, dimNum, aggMap);
        }
        if (DimEntityNumEnum.ENTITY.getNumber().equals(dimNum) && ConfigServiceHelper.getBoolParam(modelNum, "CM006")) {
            OlapServiceHelper.repairEntityWithParentFactor(modelNum, members.stream().map(x -> x.getString("number")).collect(Collectors.toSet()));
        }
        if (DimEntityNumEnum.ENTITY.getNumber().equals(dimNum) || DimEntityNumEnum.PROCESS.getNumber().equals(dimNum)) {
            OlapServiceHelper.setProcessShieldRule(modelNum);
        }
        if (DimEntityNumEnum.INTERCOMPANY.getNumber().equals(dimNum)) {
            ShareNodeStructSyncHelper.syncICNodeStorageType(modelId, MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum));
        }
        DimProcessEntity.aggEIRptAndEAdj(modelNum);
    }

    public static void repairModelByParents(String modelNum, String dimNum, boolean isAll, Collection<Long> parents) {
        DynamicObjectCollection docs;
        if (CollectionUtils.isEmpty(parents)) {
            return;
        }
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        if (isAll) {
            List longNumbers = parents.stream().map(m -> MemberReader.findMemberById((String)modelNum, (String)entityName, (Long)m).getLongNumber()).collect(Collectors.toList());
            QFilter filter = new QFilter("model.number", "=", (Object)modelNum).and(new QFilter("status", "!=", (Object)"A"));
            QFilter nFilter = new QFilter("longnumber", "like", (Object)((String)longNumbers.get(0) + "%"));
            if (longNumbers.size() > 1) {
                for (int i = 1; i < longNumbers.size(); ++i) {
                    nFilter.or(new QFilter("longnumber", "like", (Object)((String)longNumbers.get(i) + "%")));
                }
            }
            docs = QueryServiceHelper.query((String)entityName, (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])new QFilter[]{filter, nFilter});
        } else {
            docs = QueryServiceHelper.query((String)entityName, (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])new QFilter[]{new QFilter("id", "in", parents).or(new QFilter("parent", "in", parents)), new QFilter("status", "!=", (Object)"A")});
            docs.forEach(e -> e.set("isleaf", (Object)(parents.contains(e.getLong("id")) ? 0 : 1)));
        }
        if (docs != null && docs.size() > 0) {
            DynamicComputingServiceHelper.repairModelByScope(modelNum, dimNum, isAll, docs);
        }
    }

    public static void repairModelByDim(String modelNum, String dimNum, boolean isAll) {
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        if ("bcm_structofextend".equals(entityName)) {
            return;
        }
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        if (ICVersionServiceHelper.isICVersion(modelId, dimNum)) {
            ICVersionServiceHelper.batchSynchroMemberSlowEvolving(modelId);
            return;
        }
        QFilter filter = new QFilter("model.number", "=", (Object)modelNum);
        filter.and(new QFilter("dimension.number", "=", (Object)dimNum));
        filter.and(new QFilter("status", "!=", (Object)"A"));
        if ("bcm_entitymembertree".equals(entityName)) {
            filter.and(new QFilter("isexchangerate", "=", (Object)"0"));
        }
        DynamicObjectCollection memCollection = QueryServiceHelper.query((String)entityName, (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])filter.toArray());
        DynamicComputingServiceHelper.repairModelByScope(modelNum, dimNum, isAll, memCollection);
        if (DimEntityNumEnum.YEAR.getNumber().equalsIgnoreCase(dimNum)) {
            DynamicObject dimensionDy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, model.id", (QFilter[])new QFilter[]{new QFilter("model.number", "=", (Object)modelNum), new QFilter("number", "=", (Object)DimEntityNumEnum.YEAR.getNumber())});
            long dimensionId = dimensionDy.getLong("id");
            DynamicComputingServiceHelper.syncMemberShieldRule(modelId, dimensionId, memCollection);
        }
    }

    private static void syncMemberShieldRule(long modelId, long dimensionId, DynamicObjectCollection members) {
        if (CollectionUtils.isEmpty((Collection)members)) {
            return;
        }
        members.stream().filter(x -> StorageTypeEnum.STORAGE.index.equals(x.getString("storagetype")) || StorageTypeEnum.UNSHARE.index.equals(x.getString("storagetype"))).forEach(x -> {
            String shieldDim = ShieldRuleBulider.getRuleStrByMem(dimensionId, x.get("id"));
            if (StringUtils.isNotEmpty((CharSequence)shieldDim)) {
                ShieldRuleBulider srb = new ShieldRuleBulider(modelId);
                long srid = srb.getShieldRule(dimensionId, shieldDim);
                srb.save(dimensionId, x.getLong("id"), srid);
            }
        });
    }

    public static int getTimeoutSeconds(int defaultTimeout) {
        try {
            return Integer.parseInt(ConfigServiceHelper.getStringParamNoModel("timeoutSeconds"));
        }
        catch (NumberFormatException ex) {
            return defaultTimeout;
        }
    }
}

