/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtDimensionHelper {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ExtDimensionHelper.class);
    private static final Set<String> CvtDataTypes = Sets.newHashSet((Object[])new String[]{DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.ENUMTP.getOIndex()});

    public static List<Long> getIdsByIds(Collection<Long> ids) {
        String id = "id";
        return QueryServiceHelper.query((String)"bcm_structofextend", (String)"id", (QFilter[])new QFBuilder(id, "in", ids).toArray()).stream().map(dynamicObject -> dynamicObject.getLong(id)).collect(Collectors.toList());
    }

    public static Map<Long, String> getExtGroupByGroupType(Long modelId, String groupType) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelId).and("grouptype", "=", (Object)groupType).and("level", "=", (Object)2);
        DynamicObjectCollection extGroupObjects = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id, name", (QFilter[])new QFilter[]{qfilter});
        return extGroupObjects.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
    }

    public static DynamicObject getExtGroupByNumber(Long modelId, String groupNum) {
        return (DynamicObject)ThreadCache.get((Object)("extgroupbynumber" + modelId + groupNum), () -> {
            QFilter qfilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)groupNum);
            DynamicObject extGroupObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, number,grouptype, isparticipmerge", (QFilter[])new QFilter[]{qfilter});
            return extGroupObject;
        });
    }

    public static Map<String, DynamicObject> getExtMemberByNumbers(Long modelId, String groupNum, Collection<String> numbers) {
        DynamicObjectCollection data = ExtDimensionHelper.getExtMemberTree(modelId, groupNum);
        return data.stream().filter(s -> numbers.contains(s.getString("number"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), Function.identity()));
    }

    private static DynamicObjectCollection getExtMemberTree(Long modelId, String groupNum) {
        DynamicObject extGroup = ExtDimensionHelper.getExtGroupByNumber(modelId, groupNum);
        if (extGroup == null) {
            return new DynamicObjectCollection();
        }
        return (DynamicObjectCollection)ThreadCache.get((Object)("ExtMemberTree" + modelId + groupNum), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId).and("parent", "=", (Object)extGroup.getLong("id"));
            return QueryServiceHelper.query((String)"bcm_structofextend", (String)"number, fieldmapped, datatype, enumitem,exchange,isparticipmerge", (QFilter[])new QFilter[]{filter});
        });
    }

    public static Map<String, DynamicObject> getExtMemberForEnumType(Long modelId, String groupNum, Collection<String> numbers) {
        Map<String, DynamicObject> extMemberMap = ExtDimensionHelper.getExtMemberByNumbers(modelId, groupNum, numbers);
        if (MapUtils.isNotEmpty(extMemberMap)) {
            return extMemberMap.values().stream().filter(dynamicObject -> DataTypeEnum.ENUMTP.getOIndex().equals(dynamicObject.getString("datatype"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), Function.identity()));
        }
        return Maps.newHashMap();
    }

    public static Map<String, List<DynamicObject>> getExtMemberEnumValueByNumber(Long modelId, String groupNum, Collection<String> numbers) {
        Map<String, DynamicObject> queryMap = ExtDimensionHelper.getExtMemberForEnumType(modelId, groupNum, numbers);
        HashMap extMemberEnumValueMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(queryMap)) {
            ArrayList enumItemIds = Lists.newArrayList();
            queryMap.values().stream().forEach(dynamicObject -> enumItemIds.add(dynamicObject.getLong("enumitem")));
            QFilter filter = new QFilter("model", "=", (Object)modelId).and("enumitemid", "in", (Object)enumItemIds);
            DynamicObjectCollection enumValues = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id, enumvalue, name, enumitemid,dseq", (QFilter[])new QFilter[]{filter}, (String)"dseq");
            if (enumValues != null && enumValues.size() != 0) {
                Map<Long, List<DynamicObject>> valueMap = enumValues.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("enumitemid")));
                queryMap.forEach((number, dynamicObject) -> extMemberEnumValueMap.put(number, valueMap.get(dynamicObject.getLong("enumitem"))));
            }
        }
        return extMemberEnumValueMap;
    }

    public static Map<String, String> getExtMemberForNumberType(Long modelId, String groupNum, Collection<String> numbers) {
        Map<String, DynamicObject> extMemberMap = ExtDimensionHelper.getExtMemberByNumbers(modelId, groupNum, numbers);
        if (MapUtils.isNotEmpty(extMemberMap)) {
            return extMemberMap.values().stream().filter(dynamicObject -> ExtDimensionHelper.isConvertDataType(modelId, dynamicObject)).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("exchange")));
        }
        return Maps.newHashMap();
    }

    public static Map<String, String> getExtMemberDataType(Long modelId, String groupNum, Collection<String> numbers) {
        Map<String, DynamicObject> extMemberMap = ExtDimensionHelper.getExtMemberByNumbers(modelId, groupNum, numbers);
        if (MapUtils.isNotEmpty(extMemberMap)) {
            return extMemberMap.values().stream().filter(dynamicObject -> ExtDimensionHelper.isConvertDataType(modelId, dynamicObject)).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
        }
        return Maps.newHashMap();
    }

    private static boolean isConvertDataType(long modelId, DynamicObject dynamicObject) {
        boolean canDoConvert = false;
        if (CvtDataTypes.contains(dynamicObject.getString("datatype"))) {
            if (Objects.equals(dynamicObject.getString("datatype"), DataTypeEnum.ENUMTP.getOIndex())) {
                Map<Long, String> enumItemDataTypeMap = ExtDimensionHelper.getExtendDimEnumItemDataType(modelId);
                if (DataTypeEnum.CURRENCY.getOIndex().equals(enumItemDataTypeMap.get(dynamicObject.getLong("enumitem")))) {
                    canDoConvert = true;
                }
            } else {
                canDoConvert = true;
            }
        }
        return canDoConvert;
    }

    private static Map<Long, String> getExtendDimEnumItemDataType(long modelId) {
        return (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("ExtendDimEnum" + modelId), () -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            DynamicObject extendDim = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])qFilter.toArray());
            if (extendDim != null) {
                qFilter.and("dimension", "=", (Object)extendDim.getLong("id"));
                DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])qFilter.toArray());
                return list.stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r.getString("datatype")));
            }
            return Maps.newHashMap();
        });
    }

    public static void clearCommonCacheForExtendDimEnumItemDataType(long modelId) {
        CacheGenFactory.getCommonCache().invalidateByKey("ExtendDimEnum" + modelId);
    }

    public static Tuple<Integer, Integer, Integer> getTypeDataByGroupType(Integer numMax, Integer textMax, Integer dateMax, String groupType) {
        String sumMax = ConfigServiceHelper.getStringParamNoModel("ExtFieldNum");
        if (StringUtils.isEmpty((CharSequence)sumMax)) {
            sumMax = "{n:40,t:30,d:5,tn:40,tt:30,td:5,en:80,et:30,ed:5}";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)sumMax);
        if ("1".equals(groupType)) {
            numMax = jsonObject.getInteger("n");
            textMax = jsonObject.getInteger("t");
            dateMax = jsonObject.getInteger("d");
        } else if ("2".equals(groupType)) {
            numMax = jsonObject.getInteger("tn");
            textMax = jsonObject.getInteger("tt");
            dateMax = jsonObject.getInteger("td");
        } else if ("3".equals(groupType)) {
            numMax = jsonObject.getInteger("en");
            textMax = jsonObject.getInteger("et");
            dateMax = jsonObject.getInteger("ed");
        }
        Tuple tuple = Tuple.create((Object)numMax, (Object)textMax, (Object)dateMax);
        return tuple;
    }

    public static boolean checkIsExistOfField(String fieldName, String groupType) {
        String field = "f" + fieldName;
        String table = "1".equals(groupType) ? "t_bcm_extenddata" : "t_bcm_extenddata_bus";
        List columns = DB.getColumnNames((DBRoute)DBRoute.of((String)"bcm"), (String)table);
        if (columns == null || columns.size() == 0) {
            return false;
        }
        if (!columns.stream().anyMatch(x -> x.equalsIgnoreCase(field))) {
            LOG.error(String.format("checkIsExistOfField param fieldName\uff1a%s\uff0cgroupType\uff1a%s", fieldName, groupType));
            return false;
        }
        return true;
    }

    public static DynamicObjectCollection getSheetExtMemberByExtModel(long modelId, Set<String> numbers, Long extModelId) {
        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"extendsgroup.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extModelId)});
        if (extModel == null) {
            return new DynamicObjectCollection();
        }
        long parentId = extModel.getLong("extendsgroup.id");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("parent", "=", (Object)parentId);
        if (numbers != null) {
            qfBuilder.and("number", "in", numbers);
        }
        return QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name,datatype,parent", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection getSheetExtMemberByTemplate(long modelId, Set<String> numbers, Long templateId) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", "extdimid"), (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        if (template == null) {
            return new DynamicObjectCollection();
        }
        long extModelId = template.getLong("extdimid");
        return ExtDimensionHelper.getSheetExtMemberByExtModel(modelId, numbers, extModelId);
    }

    public static List<DynamicObject> savePreSharedMembers(List<DynamicObject> extDimMembs) {
        DynamicObject[] dyMems;
        if (CollectionUtils.isEmpty(extDimMembs)) {
            return new ArrayList<DynamicObject>(0);
        }
        QFilter qf = new QFilter("model", "=", (Object)extDimMembs.get(0).getLong("model"));
        qf.and("number", "in", Arrays.asList("INTR_000", "INTR_001"));
        qf.and("storagetype", "=", (Object)StorageTypeEnum.STORAGE.getOIndex());
        String selectedFields = "id,number,longnumber,name,parent,copyfrom,storagetype,level,simplename,description,model,storagetype,fieldmapped,issysmember,enumitem,dimension,exchange,entryrate,datatype,creator,createtime,modifier,modifytime,status,enable,isleaf,dseq";
        DynamicObject[] storageMems = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)selectedFields, (QFilter[])qf.toArray(), (String)"number");
        if (storageMems.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(extDimMembs.size() << 1);
        ArrayList<DynamicObject> dyTrees = new ArrayList<DynamicObject>(extDimMembs.size() << 1);
        for (DynamicObject extDimMemb : extDimMembs) {
            for (int i = 0; i < storageMems.length; ++i) {
                DynamicObject storageMem = storageMems[i];
                DynamicObject shareMem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membofextend");
                shareMem.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                shareMem.set("name", storageMem.get("name"));
                shareMem.set("number", (Object)storageMem.getString("number"));
                shareMem.set("simplename", storageMem.get("simplename"));
                shareMem.set("dimension", storageMem.get("dimension"));
                shareMem.set("model", storageMem.get("model"));
                shareMem.set("model", storageMem.get("model"));
                shareMem.set("creator", (Object)currUserId);
                shareMem.set("createtime", (Object)date);
                shareMem.set("modifier", (Object)currUserId);
                shareMem.set("modifytime", (Object)date);
                shareMem.set("status", (Object)"C");
                shareMem.set("enable", (Object)"1");
                dys.add(shareMem);
                DynamicObject shareMemTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
                shareMemTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                shareMemTree.set("number", (Object)storageMem.getString("number"));
                shareMemTree.set("name", storageMem.get("name"));
                shareMemTree.set("longnumber", (Object)(extDimMemb.getString("longnumber") + '!' + storageMem.getString("number")));
                shareMemTree.set("parent", (Object)extDimMemb.getLong("id"));
                shareMemTree.set("copyfrom", (Object)storageMem.getLong("id"));
                shareMemTree.set("storagetype", (Object)StorageTypeEnum.SHARE.getOIndex());
                shareMemTree.set("level", storageMem.get("level"));
                shareMemTree.set("simplename", storageMem.get("simplename"));
                shareMemTree.set("description", storageMem.get("description"));
                shareMemTree.set("model", (Object)((DynamicObject)storageMem.get("model")).getLong("id"));
                shareMemTree.set("enumitem", storageMem.get("enumitem"));
                shareMemTree.set("dimension", storageMem.get("dimension"));
                shareMemTree.set("exchange", storageMem.get("exchange"));
                shareMemTree.set("entryrate", storageMem.get("entryrate"));
                shareMemTree.set("datatype", storageMem.get("datatype"));
                shareMemTree.set("fieldmapped", (Object)("textext" + (i + 1)));
                ExtDimensionHelper.setSeqValue(shareMemTree, dyTrees);
                shareMemTree.set("issysmember", (Object)"0");
                shareMemTree.set("creator", (Object)currUserId);
                shareMemTree.set("createtime", (Object)date);
                shareMemTree.set("modifier", (Object)currUserId);
                shareMemTree.set("modifytime", (Object)date);
                shareMemTree.set("status", (Object)"C");
                shareMemTree.set("enable", (Object)"1");
                shareMemTree.set("isleaf", (Object)"1");
                dyTrees.add(shareMemTree);
            }
        }
        for (DynamicObject dyMem : dyMems = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dys.toArray(new DynamicObject[0]))) {
            for (DynamicObject dyTree : dyTrees) {
                if (!dyMem.getString("number").equals(dyTree.getString("number"))) continue;
                dyTree.set("member", (Object)dyMem.getLong("id"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyTrees.toArray(new DynamicObject[0]));
        return dyTrees;
    }

    public static void setSeqValue(DynamicObject extDimMemb, List<DynamicObject> dyTrees) {
        int seq;
        QFilter qFilter = new QFilter("model", "=", (Object)extDimMemb.getLong("model"));
        qFilter.and("parent", "=", (Object)extDimMemb.getLong("parent"));
        DynamicObjectCollection seqs = QueryServiceHelper.query((String)"bcm_structofextend", (String)"dseq", (QFilter[])new QFilter[]{qFilter});
        int max = -1;
        for (DynamicObject dynamicObject : seqs) {
            seq = dynamicObject.getInt("dseq");
            max = max > seq ? max : seq;
        }
        if (dyTrees.size() > 0) {
            for (DynamicObject dyTree : dyTrees) {
                seq = dyTree.getInt("dseq");
                max = max > seq ? max : seq;
            }
        }
        AtomicInteger at = new AtomicInteger(max);
        at.getAndIncrement();
        extDimMemb.set("dseq", (Object)at.get());
    }
}

