/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.OlapPresetHelper;
import kd.fi.bcm.business.dimension.model.ImportDataInfo;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.poi.util.StringUtil;

public class ImportJsonServiceHelper {
    private static final Set<String> strDataTypes = Sets.newHashSet((Object[])new String[]{"CHAR", "VARCHAR2", "NVARCHAR2", "VARCHAR", "NVARCHAR", "NCHAR", "char", "varchar", "bpchar"});
    private static final Set<String> nullAble = Sets.newHashSet((Object[])new String[]{"N", "NO"});
    private static final Set<String> dateDataTypes = Sets.newHashSet((Object[])new String[]{"DATE", "TIMESTAMP", "timestamp", "datetime"});
    private static Set<String> decDataTypes = Sets.newHashSet((Object[])new String[]{"decimal", "DECIMAL", "numeric"});
    private static final Set<String> numDataTypes = Sets.newHashSet((Object[])new String[]{"INT", "NUMBER", "INTEGER", "FLOAT", "bigint", "int", "int2", "int4", "int8"});
    private static final Set<String> changeDateFields = Sets.newHashSet((Object[])new String[]{"FMODIFYTIME", "FCREATETIME", "FMODIFYDATE", "FCREATEDATE"});

    private static void importData(String table, JSONArray jsonArr, String entity, Map<String, ImportDataInfo> infoMap) {
        List columnNames = JSONObject.parseArray((String)((JSONArray)jsonArr.get(0)).toJSONString(), String.class);
        List newColumnNames = columnNames.stream().filter(p -> infoMap.containsKey(p)).collect(Collectors.toList());
        String fields = String.join((CharSequence)",", newColumnNames);
        StringBuilder strflag = new StringBuilder();
        for (String col : newColumnNames) {
            strflag.append("?,");
        }
        String conditions = strflag.substring(0, strflag.length() - 1);
        String sql = "insert into " + table + " (" + fields + ")  values (" + conditions + ")";
        ArrayList<Object[]> conditionList = new ArrayList<Object[]>(10);
        ArrayList<Object> vList = new ArrayList<Object>(newColumnNames.size());
        for (int i = 1; i < jsonArr.size(); ++i) {
            JSONArray jsonArray = (JSONArray)jsonArr.get(i);
            if (null == jsonArray || jsonArray.size() <= 0) continue;
            vList.clear();
            for (int j = 0; j < jsonArray.size(); ++j) {
                Object value = (String)jsonArray.get(j);
                String field = (String)columnNames.get(j);
                if (infoMap.get(field) == null) continue;
                if (value == null && nullAble.contains(infoMap.get(field).getNullAble())) {
                    value = strDataTypes.contains(infoMap.get(field).getDataType()) ? (null != infoMap.get(field).getDataDefault() ? infoMap.get(field).getDataDefault() : " ") : (numDataTypes.contains(infoMap.get(field).getDataType()) ? (null != infoMap.get(field).getDataDefault() ? infoMap.get(field).getDataDefault() : Integer.valueOf(0)) : (dateDataTypes.contains(infoMap.get(field).getDataType()) ? ImportJsonServiceHelper.getSQLDate(TimeServiceHelper.now()) : Integer.valueOf(0)));
                }
                if (value != null && numDataTypes.contains(infoMap.get(field).getDataType())) {
                    value = "0".equals(infoMap.get(field).getScale()) ? Long.valueOf(value.toString()) : ("2".equals(infoMap.get(field).getScale()) ? BigDecimal.valueOf(Double.parseDouble(value.toString())).stripTrailingZeros() : BigDecimal.valueOf(Double.parseDouble(value.toString())));
                }
                if (value != null && decDataTypes.contains(infoMap.get(field).getDataType())) {
                    value = BigDecimal.valueOf(Double.parseDouble(value.toString()));
                }
                if (value != null && dateDataTypes.contains(infoMap.get(field).getDataType())) {
                    value = ImportJsonServiceHelper.strToDate(value.toString());
                }
                if (changeDateFields.contains(field)) {
                    value = ImportJsonServiceHelper.getSQLDate(TimeServiceHelper.now());
                } else if ("fcreatorid".equalsIgnoreCase(field) || "fmodifierid".equalsIgnoreCase(field)) {
                    value = Long.valueOf(RequestContext.get().getUserId());
                }
                if ("t_bcm_model".equalsIgnoreCase(table)) {
                    if ("fdatasource".equalsIgnoreCase(field)) {
                        int index = ((JSONArray)jsonArr.get(0)).indexOf((Object)"FNUMBER");
                        if (index != -1) {
                            String cubeName = ((JSONArray)jsonArr.get(1)).getString(index);
                            ModelDataClearUtils.reMoveCatalogCache(cubeName);
                            Long dataSource = OlapServiceHelper.selectDatasource(true);
                            if (dataSource.equals(0L)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684OLAP\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"ImportJsonServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                            }
                            value = dataSource;
                        }
                    } else if ("fcreatorid".equalsIgnoreCase(field) || "fmodifierid".equalsIgnoreCase(field)) {
                        value = Long.valueOf(RequestContext.get().getUserId());
                    }
                }
                vList.add(value);
            }
            conditionList.add(vList.toArray());
        }
        if (conditionList.size() > 0) {
            ImportJsonServiceHelper.deleteBatch(jsonArr, table, entity, infoMap);
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, conditionList);
        }
    }

    public static void importSave(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        Set<String> getAllEntityTable = ModelDataClearUtils.getAllEntityTable();
        HashSet<String> executeTables = new HashSet<String>(64);
        for (String strEntityName : getAllEntityTable) {
            JSONObject entityData = jsonObject.getJSONObject(strEntityName);
            if (entityData == null || entityData.isEmpty() || "bcm_modelperm".equals(strEntityName)) continue;
            for (Map.Entry entry : entityData.entrySet()) {
                JSONArray jsonArr;
                String table = (String)entry.getKey();
                if (executeTables.contains(table.toLowerCase(Locale.ENGLISH)) || (jsonArr = (JSONArray)entry.getValue()).isEmpty() || !DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)table)) continue;
                List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)table);
                Map<String, ImportDataInfo> infoMap = ImportJsonServiceHelper.getDataInfo(table.toUpperCase(Locale.ENGLISH), columnNames);
                ImportJsonServiceHelper.importData(table, jsonArr, strEntityName, infoMap);
                executeTables.add(table.toLowerCase(Locale.ENGLISH));
            }
        }
    }

    private static Map<String, ImportDataInfo> getDataInfo(String table, List<String> columnNames) {
        HashMap<String, ImportDataInfo> dataMap = new HashMap<String, ImportDataInfo>(20);
        String sql = "select " + StringUtil.join((Object[])columnNames.toArray(), (String)",") + " from " + table;
        DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql, x -> {
            ResultSetMetaData metaData = x.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnType = metaData.getColumnTypeName(i);
                String columnName = metaData.getColumnName(i);
                int isNullable = metaData.isNullable(i);
                int scale = metaData.getScale(i);
                int precision = metaData.getPrecision(i);
                String nullable = isNullable == 0 ? "N" : "Y";
                ImportDataInfo info = new ImportDataInfo();
                info.setColumnName(columnName.toUpperCase(Locale.ENGLISH));
                info.setDataType(columnType);
                info.setNullAble(nullable);
                info.setDataLength(precision + "");
                info.setScale(scale + "");
                dataMap.put(columnName.toUpperCase(Locale.ENGLISH), info);
            }
            return null;
        });
        return dataMap;
    }

    public static String changeModelPerm(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject modelObj = (JSONObject)jsonObject.get((Object)"bcm_model");
        JSONArray model = (JSONArray)modelObj.getJSONArray("t_bcm_model").get(0);
        int index = model.indexOf((Object)"FID");
        if (index != -1) {
            Long modelid = Long.parseLong(((JSONArray)modelObj.getJSONArray("t_bcm_model").get(1)).getString(index));
            QFilter filter = new QFilter("model", "=", (Object)modelid);
            DynamicObject modelPerm = BusinessDataServiceHelper.loadSingle((String)"bcm_modelperm", (String)"id,model,createtime,modifytime,creator,modifier,username,modelpermentry,modelpermentry.seq,modelpermentry.etype,modelpermentry.eusers", (QFilter[])new QFilter[]{filter});
            if (modelPerm == null) {
                modelPerm = BusinessDataServiceHelper.newDynamicObject((String)"bcm_modelperm");
                modelPerm.set("id", (Object)DBServiceHelper.genGlobalLongId());
                modelPerm.set("model", (Object)modelid);
            }
            RequestContext tx = RequestContext.get();
            String userId = tx.getUserId();
            Date time = ImportJsonServiceHelper.getSQLDate(TimeServiceHelper.now());
            modelPerm.set("createtime", (Object)time);
            modelPerm.set("modifytime", (Object)time);
            modelPerm.set("creator", (Object)userId);
            modelPerm.set("modifier", (Object)userId);
            modelPerm.set("username", (Object)tx.getUserName());
            DynamicObjectCollection permEntrys = modelPerm.getDynamicObjectCollection("modelpermentry");
            permEntrys.clear();
            if ("0".equals(tx.getUserId()) || StringUtils.isEmpty((String)tx.getUserId())) {
                DynamicObject dyuser = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)"13466739").toArray());
                Long ierpid = dyuser.getLong("id");
                String username = dyuser.getString("name");
                modelPerm.set("creator", (Object)ierpid);
                modelPerm.set("modifier", (Object)ierpid);
                modelPerm.set("username", (Object)username);
                DynamicObject permEntry1 = new DynamicObject(permEntrys.getDynamicObjectType());
                permEntry1.set("id", (Object)DBServiceHelper.genGlobalLongId());
                permEntry1.set("seq", (Object)1);
                permEntry1.set("etype", (Object)"bos_user");
                permEntry1.set("eusers", (Object)ierpid);
                permEntrys.add((Object)permEntry1);
            } else {
                DynamicObject permEntry = new DynamicObject(permEntrys.getDynamicObjectType());
                permEntry.set("id", (Object)DBServiceHelper.genGlobalLongId());
                permEntry.set("seq", (Object)2);
                permEntry.set("etype", (Object)"bos_user");
                permEntry.set("eusers", (Object)tx.getUserId());
                permEntrys.add((Object)permEntry);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{modelPerm});
            return "" + modelid;
        }
        return null;
    }

    public static void addAllRootPermByUser(String modelid) {
        if (modelid != null) {
            BcmFunPermissionHelper.addAllRootPermByUser(String.valueOf(modelid), RequestContext.get().getUserId(), ApplicationTypeEnum.CM);
        }
    }

    private static Date strToDate(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date date = null;
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return ImportJsonServiceHelper.getSQLDate(date);
    }

    private static Date getSQLDate(java.util.Date now) {
        return new Date(now.getTime());
    }

    public static void createCube(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject modelObj = (JSONObject)jsonObject.get((Object)"bcm_model");
        JSONObject dimensionObj = (JSONObject)jsonObject.get((Object)"bcm_dimension");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        JSONArray model = (JSONArray)modelObj.getJSONArray("t_bcm_model").get(0);
        JSONArray model_L = (JSONArray)modelObj.getJSONArray("t_bcm_model_l").get(0);
        int idIndex = model.indexOf((Object)"FID");
        int numberIndex = model.indexOf((Object)"FNUMBER");
        int nameIndex = model_L.indexOf((Object)"FNAME");
        int shownumberIndex = model.indexOf((Object)"FSHOWNUMBER");
        if (numberIndex != -1 && nameIndex != -1 && shownumberIndex != -1) {
            String id = ((JSONArray)modelObj.getJSONArray("t_bcm_model").get(1)).getString(idIndex);
            String cube_catalog = ((JSONArray)modelObj.getJSONArray("t_bcm_model").get(1)).getString(numberIndex);
            String name = ((JSONArray)modelObj.getJSONArray("t_bcm_model_l").get(1)).getString(nameIndex);
            String shownumber = ((JSONArray)modelObj.getJSONArray("t_bcm_model").get(1)).getString(shownumberIndex);
            dy.set("number", (Object)cube_catalog);
            dy.set("name", (Object)name);
            dy.set("shownumber", (Object)shownumber);
            OlapServiceHelper.createCubeSchemes(dy);
            JSONArray dimensionArr = dimensionObj.getJSONArray("t_bcm_dimension");
            JSONArray dimension = (JSONArray)dimensionArr.get(0);
            int number = dimension.indexOf((Object)"FNUMBER");
            int dimensionidIndex = dimension.indexOf((Object)"FID");
            int shortNumber = dimension.indexOf((Object)"FSHORTNUMBER");
            int memberModel = dimension.indexOf((Object)"FMEMBERMODEL");
            int memberTable = dimension.indexOf((Object)"FMEMBERTABLE");
            for (int i = 1; i < dimensionArr.size(); ++i) {
                String dimensionNumber = ((JSONArray)dimensionArr.get(i)).getString(number);
                String dimensionid = ((JSONArray)dimensionArr.get(i)).getString(dimensionidIndex);
                String dimensionShortNumber = ((JSONArray)dimensionArr.get(i)).getString(shortNumber);
                String dimensionModel = ((JSONArray)dimensionArr.get(i)).getString(memberModel);
                String tableName = ((JSONArray)dimensionArr.get(i)).getString(memberTable).toLowerCase(Locale.ENGLISH);
                JSONObject treeObj = (JSONObject)jsonObject.get((Object)dimensionModel);
                JSONArray tableArr = (JSONArray)treeObj.get((Object)tableName);
                JSONArray tableArrNum = (JSONArray)tableArr.get(0);
                int numIndex = tableArrNum.indexOf((Object)"FNUMBER");
                int longnumIndex = tableArrNum.indexOf((Object)"FLONGNUMBER");
                HashSet<String> numbers = new HashSet<String>(tableArr.size());
                if (dimensionModel.equals("bcm_userdefinedmembertree") && "t_bcm_structofdefined".equals(tableName)) {
                    QFilter fdimensionid = new QFilter("dimension", "=", (Object)Long.valueOf(dimensionid));
                    QFilter fmodelid = new QFilter("model", "=", (Object)Long.valueOf(id));
                    DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number,parent", (QFilter[])new QFilter[]{fmodelid, fdimensionid});
                    HashSet<String> userdefined = new HashSet<String>(16);
                    for (DynamicObject dynamicObject : col) {
                        userdefined.add(dynamicObject.getString("number"));
                    }
                    OlapServiceHelper.batchCreateDimensionSchemes(cube_catalog, dimensionNumber, dimensionShortNumber, userdefined.toArray(new String[0]));
                    continue;
                }
                for (int j = 1; j < tableArr.size(); ++j) {
                    numbers.add(((JSONArray)tableArr.get(j)).getString(numIndex));
                    if (!dimensionModel.equals("bcm_entitymembertree")) continue;
                    numbers.add(OlapPresetHelper.getDeriveNum(((JSONArray)tableArr.get(j)).getString(longnumIndex)));
                }
                OlapServiceHelper.batchCreateDimensionSchemes(cube_catalog, dimensionNumber, dimensionShortNumber, numbers.toArray(new String[0]));
            }
        }
    }

    public static String getCubeName(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject modelObj = (JSONObject)jsonObject.get((Object)"bcm_model");
        JSONArray model = (JSONArray)modelObj.getJSONArray("t_bcm_model").get(0);
        int index = model.indexOf((Object)"FNUMBER");
        if (index != -1) {
            return ((JSONArray)modelObj.getJSONArray("t_bcm_model").get(1)).get(index).toString();
        }
        return null;
    }

    public static String loadTextFileString(String fileUrl) {
        byte[] bt;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        int len = 0;
        InputStream inStream = null;
        try {
            int temp;
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            LinkedHashMap<String, String> downloadFileParams = new LinkedHashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            bt = new byte[524288000];
            while ((temp = inStream.read()) != -1) {
                bt[len] = (byte)temp;
                ++len;
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            return new String(bt, 0, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u65e0\u6cd5\u8bc6\u522b", (String)"ImportJsonServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static void deleteBatch(JSONArray jsonArr, String table, String entityName, Map<String, ImportDataInfo> infoMap) {
        String tableName = EntityMetadataCache.getDataEntityType((String)entityName).getAlias();
        if (table.equalsIgnoreCase(tableName)) {
            Object[] ids = new Object[jsonArr.size()];
            int j = 0;
            int index = ((JSONArray)jsonArr.get(0)).indexOf((Object)"FID");
            if (index != -1) {
                for (int i = 1; i < jsonArr.size(); ++i) {
                    try {
                        ids[j] = Long.valueOf(((JSONArray)jsonArr.get(i)).getString(index));
                    }
                    catch (Exception e) {
                        ids[j] = ((JSONArray)jsonArr.get(i)).getString(index);
                    }
                    ++j;
                }
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])ids);
        } else {
            List<Object> params;
            int fpkIndex = ((JSONArray)jsonArr.get(0)).indexOf((Object)"FPK");
            int entryIdIndex = ((JSONArray)jsonArr.get(0)).indexOf((Object)"FENTRYID");
            int fidIndex = ((JSONArray)jsonArr.get(0)).indexOf((Object)"FID");
            int detailIdIndex = ((JSONArray)jsonArr.get(0)).indexOf((Object)"DETAILID");
            String fieldName = null;
            int fieldIndex = -1;
            if (fpkIndex != -1) {
                fieldName = "FPK";
                fieldIndex = fpkIndex;
            } else if (fidIndex != -1) {
                fieldName = "FID";
                fieldIndex = fidIndex;
            } else if (entryIdIndex != -1) {
                fieldName = "FENTRYID";
                fieldIndex = entryIdIndex;
            } else if (detailIdIndex != -1) {
                fieldName = "DETAILID";
                fieldIndex = detailIdIndex;
            }
            if (fieldName != null && !(params = ImportJsonServiceHelper.getPrimaryKeys(jsonArr, fieldIndex, fieldName, infoMap)).isEmpty()) {
                String sql = String.format("delete  from %s where %s in(%s)", table, fieldName, Joiner.on((char)',').join((Iterable)Lists.transform(params, p -> "?")));
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])params.toArray());
            }
        }
    }

    private static List<Object> getPrimaryKeys(JSONArray jsonArr, int colIndex, String colName, Map<String, ImportDataInfo> infoMap) {
        ArrayList<Object> ids = new ArrayList<Object>(jsonArr.size() - 1);
        Object realTypeVal = null;
        for (int i = 1; i < jsonArr.size(); ++i) {
            String val = ((JSONArray)jsonArr.get(i)).getString(colIndex);
            if (val == null) continue;
            realTypeVal = numDataTypes.contains(infoMap.get(colName).getDataType()) ? Long.valueOf(val) : val;
            ids.add(realTypeVal);
        }
        return ids;
    }
}

