/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.api.CreateEntityDTO;
import kd.fi.bcm.business.dimension.api.UpdateEntityDTO;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DefinedImpSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.DimensionUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberServiceHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(MemberServiceHelper.class);

    public static DynamicObject getBaseMember(String entityNum, String fileds, QFilter filter) {
        if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        }
        return BusinessDataServiceHelper.loadSingle((String)entityNum, (String)fileds, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryBaseMember(String entity, String fileds, QFilter[] filters) {
        if (DataEntityUtils.isIncludeShareField((String)entity)) {
            filters[0].and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        }
        return QueryServiceHelper.query((String)entity, (String)fileds, (QFilter[])filters);
    }

    public static DynamicObjectCollection queryBaseMember(String entity, String fileds, QFBuilder filter) {
        if (DataEntityUtils.isIncludeShareField((String)entity)) {
            filter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        }
        return QueryServiceHelper.query((String)entity, (String)fileds, (QFilter[])filter.toArray());
    }

    public static DynamicObject queryOneBaseMember(String entity, String fileds, QFBuilder filter) {
        DynamicObjectCollection doc = MemberServiceHelper.queryBaseMember(entity, fileds, filter);
        if (doc != null && !doc.isEmpty()) {
            return (DynamicObject)doc.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getAllChildrenOfBaseMember(String entityNum, String fields, String number, Object modelId, boolean includeSelf) {
        QFilter filter = new QFilter("model", "=", modelId);
        filter.and(new QFilter("number", "=", (Object)number));
        DynamicObject dy = MemberServiceHelper.getBaseMember(entityNum, "id", filter);
        QFBuilder qfb = new QFBuilder();
        qfb.add("parent.id", "=", dy.get("id"));
        if (includeSelf) {
            qfb.or("id", "=", dy.get("id"));
        }
        return QueryServiceHelper.query((String)entityNum, (String)fields, (QFilter[])qfb.toArray());
    }

    public static DynamicObjectCollection getAllBaseMember(String entityNum, String fields, Object modelId) {
        QFilter filter = new QFilter("model", "=", modelId);
        if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        }
        return QueryServiceHelper.query((String)entityNum, (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject queryMemberFromCache(String entityNum, String selectFields, long memberId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)memberId, (String)entityNum, (String)selectFields);
    }

    public static void createMember(long modelid, String dim, Map<String, String> member, long parentid, DimMemTypeEnum type) {
        String cube = QueryDimensionServiceHelper.getModelNumber(modelid);
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dim);
        QFilter dimFilterID = QFilter.of((String)"model=? and number=?", (Object[])new Object[]{modelid, dim});
        DynamicObject dimesion = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{dimFilterID});
        String cs1 = "icmembertree";
        String membertable = entity.contains(cs1) ? "bcm_intercompanymember" : entity.substring(0, entity.length() - 4);
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)entity);
        if (parent.getBoolean("isleaf")) {
            parent.set("isleaf", (Object)0);
        }
        int seq = QueryDimensionServiceHelper.getMaxDSeq(parentid, entity);
        Object[] nones = new DynamicObject[member.size()];
        Object[] noneTrees = new DynamicObject[member.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : member.entrySet()) {
            String number = entry.getKey();
            String name = entry.getValue();
            DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            DimensionServiceHelper.initDimensionDyObjectWithOrg(none);
            none.set("number", (Object)number);
            none.set("name", (Object)name);
            none.set("model", (Object)modelid);
            none.set("dimension", (Object)dimesion.getLong("id"));
            nones[i] = none;
            DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)entity);
            DimensionServiceHelper.initDimensionDyObject(noneTree);
            noneTree.set("model", (Object)modelid);
            noneTree.set("dimension", (Object)dimesion.getLong("id"));
            noneTree.set("level", (Object)String.valueOf((Integer)parent.get("level") + 1));
            noneTree.set("member", (Object)none);
            noneTree.set("parent", (Object)parentid);
            String storagetype = StorageTypeEnum.STORAGE.getOIndex();
            noneTree.set("storagetype", (Object)storagetype);
            noneTree.set("datatype", (Object)"0");
            noneTree.set("aggoprt", (Object)"1");
            noneTree.set("isleaf", (Object)true);
            noneTree.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
            noneTree.set("number", (Object)number);
            noneTree.set("name", (Object)name);
            noneTree.set("issysmember", (Object)type.getIndex());
            noneTree.set("dseq", (Object)(++seq));
            noneTrees[i] = noneTree;
            ++i;
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)membertable).getDynamicObjectType(), (Object[])nones);
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entity).getDynamicObjectType(), (Object[])noneTrees);
                BusinessDataWriter.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])new DynamicObject[]{parent});
                ArrayList<Tuple<String, Integer, String>> list = new ArrayList<Tuple<String, Integer, String>>(noneTrees.length);
                for (Object treeMember : noneTrees) {
                    list.add((Tuple<String, Integer, String>)Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber(entity, treeMember.get("parent"))));
                }
                OlapServiceHelper.batchCreateDimensionMembers(cube, dim, list);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static DynamicObject[] getOrgInfoByScheme(String cube, String scheme, Date modifyTime, Set<String> numbers) {
        QFilter filter = new QFilter("model.number", "=", (Object)cube);
        filter.and(new QFilter("cslscheme.number", "=", (Object)scheme));
        filter.and(new QFilter("status", "!=", (Object)OrgStoreStatusEnum.TEMPSAVE.getValue()));
        if (modifyTime != null) {
            QFilter mFilter = new QFilter("modifytime", ">=", (Object)modifyTime);
            if (CollectionUtils.isNotEmpty(numbers)) {
                mFilter.or(new QFilter("number", "in", numbers));
            }
            filter.and(mFilter);
        }
        String fields = "id,number,name,simplename,longnumber,shownumber,orgcode,parent.id,parent.number,parent.name,creator.id,createtime,modifier.id,modifytime,enable,status,masterid,storagetype,aggoprt,isindependentorg,ctrlorg,currency.number,currency.name,isinnerorg,entitypart,isclearorg,isleaf,description,bizchangerds,bizchangerds.changetype,bizchangerds.bizeffdate,bizchangerds.bizexpdate,bizchangerds.bizmodifier,bizchangerds.bizmodifier.id,bizchangerds.bizmodifytime,namechangerds,namechangerds.namerds,namechangerds.simplenamerds,namechangerds.nameeffdate,namechangerds.nameexpdate,namechangerds.namemodifier,namechangerds.namemodifier.id,namechangerds.namemodifytime";
        return BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static Multimap<String, DynamicObject> getAllMergeStructInfo(String cube, String scene) {
        return (Multimap)ThreadCache.get((Object)("getAllMergeStructInfo_" + cube + scene), () -> {
            QFBuilder qfBuilder = new QFBuilder("model.number", "=", (Object)cube);
            qfBuilder.add("scenario.number", "=", (Object)scene);
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge,year.number,period.number,scenario.number,modifytime", (QFilter[])qfBuilder.toArray());
            HashMultimap multimap = HashMultimap.create();
            for (DynamicObject obj : docs) {
                multimap.put((Object)(obj.getString("orgpnumber") + "|" + obj.getString("orgnumber")), (Object)obj);
            }
            return multimap;
        });
    }

    public static void batchCreateMembers(String entityName, long modelId, long dimId, Map<String, String> members, long parentId, DimMemTypeEnum type, DefinedImpSourceEnum source, DimMemberOperateTypeEnum operateType) {
        if (members == null || members.isEmpty()) {
            return;
        }
        if (!"bcm_icmembertree".equals(entityName) && !"bcm_userdefinedmembertree".equals(entityName)) {
            return;
        }
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityName);
        if (parent == null) {
            return;
        }
        if ("bcm_icmembertree".equals(entityName) && !"ICOEntity".equals(parent.getString("number"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u5916\u90e8\u5f80\u6765\u7ec4\u7ec7\u4e0b\u6dfb\u52a0\u6210\u5458\u3002", (String)"MemberServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        filter.and(new QFilter("number", "in", members.keySet()));
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{filter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"MemberServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> parents = new ArrayList<DynamicObject>(16);
        if (parent.getBoolean("isleaf")) {
            parent.set("isleaf", (Object)0);
            parents.add(parent);
        }
        int seq = MemberServiceHelper.getMaxSeqByParent(entityName, modelId, parentId);
        ArrayList<DynamicObject> memberTrees = new ArrayList<DynamicObject>(members.size());
        ArrayList<Tuple<String, Integer, String>> memberList = new ArrayList<Tuple<String, Integer, String>>(memberTrees.size());
        for (Map.Entry<String, String> entry : members.entrySet()) {
            DynamicObject memberTree = MemberServiceHelper.initCommonDyObject(entityName, modelId, dimId, entry.getKey(), entry.getValue(), parent, ++seq);
            memberTree.set("issysmember", (Object)(type == null ? DimMemTypeEnum.UNSYSMEM.getIndex() : type.getIndex()));
            memberTree.set("source", (Object)source);
            if ("bcm_userdefinedmembertree".equals(entityName)) {
                memberTree.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
            }
            memberTrees.add(memberTree);
            memberList.add((Tuple<String, Integer, String>)Tuple.create((Object)entry.getKey(), (Object)AggOprtEnum.ADD.getIntSign(), (Object)parent.getString("number")));
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])memberTrees.toArray(new DynamicObject[0]));
                if (!parents.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])parents.toArray(new DynamicObject[0]));
                }
                MemberServiceHelper.modifyLog(modelId, dimId, members, operateType);
                OlapServiceHelper.batchCreateDimensionMembers(MemberReader.findModelNumberById((Object)modelId), MemberReader.getDimensionNumById((long)dimId), memberList);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static DynamicObject initCommonDyObject(String entityName, long modelId, long dimId, String number, String name, DynamicObject parent, int seq) {
        DynamicObject memberTree = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DimensionServiceHelper.initDimensionDyObject(memberTree);
        memberTree.set("model", (Object)modelId);
        memberTree.set("dimension", (Object)dimId);
        memberTree.set("number", (Object)number);
        memberTree.set("name", (Object)name);
        memberTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
        memberTree.set("aggoprt", (Object)AggOprtEnum.ADD.sign);
        memberTree.set("isleaf", (Object)true);
        memberTree.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
        memberTree.set("level", (Object)(parent.getInt("level") + 1));
        memberTree.set("parent", (Object)parent.getLong("id"));
        memberTree.set("dseq", (Object)seq);
        return memberTree;
    }

    public static int getMaxSeqByParent(String entityName, long modelId, long parentId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("parent", "=", (Object)parentId));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"dseq", (QFilter[])new QFilter[]{filter}, (String)"dseq desc", (int)1);
        return docs.size() == 0 ? 0 : ((DynamicObject)docs.get(0)).getInt("dseq");
    }

    public static void modifyLog(long modelId, long dimension, Map<String, String> members, DimMemberOperateTypeEnum operateType) {
        if (operateType == null) {
            operateType = DimMemberOperateTypeEnum.BATCH_CREATE;
        }
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(members.size());
        for (Map.Entry<String, String> entry : members.entrySet()) {
            String number = entry.getKey();
            String name = entry.getValue();
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimension, null, number, name, operateType.getValue(), operateType.getName(), null, name, RequestContext.get().getCurrUserId(), 1, RequestContext.get().getLoginIP());
            logs.add(modifyLog);
        }
        SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
    }

    public static void syncChangeRecord(long modelId, DynamicObject entity) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        long copyfrom = entity.getLong("copyfrom.id");
        filter.and(new QFilter("copyfrom", "=", (Object)(copyfrom == 0L ? entity.getLong("id") : copyfrom)));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])filter.toArray());
        ArrayList<DynamicObject> nodes = new ArrayList<DynamicObject>(docs.size());
        DynamicObjectCollection bizChangeRds = entity.getDynamicObjectCollection("bizchangerds");
        DynamicObjectCollection nameChangeRds = entity.getDynamicObjectCollection("namechangerds");
        for (DynamicObject doc : docs) {
            DynamicObject node = BusinessDataServiceHelper.loadSingle((Object)doc.getLong("id"), (String)"bcm_entitymembertree");
            node.set("name", (Object)entity.getString("name"));
            node.set("simplename", (Object)entity.getString("simplename"));
            node.set("modifier", (Object)RequestContext.get().getCurrUserId());
            node.set("modifytime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection nameRecords = new DynamicObjectCollection();
            nameChangeRds.forEach(s -> nameRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)s, (boolean)true, (boolean)true))));
            node.set("namechangerds", (Object)nameRecords);
            if (node.getString("parent.number").equals(entity.getString("parent.number"))) {
                DynamicObjectCollection bizRecords = new DynamicObjectCollection();
                bizChangeRds.forEach(s -> bizRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)s, (boolean)true, (boolean)true))));
                node.set("bizchangerds", (Object)bizRecords);
            }
            nodes.add(node);
        }
        if (!nodes.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])nodes.toArray(new DynamicObject[0]));
        }
    }

    public static void batchCreateEntity(String modelNum, List<CreateEntityDTO> orgs) {
        logger.startWatch();
        if (CollectionUtils.isEmpty(orgs)) {
            return;
        }
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
        ArrayList<Tuple<String, Integer, String>> members = new ArrayList<Tuple<String, Integer, String>>(orgs.size());
        ArrayList pMembers = new ArrayList(orgs.size());
        ArrayList<Tuple<String, Integer, String>> icMembers = new ArrayList<Tuple<String, Integer, String>>(orgs.size());
        ArrayList parents = new ArrayList(16);
        long userId = RequestContext.get().getCurrUserId();
        HashSet<String> propertyNumbers = new HashSet<String>(16);
        Set changeTypes = InvestServiceHelper.getInvChangetypeModel(modelId).values().stream().map(m -> m.number()).collect(Collectors.toSet());
        orgs.forEach(o -> propertyNumbers.addAll(o.getPropertyNumbers()));
        Map<String, Pair<Long, String>> properties = MemberServiceHelper.getPropertyByNumbers(modelId, dimId, propertyNumbers);
        try (TXHandle tx = TX.required();){
            try {
                orgs.forEach(org -> {
                    StorageTypeEnum storageType;
                    QFilter filter = new QFilter("model", "=", (Object)modelId);
                    filter.and(new QFilter("number", "=", (Object)org.getSchemeNum()));
                    DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])filter.toArray());
                    if (scheme == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    long schemeId = scheme.getLong("id");
                    String number = org.getNumber();
                    String name = org.getName();
                    String checkMsg = DimensionUtils.checkNumber((String)number);
                    if (checkMsg != null) {
                        throw new KDBizException(checkMsg);
                    }
                    DynamicObject parent = MemberServiceHelper.getEntity(modelId, schemeId, org.getParentNum());
                    if (parent == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u4e0b\u4e0d\u5b58\u5728\u975e\u5171\u4eab\u7c7b\u578b\u7684\u4e0a\u7ea7\u7ec4\u7ec7[%s]\u3002", (String)"MemberServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), org.getParentNum()));
                    }
                    parent.set("isleaf", (Object)"0");
                    parents.add(parent);
                    long pid = parent.getLong("id");
                    if (!changeTypes.contains(org.getChangeType())) {
                        throw new KDBizException(String.format("not fount OrgBizChangeTypeEnum value: %s", org.getChangeType()));
                    }
                    DynamicObject entity = MemberServiceHelper.getEntity(modelId, 0L, number);
                    StorageTypeEnum storageTypeEnum = storageType = entity == null ? StorageTypeEnum.STORAGE : StorageTypeEnum.SHARE;
                    if (storageType == StorageTypeEnum.SHARE && MemberServiceHelper.entityExist(modelId, pid, number)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u5df2\u5b58\u5728\u3002", (String)"MemberServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), number));
                    }
                    int seq = MemberServiceHelper.getMaxSeqByParent("bcm_entitymembertree", modelId, pid) + 1;
                    Date now = TimeServiceHelper.now();
                    Date effectDate = DateTimeUtils.truncateDate((Date)org.getEffectDate());
                    String message = EntityVersioningUtil.checkModelDate(modelId, effectDate);
                    if (StringUtils.isNotEmpty((CharSequence)message)) {
                        throw new KDBizException(message);
                    }
                    int aggOprt = AggOprtEnum.getAggOprtEnumBySign((String)org.getAggoprt()).getIntSign();
                    if (storageType == StorageTypeEnum.SHARE) {
                        DynamicObject modifierDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                        modifierDy.set("id", (Object)userId);
                        entity.set("modifier", (Object)modifierDy);
                        entity.set("creator", (Object)modifierDy);
                        DynamicObject shareTree = (DynamicObject)OrmUtils.clone((Object)entity, (IDataEntityType)entity.getDataEntityType(), (boolean)true, (boolean)true);
                        shareTree.set("parent", (Object)parent);
                        DynamicObject copyFrom = new DynamicObject(shareTree.getDynamicObjectType());
                        copyFrom.set("id", (Object)entity.getLong("id"));
                        shareTree.set("copyfrom", (Object)copyFrom);
                        shareTree.set("cslscheme", (Object)parent.getLong("cslscheme.id"));
                        shareTree.set("storagetype", (Object)StorageTypeEnum.SHARE.getOIndex());
                        shareTree.set("issysmember", (Object)DimMemTypeEnum.INTERFACE.getIndex());
                        shareTree.set("dseq", (Object)seq);
                        shareTree.set("level", (Object)(parent.getInt("level") + 1));
                        shareTree.set("longnumber", (Object)(parent.get("longnumber") + "!" + number));
                        shareTree.set("modifytime", (Object)now);
                        shareTree.set("createtime", (Object)now);
                        shareTree.set("aggoprt", (Object)aggOprt);
                        DynamicObjectCollection bizRecords = shareTree.getDynamicObjectCollection("bizchangerds");
                        DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
                        bizRecord.set("changetype", (Object)org.getChangeType());
                        bizRecord.set("bizeffdate", (Object)effectDate);
                        bizRecord.set("bizmodifier", (Object)userId);
                        bizRecord.set("bizmodifytime", (Object)now);
                        bizRecord.set("seq", (Object)1);
                        bizRecords.clear();
                        bizRecords.add((Object)bizRecord);
                        MemberServiceHelper.createEntityPart(shareTree);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{shareTree});
                    } else {
                        DynamicObject ic;
                        DynamicObject currency = MemberServiceHelper.getBDCurrency(org.getCurrency());
                        if (currency == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e01\u79cd[%s]\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), org.getCurrency()));
                        }
                        DynamicObject memberTree = MemberServiceHelper.initCommonDyObject("bcm_entitymembertree", modelId, dimId, number, name, parent, seq);
                        memberTree.set("storagetype", (Object)storageType.getOIndex());
                        memberTree.set("aggoprt", (Object)aggOprt);
                        if (org.isInnerOrg() && org.isOuterOrg()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u4e3a\u5185\u5916\u90e8\u5f80\u6765\u7ec4\u7ec7\u3002", (String)"MemberServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        if (org.isIndependentOrg() && StringUtils.isNotEmpty((CharSequence)org.getCtrlOrg())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u72ec\u7acb\u6cd5\u4eba\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u63a7\u80a1\u7ec4\u7ec7\u3002", (String)"MemberServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        org.getPropertyNumbers().forEach(o -> {
                            if (!properties.containsKey(o)) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u7f16\u7801[%s]\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), o));
                            }
                            memberTree.set((String)((Pair)properties.get((Object)o)).p2, ((Pair)properties.get((Object)o)).p1);
                        });
                        memberTree.set("simplename", (Object)org.getSimpleName());
                        memberTree.set("cslscheme", (Object)scheme.getLong("id"));
                        memberTree.set("shownumber", (Object)number);
                        memberTree.set("issysmember", (Object)DimMemTypeEnum.INTERFACE.getIndex());
                        memberTree.set("isclearorg", (Object)org.isClearOrg());
                        memberTree.set("isinnerorg", (Object)org.isInnerOrg());
                        memberTree.set("isouterorg", (Object)org.isOuterOrg());
                        memberTree.set("isindependentorg", (Object)org.isIndependentOrg());
                        memberTree.set("description", (Object)org.getDescription());
                        memberTree.set("currency", (Object)currency.getLong("id"));
                        MemberServiceHelper.createChangeRecord(memberTree, org.getChangeType(), effectDate);
                        MemberServiceHelper.createEntityPart(memberTree);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
                        if ((org.isOuterOrg() || org.isInnerOrg()) && (ic = MemberServiceHelper.createICMember(modelId, number, name, org.isInnerOrg())) != null) {
                            icMembers.add(new Tuple((Object)number, (Object)AggOprtEnum.ADD.getIntSign(), (Object)(org.isInnerOrg() ? "ICEntity" : "ICOEntity")));
                        }
                        MemberServiceHelper.createMyCompanyMember(modelId, number, name, org.getSimpleName(), aggOprt);
                    }
                    members.add(new Tuple((Object)number, (Object)aggOprt, (Object)org.getParentNum()));
                    pMembers.add(org.getParentNum() + "_" + number);
                    MemberServiceHelper.modifyLog(modelId, dimId, number, null, name, DimMemberOperateTypeEnum.BATCH_CREATE);
                });
                ArrayList toUpdate = new ArrayList(16);
                orgs.forEach(org -> {
                    if (StringUtils.isNotEmpty((CharSequence)org.getCtrlOrg())) {
                        DynamicObject ctrlOrg = MemberServiceHelper.getEntity(modelId, 0L, org.getCtrlOrg());
                        if (ctrlOrg == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u80a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        DynamicObject entity = MemberServiceHelper.getEntity(modelId, 0L, org.getNumber());
                        entity.set("ctrlorg", (Object)ctrlOrg.getLong("id"));
                        toUpdate.add(entity);
                    }
                });
                if (!toUpdate.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])toUpdate.toArray(new DynamicObject[0]));
                }
                if (!parents.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])parents.toArray(new DynamicObject[0]));
                }
                if (!members.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers(modelNum, DimTypesEnum.ENTITY.getNumber(), members);
                }
                if (!pMembers.isEmpty()) {
                    pMembers.forEach(p -> OlapServiceHelper.createMember(modelNum, DimTypesEnum.ENTITY.getNumber(), p));
                }
                if (!icMembers.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers(modelNum, DimTypesEnum.INTERCOMPANY.getNumber(), icMembers);
                }
                BatchProcessHelper.handleAsync(() -> ShareNodeStructSyncHelper.resyncShareNodeStructure("bcm_entitymembertree", modelId, dimId));
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("batch create entity fail: " + ThrowableHelper.toString((Exception)ex));
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public static void batchUpdateEntity(String modelNum, List<UpdateEntityDTO> orgs) {
        logger.startWatch();
        if (CollectionUtils.isEmpty(orgs)) {
            return;
        }
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        HashSet<String> propertyNumbers = new HashSet<String>(16);
        Set changeTypes = InvestServiceHelper.getInvChangetypeModel(modelId).values().stream().map(m -> m.number()).collect(Collectors.toSet());
        orgs.forEach(o -> propertyNumbers.addAll(o.getPropertyNumbers()));
        Map<String, Pair<Long, String>> properties = MemberServiceHelper.getPropertyByNumbers(modelId, dimId, propertyNumbers);
        try (TXHandle tx = TX.required();){
            try {
                orgs.forEach(org -> {
                    String number = org.getNumber();
                    String name = org.getName();
                    QFilter filter = new QFilter("model", "=", (Object)modelId);
                    filter.and(new QFilter("number", "=", (Object)org.getSchemeNum()));
                    DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])filter.toArray());
                    if (scheme == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    if (!changeTypes.contains(org.getChangeType())) {
                        throw new KDBizException(String.format("not fount OrgBizChangeTypeEnum value: %s", org.getChangeType()));
                    }
                    long schemeId = scheme.getLong("id");
                    DynamicObject entity = MemberServiceHelper.getEntityByParent(modelId, schemeId, number, org.getParentNum());
                    if (entity == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u4e0b\u4e0d\u5b58\u5728\u975e\u5171\u4eab\u7c7b\u578b\u7684\u4e0a\u7ea7\u7ec4\u7ec7[%s]\u3002", (String)"MemberServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), number));
                    }
                    entity.set("modifier", (Object)userId);
                    entity.set("modifytime", (Object)now);
                    org.getPropertyNumbers().forEach(o -> {
                        if (!properties.containsKey(o)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u7f16\u7801[%s]\u4e0d\u5b58\u5728\u3002", (String)"MemberServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), o));
                        }
                        entity.set((String)((Pair)properties.get((Object)o)).p2, ((Pair)properties.get((Object)o)).p1);
                    });
                    Date effectDate = DateTimeUtils.truncateDate((Date)org.getEffectDate());
                    DynamicObjectCollection bizRecords = entity.getDynamicObjectCollection("bizchangerds");
                    DynamicObject lastBiz = (DynamicObject)bizRecords.get(bizRecords.size() - 1);
                    if (!org.getChangeType().equals(lastBiz.getString("changetype"))) {
                        Date lastEffDate = lastBiz.getDate("bizeffdate");
                        if (!DateTimeUtils.dayAfter((Date)effectDate, (Date)lastEffDate)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u4e00\u6761\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"MemberServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        lastBiz.set("bizexpdate", (Object)DateTimeUtils.getDayAround((Date)effectDate, (int)-1));
                        DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
                        bizRecord.set("changetype", (Object)org.getChangeType());
                        bizRecord.set("bizeffdate", (Object)effectDate);
                        bizRecord.set("bizmodifier", (Object)userId);
                        bizRecord.set("bizmodifytime", (Object)now);
                        bizRecord.set("seq", (Object)(lastBiz.getInt("seq") + 1));
                        bizRecords.add((Object)bizRecord);
                    }
                    String beforeName = entity.getString("name");
                    String simpleName = org.getSimpleName();
                    if (StringUtils.isEmpty((CharSequence)org.getSimpleName())) {
                        simpleName = entity.getString("simplename");
                    }
                    if (!beforeName.equals(name)) {
                        DynamicObject myCompanyObj;
                        DynamicObject icObj;
                        entity.set("name", (Object)name);
                        entity.set("simplename", (Object)simpleName);
                        DynamicObjectCollection record = entity.getDynamicObjectCollection("namechangerds");
                        DynamicObject lastName = (DynamicObject)record.get(record.size() - 1);
                        Date lastEffDate = lastName.getDate("nameeffdate");
                        if (DateTimeUtils.dayBefore((Date)effectDate, (Date)lastEffDate)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u4e00\u6761\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"MemberServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        if (DateTimeUtils.dayEquals((Date)effectDate, (Date)lastEffDate) || beforeName.equals(name)) {
                            lastName.set("namerds", (Object)name);
                            lastName.set("simplenamerds", (Object)simpleName);
                            lastName.set("namemodifier", (Object)userId);
                            lastName.set("namemodifytime", (Object)now);
                        } else {
                            Date expDate = DateTimeUtils.getDayBefore((Date)effectDate);
                            if (expDate.before(lastEffDate)) {
                                expDate = lastEffDate;
                            }
                            lastName.set("nameexpdate", (Object)expDate);
                            DynamicObject newRecord = new DynamicObject(lastName.getDynamicObjectType());
                            newRecord.set("namerds", (Object)name);
                            newRecord.set("simplenamerds", (Object)simpleName);
                            newRecord.set("nameeffdate", (Object)effectDate);
                            newRecord.set("namemodifier", (Object)userId);
                            newRecord.set("namemodifytime", (Object)now);
                            newRecord.set("seq", (Object)(lastName.getInt("seq") + 1));
                            record.add((Object)newRecord);
                        }
                        boolean isInnerOrg = entity.getBoolean("isinnerorg");
                        boolean isOuterOrg = entity.getBoolean("isouterorg");
                        if ((isInnerOrg || isOuterOrg) && Objects.nonNull(icObj = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"id,name,modifier,modifytime", (QFilter[])new QFilter[]{filter}))) {
                            icObj.set("name", (Object)name);
                            icObj.set("modifier", (Object)userId);
                            icObj.set("modifytime", (Object)TimeServiceHelper.now());
                            SaveServiceHelper.update((DynamicObject)icObj);
                        }
                        if (Objects.nonNull(myCompanyObj = BusinessDataServiceHelper.loadSingle((String)"bcm_mycompanymembertree", (String)"id,name,modifier,modifytime", (QFilter[])new QFilter[]{filter}))) {
                            myCompanyObj.set("name", (Object)name);
                            myCompanyObj.set("modifier", (Object)userId);
                            myCompanyObj.set("modifytime", (Object)TimeServiceHelper.now());
                            SaveServiceHelper.update((DynamicObject)myCompanyObj);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
                    MemberServiceHelper.syncChangeRecord(modelId, entity);
                    MemberServiceHelper.modifyLog(modelId, entity.getLong("dimension.id"), number, beforeName, name, DimMemberOperateTypeEnum.EDIT_NAME);
                });
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("batchUpdateEntity fail: " + ThrowableHelper.toString((Exception)e));
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static DynamicObject createChangeRecord(DynamicObject memberTree, String changeType, Date effectDate) {
        Date nowTime = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection nameRecords = memberTree.getDynamicObjectCollection("namechangerds");
        DynamicObject nameRecord = new DynamicObject(nameRecords.getDynamicObjectType());
        nameRecord.set("namerds", memberTree.get("name"));
        nameRecord.set("simplenamerds", memberTree.get("simplename"));
        nameRecord.set("nameeffdate", (Object)effectDate);
        nameRecord.set("namemodifier", (Object)userId);
        nameRecord.set("namemodifytime", (Object)nowTime);
        nameRecord.set("seq", (Object)1);
        nameRecords.add((Object)nameRecord);
        DynamicObjectCollection bizRecords = memberTree.getDynamicObjectCollection("bizchangerds");
        DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
        bizRecord.set("changetype", (Object)changeType);
        bizRecord.set("bizeffdate", (Object)effectDate);
        bizRecord.set("bizmodifier", (Object)userId);
        bizRecord.set("bizmodifytime", (Object)nowTime);
        bizRecord.set("seq", (Object)1);
        bizRecords.add((Object)bizRecord);
        DynamicObjectCollection currencyRecords = memberTree.getDynamicObjectCollection("currencychangerds");
        DynamicObject currencyRecord = new DynamicObject(currencyRecords.getDynamicObjectType());
        currencyRecord.set("currencyrds", (Object)memberTree.getLong("currency"));
        currencyRecord.set("currencyeffdate", (Object)effectDate);
        currencyRecord.set("currencymodifier", (Object)userId);
        currencyRecord.set("currencymodifytime", (Object)nowTime);
        currencyRecord.set("seq", (Object)1);
        currencyRecords.add((Object)currencyRecord);
        return memberTree;
    }

    public static DynamicObject createICMember(long modelId, String number, String name, boolean isInner) {
        QFilter mFilter = new QFilter("model", "=", (Object)modelId);
        QFilter nFilter = new QFilter("number", "=", (Object)number);
        logger.info(String.format("begin create ic, number:%s, isInner:%s", number, isInner));
        if (QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])new QFilter[]{mFilter, nFilter})) {
            logger.error("create ic fail, number is already exists.");
            return null;
        }
        QFilter filter = new QFilter("number", "=", (Object)(isInner ? "ICEntity" : "ICOEntity"));
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_icmembertree", (String)"id,number,name,longnumber,dimension.id,level,isleaf", (QFilter[])new QFilter[]{mFilter, filter});
        if (Objects.isNull(parent)) {
            logger.error("create ic fail, parent number is not exists.");
            return null;
        }
        int seq = MemberServiceHelper.getMaxSeqByParent("bcm_icmembertree", modelId, parent.getLong("id")) + 1;
        long dimId = parent.getLong("dimension.id");
        DynamicObject memberTree = MemberServiceHelper.initCommonDyObject("bcm_icmembertree", modelId, dimId, number, name, parent, seq);
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        memberTree.set("dimension", (Object)dimId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
        return memberTree;
    }

    public static void createMyCompanyMember(long modelId, String number, String name, String simpleName, int agg) {
        QFilter mFilter = new QFilter("model", "=", (Object)modelId);
        QFilter nFilter = new QFilter("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"bcm_mycompanymembertree", (QFilter[])new QFilter[]{mFilter, nFilter})) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)"MyCompany");
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_mycompanymembertree", (String)"id,number,name,longnumber,dimension.id,level,isleaf", (QFilter[])new QFilter[]{mFilter, filter});
        if (Objects.isNull(parent)) {
            return;
        }
        int seq = MemberServiceHelper.getMaxSeqByParent("bcm_mycompanymembertree", modelId, parent.getLong("id")) + 1;
        long dimId = parent.getLong("dimension.id");
        DynamicObject memberTree = MemberServiceHelper.initCommonDyObject("bcm_mycompanymembertree", modelId, dimId, number, name, parent, seq);
        memberTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        memberTree.set("dimension", (Object)dimId);
        memberTree.set("simplename", (Object)simpleName);
        memberTree.set("aggoprt", (Object)agg);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberTree});
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        OlapServiceHelper.createMember(modelNum, "MyCompany", number, agg, "MyCompany");
    }

    public static DynamicObject getEntity(long modelId, long scheme, String number) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)number));
        if (scheme != 0L) {
            filter.and(new QFilter("cslscheme", "=", (Object)scheme));
        }
        filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        DynamicObject entity = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])filter.toArray());
        if (entity != null) {
            return BusinessDataServiceHelper.loadSingle((Object)entity.getLong("id"), (String)"bcm_entitymembertree");
        }
        return null;
    }

    public static DynamicObject getBDCurrency(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number,name", (QFilter[])filter.toArray());
    }

    public static DynamicObject getEntityByParent(long modelId, long scheme, String number, String parentNum) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)number));
        filter.and(new QFilter("parent.number", "=", (Object)parentNum));
        filter.and(new QFilter("cslscheme", "=", (Object)scheme));
        filter.and(new QFilter("parent.storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        DynamicObject entity = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])filter.toArray());
        if (entity != null) {
            return BusinessDataServiceHelper.loadSingle((Object)entity.getLong("id"), (String)"bcm_entitymembertree");
        }
        return null;
    }

    public static boolean entityExist(long modelId, long parentId, String number) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("parent", "=", (Object)parentId));
        filter.and(new QFilter("number", "=", (Object)number));
        return QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])filter.toArray());
    }

    public static void createEntityPart(DynamicObject dyTree) {
        DynamicObject part = dyTree.getDynamicObject("entitypart");
        if (part == null) {
            part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
            part.set("id", (Object)DBServiceHelper.genGlobalLongId());
        } else {
            part = BusinessDataServiceHelper.loadSingle((Object)part.getLong("id"), (String)"bcm_entitymemberpart");
        }
        part.set("isouterorg", (Object)dyTree.getBoolean("isouterorg"));
        part.set("accounttype", dyTree.get("accounttype"));
        dyTree.set("entitypart", (Object)part.getLong("id"));
        BusinessDataWriter.save((IDataEntityType)part.getDataEntityType(), (Object[])new DynamicObject[]{part});
    }

    public static void modifyLog(long modelId, long dimension, String number, String beforeName, String name, DimMemberOperateTypeEnum operateType) {
        DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimension, null, number, name, operateType.getValue(), operateType.getName(), beforeName, name, RequestContext.get().getCurrUserId(), 1, RequestContext.get().getLoginIP());
        SaveDimMemberHelper.batchInsertDimMemberModifyLog(Collections.singletonList(modifyLog));
    }

    public static Map<String, Pair<Long, String>> getPropertyByNumbers(long modelId, long dimension, Set<String> numbers) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimension));
        filter.and(new QFilter("number", "in", numbers));
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.propertyn", (QFilter[])filter.toArray());
        HashMap<String, Pair<Long, String>> properties = new HashMap<String, Pair<Long, String>>(16);
        docs.forEach(d -> properties.put(d.getString("number"), Pair.onePair((Object)d.getLong("id"), (Object)d.getString("propertyid.propertyn"))));
        return properties;
    }
}

