/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.fi.bcm.business.dimension.helper.DimensionLockHelper;
import org.apache.commons.lang3.time.DateUtils;

public class ModelLockHelper {
    private static final Log LOG = LogFactory.getLog(ModelLockHelper.class);
    private static final String CUR_APP = "fi-bcm-business";

    public static String modelLockKey(long modelId, String viewName) {
        if (modelId <= 0L) {
            throw new IllegalArgumentException("invalid model id:" + modelId);
        }
        if (StringUtils.isEmpty((CharSequence)viewName)) {
            throw new IllegalArgumentException("invalid view name:" + viewName);
        }
        return String.format("fi/bcm/dimension/%s/%s", viewName, modelId);
    }

    public static <R> R executeWithModelLock(long modelId, String entityName, int tryLockTimeout, TimeUnit timeUnit, String lockDesc, Callable<R> callable) {
        try (DLock dLock = null;){
            R lockingInfo2;
            String key = ModelLockHelper.modelLockKey(modelId, entityName);
            dLock = DLock.create((String)key, (String)lockDesc).fastMode();
            boolean success = dLock.tryLock(timeUnit.toMillis(tryLockTimeout));
            if (!success) {
                LOG.info("bcm_model_lock had been locked on key: " + key);
                Optional<DLockInfo> lockingInfo2 = ModelLockHelper.getLockInfo(modelId, entityName);
                if (lockingInfo2.isPresent()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u6267\u884c\u6570\u636e\u5bfc\u5165", (String)"ModelLockHelper_0", (String)CUR_APP, (Object[])new Object[0]), RequestContext.get().getUserName()));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6b63\u5728\u6267\u884c\u66f4\u65b0\u6216\u5bfc\u5165\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ModelLockHelper_1", (String)CUR_APP, (Object[])new Object[0]));
            }
            LOG.info("bcm_model_lock got lock success: " + key + ", detail info: " + ModelLockHelper.getWorkingLockInfo(modelId, entityName).toString());
            try {
                lockingInfo2 = callable.call();
            }
            catch (Exception e) {
                LOG.error("failed_lock_model_execute on locking model: " + modelId + "; view\uff1a" + entityName, (Throwable)e);
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
            }
            return lockingInfo2;
        }
    }

    private static Optional<DLockInfo> getLockInfo(long modelId, String entityName) {
        String key = ModelLockHelper.modelLockKey(modelId, entityName);
        return Optional.ofNullable(DLock.getLockInfo((String)key));
    }

    public static Optional<DLockInfo> getWorkingLockInfo(long modelId, String entityName) {
        Optional<DLockInfo> lockInfo = ModelLockHelper.getLockInfo(modelId, entityName);
        if (lockInfo.isPresent()) {
            if (DateUtils.addMinutes((Date)lockInfo.get().getCreateTime(), (int)30).compareTo(new Date()) < 0) {
                DimensionLockHelper.forceUnlock(lockInfo.get().getKey());
                return Optional.empty();
            }
            return lockInfo;
        }
        return Optional.empty();
    }
}

