/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;

public class ModelServiceHelper {
    public static DynamicObject getOneModelByReportType(String selectFields, String reportType) {
        if (StringUtils.isEmpty((CharSequence)selectFields) || StringUtils.isEmpty((CharSequence)reportType)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"bcm_model", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("reporttype", "=", (Object)reportType)});
    }

    public static DynamicObject getOneModelByReportTypes(String selectFields, Collection<String> reportTypes) {
        if (StringUtils.isEmpty((CharSequence)selectFields) || reportTypes == null || reportTypes.size() == 0) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"bcm_model", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("reporttype", "in", reportTypes)});
    }

    public static ApplicationTypeEnum getModelApp(long modelId) {
        QFilter fmodelid = new QFilter("id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])filters);
        ApplicationTypeEnum app = ApplicationTypeEnum.CM;
        if (dcs != null) {
            String reporttype = dcs.getString("reporttype");
            app = ApplicationTypeEnum.getEnumByIndex((String)reporttype);
        }
        return app;
    }

    public static boolean isDynamicComputing(long modelId) {
        return ConfigServiceHelper.getBoolParam(modelId, "CM006");
    }

    public static DynamicObject getModelDynamic(long modelId) {
        return BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
    }
}

