/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.base.Joiner;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;

public class OrgCurrencyServiceHelper {
    private static QFilter expdateNullQf = new QFilter("currencychangerds.currencyexpdate", "is null", null);
    private static QFilter pExpdateNullQf = new QFilter("parent.currencychangerds.currencyexpdate", "is null", null);
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(OrgCurrencyServiceHelper.class);

    public static DynamicObject getAdjustCurrencyDynByDc(Long orgId, Long yearId, Long periodId, boolean isPc) {
        DynamicObject org;
        if (isPc && (org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent.id,parent.number", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray())) != null && !"Entity".equals(org.getString("parent.number"))) {
            orgId = org.getLong("parent.id");
        }
        DynamicObject curOrg = OrgCurrencyServiceHelper.getCurrencyDynById(orgId, yearId, periodId);
        return curOrg;
    }

    public static DynamicObject getCurrencyDynByIdThrow(Long orgId, String yearNum, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgId, yearNum, periodId);
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868", (String)"OrgCurrencyServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return OrgCurrencyServiceHelper.getCurrencyDyn(org);
    }

    public static DynamicObject getCurrencyDynById(Long orgId, String yearNum, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgId, yearNum, periodId);
        if (org == null) {
            return null;
        }
        return OrgCurrencyServiceHelper.getCurrencyDyn(org);
    }

    public static DynamicObject getCurrencyDynByIdThrow(Long orgId, Long yearId, Long periodId) {
        return (DynamicObject)BcmThreadCache.get((Object)"OCSH.GCDBIT", (Object)yearId, (Object)periodId, (Object)orgId, () -> {
            DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"bcm_fymembertree");
            return OrgCurrencyServiceHelper.getCurrencyDynByIdThrow(orgId, yearDyn.getString("number"), periodId);
        });
    }

    public static DynamicObject getCurrencyDynById(Long orgId, Long yearId, Long periodId) {
        DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"bcm_fymembertree");
        return OrgCurrencyServiceHelper.getCurrencyDynById(orgId, yearDyn.getString("number"), periodId);
    }

    public static DynamicObject getParentCurrencyDynByIdThrow(Long orgId, Long yearId, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getParentOrgModelAndCurrency(orgId, yearId, periodId);
        if (org != null && org.getInt("level") >= 3) {
            DynamicObject currency = OrgCurrencyServiceHelper.getCurrencyDyn(org);
            if (currency == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u5f97\u5230\u4efb\u4f55\u5e01\u79cd\u6570\u636e : %s", (String)"OrgCurrencyServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgId));
            }
            return currency;
        }
        DynamicObject currency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow(orgId, yearId, periodId);
        if (currency == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u5f97\u5230\u4efb\u4f55\u5e01\u79cd\u6570\u636e : %s", (String)"OrgCurrencyServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgId));
        }
        return currency;
    }

    public static IDNumberTreeNode getParentCurrencyById(Long orgId, long modelId) {
        return (IDNumberTreeNode)ThreadCache.get((Object)("getParentCurrencyById" + orgId), () -> {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String cyNum = entity != IDNumberTreeNode.NotFoundTreeNode && entity.getParent() != null && entity.getParent() != IDNumberTreeNode.NotFoundTreeNode && entity.getLevel() >= 3 ? entity.getParent().getCurrency() : entity.getCurrency();
            if (StringUtils.isEmpty((CharSequence)cyNum)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u5f97\u5230\u4efb\u4f55\u5e01\u79cd\u6570\u636e : %s", (String)"OrgCurrencyServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgId));
            }
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)cyNum);
            return cyNode;
        });
    }

    public static DynamicObject getTheDateCurrency(Long orgId, Date date) {
        return (DynamicObject)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)"getTheDateCurrency", (Object)orgId, new Object[]{date}), () -> {
            QFilter idQf = new QFilter("id", "=", (Object)orgId);
            QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)date);
            QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)date);
            expdateQf.or(expdateNullQf);
            QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
            String selectFields = "id,number,model,currency currency.id,currency.number";
            DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,model,currency currency.id,currency.number,currencychangerds.currencyrds.number", (QFilter[])filters);
            if (org == null) {
                org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,model,currency currency.id,currency.number", (QFilter[])new QFilter[]{idQf});
            } else {
                org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            }
            return org;
        });
    }

    public static DynamicObjectCollection getTheDateCurrency(Set<Long> orgIds, Date date) {
        QFilter idQf = new QFilter("id", "in", orgIds);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)date);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)date);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
        String selectFields = "id,model,currency.number";
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model,currency.number,currencychangerds.currencyrds.number", (QFilter[])filters);
        if (orgs == null || orgs.size() == 0) {
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model,currency.number", (QFilter[])new QFilter[]{idQf});
        } else {
            for (DynamicObject org : orgs) {
                org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            }
        }
        return orgs;
    }

    public static Map<Object, DynamicObject> getTheDateCurrencyMap(Set<Long> orgIds, Date date) {
        QFilter idQf = new QFilter("id", "in", orgIds);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)date);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)date);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
        String selectFields = "id,model,currency.number";
        HashMap<Object, DynamicObject> resultMap = new HashMap<Object, DynamicObject>();
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model,currency.number,currencychangerds.currencyrds.number", (QFilter[])filters);
        if (orgs == null || orgs.size() == 0) {
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model,currency.number,currencychangerds.currencyrds.number", (QFilter[])new QFilter[]{idQf});
        }
        if (orgs != null && orgs.size() != 0) {
            for (DynamicObject org : orgs) {
                org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
                resultMap.put(org.getLong("id"), org);
            }
        }
        return resultMap;
    }

    public static DynamicObject getOrgCurrency(QFilter[] qfs, Long modelId, String yearNum, String periodNum) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)yearNum, (String)periodNum);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,number,longnumber,currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,longnumber,currency.number,currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,longnumber,currency.number", (QFilter[])qfs);
        } else {
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getParentOrgCurrency(QFilter[] qfs, Long modelId, String yearNum, String periodNum) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)yearNum, (String)periodNum);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,parent,parent.currency.number currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent,parent.currency.number currency.number,parent.currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent,parent.currency.number currency.number", (QFilter[])qfBuilder.toArray());
        } else {
            org.set("currency.number", org.get("parent.currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObjectCollection getOrgsCurrency(QFilter[] qfs, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,number,longnumber,currency.number";
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,longnumber,currency.number,currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (orgs == null || orgs.size() == 0) {
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,longnumber,currency.number", (QFilter[])qfs);
        } else {
            for (DynamicObject org : orgs) {
                org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            }
        }
        return orgs;
    }

    public static DynamicObject getOrgAndParentCurrency(QFilter[] qfs, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,level,number,parent.id,parent.number,currency.number,parent.currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,level,number,parent.id,parent.number,currency.number,parent.currency.number,currencychangerds.currencyrds.number,parent.currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,level,number,parent.id,parent.number,currency.number,parent.currency.number", (QFilter[])qfs);
        } else {
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            org.set("parent.currency.number", org.get("parent.currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getOrgModelAndCurrency(Long orgId, Long yearId, Long periodId) {
        return (DynamicObject)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)"getOrgModelAndCurrency1", (Object)orgId, new Object[]{yearId, periodId}), () -> {
            Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
            return OrgCurrencyServiceHelper.getTheDateCurrency(orgId, periodLastDate);
        });
    }

    public static DynamicObject getOrgModelAndCurrency(Long orgId, String yearNum, Long periodId) {
        return (DynamicObject)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)"getOrgModelAndCurrency2", (Object)orgId, new Object[]{yearNum, periodId}), () -> {
            Date periodLastDate = PeriodUtils.getPeriodLastDate((String)yearNum, (Long)periodId);
            return OrgCurrencyServiceHelper.getTheDateCurrency(orgId, periodLastDate);
        });
    }

    public static DynamicObjectCollection getOrgModelAndCurrency(Set<Long> orgIds, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        return OrgCurrencyServiceHelper.getTheDateCurrency(orgIds, periodLastDate);
    }

    public static Map<Object, DynamicObject> getOrgModelAndCurrencyMap(Set<Long> orgIds, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        return OrgCurrencyServiceHelper.getTheDateCurrencyMap(orgIds, periodLastDate);
    }

    public static DynamicObject getParentOrgModelAndCurrency(Long orgId, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter idQf = new QFilter("id", "=", (Object)orgId);
        QFilter effdateQf = new QFilter("parent.currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("parent.currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(pExpdateNullQf);
        QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
        String selectFields = "id,parent,number,model,level,parent.number,parent.currency.id currency.id,parent.currency.number currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent,number,model,level,parent.number,parent.currency.id currency.id,parent.currency.number currency.number,parent.currencychangerds.currencyrds.id,parent.currencychangerds.currencyrds.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent,number,model,level,parent.number,parent.currency.id currency.id,parent.currency.number currency.number", (QFilter[])new QFilter[]{idQf});
        } else {
            org.set("currency.id", org.get("parent.currencychangerds.currencyrds.id"));
            org.set("currency.number", org.get("parent.currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getCurrencyDyn(DynamicObject org) {
        QFilter numberFilter = new QFilter("number", "=", (Object)org.getString("currency.number"));
        QFilter modelFilter = new QFilter("model", "=", (Object)org.getLong("model"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
    }

    public static DynamicObject getCurrencyDyn(String number, long modelId) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
    }

    public static DynamicObject getOrgById(Long orgId, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter idQf = new QFilter("id", "=", (Object)orgId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
        String selectFields = "id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg,currencychangerds.currencyrds.id,currencychangerds.currencyrds.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg", (QFilter[])new QFBuilder("id", "=", (Object)orgId).toArray());
        } else {
            org.set("currency.id", org.get("currencychangerds.currencyrds.id"));
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getOrgById(Long modelId, String orgNum, String yearNum, String periodNum) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)yearNum, (String)periodNum);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter numberQf = new QFilter("number", "=", (Object)orgNum);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{modelQf, numberQf, effdateQf, expdateQf};
        String selectFields = "id, currency.number, currency.name, model.beginyearofmonth";
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, currency.number, currency.name, model.beginyearofmonth,currencychangerds.currencyrds.name, currencychangerds.currencyrds.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, currency.number, currency.name, model.beginyearofmonth", (QFilter[])new QFilter[]{modelQf, numberQf});
        } else {
            org.set("currency.name", org.get("currencychangerds.currencyrds.name"));
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static String getjointStr(String orgNum, String yearNum, String periodNum) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgNum);
        sb.append("_");
        sb.append(yearNum);
        sb.append("_");
        sb.append(periodNum);
        return sb.toString();
    }

    public static void upgradeOrgCurrency(long modelId, long userId, Date modifytime, Date effdate) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,currency,currencychangerds,currencychangerds.currencyeffdate,currencychangerds.currencymodifier,currencychangerds.currencymodifytime,currencychangerds.currencyrds", (QFilter[])new QFilter[]{qf});
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>();
        for (DynamicObject org : orgs) {
            DynamicObjectCollection currencyRecords = org.getDynamicObjectCollection("currencychangerds");
            if (currencyRecords.size() != 0 || org.getDynamicObject("currency") == null) continue;
            DynamicObject record = currencyRecords.addNew();
            record.set("currencyeffdate", (Object)effdate);
            record.set("currencymodifier", (Object)userId);
            record.set("currencymodifytime", (Object)modifytime);
            record.set("currencyrds", (Object)org.getDynamicObject("currency"));
            lst.add(org);
        }
        if (lst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])lst.toArray(new DynamicObject[0]));
        }
    }

    public static void upgradeOrgChangedRecord(long modelId, long userId, Date modifytime, Date effdate) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,name,currency,currencychangerds,currencychangerds.currencyeffdate,currencychangerds.currencymodifier,currencychangerds.currencymodifytime,currencychangerds.currencyrds,bizchangerds,bizchangerds.changetype,bizchangerds.bizeffdate,bizchangerds.bizmodifier,bizchangerds.bizmodifytime,namechangerds,namechangerds.namerds,namechangerds.nameeffdate,namechangerds.namemodifier,namechangerds.namemodifytime,currencychangerds.seq,bizchangerds.seq,namechangerds.seq", (QFilter[])new QFilter[]{qf});
        ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>(10);
        for (DynamicObject org : orgs) {
            DynamicObjectCollection currencyRecords = org.getDynamicObjectCollection("currencychangerds");
            if (currencyRecords.size() == 0 && org.getDynamicObject("currency") != null) {
                DynamicObject record = currencyRecords.addNew();
                record.set("currencyeffdate", (Object)effdate);
                record.set("currencymodifier", (Object)userId);
                record.set("currencymodifytime", (Object)modifytime);
                record.set("currencyrds", (Object)org.getDynamicObject("currency"));
                record.set("seq", (Object)1);
            } else if (currencyRecords.size() != 0) {
                ((DynamicObject)currencyRecords.get(0)).set("seq", (Object)1);
            }
            DynamicObjectCollection bizchangerds = org.getDynamicObjectCollection("bizchangerds");
            if (bizchangerds.size() == 0) {
                DynamicObject record = bizchangerds.addNew();
                record.set("changetype", (Object)1);
                record.set("bizeffdate", (Object)effdate);
                record.set("bizmodifier", (Object)userId);
                record.set("bizmodifytime", (Object)modifytime);
                record.set("seq", (Object)1);
            } else {
                if (((DynamicObject)bizchangerds.get(0)).get("bizeffdate") == null) {
                    ((DynamicObject)bizchangerds.get(0)).set("bizeffdate", (Object)effdate);
                }
                ((DynamicObject)bizchangerds.get(0)).set("seq", (Object)1);
            }
            DynamicObjectCollection namechangerds = org.getDynamicObjectCollection("namechangerds");
            if (namechangerds.size() == 0) {
                DynamicObject record = namechangerds.addNew();
                record.set("namerds", (Object)org.getString("name"));
                record.set("nameeffdate", (Object)effdate);
                record.set("namemodifier", (Object)userId);
                record.set("namemodifytime", (Object)modifytime);
                record.set("seq", (Object)1);
            } else {
                if (((DynamicObject)namechangerds.get(0)).get("nameeffdate") == null) {
                    ((DynamicObject)namechangerds.get(0)).set("nameeffdate", (Object)effdate);
                }
                ((DynamicObject)namechangerds.get(0)).set("seq", (Object)1);
            }
            lst.add(org);
        }
        if (lst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])lst.toArray(new DynamicObject[0]));
        }
    }

    public static void upgradeOrgChangeRdForModelId(long modelId) {
        Date nowDate = TimeServiceHelper.now();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-dd");
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        int firstYear = model.getInt("startfy") + 1997 - 1;
        int firstMonth = model.getInt("beginperiod");
        String beginYearType = model.getString("beginyearofmonth");
        if (FyEnum.PRE.index.equals(beginYearType)) {
            --firstYear;
        }
        String effdate = String.valueOf(firstYear).concat("-").concat(String.valueOf(firstMonth)).concat("-01");
        try {
            OrgCurrencyServiceHelper.upgradeOrgChangedRecord(modelId, userId, nowDate, dateFormat.parse(effdate));
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
    }

    public static DynamicObject getOrgDefaultCurrency(long modelId, long orgId, String currencyNum) {
        return (DynamicObject)ThreadCache.get((Object)String.join((CharSequence)"|", "getOrgDefaultCurrency", modelId + "", orgId + "", currencyNum), () -> {
            String modelNum;
            IDNumberTreeNode treeNode;
            if (("DC".equals(currencyNum) || "EC".equals(currencyNum)) && (treeNode = MemberReader.findMemberById((String)(modelNum = MemberReader.findModelNumberById((Object)modelId)), (String)"bcm_entitymembertree", (Long)orgId)) != IDNumberTreeNode.NotFoundTreeNode) {
                return OrgCurrencyServiceHelper.getCurrencyDyn(treeNode.getCurrency(), modelId);
            }
            return OrgCurrencyServiceHelper.getCurrencyDyn(currencyNum, modelId);
        });
    }

    public static Map<Long, DynamicObject> getOrgDefaultCurrencys(long modelId, Collection<Long> orgrange) {
        HashMap<Long, DynamicObject> org_currs = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, String> org2CYNums = new HashMap<Long, String>(16);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (Long orgId : orgrange) {
            IDNumberTreeNode treeNode = MemberReader.findMemberById((String)modelNum, (String)"bcm_entitymembertree", (Long)orgId);
            org2CYNums.put(orgId, treeNode.getCurrency());
        }
        DynamicObjectCollection doc = OrgCurrencyServiceHelper.getCurrencyDyns(org2CYNums.values(), modelId);
        Map<String, DynamicObject> cyNum2Dys = doc.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
        for (Map.Entry entry : org2CYNums.entrySet()) {
            org_currs.put((Long)entry.getKey(), cyNum2Dys.get(entry.getValue()));
        }
        return org_currs;
    }

    public static Map<Long, DynamicObject> getOrgParentCurrencys(long modelId, Collection<Long> orgrange) {
        HashMap<Long, DynamicObject> org_currs = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, String> org2CYNums = new HashMap<Long, String>(16);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (Long orgId : orgrange) {
            IDNumberTreeNode treeNode = MemberReader.findMemberById((String)modelNum, (String)"bcm_entitymembertree", (Long)orgId);
            if (treeNode == null || treeNode.getParent() == null) continue;
            org2CYNums.put(orgId, treeNode.getParent().getCurrency());
        }
        DynamicObjectCollection doc = OrgCurrencyServiceHelper.getCurrencyDyns(org2CYNums.values(), modelId);
        Map<String, DynamicObject> cyNum2Dys = doc.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
        for (Map.Entry entry : org2CYNums.entrySet()) {
            org_currs.put((Long)entry.getKey(), cyNum2Dys.get(entry.getValue()));
        }
        return org_currs;
    }

    public static DynamicObjectCollection getCurrencyDyns(Collection<String> number, long modelId) {
        QFilter numberFilter = new QFilter("number", "in", number);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
    }
}

