/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class OrgServiceHelper {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String SEPARATOR = "!";

    private OrgServiceHelper() {
        throw new IllegalStateException("Illegal Class Constructor");
    }

    public static Long getEntityRoot(Long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qf.add("level", "=", (Object)1);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)ID, (QFilter[])qf.toArray());
        return dy == null ? null : Long.valueOf(dy.getLong(ID));
    }

    public static DynamicObject getOrg(Long modelId, long orgId) {
        QFilter qcs = new QFilter("model", "=", (Object)modelId);
        qcs.and(ID, "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qcs});
    }

    public static DynamicObjectCollection getOrgList(Long modelId, List<Long> orgIds) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(ID, "in", orgIds);
        qf.and("isexchangerate", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static DynamicObjectCollection getOrgListByPremOnWrite(Long modelId, List<Long> orgIds) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(ID, "in", orgIds);
        qf.and("isexchangerate", "=", (Object)"0");
        long orgDimId = DimensionServiceHelper.getIdByNum("bcm_dimension", modelId, DimEntityNumEnum.ENTITY.getNumber());
        qf.and(PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(orgDimId, "bcm_entitymembertree", ID));
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])qf.toArray(), (String)"level,dseq");
    }

    public static DynamicObjectCollection getOrgChildren(Long modelId, long pid) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("parent.id", "=", (Object)pid);
        qf.and("status", "!=", (Object)"A");
        qf.and("isexchangerate", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static DynamicObjectCollection getAllOrgChildren(Long modelId, long pid) {
        return OrgServiceHelper.getAllOrgChildren(modelId, pid, false);
    }

    public static DynamicObjectCollection getShareOrgList(Long modelId, Collection<String> orgNumbers) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(NUMBER, "in", orgNumbers);
        qf.and("status", "!=", (Object)"A");
        qf.and("isexchangerate", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static DynamicObjectCollection getAllOrgChildren(Long modelId, long pid, boolean inInclude) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pid);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (inInclude) {
            ids.add(pid);
        }
        ids.addAll(orgNode.getAllChildrenIds());
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(ID, "in", ids);
        qf.and("status", "!=", (Object)"A");
        qf.and("isexchangerate", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static DynamicObjectCollection getDirectOrgChildren(Long modelId, long pid, boolean inInclude) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pid);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (inInclude) {
            ids.add(pid);
        }
        ids.addAll(orgNode.getChildrenIds());
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(ID, "in", ids);
        qf.and("status", "!=", (Object)"A");
        qf.and("isexchangerate", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static PairList<String, Object> getAllRateOrgPairList(Long modelId) {
        DynamicObjectCollection allRateOrgList = OrgServiceHelper.getAllRateOrgList(modelId);
        PairList pairList = new PairList();
        if (!allRateOrgList.isEmpty()) {
            List<String> allYear = DimensionServiceHelper.getAllYear(modelId);
            List<String> allPeriod = DimensionServiceHelper.getAllPeriod(modelId);
            pairList.addPair((Object)PresetConstant.FY_DIM, allYear);
            pairList.addPair((Object)PresetConstant.PERIOD_DIM, allPeriod);
            pairList.addPair((Object)PresetConstant.ENTITY_DIM, allRateOrgList.stream().map(o -> o.getString(NUMBER)).collect(Collectors.toList()));
        }
        return pairList;
    }

    public static PairList<String, Object> getDeleteRateOrgPairList(Long modelId, List<String> deleteRateOrgNumberList) {
        DynamicObjectCollection allRateOrgList = OrgServiceHelper.getAllRateOrgList(modelId);
        PairList pairList = new PairList();
        if (!allRateOrgList.isEmpty()) {
            List<String> allYear = DimensionServiceHelper.getAllYear(modelId);
            List<String> allPeriod = DimensionServiceHelper.getAllPeriod(modelId);
            pairList.addPair((Object)PresetConstant.FY_DIM, allYear);
            pairList.addPair((Object)PresetConstant.PERIOD_DIM, allPeriod);
            pairList.addPair((Object)PresetConstant.ENTITY_DIM, deleteRateOrgNumberList);
        }
        return pairList;
    }

    private static DynamicObjectCollection getAllRateOrgList(Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("isexchangerate", "=", (Object)"1");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])new QFilter[]{qf}, (String)"level,dseq");
    }

    public static DynamicObjectCollection dealNoMergeOrgList(DynamicObjectCollection doc, String modelId, String scenarioId, String yearId, String periodId) {
        if (modelId != null && yearId != null && scenarioId != null && periodId != null) {
            return OrgServiceHelper.dealNoMergeOrgList(doc, Long.parseLong(modelId), Long.parseLong(scenarioId), Long.parseLong(yearId), Long.parseLong(periodId));
        }
        return doc;
    }

    public static DynamicObjectCollection dealNoMergeOrgList(DynamicObjectCollection doc, Long modelId, Long scenarioId, Long yearId, Long periodId) {
        if (modelId != null && yearId != null && scenarioId != null && periodId != null) {
            if (ConfigServiceHelper.getBoolParam(modelId, "CM030")) {
                Set<String> mergeOrgListIds = OrgServiceHelper.getNoMergeOrgIds(doc, modelId, scenarioId, yearId, periodId);
                for (DynamicObject dy : doc) {
                    if (!mergeOrgListIds.contains(dy.getString(ID))) continue;
                    dy.set(NAME, (Object)String.format(ResManager.loadKDString((String)"%s(\u4e0d\u53c2\u4e0e\u5408\u5e76)", (String)"OrgServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), dy.getString(NAME)));
                }
            } else {
                OrgServiceHelper.delNoMergeOrgListAll(doc, modelId, scenarioId, yearId, periodId);
            }
        }
        return doc;
    }

    public static DynamicObjectCollection delNoMergeOrgListAll(DynamicObjectCollection orgList, Long modelId, Long scenarioId, Long yearId, Long periodId) {
        if (orgList == null || orgList.isEmpty()) {
            return new DynamicObjectCollection();
        }
        boolean mergeOfNoLeaf = ConfigServiceHelper.getNonLeafOfCM030(modelId);
        Map allOrgNodes = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (Object)modelId);
        Collection orgMembersCol = allOrgNodes.values();
        HashSet<Long> hideOrgIds = new HashSet<Long>(orgMembersCol.size());
        Set<Long> noMergeOrgIds = OrgServiceHelper.getAllNoMergeOrgIds(allOrgNodes, modelId, scenarioId, yearId, periodId);
        if (!noMergeOrgIds.isEmpty()) {
            for (long orgId : noMergeOrgIds) {
                IDNumberTreeNode orgNode = (IDNumberTreeNode)allOrgNodes.get(orgId);
                if (orgNode.isLeaf()) {
                    hideOrgIds.add(orgId);
                    continue;
                }
                if (!mergeOfNoLeaf) {
                    hideOrgIds.add(orgId);
                    OrgServiceHelper.addAllChildrens(orgNode, hideOrgIds);
                    continue;
                }
                String longNumber = orgNode.getLongNumber() + SEPARATOR;
                Set collect = orgMembersCol.stream().filter(x -> x.getLongNumber().contains(longNumber) && !noMergeOrgIds.contains(x.getId())).collect(Collectors.toSet());
                if (!collect.isEmpty()) continue;
                hideOrgIds.add(orgId);
            }
            if (!hideOrgIds.isEmpty()) {
                Set collect = orgList.stream().filter(x -> hideOrgIds.contains(x.getLong(ID))).collect(Collectors.toSet());
                orgList.removeAll(collect);
            }
        }
        return orgList;
    }

    public static void addAllChildrens(IDNumberTreeNode node, Set<Long> noMergeChilds) {
        List children = node.getChildren();
        if (children.size() > 0) {
            noMergeChilds.addAll(children.stream().map(x -> x.getId()).collect(Collectors.toSet()));
            for (IDNumberTreeNode child : children) {
                OrgServiceHelper.addAllChildrens(child, noMergeChilds);
            }
        }
    }

    public static DynamicObjectCollection delNoMergeOrgListAllChildren(DynamicObjectCollection doc, Long modelId, Long scenarioId, Long yearId, Long periodId, Long pid) {
        if (doc == null || doc.isEmpty()) {
            return new DynamicObjectCollection();
        }
        Map allOrgNodes = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (Object)modelId);
        Collection orgMembersCol = allOrgNodes.values();
        ArrayList<Long> hideOrgIds = new ArrayList<Long>(orgMembersCol.size());
        Set<Long> noMergeOrgIds = OrgServiceHelper.getAllNoMergeOrgIds(allOrgNodes, modelId, scenarioId, yearId, periodId);
        if (!noMergeOrgIds.isEmpty()) {
            for (long orgId : noMergeOrgIds) {
                if (Objects.equals(orgId, pid)) continue;
                IDNumberTreeNode orgNode = (IDNumberTreeNode)allOrgNodes.get(orgId);
                hideOrgIds.add(orgId);
                if (orgNode.isLeaf()) continue;
                String longNumber = orgNode.getLongNumber() + SEPARATOR;
                hideOrgIds.addAll(orgMembersCol.stream().filter(x -> x.getLongNumber().contains(longNumber)).map(e -> e.getId()).collect(Collectors.toList()));
            }
            if (!hideOrgIds.isEmpty()) {
                Set collect = doc.stream().filter(x -> hideOrgIds.contains(x.getLong(ID))).collect(Collectors.toSet());
                doc.removeAll(collect);
            }
        }
        return doc;
    }

    public static DynamicObjectCollection getNoMergeOrgList(DynamicObjectCollection orgList, Long modelId, Long scenarioId, Long yearId, Long periodId) {
        DynamicObjectCollection noMergeDoc = new DynamicObjectCollection();
        if (orgList == null || orgList.isEmpty()) {
            return noMergeDoc;
        }
        Map<String, Boolean> orgMergeInfoMap = MergeControlHelper.getAllStructInfoForMap(modelId, scenarioId, yearId, periodId);
        for (DynamicObject org : orgList) {
            String parentNumber;
            IDNumberTreeNode orgTreeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)org.getLong(ID));
            if (orgTreeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
            String number = orgTreeNode.getNumber();
            IDNumberTreeNode parentOrgTreeNode = orgTreeNode.getParent();
            if (parentOrgTreeNode == null || !StringUtils.isNotEmpty((String)(parentNumber = parentOrgTreeNode.getNumber())) || !StringUtils.isNotEmpty((String)number) || OrgServiceHelper.isMerge(parentNumber + SEPARATOR + number, orgMergeInfoMap)) continue;
            noMergeDoc.add((Object)org);
        }
        return noMergeDoc;
    }

    public static Set<Long> getAllNoMergeOrgIds(Map<Long, IDNumberTreeNode> allOrgNodes, Long modelId, Long scenarioId, Long yearId, Long periodId) {
        HashSet<Long> noMergeIds = new HashSet<Long>(10);
        Map<String, Boolean> isMergeMap = MergeControlHelper.getAllStructInfoForMap(modelId, scenarioId, yearId, periodId);
        for (IDNumberTreeNode node : allOrgNodes.values()) {
            String parentNumber;
            Long orgId = node.getId();
            String number = node.getNumber();
            IDNumberTreeNode parentOrgTreeNode = node.getParent();
            if (parentOrgTreeNode == null || !StringUtils.isNotEmpty((String)(parentNumber = parentOrgTreeNode.getNumber())) || !StringUtils.isNotEmpty((String)number) || OrgServiceHelper.isMerge(parentNumber + SEPARATOR + number, isMergeMap)) continue;
            noMergeIds.add(orgId);
        }
        return noMergeIds;
    }

    public static Set<String> getNoMergeOrgIds(DynamicObjectCollection doc, Long modelId, Long scenarioId, Long yearId, Long periodId) {
        DynamicObjectCollection noMergeDoc = OrgServiceHelper.getNoMergeOrgList(doc, modelId, scenarioId, yearId, periodId);
        HashSet<String> selectIds = new HashSet<String>(noMergeDoc.size());
        for (DynamicObject dy : noMergeDoc) {
            selectIds.add(dy.getString(ID));
        }
        return selectIds;
    }

    private static boolean isMerge(String key, Map<String, Boolean> isMergeMap) {
        return isMergeMap.get(key) == null || isMergeMap.get(key) != false;
    }

    public static void setLeftTreeNoteChange(Set<String> actSelectIds, OrgTreeNode children) {
        if (children != null) {
            String id = children.getId();
            if (actSelectIds.contains(id)) {
                children.setName(String.format(ResManager.loadKDString((String)"%s(\u4e0d\u53c2\u4e0e\u5408\u5e76)", (String)"OrgServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), children.getName()));
            }
            if (children.getChildren() != null && children.getChildSize() > 0) {
                for (ITreeNode tn : children.getChildren()) {
                    OrgServiceHelper.setLeftTreeNoteChange(actSelectIds, (OrgTreeNode)tn);
                }
            }
        }
    }

    public static DynamicObjectCollection getMergeOrgListByParentDisable(DynamicObjectCollection doc, Object modelId, long sceneId, String yearNum, Object periodId, String cslschemeId) {
        String selectField = "id,name,number,longNumber,isleaf,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate";
        QFBuilder qfBuilder = new QFBuilder().add("model", "=", (Object)LongUtil.toLong((Object)modelId));
        if (cslschemeId != null) {
            qfBuilder.add("cslscheme", "=", (Object)LongUtil.toLong((Object)cslschemeId));
            qfBuilder.or(NUMBER, "=", (Object)"Entity");
        }
        Map orgMembers = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)selectField, (QFilter[])qfBuilder.toArray());
        Collection orgMembersCol = orgMembers.values();
        DynamicObjectCollection memberColls = new DynamicObjectCollection();
        memberColls.addAll(orgMembersCol);
        EntityVersioningUtil.filterOrgsByMergeStruct(new FilterOrgStructParam((long)LongUtil.toLong((Object)modelId), sceneId, yearNum, (long)LongUtil.toLong((Object)periodId)), (List<DynamicObject>)memberColls);
        HashMap orgMap = Maps.newHashMap();
        for (DynamicObject memberColl : memberColls) {
            orgMap.put(memberColl.getLong(ID), Boolean.TRUE);
        }
        for (int i = doc.size() - 1; i >= 0; --i) {
            DynamicObject dy = (DynamicObject)doc.get(i);
            Long entityId = dy.getLong(ID);
            if (null != orgMap.get(entityId)) continue;
            doc.remove((Object)dy);
        }
        return doc;
    }

    public static void dealNoMergeOrgs(DynamicObjectCollection doc, Long modelId, Long scenarioId, Long yearId, Long periodId, OrgTreeNode root) {
        if (modelId != null && yearId != null && scenarioId != null && periodId != null) {
            if (ConfigServiceHelper.getBoolParam(modelId, "CM030")) {
                if (root != null) {
                    Set<String> mergeOrgIds = OrgServiceHelper.getNoMergeOrgIds(doc, modelId, scenarioId, yearId, periodId);
                    OrgServiceHelper.setLeftTreeNoteChange(mergeOrgIds, root);
                }
            } else {
                OrgServiceHelper.delNoMergeOrgListAll(doc, modelId, scenarioId, yearId, periodId);
            }
        }
    }

    public static String getEnumValueByValue(String changetype, Long modelId) {
        Map<String, ChangeTypeModel> invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(modelId);
        if (invChangetypeModel.containsKey(changetype)) {
            return changetype;
        }
        throw new KDBizException(String.format("not fount OrgBizChangeType value %s", changetype));
    }

    public static String getEnumTextByValue(String changetype, Long modelId) {
        Map<String, ChangeTypeModel> invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(modelId);
        if (invChangetypeModel.containsKey(changetype)) {
            return invChangetypeModel.get(changetype).name();
        }
        throw new KDBizException(String.format("not fount OrgBizChangeType value %s", changetype));
    }

    public static long getCslSchemeId(long orgId) {
        return (Long)ThreadCache.get((Object)"CsSchemeId", () -> {
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"cslscheme.id", (QFilter[])new QFilter(ID, "=", (Object)orgId).toArray());
            return scheme != null ? scheme.getLong("cslscheme.id") : -1L;
        });
    }

    public static List<Long> findAllParentOrgIdsFormMemberNode(Long modelId, List<Long> orgIdList) {
        ArrayList<Long> allOrgIds = new ArrayList<Long>(16);
        if (CollectionUtils.isEmpty(orgIdList)) {
            return allOrgIds;
        }
        for (Long tempOrgId : orgIdList) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)tempOrgId);
            OrgServiceHelper.findParentOrgIds(orgNode, allOrgIds);
        }
        return allOrgIds;
    }

    private static void findParentOrgIds(IDNumberTreeNode orgNode, List<Long> orgIds) {
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode || "Entity".equals(orgNode.getNumber())) {
            return;
        }
        IDNumberTreeNode nodeParent = orgNode.getParent();
        if (nodeParent != null && IDNumberTreeNode.NotFoundTreeNode != nodeParent && !"Entity".equals(nodeParent.getNumber())) {
            Long nodeParentId = nodeParent.getId();
            if (!orgIds.contains(nodeParentId)) {
                orgIds.add(nodeParentId);
            }
            OrgServiceHelper.findParentOrgIds(nodeParent, orgIds);
        }
    }

    public static Set<Long> findParentOrgIdsForIsMergeAndCSTE(Long modelId, Long scenarioId, Long yearId, Long periodId, Set<Long> orgIdSet) {
        HashSet<Long> partMergeOrgIdSet = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return partMergeOrgIdSet;
        }
        Table<String, String, Boolean> isMergeMap = MergeControlHelper.getAllStructInfoForTable(modelId, scenarioId, yearId, periodId);
        for (Long tempOrgId : orgIdSet) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)tempOrgId);
            OrgServiceHelper.initParentOrgs(orgNode, partMergeOrgIdSet, modelId, scenarioId, yearId, periodId, isMergeMap);
        }
        return partMergeOrgIdSet;
    }

    private static void initParentOrgs(IDNumberTreeNode orgNode, Set<Long> orgIds, Long modelId, Long scenarioId, Long yearId, Long periodId, Table<String, String, Boolean> isMergeMap) {
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode || "Entity".equals(orgNode.getNumber())) {
            return;
        }
        IDNumberTreeNode nodeParent = orgNode.getParent();
        if (nodeParent != null && IDNumberTreeNode.NotFoundTreeNode != nodeParent && !"Entity".equals(nodeParent.getNumber())) {
            MergeDataSourceEnum dataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)scenarioId, (Object)yearId, (Object)periodId, nodeParent.getId());
            if (MergeDataSourceEnum.CSTE == dataSourceEnum) {
                return;
            }
            Boolean isMerge = (Boolean)isMergeMap.get((Object)nodeParent.getNumber(), (Object)orgNode.getNumber());
            if (!Boolean.FALSE.equals(isMerge)) {
                Long nodeParentId = nodeParent.getId();
                orgIds.add(nodeParentId);
                OrgServiceHelper.initParentOrgs(nodeParent, orgIds, modelId, scenarioId, yearId, periodId, isMergeMap);
            }
        }
    }

    public static void checkChangeTypeUsed(long modelId, Set<String> numbers, BiConsumer<String, String> consumer) {
        QFBuilder qfBuilder = new QFBuilder("bizchangerds.changetype", "in", numbers);
        qfBuilder.and("model", "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,longnumber,bizchangerds.changetype", (QFilter[])qfBuilder.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String changeTypeNumber = dynamicObject.getString("bizchangerds.changetype");
                String longNumber = dynamicObject.getString("longnumber");
                consumer.accept(changeTypeNumber, longNumber);
            }
        }
    }
}

