/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.api.MemberTreeNode;
import kd.fi.bcm.business.dimension.api.QueryMemberDTO;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.lang.StringUtils;

public class QueryDimensionServiceHelper {
    public static String getIdByFormName(String name) {
        String id = QueryDimensionServiceHelper.search("id", "name", name, "bos_formmeta");
        return id;
    }

    public static void delectDimensionDefaultValue(Set<String> deleteTreeMember, String dimensionNum, Long modelId) {
        QFilter qcf = new QFilter("model.id", "=", (Object)modelId);
        QFilter qcf1 = new QFilter("dimension", "=", (Object)dimensionNum);
        QFilter qcf2 = new QFilter("defaultvalueid", "in", deleteTreeMember);
        DeleteServiceHelper.delete((String)"bcm_defaultvalue", (QFilter[])new QFilter[]{qcf, qcf1, qcf2});
    }

    public static boolean checkNumber(String number, String modelid) {
        boolean is = QueryDimensionServiceHelper.checkInfoInModel("number", "number", number, "bcm_dimension", modelid);
        return is;
    }

    public static boolean checkName(String name, String modelid) {
        boolean is = QueryDimensionServiceHelper.checkInfoInModel("name", "name", name, "bcm_dimension", modelid);
        return is;
    }

    public static boolean checkShortNumber(String snum, String modelid) {
        boolean is = QueryDimensionServiceHelper.checkInfoInModel("shortnumber", "shortnumber", snum, "bcm_dimension", modelid);
        return is;
    }

    public static boolean checkInfoInModel(String selectField, String filter, String filvalue, String form, String modelid) {
        QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
        QFilter fmodelid2 = new QFilter("model", "=", (Object)ConvertUtil.convertStrToLong(modelid));
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.exists((String)form, (QFilter[])filters);
    }

    public static String getIdByModelNumber(String number) {
        QFilter fmodelid = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])filters);
        String id = "";
        if (dcs != null) {
            id = dcs.getString("id");
        }
        return id;
    }

    public static String search(String selectField, String filter, String filvalue, String form) {
        String selectFields = selectField;
        QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)form, (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static int getMaxDseq(String modId) {
        String selectFields = "dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modId));
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq desc");
        int result = 0;
        if (dcs != null && dcs.size() > 0) {
            result = ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return result;
    }

    public static String getDimIdByNumber(String number, String modId) {
        String selectFields = "id";
        QFilter fmodelid = new QFilter("model", "=", (Object)Long.valueOf(modId));
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static String getDimNumberById(String id) {
        String selectFields = "number";
        QFilter fmodelid = new QFilter("id", "=", (Object)LongUtil.toLong((Object)id));
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static DynamicObject getDimById(Long dimensionId, String modelId) {
        String selectFields = "id,number,name,membermodel,shortnumber,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter fmodelid2 = new QFilter("id", "=", (Object)dimensionId);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getDimByDseq(int seq, String modelId) {
        String selectFields = "id,number,name,membermodel,shortnumber,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong(modelId));
        QFilter fmodelid2 = new QFilter("dseq", "=", (Object)seq);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getDimByNumber(String number, Long modelId) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getDMDimByNumber(String number, Long modelId, String entity) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fnumber = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)selectFields, (QFilter[])filters);
    }

    public static Long getDefautDimMemId(long dimid, String membermodel) {
        String selectFields = "id";
        QFilter fmodelid = new QFilter("dimension", "=", (Object)dimid);
        QFilter fmodelid3 = new QFilter("issysmember", "=", (Object)1);
        QFilter fmodelid4 = new QFilter("level", "=", (Object)2);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid3, fmodelid4};
        return QueryServiceHelper.queryOne((String)membermodel, (String)selectFields, (QFilter[])filters).getLong("id");
    }

    public static List<DynamicObject> getrank(List<String> number, Long modelId) {
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "in", number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        return dcs;
    }

    public static List<DynamicObject> getOthersDim(List<String> number, Long modelId) {
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "not in", number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        return dcs;
    }

    public static DynamicObject getMsgByNumber(long modelId, String number) {
        String selectFields = "dseq,membermodel,id,name,number,fieldmapped";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getMsgByNumberIgnoreCase(long modelId, String number) {
        String selectFields = "dseq,membermodel,id,name,number,fieldmapped,shortnumber";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
        for (DynamicObject dynamicObject : collection) {
            if (!dynamicObject.getString("number").equalsIgnoreCase(number)) continue;
            return dynamicObject;
        }
        return null;
    }

    public static boolean checkIcEnt(long modelId) {
        return true;
    }

    public static boolean checkMyCompanyEnt(long modelId) {
        String selectFields = "count(*) as num";
        QFilter fmodelid = new QFilter("issysmember", "!=", (Object)1);
        QFilter fmodelid2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs2 = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_mycompanymembertree", (String)selectFields, (QFilter[])filters, null);
        int num = 0;
        if (dcs2 != null && dcs2.size() > 0) {
            num = Integer.parseInt(((DynamicObject)dcs2.get(0)).get("num").toString());
        }
        return num > 0;
    }

    public static boolean isExitDimension(long modelId, String number) {
        String selectFields = "dseq,membermodel,id,name,number";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
        return dcs != null;
    }

    public static DynamicObject getMemberMsgByNumber(long modelId, String number, String entityName) {
        String selectFields = "id,number,name,isleaf,longnumber,storagetype,parent";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)number);
        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        QFilter[] filters = new QFilter[]{qFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectFields, (QFilter[])filters);
    }

    public static Map<String, DynamicObject> getMemberMapByNumber(long modelId, List<String> numbers, String entityName) {
        String selectFields = "id,number,name,isleaf,longnumber,storagetype";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", numbers);
        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObjectCollection col = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        col.forEach(e -> result.put(e.getString("number"), (DynamicObject)e));
        return result;
    }

    public static DynamicObjectCollection getUserDefineMember(long modelId) {
        String selectFields = "id,number,name";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("issysdimension", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{qFilter};
        return QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getUserDefineMember(long modelId, long dimensionId, String number) {
        String selectFields = "id,number,name,isleaf,longnumber,storagetype";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimensionId);
        qFilter.and("number", "=", (Object)number);
        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        QFilter[] filters = new QFilter[]{qFilter};
        return QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getMsgByDimId(Object dimId) {
        String selectFields = "model,membermodel";
        QFilter fmodelid = new QFilter("id", "=", (Object)LongUtil.toLong((Object)dimId));
        QFilter[] filters = new QFilter[]{fmodelid};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static String getModelNumber(long modelId) {
        return MemberReader.findModelNumberById((Object)modelId);
    }

    public static DynamicObject[] getMoreMsgByNumber(long modelId, List<String> number) {
        DynamicObject[] dob = new DynamicObject[number.size()];
        String selectFields = "dseq,membermodel,id,name,number";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fnumber = new QFilter("number", "in", number);
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
        for (DynamicObject dynamicObject : dcs) {
            int i = number.indexOf(dynamicObject.getString("number"));
            dob[i] = dynamicObject;
        }
        return dob;
    }

    public static List<DynamicObject> getUserDefineDim(Long modelId) {
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fliter2 = new QFilter("ISSYSDIMENSION", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{fmodelid, fliter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
        return dcs;
    }

    public static String[] getparent(String fid, String entityName) {
        QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)fid));
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "longnumber,level";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityName, (String)selectFields, (QFilter[])qfs, null);
        String Flongnumber = ((DynamicObject)dcs.get(0)).getString("longnumber");
        String Flevel = String.valueOf(((DynamicObject)dcs.get(0)).getInt("level"));
        String[] ss = new String[]{Flongnumber, Flevel};
        return ss;
    }

    public static DynamicObjectCollection getDimensionBaseInfos(Object model) {
        QFilter qf = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)model));
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfs, (String)"dseq");
        return dcs;
    }

    public static List<Long> getdimensionIds(String model) {
        QFilter qf = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)model));
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)selectFields, (QFilter[])qfs, null);
        ArrayList<Long> list = new ArrayList<Long>();
        dcs.forEach(p -> list.add(p.getLong("id")));
        return list;
    }

    public static List<Long> getdimensionId(String model, DimTypesEnum type) {
        QFilter qf1 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)model));
        QFilter qf2 = new QFilter("number", "=", (Object)type.getNumber());
        QFilter[] qfs = new QFilter[]{qf1, qf2};
        ArrayList<Long> list = new ArrayList<Long>(10);
        for (DynamicObject dyn : BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id", (QFilter[])qfs).values()) {
            list.add(dyn.getLong("id"));
        }
        return list;
    }

    public static int getMaxDSeq(long parentselectid, String entityname) {
        QFilter fdimenId = new QFilter("parent", "=", (Object)parentselectid);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityname, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq");
        }
        return 0;
    }

    public static DynamicObject getMemMsgById(String memId, String membermodel) {
        if (StringUtils.isBlank((String)memId)) {
            return null;
        }
        String selectFields = "id, name, number, isleaf, dimension.number, issysmember,longnumber,level";
        if ("bcm_entitymembertree".equalsIgnoreCase(membermodel)) {
            selectFields = "id, name, number, isleaf, dimension.number, issysmember,longnumber,level,cslscheme";
        }
        QFilter qf1 = new QFilter("id", "=", (Object)LongUtil.toLong((Object)memId));
        QFilter[] filters = new QFilter[]{qf1};
        return QueryServiceHelper.queryOne((String)membermodel, (String)selectFields, (QFilter[])filters);
    }

    public static List<String> getDimensionNums(Long modelId) {
        return (List)GlobalCacheServiceHelper.getOrLoadNode((String)("getDimensionNums-" + modelId), () -> {
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])qf.toArray(), null);
            ArrayList list = new ArrayList();
            dcs.forEach(p -> list.add(p.getString("number")));
            return list;
        });
    }

    public static long getParentId(long modelId, String entityName, String parentNum, String algoNmae) {
        long parentid = 0L;
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)parentNum);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoNmae, (String)entityName, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            parentid = ((DynamicObject)dcs.get(0)).getLong("id");
        }
        return parentid;
    }

    public static Map<String, Tuple<String, String, String>> getDimensionsInfo(Long modelId) {
        return (Map)GlobalCacheServiceHelper.getOrLoadNode((String)("getDimensionsInfo-" + modelId), () -> {
            LinkedHashMap shortNumber2NumberName = new LinkedHashMap(16);
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,number,name,membermodel", (QFilter[])qf.toArray(), (String)"dseq");
            dcs.forEach(p -> shortNumber2NumberName.put(p.getString("shortnumber"), new Tuple((Object)p.getString("number"), (Object)p.getString("name"), (Object)p.getString("membermodel"))));
            return shortNumber2NumberName;
        });
    }

    public static boolean ifMemberExistMDData(String cube, PairList<String, String> dim) {
        SQLBuilder sql = new SQLBuilder(cube);
        for (Pair pair : dim) {
            sql.addFilter((String)pair.p1, (String)pair.p2);
            sql.addSelectField((String)pair.p1);
        }
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.setTop(1);
        MDResultSet set = OlapServiceHelper.queryData(sql);
        return set.next();
    }

    public static Map<String, String> getOrgNameByNum(long modelid, String[] numbers) {
        QFilter qf1 = new QFilter("number", "in", (Object)numbers);
        QFilter qf2 = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{qf1, qf2};
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"name,number", (QFilter[])filters);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject obj : docs) {
            map.put(obj.getString("number"), obj.getString("name"));
        }
        return map;
    }

    public static boolean checkDimNumberExist(String number, long modelid) {
        return QueryDimensionServiceHelper.getDimNumberEgnoreCase(number, modelid) != null;
    }

    public static String getDimNumberEgnoreCase(String number, long modelid) {
        Collection dimNums = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelid)).values();
        for (String realnumber : dimNums) {
            if (!realnumber.equalsIgnoreCase(number)) continue;
            return realnumber;
        }
        return null;
    }

    public static Map<String, Map<String, Map<String, Object>>> getDimMemberInfoMap(long modelid, Map<String, List<String>> dimNumbers, boolean onlyLeaf) {
        boolean isTrue = true;
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>(dimNumbers.size());
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        QFilter qFilter1 = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        if (onlyLeaf) {
            qFilter.and("isleaf", "=", (Object)isTrue);
        }
        for (Map.Entry<String, List<String>> entry : dimNumbers.entrySet()) {
            String dim = entry.getKey();
            List<String> value = entry.getValue();
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(dim);
            HashMap dimInfo = new HashMap(16);
            DataSet dset = QueryServiceHelper.queryDataSet((String)"bcm", (String)entity, (String)StringUtils.strip((String)value.toString(), (String)"[]"), (QFilter[])new QFilter[]{qFilter, qFilter1}, null);
            while (dset.hasNext()) {
                Row row = dset.next();
                HashMap<String, Object> temp = new HashMap<String, Object>(value.size());
                for (String field : value) {
                    temp.put(field, row.get(field));
                }
                dimInfo.put(row.getString("number"), temp);
            }
            result.put(dim, dimInfo);
        }
        return result;
    }

    public static DynamicObject getDimensionHideDefaultItem(Long dimensionId, Long modelId) {
        String selectFields = "id,ishide,hidedefaults";
        QFilter qFilter = new QFilter("id", "=", (Object)dimensionId);
        qFilter.and("model", "=", (Object)modelId);
        qFilter.and("membermodel", "=", (Object)"bcm_userdefinedmembertree");
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public static Map<Long, Pair<Boolean, String>> getDimensionHideDefaultItem(Long modelId) {
        String selectFields = "id,ishide,hidedefaults";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("membermodel", "=", (Object)"bcm_userdefinedmembertree");
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, Pair<Boolean, String>> dimensions = new HashMap<Long, Pair<Boolean, String>>();
        for (DynamicObject obj : docs) {
            Pair pair = new Pair((Object)obj.getBoolean("ishide"), (Object)obj.getString("hidedefaults"));
            dimensions.put(obj.getLong("id"), (Pair<Boolean, String>)pair);
        }
        return dimensions;
    }

    public static List<Map<String, String>> getOrgByFilter(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dcs = orm.query("bos_org", "id,number,simplename", filters);
        ArrayList<Map<String, String>> rootNodeList = new ArrayList<Map<String, String>>();
        for (DynamicObject dyO : dcs) {
            HashMap<String, String> mtree = new HashMap<String, String>();
            mtree.put("id", String.valueOf(dyO.getLong("id")));
            mtree.put("number", dyO.getString("number"));
            mtree.put("simplename", dyO.getString("simplename"));
            rootNodeList.add(mtree);
        }
        return rootNodeList;
    }

    public static DynamicObjectCollection getOrgParents(Object modelId, String longnumber, boolean isInclude, String selectFields) {
        String[] orgNumbers = longnumber.split("!");
        ArrayList<String> list = new ArrayList<String>(orgNumbers.length);
        String tmpStr = orgNumbers[0];
        for (int i = 1; i < orgNumbers.length - 1; ++i) {
            tmpStr = tmpStr.concat("!").concat(orgNumbers[i]);
            list.add(tmpStr);
        }
        if (isInclude) {
            list.add(longnumber);
        }
        QFilter qcs = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qcs.and("longnumber", "in", (Object)list.toArray());
        qcs.and("longnumber", "!=", (Object)"Entity");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])new QFilter[]{qcs});
        return orgs;
    }

    public static DynamicObjectCollection getDefaultValue(Long modelId, String formId, String permClassId, Long userId) {
        QFilter qcf3;
        DynamicObjectCollection returnDoc = new DynamicObjectCollection();
        String selectProperties = "id,model,usedinmenu,scope,permclass,creatorid,modifierld,dimension,hiden,defaultvalue,defaultvalueid,defaultnumber,createdate,modifydate";
        QFilter qcf = new QFilter("model", "=", (Object)modelId);
        QFilter qcf1 = new QFilter("usedinmenu", "=", (Object)formId);
        QFilter qcf2 = new QFilter("hiden", "=", (Object)false);
        DynamicObject[] root = BusinessDataServiceHelper.load((String)"bcm_defaultvalue", (String)selectProperties, (QFilter[])new QFilter[]{qcf, qcf1, qcf2, qcf3 = new QFilter("scope", "=", (Object)"1")}, (String)"createdate");
        if (root != null && root.length > 0) {
            boolean isGlobal = ConfigServiceHelper.getBoolParam(modelId, "isGlobalDefaultValue");
            if (isGlobal) {
                userId = root[0].getLong("modifierld.id");
            }
            for (DynamicObject obj : root) {
                if (userId == null || userId.longValue() != obj.getLong("modifierld.id")) continue;
                returnDoc.add((Object)obj);
            }
        }
        return returnDoc;
    }

    public static void updateHide(Long modelId, String dimNumber, Boolean isHide) {
        String selectProperties = "id,model,usedinmenu,scope,permclass,creatorid,modifierld,dimension,hiden,defaultvalue,defaultvalueid,defaultnumber,createdate,modifydate";
        QFilter qcf = new QFilter("model", "=", (Object)modelId);
        QFilter qcf1 = new QFilter("dimension", "=", (Object)dimNumber);
        DynamicObject[] oldData = BusinessDataServiceHelper.load((String)"bcm_defaultvalue", (String)selectProperties, (QFilter[])new QFilter[]{qcf, qcf1});
        if (oldData == null || oldData.length == 0) {
            return;
        }
        for (DynamicObject dy : oldData) {
            dy.set("hiden", (Object)isHide);
        }
        SaveServiceHelper.update((DynamicObject[])oldData);
    }

    public static Map<String, Long> getNumberAndDimIDMap(long modelId) {
        HashMap<String, Long> numb2IdMap = new HashMap<String, Long>(16);
        QueryServiceHelper.query((String)"bcm_dimension", (String)"number,id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").forEach(e -> numb2IdMap.put(e.getString("number").toLowerCase(), e.getLong("id")));
        return numb2IdMap;
    }

    public static Map<Long, MemberTreeNode> queryMemberTree(QueryMemberDTO param) {
        long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)param.getDimNum());
        if (modelId == 0L || dimId == 0L) {
            throw new KDBizException("model or dimension is not exits.");
        }
        String entityName = MemberReader.getEntityNumberByDim((String)param.getModelNum(), (String)param.getDimNum());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        if ("Entity".equals(param.getDimNum())) {
            QFilter sFilter = new QFilter("model", "=", (Object)modelId);
            sFilter.and(new QFilter("number", "=", (Object)param.getSchemeNum()));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])sFilter.toArray());
            if (scheme == null) {
                throw new KDBizException("scheme is not exits.");
            }
            filter.and(new QFilter("cslscheme", "=", (Object)scheme.getLong("id")));
            filter.and(new QFilter("status", "!=", (Object)"A"));
        }
        if ("W".equals(param.getPermType())) {
            filter.and(PermissionServiceImpl.getInstance(modelId).getWritePermFilter(dimId, entityName, "id"));
        } else if ("R".equals(param.getPermType())) {
            filter.and(PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(dimId, entityName, "id"));
        }
        DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"id,number,name,level,parent.id,dseq,storagetype,isleaf,copyfrom.id", (QFilter[])filter.toArray(), (String)"level,dseq");
        if (docs == null || docs.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<Long, MemberTreeNode> nodes = new HashMap<Long, MemberTreeNode>(docs.size());
        docs.forEach(d -> {
            MemberTreeNode node = new MemberTreeNode(d.getLong("id"), d.getString("number"), d.getString("name"), d.getLong("parent.id"));
            nodes.put(d.getLong("id"), node);
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("storagetype", d.getString("storagetype"));
            data.put("dseq", d.getString("dseq"));
            data.put("isleaf", d.getString("isleaf"));
            data.put("level", d.getString("level"));
            node.setData(data);
        });
        return nodes;
    }

    public static Set<Long> queryMembers(QueryMemberDTO param) {
        DynamicObjectCollection docs;
        long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)param.getDimNum());
        if (modelId == 0L || dimId == 0L) {
            throw new KDBizException("model or dimension is not exits.");
        }
        String entityName = MemberReader.getEntityNumberByDim((String)param.getModelNum(), (String)param.getDimNum());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        if ("W".equals(param.getPermType())) {
            filter.and(PermissionServiceImpl.getInstance(modelId).getWritePermFilter(dimId, entityName, "id"));
        } else if ("R".equals(param.getPermType())) {
            filter.and(PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(dimId, entityName, "id"));
        }
        if ("Entity".equals(param.getDimNum())) {
            QFilter sFilter = new QFilter("model", "=", (Object)modelId);
            sFilter.and(new QFilter("number", "=", (Object)param.getSchemeNum()));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])sFilter.toArray());
            if (scheme == null) {
                throw new KDBizException("scheme is not exits.");
            }
            filter.and(new QFilter("cslscheme", "=", (Object)scheme.getLong("id")));
            filter.and(new QFilter("status", "!=", (Object)"A"));
        }
        if ((docs = QueryServiceHelper.query((String)entityName, (String)"id,number,name,level,parent,dseq,storagetype,isleaf,copyfrom.id", (QFilter[])filter.toArray(), (String)"level,dseq")) == null || docs.isEmpty()) {
            return new HashSet<Long>(0);
        }
        return docs.stream().mapToLong(d -> d.getLong("id")).boxed().collect(Collectors.toSet());
    }
}

