/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.helper;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.CurrencyScaleEnum;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DataFromEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.ArrayUtils;

public class SaveDimMemberHelper {
    private static final Log log = LogFactory.getLog((String)"SaveDimMemberHelper");

    static String getLogResult() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"SaveDimMemberHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static void saveLog(DynamicObject dataEntity) {
        try {
            int storageType;
            long id = dataEntity.getLong("id");
            DimMemberOperateTypeEnum type = id > 0L ? ((storageType = dataEntity.getInt("storagetype")) == 3 ? DimMemberOperateTypeEnum.SHARE_EDIT : DimMemberOperateTypeEnum.EDIT) : DimMemberOperateTypeEnum.NEW;
            List<DynamicObject> logs = SaveDimMemberHelper.generateDimMemberModifyLog(dataEntity, type, null, null);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            SaveDimMemberHelper.writeOperationLog(logs);
        }
        catch (Exception e) {
            log.error("edit:" + e.getMessage());
        }
    }

    public static void saveLog(DynamicObject dataEntity, DimMemberOperateTypeEnum type) {
        try {
            List<DynamicObject> logs = SaveDimMemberHelper.generateDimMemberModifyLog(dataEntity, type, null, null);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            SaveDimMemberHelper.writeOperationLog(logs);
        }
        catch (Exception e) {
            log.error("import_new:" + e.getMessage());
        }
    }

    public static void batchSaveLog(DynamicObject[] dataEntities, DimMemberOperateTypeEnum type) {
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        try {
            ArrayList<DynamicObject> allLogs = new ArrayList<DynamicObject>(dataEntities.length);
            Arrays.stream(dataEntities).forEach(x -> allLogs.addAll(SaveDimMemberHelper.generateDimMemberModifyLog(x, type, null, null)));
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(allLogs);
            SaveDimMemberHelper.writeOperationLog(allLogs);
        }
        catch (Exception e) {
            log.error("import_new:" + e.getMessage());
        }
    }

    public static void batchSaveLog(DynamicObject[] dataEntities) {
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        try {
            ArrayList<DynamicObject> allLogs = new ArrayList<DynamicObject>(dataEntities.length);
            Arrays.stream(dataEntities).forEach(x -> allLogs.addAll(SaveDimMemberHelper.generateDimMemberModifyLog(x, x.getString("storagetype").equals(StorageTypeEnum.SHARE.index) ? DimMemberOperateTypeEnum.IMPORT_SHARE_NEW : DimMemberOperateTypeEnum.IMPORT_NEW, null, null)));
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(allLogs);
            String des = String.format(ResManager.loadKDString((String)"\u5bfc\u5165%s", (String)"DimMemberOperateTypeEnum_99", (String)"fi-bcm-common", (Object[])new Object[0]), SaveDimMemberHelper.getLogResult());
            OperationLogUtil.writeOperationLog(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DimMemberOperateTypeEnum_88", (String)"fi-bcm-common", (Object[])new Object[0]), des, ((DynamicObject)allLogs.get(0)).getLong("model_id"), "bcm_dimensionmanager");
        }
        catch (Exception e) {
            log.error("import_new:" + e.getMessage());
        }
    }

    public static void saveImportUpdateLog(DynamicObject dataEntity, DimMemberOperateTypeEnum type) {
        try {
            List<DynamicObject> logs = SaveDimMemberHelper.generateDimMemberModifyLog(dataEntity, type, null, null);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            SaveDimMemberHelper.writeOperationLog(logs);
        }
        catch (Exception e) {
            log.error("import_update:" + e.getMessage());
        }
    }

    public static void saveBatchImportUpdateLog(List<DynamicObject> dataEntities, DimMemberOperateTypeEnum type, Function<Long, DynamicObject> getOriginDyByIdFunc) {
        if (CollectionUtils.isEmpty(dataEntities)) {
            return;
        }
        try {
            ArrayList<DynamicObject> allLogs = new ArrayList<DynamicObject>(dataEntities.size() * 2);
            dataEntities.forEach(x -> allLogs.addAll(SaveDimMemberHelper.generateDimMemberModifyLog(x, type, null, getOriginDyByIdFunc)));
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(allLogs);
            String des = String.format(ResManager.loadKDString((String)"\u5bfc\u5165%s", (String)"DimMemberOperateTypeEnum_99", (String)"fi-bcm-common", (Object[])new Object[0]), SaveDimMemberHelper.getLogResult());
            OperationLogUtil.writeOperationLog(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DimMemberOperateTypeEnum_88", (String)"fi-bcm-common", (Object[])new Object[0]), des, ((DynamicObject)allLogs.get(0)).getLong("model_id"), "bcm_dimensionmanager");
        }
        catch (Exception e) {
            log.error("import_update:" + e.getMessage());
        }
    }

    public static void saveLog(List<DynamicObject> dataList, DimMemberOperateTypeEnum type) {
        try {
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
            for (DynamicObject data : dataList) {
                List<DynamicObject> modifyLogs = SaveDimMemberHelper.generateDimMemberModifyLog(data, type, null, null);
                if (modifyLogs.size() <= 0) continue;
                logs.addAll(modifyLogs);
            }
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            SaveDimMemberHelper.writeOperationLog(logs);
        }
        catch (Exception e) {
            log.error("new_share:" + e.getMessage());
        }
    }

    public static void saveDeleteLog(String entityId, Set<String> deleteIdSet, long userId) {
        try {
            List<DynamicObject> logs = SaveDimMemberHelper.generateDimMemberDeleteLog(entityId, deleteIdSet, userId);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
        }
        catch (Exception e) {
            log.error("delete:" + e.getMessage());
        }
    }

    public static void saveSingleMemberOperateLog(String entityId, long memberId, Long userId, DimMemberOperateTypeEnum type) {
        try {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)entityId);
            List<DynamicObject> logs = SaveDimMemberHelper.generateDimMemberModifyLog(dataEntity, type, userId, null);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
            SaveDimMemberHelper.writeOperationLog(logs);
        }
        catch (Exception e) {
            log.error(type.getValue() + ":" + e.getMessage());
        }
    }

    public static void savePasteMemberOperateLog(DynamicObject cutMember, DynamicObject pasteMember) {
        try {
            String before = String.format(ResManager.loadKDString((String)"%1$s \u76f4\u63a5\u4e0b\u7ea7", (String)"SaveDimMemberHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), cutMember.getString("parent.number"));
            String after = String.format(ResManager.loadKDString((String)"%1$s \u76f4\u63a5\u4e0b\u7ea7", (String)"SaveDimMemberHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), pasteMember.getString("number"));
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(cutMember.getLong("model.id"), cutMember.getLong("dimension.id"), cutMember.getLong("id"), cutMember.getString("number"), cutMember.getString("name"), DimMemberOperateTypeEnum.PASTE.getValue(), DimMemberOperateTypeEnum.PASTE.getName(), before, after, RequestContext.get().getCurrUserId(), 1, "192.168.0.1");
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(Lists.newArrayList((Object[])new DynamicObject[]{modifyLog}));
        }
        catch (Exception e) {
            log.error("paste:" + e.getMessage());
        }
    }

    public static void saveSystemImportLog(Long modelId, Long dimId, String memberNumber, String memberName, Long userId) {
        try {
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
            int clientType = 1;
            String clientAddress = "192.168.0.1";
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, null, memberNumber, memberName, DimMemberOperateTypeEnum.SYSTEM_IMPORT.getValue(), DimMemberOperateTypeEnum.SYSTEM_IMPORT.getName(), null, null, userId, clientType, clientAddress);
            logs.add(modifyLog);
            SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
        }
        catch (Exception e) {
            log.error("system_import:" + e.getMessage());
        }
    }

    public static void writeOperationLog(List<DynamicObject> logs) {
        if (!CollectionUtils.isEmpty(logs)) {
            for (DynamicObject log : logs) {
                Long modelId = log.getLong("model_id");
                String memberNumber = log.getString("membernumber");
                String opName = log.getString("operatename");
                String newData = log.getString("modifyafter");
                String opDescriotion = String.format("%s %s,%s%s", memberNumber, newData, opName, SaveDimMemberHelper.getLogResult());
                OperationLogUtil.writeOperationLog(opName, opDescriotion, modelId, "bcm_dimensionmanager");
            }
        }
    }

    public static void batchInsertDimMemberModifyLog(List<DynamicObject> logs) {
        if (logs.size() > 0) {
            DynamicObjectType objectType = logs.get(0).getDynamicObjectType();
            int batchSize = 999;
            if (logs.size() < batchSize) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])logs.toArray(new DynamicObject[0]));
            } else {
                ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
                for (DynamicObject log : logs) {
                    batch.add(log);
                    if (batch.size() < batchSize) continue;
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
            }
        }
    }

    private static long getBaseDataIdCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public static List<DynamicObject> generateDimMemberModifyLog(DynamicObject newData, DimMemberOperateTypeEnum type, Long userId, Function<Long, DynamicObject> getOriginDyByIdFunc) {
        try {
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
            long modelId = SaveDimMemberHelper.getBaseDataIdCompatible(newData, "model");
            long dimId = SaveDimMemberHelper.getBaseDataIdCompatible(newData, "dimension");
            long memberId = newData.getLong("id");
            String memberNumber = newData.getString("number");
            if (userId == null) {
                userId = newData.get("creator") instanceof Long ? Long.valueOf(newData.getLong("creator")) : Long.valueOf(RequestContext.get().getUserId());
            }
            int clientType = 1;
            String clientAddress = "192.168.0.1";
            if (type == DimMemberOperateTypeEnum.NEW || type == DimMemberOperateTypeEnum.NEW_SHARE || type == DimMemberOperateTypeEnum.IMPORT_NEW || type == DimMemberOperateTypeEnum.IMPORT_SHARE_NEW) {
                DynamicObject modifyLog;
                String afterContent;
                DynamicObject parent;
                if (type == DimMemberOperateTypeEnum.NEW) {
                    String actionName = newData.getString("addtext");
                    type = "baritemaddsub".equals(actionName) ? DimMemberOperateTypeEnum.NEW_NEXT_LEVEL : DimMemberOperateTypeEnum.NEW_SAME_LEVEL;
                    DynamicObject modifyLog2 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, null, memberNumber, newData.getString("name"), type.getValue(), type.getName(), null, null, userId, clientType, clientAddress);
                    logs.add(modifyLog2);
                }
                if (type == DimMemberOperateTypeEnum.IMPORT_NEW) {
                    DynamicObject modifyLog3 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), type.getValue(), type.getName(), null, null, userId, clientType, clientAddress);
                    logs.add(modifyLog3);
                }
                if (type == DimMemberOperateTypeEnum.NEW_SHARE) {
                    long parentMemberId = newData.getLong("parent.id");
                    parent = Objects.nonNull(getOriginDyByIdFunc) ? getOriginDyByIdFunc.apply(parentMemberId) : BusinessDataServiceHelper.loadSingle((Object)parentMemberId, (DynamicObjectType)newData.getDynamicObjectType());
                    afterContent = String.format(ResManager.loadKDString((String)"%1$s\u7236\u7ea7\u8282\u70b9\u4e0b\u7684%2$s\u5171\u4eab\u6210\u5458", (String)"SaveDimMemberHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), parent.getString("number"), memberNumber);
                    modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), type.getValue(), type.getName(), null, afterContent, userId, clientType, clientAddress);
                    logs.add(modifyLog);
                }
                if (type == DimMemberOperateTypeEnum.IMPORT_SHARE_NEW) {
                    long parentMemberId = newData.getLong("parent");
                    parent = Objects.nonNull(getOriginDyByIdFunc) ? getOriginDyByIdFunc.apply(parentMemberId) : BusinessDataServiceHelper.loadSingle((Object)parentMemberId, (DynamicObjectType)newData.getDynamicObjectType());
                    afterContent = String.format(ResManager.loadKDString((String)"%1$s\u7236\u7ea7\u8282\u70b9\u4e0b\u7684%2$s\u5171\u4eab\u6210\u5458", (String)"SaveDimMemberHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), parent.getString("number"), memberNumber);
                    modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), type.getValue(), type.getName(), null, afterContent, userId, clientType, clientAddress);
                    logs.add(modifyLog);
                }
            } else if (type == DimMemberOperateTypeEnum.CUT) {
                long parentMemberId = newData.getLong("parent.id");
                DynamicObject parent = Objects.nonNull(getOriginDyByIdFunc) ? getOriginDyByIdFunc.apply(parentMemberId) : BusinessDataServiceHelper.loadSingle((Object)parentMemberId, (DynamicObjectType)newData.getDynamicObjectType());
                String before = String.format(ResManager.loadKDString((String)"%1$s \u76f4\u63a5\u4e0b\u7ea7", (String)"SaveDimMemberHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), parent.getString("number"));
                DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), type.getValue(), type.getName(), before, null, userId, clientType, clientAddress);
                logs.add(modifyLog);
            } else if (type == DimMemberOperateTypeEnum.UP || type == DimMemberOperateTypeEnum.DOWN) {
                DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), type.getValue(), type.getName(), null, null, userId, clientType, clientAddress);
                logs.add(modifyLog);
            } else if (type == DimMemberOperateTypeEnum.EDIT || type == DimMemberOperateTypeEnum.IMPORT_EDIT || type == DimMemberOperateTypeEnum.SHARE_EDIT) {
                String creditcodeOld;
                String creditcodeNew;
                CharSequence newVal;
                DynamicObject modifyLog;
                Object beforeContent;
                String datasourceOld;
                String oldDatasource;
                DynamicObject datasource;
                DynamicObject modifyLog4;
                DynamicObject outerorg;
                boolean oldIsouterorg;
                boolean isouterorg;
                boolean oldIsinnerorg;
                boolean isinnerorg;
                String orgcodeold;
                String orgcodeNew;
                boolean oldIsCalType;
                boolean isCalType;
                boolean oldIsLossCarry;
                boolean isLossCarry;
                boolean oldIsParticipMerge;
                boolean isParticipMerge;
                String oldEntryrate;
                String entryrate;
                ExchangeEnum newExchangeEnum;
                ExchangeEnum oldExchangeEnum;
                int oldExchange;
                int exchange;
                int oldDataType;
                int dataType;
                int oldDrCrDirect;
                int drCrDirect;
                DynamicObject modifyLog5;
                int oldAccountType;
                int accountType;
                int oldAggOprt;
                int aggOprt;
                int oldStorageType;
                int storageType;
                DynamicObject modifyLog6;
                DynamicObject oldData = Objects.nonNull(getOriginDyByIdFunc) ? getOriginDyByIdFunc.apply(memberId) : BusinessDataServiceHelper.loadSingle((Object)memberId, (DynamicObjectType)newData.getDynamicObjectType());
                List updateAuth = SaveDimMemberHelper.getUpdateAuth(newData.getDynamicObjectType().getName());
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_NAME.getValue())) {
                    String name = newData.getLocaleString("name").getLocaleValue();
                    String oldName = oldData.getLocaleString("name").getLocaleValue();
                    if (name != null && !name.equals(oldName)) {
                        DynamicObject modifyLog7 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, newData.getString("name"), DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME.getName()), oldName, name, userId, clientType, clientAddress);
                        logs.add(modifyLog7);
                    }
                }
                String memberName = newData.getString("name");
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ALIAS.getValue())) {
                    String simpleName = newData.getLocaleString("simplename").getLocaleValue();
                    String oldSimpleName = oldData.getLocaleString("simplename").getLocaleValue();
                    if (simpleName == null) {
                        if (oldSimpleName != null) {
                            modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ALIAS.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ALIAS.getName()), oldSimpleName, null, userId, clientType, clientAddress);
                            logs.add(modifyLog6);
                        }
                    } else if (!simpleName.equals(oldSimpleName)) {
                        modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ALIAS.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ALIAS.getName()), oldSimpleName, simpleName, userId, clientType, clientAddress);
                        logs.add(modifyLog6);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_STORAGE.getValue()) && (storageType = newData.getInt("storagetype")) != (oldStorageType = oldData.getInt("storagetype"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_STORAGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_STORAGE.getName()), StorageTypeEnum.stringToStorageType((String)String.valueOf(oldStorageType)).getName(), StorageTypeEnum.stringToStorageType((String)String.valueOf(storageType)).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_AGG.getValue()) && (aggOprt = newData.getInt("aggoprt")) != (oldAggOprt = oldData.getInt("aggoprt"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_AGG.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_AGG.getName()), AggOprtEnum.getAggOprtEnumBySign((String)String.valueOf(oldAggOprt)).getName(), AggOprtEnum.getAggOprtEnumBySign((String)String.valueOf(aggOprt)).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ACCOUNT_TYPE.getValue()) && (accountType = newData.getInt("accounttype")) != (oldAccountType = oldData.getInt("accounttype"))) {
                    AccountTypeEnum accountTypeEnum = AccountTypeEnum.getEnum((String)String.valueOf(accountType));
                    AccountTypeEnum oldAccountTypeEnum = AccountTypeEnum.getEnum((String)String.valueOf(oldAccountType));
                    modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ACCOUNT_TYPE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ACCOUNT_TYPE.getName()), oldAccountTypeEnum == null ? "" : oldAccountTypeEnum.getName(), accountTypeEnum == null ? "" : accountTypeEnum.getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog5);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_BORROWING.getValue()) && (drCrDirect = newData.getInt("drcrdirect")) != (oldDrCrDirect = oldData.getInt("drcrdirect"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_BORROWING.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_BORROWING.getName()), DrCRDirectEnum.getDrCRDirectEnum((String)String.valueOf(oldDrCrDirect)).getName(), DrCRDirectEnum.getDrCRDirectEnum((String)String.valueOf(drCrDirect)).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue()) && (dataType = newData.getInt("datatype")) != (oldDataType = oldData.getInt("datatype"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getName()), DataTypeEnum.getDataTypeEnumByIndex((String)String.valueOf(oldDataType)).getName(), DataTypeEnum.getDataTypeEnumByIndex((String)String.valueOf(dataType)).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_EXCHANGE.getValue()) && (exchange = newData.getInt("exchange")) != (oldExchange = oldData.getInt("exchange"))) {
                    oldExchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)String.valueOf(oldExchange));
                    newExchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)String.valueOf(exchange));
                    modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXCHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXCHANGE.getName()), oldExchangeEnum == null ? "" : oldExchangeEnum.getName(), newExchangeEnum == null ? "" : newExchangeEnum.getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog5);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ENTRAYRATE.getValue()) && !(entryrate = newData.getString("entryrate")).equals(oldEntryrate = oldData.getString("entryrate"))) {
                    oldExchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)String.valueOf(oldEntryrate));
                    newExchangeEnum = ExchangeEnum.getExchangeEnumByIndex((String)String.valueOf(entryrate));
                    modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENTRAYRATE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENTRAYRATE.getName()), oldExchangeEnum == null ? "" : oldExchangeEnum.getName(), newExchangeEnum == null ? "" : newExchangeEnum.getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog5);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_MERGE_ACCOUNT.getValue()) && (isParticipMerge = newData.getBoolean("isparticipmerge")) != (oldIsParticipMerge = oldData.getBoolean("isparticipmerge"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_MERGE_ACCOUNT.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_MERGE_ACCOUNT.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsParticipMerge), SaveDimMemberHelper.getIfNameByValue(isParticipMerge), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue()) && (isParticipMerge = newData.getBoolean("ismerge")) != (oldIsParticipMerge = oldData.getBoolean("ismerge"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsParticipMerge), SaveDimMemberHelper.getIfNameByValue(isParticipMerge), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_OFFSET.getValue())) {
                    boolean oldIsAccountOffset;
                    boolean isAccountOffset = newData.getBoolean("isaccountoffset");
                    if (type == DimMemberOperateTypeEnum.IMPORT_EDIT) {
                        isAccountOffset = newData.getDynamicObject("accountpart") != null && newData.getDynamicObject("accountpart").getBoolean("isaccountoffset");
                    }
                    boolean bl = oldIsAccountOffset = oldData.getDynamicObject("accountpart") != null && oldData.getDynamicObject("accountpart").getBoolean("isaccountoffset");
                    if (isAccountOffset != oldIsAccountOffset) {
                        modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_OFFSET.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_OFFSET.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsAccountOffset), SaveDimMemberHelper.getIfNameByValue(isAccountOffset), userId, clientType, clientAddress);
                        logs.add(modifyLog6);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_LOSS_CARRY.getValue()) && (isLossCarry = newData.getBoolean("islosscarry")) != (oldIsLossCarry = oldData.getBoolean("islosscarry"))) {
                    modifyLog6 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_LOSS_CARRY.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_LOSS_CARRY.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsLossCarry), SaveDimMemberHelper.getIfNameByValue(isLossCarry), userId, clientType, clientAddress);
                    logs.add(modifyLog6);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_BEGIN_DATE.getValue())) {
                    int effmonth = newData.getInt("effmonth");
                    int oldIsEffmonth = oldData.getInt("effmonth");
                    int effday = newData.getInt("effday");
                    int oldIsEffday = oldData.getInt("effday");
                    if (effmonth != oldIsEffmonth || effday != oldIsEffday) {
                        modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_BEGIN_DATE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_BEGIN_DATE.getName()), String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"SaveDimMemberHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), oldIsEffmonth, oldIsEffday), String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"SaveDimMemberHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), effmonth, effday), userId, clientType, clientAddress);
                        logs.add(modifyLog5);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_END_DATE.getValue())) {
                    int effmonth = newData.getInt("expmonth");
                    int oldIsEffmonth = oldData.getInt("expmonth");
                    int effday = newData.getInt("expday");
                    int oldIsEffday = oldData.getInt("expday");
                    if (effmonth != oldIsEffmonth || effday != oldIsEffday) {
                        modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_END_DATE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_END_DATE.getName()), String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"SaveDimMemberHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), oldIsEffmonth, oldIsEffday), String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"SaveDimMemberHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), effmonth, effday), userId, clientType, clientAddress);
                        logs.add(modifyLog5);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DATA_COLLECT.getValue()) && (isParticipMerge = newData.getBoolean("isdatacollect")) != (oldIsParticipMerge = oldData.getBoolean("isdatacollect"))) {
                    DynamicObject modifyLog8 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_COLLECT.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_COLLECT.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsParticipMerge), SaveDimMemberHelper.getIfNameByValue(isParticipMerge), userId, clientType, clientAddress);
                    logs.add(modifyLog8);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_CALCULATE.getValue()) && (isCalType = newData.getBoolean("iscaltype")) != (oldIsCalType = oldData.getBoolean("iscaltype"))) {
                    DynamicObject modifyLog9 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_CALCULATE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_CALCULATE.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsCalType), SaveDimMemberHelper.getIfNameByValue(isCalType), userId, clientType, clientAddress);
                    logs.add(modifyLog9);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ORGANIZATION_CODE.getValue()) && !(orgcodeNew = newData.getString("orgcode")).equals(orgcodeold = oldData.getString("orgcode"))) {
                    DynamicObject modifyLog10 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ORGANIZATION_CODE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ORGANIZATION_CODE.getName()), orgcodeold, orgcodeNew, userId, clientType, clientAddress);
                    logs.add(modifyLog10);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_INDEPENDENT_CORPORATION.getValue()) && (isCalType = newData.getBoolean("isindependentorg")) != (oldIsCalType = oldData.getBoolean("isindependentorg"))) {
                    DynamicObject modifyLog11 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_INDEPENDENT_CORPORATION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_INDEPENDENT_CORPORATION.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsCalType), SaveDimMemberHelper.getIfNameByValue(isCalType), userId, clientType, clientAddress);
                    logs.add(modifyLog11);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_HOLDING_ORGANIZATION.getValue())) {
                    String orgNameOld;
                    String orgNameNew = newData.getString("ctrlorg.name") == null ? "" : newData.getString("ctrlorg.name");
                    String string = orgNameOld = oldData.getString("ctrlorg.name") == null ? "" : oldData.getString("ctrlorg.name");
                    if (!orgNameNew.equals(orgNameOld)) {
                        DynamicObject modifyLog12 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_HOLDING_ORGANIZATION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_HOLDING_ORGANIZATION.getName()), orgNameOld, orgNameNew, userId, clientType, clientAddress);
                        logs.add(modifyLog12);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_INTERNAL_CONTACT_ORGANIZATION.getValue()) && (isinnerorg = newData.getBoolean("isinnerorg")) != (oldIsinnerorg = oldData.getBoolean("isinnerorg"))) {
                    DynamicObject modifyLog13 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_INTERNAL_CONTACT_ORGANIZATION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_INTERNAL_CONTACT_ORGANIZATION.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsinnerorg), SaveDimMemberHelper.getIfNameByValue(isinnerorg), userId, clientType, clientAddress);
                    logs.add(modifyLog13);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_EXTERNAL_CONTACT_ORGANIZATION.getValue()) && newData.getDynamicObject("entitypart") != null && (isouterorg = newData.getDynamicObject("entitypart").getBoolean("isouterorg")) != (oldIsouterorg = (outerorg = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymemberpart", (String)"id,isouterorg", (QFilter[])new QFilter("id", "=", (Object)oldData.getLong("entitypart.id")).toArray())).getBoolean("isouterorg"))) {
                    DynamicObject modifyLog14 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXTERNAL_CONTACT_ORGANIZATION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXTERNAL_CONTACT_ORGANIZATION.getName()), SaveDimMemberHelper.getIfNameByValue(oldIsouterorg), SaveDimMemberHelper.getIfNameByValue(isouterorg), userId, clientType, clientAddress);
                    logs.add(modifyLog14);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getValue())) {
                    String description = newData.getLocaleString("description").getLocaleValue();
                    String oldDescription = oldData.getLocaleString("description").getLocaleValue();
                    if (description == null) {
                        if (oldDescription != null) {
                            DynamicObject modifyLog15 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getName()), oldDescription, null, userId, clientType, clientAddress);
                            logs.add(modifyLog15);
                        }
                    } else if (!description.equals(oldDescription)) {
                        DynamicObject modifyLog16 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getName()), oldDescription, description, userId, clientType, clientAddress);
                        logs.add(modifyLog16);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DIM_GROUP_SETTING.getValue())) {
                    DynamicObjectCollection dimGroup = newData.getDynamicObjectCollection("dm_entry");
                    DynamicObjectCollection oldDimGroup = oldData.getDynamicObjectCollection("dm_entry");
                    int size = Math.max(dimGroup.size(), oldDimGroup.size());
                    for (int i = 0; i < size; ++i) {
                        String valStr = "";
                        String oldValStr = "";
                        String dimName = "";
                        if (i < oldDimGroup.size()) {
                            DynamicObject oldCustomDimDy = (DynamicObject)oldDimGroup.get(i);
                            oldValStr = oldCustomDimDy.getString("dm_val");
                            dimName = oldCustomDimDy.getString("dm_dim.name");
                            oldValStr = SaveDimMemberHelper.getRealDmVal(oldValStr);
                        }
                        if (i < dimGroup.size()) {
                            DynamicObject customDimDy = (DynamicObject)dimGroup.get(i);
                            valStr = customDimDy.getString("dm_val");
                            dimName = customDimDy.getString("dm_dim.name");
                            valStr = SaveDimMemberHelper.getRealDmVal(valStr);
                        }
                        if (valStr.equals(oldValStr)) continue;
                        modifyLog4 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DIM_GROUP_SETTING.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)(DimMemberOperateTypeEnum.EDIT_DIM_GROUP_SETTING.getName() + "-" + dimName)), oldValStr, valStr, userId, clientType, clientAddress);
                        logs.add(modifyLog4);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CUSTOM_PROPERTY.getValue())) {
                    StringBuilder beforeContent2 = new StringBuilder();
                    StringBuilder afterContent = new StringBuilder();
                    for (int i = 1; i <= 10; ++i) {
                        if (type == DimMemberOperateTypeEnum.IMPORT_EDIT) {
                            long id = newData.getLong("dpropertyid" + i);
                            QFilter qcf = new QFilter("id", "=", (Object)id);
                            DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"name", (QFilter[])new QFilter[]{qcf});
                            if (null != data) {
                                afterContent.append(data.getString("name"));
                                afterContent.append(",");
                            }
                        } else {
                            DynamicObject customProperty = newData.getDynamicObject("dpropertyid" + i);
                            if (null != customProperty) {
                                afterContent.append(customProperty.getString("name"));
                                afterContent.append(",");
                            }
                        }
                        DynamicObject oldCustomProperty = oldData.getDynamicObject("dpropertyid" + i);
                        if (null == oldCustomProperty) continue;
                        beforeContent2.append(oldCustomProperty.getString("name"));
                        beforeContent2.append(",");
                    }
                    StringBuilder before = new StringBuilder();
                    StringBuilder after = new StringBuilder();
                    if (beforeContent2.length() > 0) {
                        before = new StringBuilder(beforeContent2.substring(0, beforeContent2.length() - 1));
                    }
                    if (afterContent.length() > 0) {
                        after = new StringBuilder(afterContent.substring(0, afterContent.length() - 1));
                    }
                    if (!before.toString().equals(after.toString())) {
                        modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CUSTOM_PROPERTY.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CUSTOM_PROPERTY.getName()), before.toString(), after.toString(), userId, clientType, clientAddress);
                        logs.add(modifyLog5);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_BUSINESS_CHANGE.getValue())) {
                    SaveDimMemberHelper.addBizChangeLog(newData, type, userId, logs, modelId, dimId, memberId, memberNumber, clientType, clientAddress, oldData, memberName, DimMemberOperateTypeEnum.EDIT_BUSINESS_CHANGE, "bizchangerds", "bizeffdate", "bizexpdate");
                    if (!newData.getDynamicObjectType().getName().equals("bcm_accountmembertree")) {
                        SaveDimMemberHelper.addBizChangeLog(newData, type, userId, logs, modelId, dimId, memberId, memberNumber, clientType, clientAddress, oldData, memberName, DimMemberOperateTypeEnum.EDIT_BUSINESS_CHANGE, "bizchangerds", "changetype");
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue())) {
                    SaveDimMemberHelper.addBizChangeLog(newData, type, userId, logs, modelId, dimId, memberId, memberNumber, clientType, clientAddress, oldData, memberName, DimMemberOperateTypeEnum.EDIT_NAME_CHANGE, "namechangerds", "nameeffdate", "nameexpdate");
                    DynamicObjectCollection bizChangeRecords = newData.getDynamicObjectCollection("namechangerds");
                    String sql = "SELECT l.Fname,n.fsimplename FROM t_bcm_entitynamerecord n LEFT JOIN t_bcm_entitynamerecord_l l on n.fentityid=l.fentityid  and l.FLocaleID = 'zh_CN'  WHERE fid = (" + oldData.getLong("id") + ")";
                    DataSet dataSet = DB.queryDataSet((String)"t_bcm_structofaccount_dm", (DBRoute)BCMConstant.DBROUTE, (String)sql);
                    ArrayList<String> nameList = new ArrayList<String>();
                    ArrayList<String> implenameList = new ArrayList<String>();
                    for (Row ds : dataSet) {
                        String name = ds.getString("Fname");
                        nameList.add(name);
                        String implename = ds.getString("fsimplename");
                        implenameList.add(implename);
                    }
                    if (bizChangeRecords.size() > 0) {
                        for (int i = 0; i < bizChangeRecords.size(); ++i) {
                            String simplenamerds;
                            String name;
                            if (i < nameList.size()) {
                                String oldsimplenamerds;
                                String oldname;
                                name = ((DynamicObject)bizChangeRecords.get(i)).getString("namerds");
                                if (!name.equals(oldname = (String)nameList.get(i))) {
                                    DynamicObject modifyLog17 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u540d\u79f0", (String)"SaveDimMemberHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getName())), oldname, name, userId, clientType, clientAddress);
                                    logs.add(modifyLog17);
                                }
                                if ((simplenamerds = SaveDimMemberHelper.trimToEmpty(((DynamicObject)bizChangeRecords.get(i)).getString("simplenamerds"))).equals(oldsimplenamerds = SaveDimMemberHelper.trimToEmpty((String)implenameList.get(i)))) continue;
                                DynamicObject modifyLog18 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u7b80\u79f0", (String)"SaveDimMemberHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getName())), oldsimplenamerds, simplenamerds, userId, clientType, clientAddress);
                                logs.add(modifyLog18);
                                continue;
                            }
                            name = ((DynamicObject)bizChangeRecords.get(i)).getString("namerds");
                            modifyLog4 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u540d\u79f0", (String)"SaveDimMemberHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getName())), "", name, userId, clientType, clientAddress);
                            simplenamerds = ((DynamicObject)bizChangeRecords.get(i)).getString("simplenamerds");
                            DynamicObject modifyLog1 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u7b80\u79f0", (String)"SaveDimMemberHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getName())), "", simplenamerds, userId, clientType, clientAddress);
                            if (!"".equals(simplenamerds)) {
                                logs.add(modifyLog1);
                            }
                            logs.add(modifyLog4);
                        }
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CURRENCY_CHANGE.getValue())) {
                    SaveDimMemberHelper.addBizChangeLog(newData, type, userId, logs, modelId, dimId, memberId, memberNumber, clientType, clientAddress, oldData, memberName, DimMemberOperateTypeEnum.EDIT_CURRENCY_CHANGE, "currencychangerds", "currencyeffdate", "currencyexpdate");
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue()) && Objects.nonNull(datasource = newData.getDynamicObject("permclass"))) {
                    String permissionName;
                    DynamicObject oldDatasource2 = PermClassEntityHelper.getBasePermissionClassEntity(oldData.getDataEntityType().getName(), oldData.getLong("id"), oldData.getLong("model.id"));
                    StringBuilder old = new StringBuilder();
                    StringBuilder addNew = new StringBuilder();
                    if (null != datasource) {
                        permissionName = datasource.getString("number");
                        addNew.append(permissionName);
                    }
                    if (null != oldDatasource2) {
                        permissionName = oldDatasource2.getString("permclass.number");
                        old.append(permissionName);
                    }
                    if (!old.toString().equals(addNew.toString())) {
                        modifyLog5 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getName()), old.toString(), addNew.toString(), userId, clientType, clientAddress);
                        logs.add(modifyLog5);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CURRENCY_ACCURACY.getValue()) && !(datasource = newData.getString("scaletext")).equals(oldDatasource = SaveDimMemberHelper.getCurrencyInfo(oldData.getLong("model.id"), oldData.getLong("id")))) {
                    DynamicObject modifyLog19 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CURRENCY_ACCURACY.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CURRENCY_ACCURACY.getName()), oldDatasource, datasource, userId, clientType, clientAddress);
                    logs.add(modifyLog19);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ACCOUNT_SCALE.getValue())) {
                    String newScale = newData.getString("accountscale");
                    if (newScale == null) {
                        newScale = "";
                    }
                    HashSet<String> numberList = new HashSet<String>();
                    String number = newData.getString("number");
                    numberList.add(number);
                    Map<String, Integer> scaleMap = CurrencyScaleHandler.getAccountScale(modelId, numberList);
                    String oldScale = "";
                    if (scaleMap.get(number) != null) {
                        oldScale = String.valueOf(scaleMap.get(number));
                    }
                    if (!newScale.equals(oldScale)) {
                        DynamicObject modifyLog20 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ACCOUNT_SCALE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ACCOUNT_SCALE.getName()), newScale, oldScale, userId, clientType, clientAddress);
                        logs.add(modifyLog20);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ENUM.getValue())) {
                    int position = newData.getInt("value");
                    oldDatasource = oldData.getString("enumitem.name") == null ? "" : oldData.getString("enumitem.name");
                    String datasource2 = "";
                    if (position != 0) {
                        QFilter qf = new QFilter("model", "=", (Object)oldData.getLong("model.id"));
                        qf.and(new QFilter("number", "=", (Object)DimTypesEnum.SCENARIO.getNumber()));
                        QFilter[] fil = new QFilter[]{qf};
                        DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])fil);
                        QFilter filter = new QFilter("dimension", "=", (Object)data.getLong("id"));
                        QFilter[] filters = new QFilter[]{filter};
                        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,name", (QFilter[])filters);
                        datasource2 = ((DynamicObject)dcs.get(--position)).getString("name");
                    }
                    if (!datasource2.equals(oldDatasource)) {
                        DynamicObject modifyLog21 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENUM.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENUM.getName()), oldDatasource, datasource2, userId, clientType, clientAddress);
                        logs.add(modifyLog21);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DATA_FROM.getValue()) && !(datasource = newData.getString("datafrom")).equals(datasourceOld = oldData.getString("datafrom"))) {
                    DynamicObject modifyLog22 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_FROM.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_FROM.getName()), DataFromEnum.getEnumByValue((String)datasourceOld).getName(), DataFromEnum.getEnumByValue((String)datasource).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog22);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_DATA_SOURCE.getValue()) && !(datasource = newData.getString("datasource")).equals(oldDatasource = oldData.getString("datasource"))) {
                    DynamicObject modifyLog23 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_SOURCE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_DATA_SOURCE.getName()), DataSourceEnum.getDataSourceEnumByIndex((String)oldDatasource).getName(), DataSourceEnum.getDataSourceEnumByIndex((String)datasource).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog23);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CHANGE_METHOD.getValue()) && !(datasource = newData.getString("changeway")).equals(oldDatasource = oldData.getString("changeway"))) {
                    DynamicObject modifyLog24 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CHANGE_METHOD.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CHANGE_METHOD.getName()), ChangewayEnum.getChangewayEnumByIndex((String)oldDatasource).getName(), ChangewayEnum.getChangewayEnumByIndex((String)datasource).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog24);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CHANGE_TYPE.getValue()) && !(datasource = newData.getString("dchangetype")).equals(oldDatasource = oldData.getString("dchangetype"))) {
                    DynamicObject modifyLog25 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CHANGE_TYPE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CHANGE_TYPE.getName()), DChangeTypeEnum.valueof((String)oldDatasource).getName(), DChangeTypeEnum.valueof((String)datasource).getName(), userId, clientType, clientAddress);
                    logs.add(modifyLog25);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_IF_YEARENDOFF.getValue()) && !(datasource = Boolean.valueOf(newData.getBoolean("isyearendchargeagaint"))).equals(oldDatasource = Boolean.valueOf(oldData.getBoolean("isyearendchargeagaint")))) {
                    DynamicObject modifyLog26 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_YEARENDOFF.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_IF_YEARENDOFF.getName()), SaveDimMemberHelper.getIfNameByValue(oldDatasource), SaveDimMemberHelper.getIfNameByValue(datasource), userId, clientType, clientAddress);
                    logs.add(modifyLog26);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_EXCHANGE_RATE.getValue()) && !(datasource = Boolean.valueOf(newData.getBoolean("isexchange"))).equals(oldDatasource = Boolean.valueOf(oldData.getBoolean("isexchange")))) {
                    DynamicObject modifyLog27 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXCHANGE_RATE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_EXCHANGE_RATE.getName()), SaveDimMemberHelper.getIfNameByValue(oldDatasource), SaveDimMemberHelper.getIfNameByValue(datasource), userId, clientType, clientAddress);
                    logs.add(modifyLog27);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_APPLICABLE_CSLSCHEME.getValue())) {
                    DynamicObjectCollection cslschemes = newData.getDynamicObjectCollection("scenecslscheme");
                    DynamicObjectCollection oldSslschemes = oldData.getDynamicObjectCollection("scenecslscheme");
                    StringBuilder old = new StringBuilder();
                    StringBuilder addNew = new StringBuilder();
                    if (null != cslschemes && cslschemes.size() > 0) {
                        for (DynamicObject object : cslschemes) {
                            addNew.append(object.get("fbasedataid.name"));
                            addNew.append(",");
                        }
                    }
                    if (null != oldSslschemes && oldSslschemes.size() > 0) {
                        for (DynamicObject object : oldSslschemes) {
                            old.append(object.get("fbasedataid.name"));
                            old.append(",");
                        }
                    }
                    if (!old.toString().equals(addNew.toString())) {
                        beforeContent = null;
                        if (old.length() > 1) {
                            beforeContent = old.substring(0, old.lastIndexOf(","));
                        }
                        String afterContent = null;
                        if (addNew.length() > 1) {
                            afterContent = addNew.substring(0, addNew.lastIndexOf(","));
                        }
                        modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_APPLICABLE_CSLSCHEME.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_APPLICABLE_CSLSCHEME.getName()), (String)beforeContent, afterContent, userId, clientType, clientAddress);
                        logs.add(modifyLog);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_APPLICABLE_PERIOD.getValue())) {
                    DynamicObjectCollection datasource3 = newData.getDynamicObjectCollection("sceneperiod");
                    DynamicObjectCollection oldDatasource3 = oldData.getDynamicObjectCollection("sceneperiod");
                    StringBuilder old = new StringBuilder();
                    StringBuilder addNew = new StringBuilder();
                    if (null != datasource3 && datasource3.size() > 0) {
                        for (DynamicObject object : datasource3) {
                            addNew.append(object.get("fbasedataid.name"));
                            addNew.append(",");
                        }
                    }
                    if (null != oldDatasource3 && oldDatasource3.size() > 0) {
                        for (DynamicObject object : oldDatasource3) {
                            old.append(object.get("fbasedataid.name"));
                            old.append(",");
                        }
                    }
                    if (!old.toString().equals(addNew.toString())) {
                        beforeContent = null;
                        if (old.length() > 1) {
                            beforeContent = old.substring(0, old.lastIndexOf(","));
                        }
                        String afterContent = null;
                        if (addNew.length() > 1) {
                            afterContent = addNew.substring(0, addNew.lastIndexOf(","));
                        }
                        modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_APPLICABLE_PERIOD.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_APPLICABLE_PERIOD.getName()), (String)beforeContent, afterContent, userId, clientType, clientAddress);
                        logs.add(modifyLog);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue())) {
                    String oldshielddim;
                    String shielddim = newData.getString("shielddim");
                    if (null == shielddim) {
                        shielddim = "";
                    }
                    if (null == (oldshielddim = ShieldRuleBulider.getRuleStrByMem(dimId, oldData.get("id")))) {
                        oldshielddim = "";
                    }
                    if (!shielddim.equals(oldshielddim)) {
                        List<ComboItem> items = new ShieldRuleBulider(modelId).getComboItem(dimId);
                        List<String> splitNew = Arrays.asList(shielddim.split(","));
                        List<String> splitOld = Arrays.asList(oldshielddim.split(","));
                        ArrayList<String> newList = new ArrayList<String>(10);
                        ArrayList<String> oldList = new ArrayList<String>(10);
                        for (String element : splitNew) {
                            if ("".equals(element)) continue;
                            newList.add(element);
                        }
                        Collections.sort(newList);
                        for (String value : splitOld) {
                            if ("".equals(value)) continue;
                            oldList.add(value);
                        }
                        Collections.sort(oldList);
                        StringBuilder newString = new StringBuilder();
                        if (splitNew != null) {
                            for (int i = 0; i < newList.size(); ++i) {
                                for (int j = 0; j < items.size(); ++j) {
                                    String split = (String)newList.get(i);
                                    if (!split.equals(items.get(j).getValue())) continue;
                                    newString.append(items.get(j).getCaption()).append(",");
                                }
                            }
                        }
                        StringBuilder oldString = new StringBuilder();
                        if (splitOld != null && oldData.getInt("storagetype") != Integer.parseInt(StorageTypeEnum.LABEL.getOIndex())) {
                            for (String s : oldList) {
                                for (ComboItem item : items) {
                                    String split = s;
                                    if (split.equals("") || !split.equals(item.getValue())) continue;
                                    oldString.append(item.getCaption()).append(",");
                                }
                            }
                        }
                        if (!oldString.toString().equals(newString.toString())) {
                            DynamicObject modifyLog28 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getName()), !newList.isEmpty() ? newString.substring(0, newString.length() - 1) : "", !oldList.isEmpty() ? oldString.substring(0, oldString.length() - 1) : "", userId, clientType, clientAddress);
                            logs.add(modifyLog28);
                        }
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ENTITY_ACCOUNTTYPE.getValue())) {
                    String oldVal;
                    String newVal2 = newData.getString("accounttype.name");
                    DynamicObject entitypart = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymemberpart", (String)"id,accounttype", (QFilter[])new QFilter("id", "=", (Object)oldData.getLong("entitypart.id")).toArray());
                    String string = oldVal = entitypart == null ? "" : entitypart.getString("accounttype.name");
                    if (type != DimMemberOperateTypeEnum.IMPORT_EDIT && !SaveDimMemberHelper.trimToEmpty(newVal2).equals(SaveDimMemberHelper.trimToEmpty(oldVal))) {
                        DynamicObject modifyLog29 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENTITY_ACCOUNTTYPE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ENTITY_ACCOUNTTYPE.getName()), oldVal, newVal2, userId, clientType, clientAddress);
                        logs.add(modifyLog29);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_PERIOD_LASTPERIOD.getValue())) {
                    String newVal3 = newData.getString("lastperiod");
                    String oldVal = oldData.getString("lastperiod");
                    if (!SaveDimMemberHelper.trimToEmpty(newVal3).equals(SaveDimMemberHelper.trimToEmpty(oldVal))) {
                        DynamicObject modifyLog30 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_PERIOD_LASTPERIOD.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_PERIOD_LASTPERIOD.getName()), oldVal, newVal3, userId, clientType, clientAddress);
                        logs.add(modifyLog30);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_PERIOD_USEYEAR.getValue())) {
                    String newVal4 = newData.getString("useyear");
                    String oldVal = oldData.getString("useyear");
                    if (!SaveDimMemberHelper.trimToEmpty(newVal4).equals(SaveDimMemberHelper.trimToEmpty(oldVal))) {
                        DynamicObject modifyLog31 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_PERIOD_USEYEAR.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_PERIOD_USEYEAR.getName()), oldVal, newVal4, userId, clientType, clientAddress);
                        logs.add(modifyLog31);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CUSTOM_PROVALUE.getValue())) {
                    Map<String, String> result = SaveDimMemberHelper.checkIsUpdateCusProValue(modelId, dimId, newData);
                    for (Map.Entry<String, String> row : result.entrySet()) {
                        String oldVal = row.getKey();
                        if (oldVal.equalsIgnoreCase((String)(newVal = row.getValue()))) {
                            oldVal = "";
                        }
                        DynamicObject modifyLog32 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CUSTOM_PROVALUE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CUSTOM_PROVALUE.getName()), oldVal, (String)newVal, userId, clientType, clientAddress);
                        logs.add(modifyLog32);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_CREDIT_CODE.getValue()) && !(creditcodeNew = newData.getString("creditcode")).equals(creditcodeOld = oldData.getString("creditcode"))) {
                    DynamicObject modifyLog33 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CREDIT_CODE.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_CREDIT_CODE.getName()), creditcodeOld, creditcodeNew, userId, clientType, clientAddress);
                    logs.add(modifyLog33);
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getValue())) {
                    DynamicObjectCollection newEntrys = newData.getDynamicObjectCollection("entryentityasso");
                    DynamicObjectCollection oldEntrys = oldData.getDynamicObjectCollection("entryentityasso");
                    MultiF7Results newMultif7 = new MultiF7Results();
                    MultiF7Results oldMultif7 = new MultiF7Results();
                    if (newEntrys.size() > 0) {
                        ExtDataUtil.combMultiF7ByEntrys(newEntrys, modelId, newMultif7);
                    }
                    if (oldEntrys.size() > 0) {
                        ExtDataUtil.combMultiF7ByEntrys(oldEntrys, modelId, oldMultif7);
                    }
                    newVal = new StringBuilder();
                    StringBuilder oldVal = new StringBuilder();
                    if (newEntrys.size() > 0) {
                        ((StringBuilder)newVal).append(((DynamicObject)newEntrys.get(0)).getDynamicObject("assodim").getString("name")).append("-").append(newMultif7.getShowText());
                    }
                    if (oldEntrys.size() > 0) {
                        oldVal.append(((DynamicObject)oldEntrys.get(0)).getDynamicObject("assodim").getString("name")).append("-").append(oldMultif7.getShowText());
                    }
                    if (!((StringBuilder)newVal).toString().equals(oldVal.toString())) {
                        modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getName()), oldVal.toString(), ((StringBuilder)newVal).toString(), userId, clientType, clientAddress);
                        logs.add(modifyLog);
                    }
                }
                if (updateAuth.contains(DimMemberOperateTypeEnum.BELONG_SCHEME.getValue())) {
                    DynamicObject newDy = newData.getDynamicObject("belongscheme");
                    DynamicObject oldDy = oldData.getDynamicObject("belongscheme");
                    if (newDy == null && oldDy != null || newDy != null && (oldDy == null || newDy.getLong("id") != oldDy.getLong("id"))) {
                        DynamicObject modifyLog34 = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getName()), oldDy.getString("name"), newDy.getString("name"), userId, clientType, clientAddress);
                        logs.add(modifyLog34);
                    }
                }
            }
            return logs;
        }
        catch (Exception e) {
            log.error("generate_log:" + e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    private static Map<String, String> checkIsUpdateCusProValue(long modelId, long dimId, DynamicObject newData) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        QFilter qf = new QFilter("id", "=", (Object)dimId);
        DynamicObjectCollection entryDys = QueryServiceHelper.query((String)"bcm_dimension", (String)"entryentity.id, entryentity.entrynumber", (QFilter[])qf.toArray());
        if (entryDys.size() > 0) {
            QFilter qfv = new QFilter("model", "=", (Object)modelId);
            qfv.and("dimension", "=", (Object)dimId);
            qfv.and("member", "=", (Object)newData.getLong("id"));
            DynamicObjectCollection cusValues = QueryServiceHelper.query((String)"bcm_dimcustompro_value", (String)"id, custompro, value", (QFilter[])qfv.toArray());
            if (cusValues.size() > 0) {
                Map<Long, DynamicObject> id2CusValues = cusValues.stream().collect(Collectors.toMap(x -> x.getLong("custompro"), y -> y, (v1, v2) -> v1));
                entryDys.forEach(x -> {
                    DynamicObject dynamicObject = (DynamicObject)id2CusValues.get(x.getLong("entryentity.id"));
                    String cusValue = newData.getString(x.getString("entryentity.entrynumber"));
                    if (dynamicObject == null) {
                        if (StringUtils.isNotEmpty((String)cusValue)) {
                            map.put(cusValue, cusValue);
                        }
                    } else {
                        String oldValue = dynamicObject.getString("value");
                        if (!oldValue.equalsIgnoreCase(cusValue)) {
                            map.put(oldValue, cusValue);
                        }
                    }
                });
            } else {
                entryDys.forEach(x -> {
                    String cusValue;
                    String entryNumber = x.getString("entryentity.entrynumber");
                    if (StringUtils.isNotEmpty((String)entryNumber) && StringUtils.isNotEmpty((String)(cusValue = newData.getString(entryNumber)))) {
                        map.put(cusValue, cusValue);
                    }
                });
            }
        }
        return map;
    }

    public static List<DynamicObject> generateDimMemberDeleteLog(String entityId, Set<String> deleteIdSet, long userId) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter("id", "in", (Object)LongUtil.toLongList(deleteIdSet));
        DynamicObject[] deleteArray = BusinessDataServiceHelper.load((String)entityId, (String)"id,name,number,model,dimension,storagetype", (QFilter[])new QFilter[]{qFilter});
        int clientType = 1;
        String clientAddress = RequestContext.get().getLoginIP();
        for (DynamicObject dy : deleteArray) {
            long modelId = dy.getLong("model.id");
            long dimId = dy.getLong("dimension.id");
            long memberId = dy.getLong("id");
            String memberNumber = dy.getString("number");
            String memberName = dy.getString("name");
            String storageType = dy.getString("storagetype");
            DimMemberOperateTypeEnum type = StorageTypeEnum.isShare((String)storageType) ? DimMemberOperateTypeEnum.DELETE_SHARE : DimMemberOperateTypeEnum.DELETE;
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, type.getValue(), type.getName(), null, null, userId, clientType, clientAddress);
            logs.add(modifyLog);
        }
        return logs;
    }

    public static List<DynamicObject> generateDimIntroduceSynchroLog(String entityId, Set<Long> updateList, Map<Long, String> nameMap, long userId) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter("id", "in", updateList);
        DynamicObject[] changeArray = BusinessDataServiceHelper.load((String)entityId, (String)"id,name,number,model,dimension", (QFilter[])new QFilter[]{qFilter});
        int clientType = 1;
        String clientAddress = RequestContext.get().getLoginIP();
        for (DynamicObject dy : changeArray) {
            long modelId = dy.getLong("model.id");
            long dimId = dy.getLong("dimension.id");
            long memberId = dy.getLong("id");
            String memberNumber = dy.getString("number");
            String memberName = dy.getString("name");
            String[] names = nameMap.get(memberId).split("_");
            DimMemberOperateTypeEnum type = DimMemberOperateTypeEnum.INTRODUCE_SYNCHRO;
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, type.getValue(), type.getName(), names[0], names[1], userId, clientType, clientAddress);
            logs.add(modifyLog);
        }
        return logs;
    }

    private static void addBizChangeLog(DynamicObject newData, DimMemberOperateTypeEnum type, Long userId, List<DynamicObject> logs, long modelId, long dimId, long memberId, String memberNumber, int clientType, String clientAddress, DynamicObject oldData, String memberName, DimMemberOperateTypeEnum typeKey, String property, String changetype) {
        String value;
        int index;
        DynamicObjectCollection bizChangeRecords = newData.getDynamicObjectCollection(property);
        DynamicObjectCollection oldBizChangeRecords = oldData.getDynamicObjectCollection(property);
        StringBuilder beforechangetype = new StringBuilder();
        StringBuilder afterchangetype = new StringBuilder();
        if (bizChangeRecords.size() > 0) {
            index = bizChangeRecords.size() - 1;
            value = ((DynamicObject)bizChangeRecords.get(index)).getString(changetype);
            afterchangetype = new StringBuilder(value);
        }
        if (oldBizChangeRecords.size() > 0) {
            index = oldBizChangeRecords.size() - 1;
            value = ((DynamicObject)oldBizChangeRecords.get(index)).getString(changetype);
            beforechangetype = new StringBuilder(value);
        }
        if (!afterchangetype.toString().equals(beforechangetype.toString())) {
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)typeKey.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b", (String)"SaveDimMemberHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), typeKey.getName())), OrgServiceHelper.getEnumTextByValue(beforechangetype.toString(), modelId), OrgServiceHelper.getEnumTextByValue(afterchangetype.toString(), modelId), userId, clientType, clientAddress);
            logs.add(modifyLog);
        }
    }

    private static void addBizChangeLog(DynamicObject newData, DimMemberOperateTypeEnum type, Long userId, List<DynamicObject> logs, long modelId, long dimId, long memberId, String memberNumber, int clientType, String clientAddress, DynamicObject oldData, String memberName, DimMemberOperateTypeEnum typeKey, String property, String ffDate, String expDate) {
        int index;
        DynamicObjectCollection bizChangeRecords = newData.getDynamicObjectCollection(property);
        DynamicObjectCollection oldBizChangeRecords = oldData.getDynamicObjectCollection(property);
        String pattern = "yyyy/MM/dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        StringBuilder beforeBizeffdate = new StringBuilder();
        StringBuilder beforeBizexpdate = new StringBuilder();
        StringBuilder afterBizeffdate = new StringBuilder();
        StringBuilder afterBizexpdate = new StringBuilder();
        if (bizChangeRecords.size() > 0) {
            index = bizChangeRecords.size() - 1;
            Date afterbizeffdate = ((DynamicObject)bizChangeRecords.get(index)).getDate(ffDate);
            afterBizeffdate = new StringBuilder(simpleDateFormat.format(afterbizeffdate));
            Date afterbizexpdate = ((DynamicObject)bizChangeRecords.get(index)).getDate(expDate);
            if (afterbizexpdate != null) {
                afterBizexpdate = new StringBuilder(simpleDateFormat.format(afterbizexpdate));
            }
        }
        if (oldBizChangeRecords.size() > 0) {
            index = oldBizChangeRecords.size() - 1;
            Date beforebizeffdate = ((DynamicObject)oldBizChangeRecords.get(index)).getDate(ffDate);
            beforeBizeffdate = new StringBuilder(simpleDateFormat.format(beforebizeffdate));
            Date beforebbizexpdate = ((DynamicObject)oldBizChangeRecords.get(index)).getDate(expDate);
            if (beforebbizexpdate != null) {
                beforeBizexpdate = new StringBuilder(simpleDateFormat.format(beforebbizexpdate));
            }
        }
        if (StringUtils.isEmpty((String)afterBizexpdate.toString())) {
            if (!beforeBizeffdate.toString().equals(afterBizeffdate.toString())) {
                DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)typeKey.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u751f\u6548\u65e5\u671f", (String)"SaveDimMemberHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), typeKey.getName())), beforeBizeffdate.toString(), afterBizeffdate.toString(), userId, clientType, clientAddress);
                logs.add(modifyLog);
            }
        } else if (!beforeBizexpdate.toString().equals(afterBizexpdate.toString())) {
            DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog(modelId, dimId, memberId, memberNumber, memberName, DimMemberOperateTypeEnum.getOperateTypeValue((DimMemberOperateTypeEnum)type, (String)typeKey.getValue()), DimMemberOperateTypeEnum.getOperateTypeName((DimMemberOperateTypeEnum)type, (String)String.format(ResManager.loadKDString((String)"%s-\u751f\u6548\u65e5\u671f", (String)"SaveDimMemberHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), typeKey.getName())), beforeBizexpdate.toString(), afterBizexpdate.toString(), userId, clientType, clientAddress);
            logs.add(modifyLog);
        }
    }

    public static DynamicObject newMemberModifyLog(Long modelId, Long dimId, Long memberId, String memberNumber, String memberName, String typeKey, String typeName, String before, String after, long userId, int clientType, String clientAddress) {
        DynamicObject modifyLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionmodifylog");
        if (before != null && before.length() > 500) {
            before = before.substring(0, 500);
        }
        if (after != null && after.length() > 500) {
            after = after.substring(0, 500);
        }
        modifyLog.set("model", (Object)modelId);
        modifyLog.set("dimension", (Object)dimId);
        modifyLog.set("dimtype", (Object)SaveDimMemberHelper.findDimTypeById(dimId));
        modifyLog.set("memberid", (Object)(memberId == null ? Long.valueOf(0L) : memberId));
        modifyLog.set("membernumber", (Object)memberNumber);
        modifyLog.set("membername", (Object)memberName);
        modifyLog.set("operatenumber", (Object)typeKey);
        modifyLog.set("operatename", (Object)typeName);
        modifyLog.set("modifybefore", (Object)before);
        modifyLog.set("modifyafter", (Object)after);
        modifyLog.set("createuserid", (Object)userId);
        modifyLog.set("createtime", (Object)TimeServiceHelper.now());
        modifyLog.set("clienttype", (Object)clientType);
        modifyLog.set("clientaddress", (Object)clientAddress);
        return modifyLog;
    }

    private static String findDimTypeById(Long dimId) {
        DynamicObject dimDy = MemberReader.getDimensionDynById((long)dimId);
        if (dimDy != null) {
            return dimDy.getDynamicObjectType().getName();
        }
        throw new KDBizException("the dimension is not found");
    }

    private static String getIfNameByValue(boolean value) {
        String no = ResManager.loadKDString((String)"\u5426", (String)"SaveDimMemberHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]);
        String yes = ResManager.loadKDString((String)"\u662f", (String)"SaveDimMemberHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]);
        return value ? yes : no;
    }

    private static List getUpdateAuth(String entityName) {
        ArrayList<String> authList = new ArrayList<String>(10);
        authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_NAME.getValue(), DimMemberOperateTypeEnum.EDIT_STORAGE.getValue(), DimMemberOperateTypeEnum.EDIT_DESCRIPTION.getValue(), DimMemberOperateTypeEnum.EDIT_CUSTOM_PROPERTY.getValue(), DimMemberOperateTypeEnum.EDIT_MEMBER_PERMISSION.getValue()));
        switch (entityName) {
            case "bcm_accountmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_ALIAS.getValue(), DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_ACCOUNT_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_BORROWING.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_EXCHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_ENTRAYRATE.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_ACCOUNT.getValue(), DimMemberOperateTypeEnum.EDIT_IF_OFFSET.getValue(), DimMemberOperateTypeEnum.EDIT_IF_LOSS_CARRY.getValue(), DimMemberOperateTypeEnum.EDIT_IF_CALCULATE.getValue(), DimMemberOperateTypeEnum.EDIT_BUSINESS_CHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_DIM_GROUP_SETTING.getValue(), DimMemberOperateTypeEnum.EDIT_ACCOUNT_SCALE.getValue()));
                break;
            }
            case "bcm_audittrialmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_SOURCE.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_COLLECT.getValue()));
                break;
            }
            case "bcm_entitymembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_ORGANIZATION_CODE.getValue(), DimMemberOperateTypeEnum.EDIT_ORGANIZATION_CODE.getValue(), DimMemberOperateTypeEnum.EDIT_INDEPENDENT_CORPORATION.getValue(), DimMemberOperateTypeEnum.EDIT_HOLDING_ORGANIZATION.getValue(), DimMemberOperateTypeEnum.EDIT_INTERNAL_CONTACT_ORGANIZATION.getValue(), DimMemberOperateTypeEnum.EDIT_EXTERNAL_CONTACT_ORGANIZATION.getValue(), DimMemberOperateTypeEnum.EDIT_BUSINESS_CHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_NAME_CHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_CURRENCY_CHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_ENTITY_ACCOUNTTYPE.getValue(), DimMemberOperateTypeEnum.EDIT_CUSTOM_PROVALUE.getValue(), DimMemberOperateTypeEnum.BELONG_SCHEME.getValue()));
                break;
            }
            case "bcm_userdefinedmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue()));
                break;
            }
            case "bcm_scenemembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_CHANGE_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_ENUM.getValue(), DimMemberOperateTypeEnum.EDIT_CURRENCY_ACCURACY.getValue(), DimMemberOperateTypeEnum.EDIT_APPLICABLE_PERIOD.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_APPLICABLE_CSLSCHEME.getValue()));
                break;
            }
            case "bcm_fymembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue()));
                break;
            }
            case "bcm_changetypemembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue(), DimMemberOperateTypeEnum.EDIT_IF_YEARENDOFF.getValue(), DimMemberOperateTypeEnum.EDIT_EXCHANGE_RATE.getValue(), DimMemberOperateTypeEnum.EDIT_CHANGE_METHOD.getValue(), DimMemberOperateTypeEnum.EDIT_DATA_FROM.getValue()));
                break;
            }
            case "bcm_icmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_AUTHCLASS.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue()));
                break;
            }
            case "bcm_processmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue()));
                break;
            }
            case "bcm_currencymembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue()));
                break;
            }
            case "bcm_periodmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_ALIAS.getValue(), DimMemberOperateTypeEnum.EDIT_BEGIN_DATE.getValue(), DimMemberOperateTypeEnum.EDIT_END_DATE.getValue(), DimMemberOperateTypeEnum.EDIT_PERIOD_LASTPERIOD.getValue(), DimMemberOperateTypeEnum.EDIT_PERIOD_USEYEAR.getValue()));
                break;
            }
            case "bcm_rulemembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue()));
                break;
            }
            case "bcm_datasortmembertree": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_AGG.getValue(), DimMemberOperateTypeEnum.EDIT_SHIELDDIM.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_CHANGE.getValue()));
                break;
            }
            case "bcm_structofextend": {
                authList.addAll(Arrays.asList(DimMemberOperateTypeEnum.EDIT_DATA_TYPE.getValue(), DimMemberOperateTypeEnum.EDIT_ASSO_DIM_MEMBER.getValue(), DimMemberOperateTypeEnum.EDIT_IF_MERGE_ACCOUNT.getValue()));
                break;
            }
        }
        return authList;
    }

    private static String mappingPermissionFromNumber2Name(String number) {
        switch (number) {
            case "1": {
                return ResManager.loadKDString((String)"\u8bfb\u5199", (String)"SaveDimMemberHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u53ea\u8bfb", (String)"SaveDimMemberHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u65e0\u6743", (String)"SaveDimMemberHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private static void addLog(DynamicObject oldData, DynamicObject newData, DimMemberOperateTypeEnum operateType, List<DynamicObject> logs, String property, int type) {
        long modelId = newData.getLong("model.id");
        long dimId = newData.getLong("dimension.id");
        long memberId = newData.getLong("id");
        String memberNumber = newData.getString("number");
    }

    private static String getCurrencyInfo(Long modelId, Long id) {
        DynamicObjectCollection scaleInfoList = SaveDimMemberHelper.getScaleEntryList(modelId, id);
        if (scaleInfoList == null || scaleInfoList.size() == 0) {
            return SaveDimMemberHelper.getCurrencyInfo(modelId);
        }
        List<Map<String, Object>> rows = SaveDimMemberHelper.initCurrencyInfo(modelId);
        HashMap<String, String> scaleMap = new HashMap<String, String>(16);
        for (Object scaleInfo : scaleInfoList) {
            String string = scaleInfo.getString("number");
            String scale = scaleInfo.getString("scale");
            scaleMap.putIfAbsent(string, scale);
        }
        StringBuilder sb = new StringBuilder();
        for (Map map : rows) {
            Object name = map.get("name");
            Object number = map.get("number");
            Object value = scaleMap.get(number);
            if (value == null) continue;
            String valueStr = value.toString();
            map.put("scale", valueStr);
            sb.append(name).append(':').append(CurrencyScaleEnum.value((String)valueStr).getValue()).append(',');
        }
        String result = sb.toString();
        if (!result.isEmpty()) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    private static List<Map<String, Object>> initCurrencyInfo(Long modelId) {
        DynamicObjectCollection currencyInfoList = SaveDimMemberHelper.getCurrencyInfoList(modelId);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        if (currencyInfoList != null && currencyInfoList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject currencyInfo : currencyInfoList) {
                HashMap<String, Object> currrencyMap = new HashMap<String, Object>(16);
                Long id = currencyInfo.getLong("id");
                String name = currencyInfo.getString("name");
                String number = currencyInfo.getString("number");
                currrencyMap.put("id", id);
                currrencyMap.put("name", name);
                currrencyMap.put("number", number);
                currrencyMap.put("scale", 2);
                sb.append(name).append(':').append(CurrencyScaleEnum.TWOSCALE.getName()).append(',');
                list.add(currrencyMap);
            }
        }
        return list;
    }

    public static String getCurrencyInfo(Long modelId) {
        DynamicObjectCollection currencyInfoList = SaveDimMemberHelper.getCurrencyInfoList(modelId);
        ArrayList list = new ArrayList(10);
        if (currencyInfoList != null && currencyInfoList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject currencyInfo : currencyInfoList) {
                HashMap<String, Object> currrencyMap = new HashMap<String, Object>(16);
                Long id = currencyInfo.getLong("id");
                String name = currencyInfo.getString("name");
                String number = currencyInfo.getString("number");
                currrencyMap.put("id", id);
                currrencyMap.put("name", name);
                currrencyMap.put("number", number);
                currrencyMap.put("scale", 2);
                sb.append(name).append(':').append(CurrencyScaleEnum.TWOSCALE.getValue()).append(',');
                list.add(currrencyMap);
            }
            String result = sb.toString();
            if (list.size() > 0) {
                return result.substring(0, result.length() - 1);
            }
        }
        return "";
    }

    private static DynamicObjectCollection getCurrencyInfoList(Long modeId) {
        String selectFields = "id,name,number";
        QFilter modelFilter = new QFilter("model", "=", (Object)modeId);
        QFilter numberFilter = new QFilter("number", "not in", (Object)new String[]{"Currency", "EC", "PC", "DC"});
        return QueryServiceHelper.query((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, numberFilter}, (String)"dseq");
    }

    private static DynamicObjectCollection getScaleEntryList(Long modeId, Long id) {
        String selectFields = "scaleentry.currency.id as id,scaleentry.currency.name as name,scaleentry.currency.number as number,scaleentry.scale as scale";
        QFilter modelFilter = new QFilter("model", "=", (Object)modeId);
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        QFilter numberFilter = new QFilter("scaleentry.currency.number", "not in", (Object)new String[]{"Currency", "EC", "PC"});
        return QueryServiceHelper.query((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, idFilter, numberFilter}, (String)"dseq");
    }

    private static String getRealDmVal(String dmValStr) {
        if (!StringUtils.isEmpty((String)dmValStr)) {
            List list = SerializationUtils.fromJsonStringToList((String)dmValStr, Map.class);
            StringBuilder sb = new StringBuilder();
            for (Object o : list) {
                Map map = (Map)o;
                sb.append((String)map.get("name"));
                int val = Integer.parseInt((String)map.get("scope"));
                if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) continue;
                sb.append(ResManager.loadKDString((String)"\u7684", (String)"SaveDimMemberHelper_15", (String)"fi-bcm-business", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName());
            }
            return sb.toString();
        }
        return dmValStr;
    }

    private static String trimToEmpty(String val) {
        return val == null ? "" : val.trim();
    }
}

