/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.interfaces.IDimensionComponent;
import kd.fi.bcm.business.dimension.interfaces.ISaveTreeAndOlap;
import kd.fi.bcm.business.dimension.model.DimensionMember;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public abstract class AbstractDimensionMemTree
implements IDimensionComponent,
ISaveTreeAndOlap {
    private static final long serialVersionUID = 1L;
    private List<AbstractDimensionMemTree> children = new ArrayList<AbstractDimensionMemTree>(10);
    private Long id = GlobalIdUtil.genGlobalLongId();
    protected Object dimension;
    protected DynamicObject model;
    private DynamicObject member;
    private String name;
    private String number;
    private String storagetype;
    private String aggoprt;
    private Long parent = 0L;
    private boolean isleaf = true;
    private int dseq = 1;
    private int level = 1;
    private String longnumber;
    private String issysmember = "1";
    private long copyfrom;
    private DynamicObject creator;
    private DynamicObject modifier;
    private Date createtime;
    private Date modifytime;

    public AbstractDimensionMemTree() {
    }

    public AbstractDimensionMemTree(DynamicObject model, Object dimension) {
        this.model = model;
        this.dimension = dimension;
        this.checkDyn(dimension);
    }

    protected final void checkDyn(Object dimension) {
        if (!(dimension instanceof DynamicObject)) {
            this.dimension = ((IDimensionComponent)dimension).initToDyna();
        }
    }

    @Override
    public String getDynaEntityname() {
        return ((DynamicObject)this.dimension).getString("membermodel");
    }

    @Override
    public DynamicObject initToDyna() {
        this.initDimensionMem();
        this.initCommInfo();
        return IDimensionComponent.super.initToDyna();
    }

    private void initCommInfo() {
        this.creator = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        this.creator.set("id", (Object)RequestContext.get().getUserId());
        this.modifier = this.creator;
        this.createtime = this.modifytime = TimeServiceHelper.getCurrentSystemTime();
    }

    public void initDimensionMem() {
        this.setDimensionmember(new DimensionMem().initToDyna());
    }

    @Override
    public void actionSaveTreeMemAndOlap(boolean needCreateOlap) {
        this.actionSaveTreeMemAndOlap(needCreateOlap, false);
    }

    public void actionSaveTreeMemAndOlap(boolean needCreateOlap, boolean isExistDimensionScheme) {
        PresetDataBuildResult buildResult = this.buildPresetData();
        List<DynamicObject> dotmembertrees = buildResult.getDotmembertrees();
        Map<String, DynamicObject> dotmembers = buildResult.getDotmembers();
        DynamicObject dimensionobj = buildResult.getDimensionobj();
        ThreadCache.put((Object)"dimensionIds", (Object)dimensionobj.getString("id"));
        SaveServiceHelper.save((DynamicObject[])dotmembers.values().toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dotmembertrees.toArray(new DynamicObject[0]));
        if (needCreateOlap) {
            ArrayList<Tuple<String, Integer, String>> list = new ArrayList<Tuple<String, Integer, String>>(dotmembertrees.size());
            List<Long> parentIds = dotmembertrees.stream().map(x -> x.getLong("parent")).collect(Collectors.toList());
            Map<Long, String> id2Nums = DimensionServiceHelper.getMemberNumber(DimEntityNumEnum.getEntieyNumByNumber((String)dimensionobj.getString("number")), parentIds);
            for (DynamicObject treeMember : dotmembertrees) {
                list.add((Tuple<String, Integer, String>)Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)id2Nums.get(treeMember.getLong("parent"))));
            }
            if (isExistDimensionScheme) {
                OlapServiceHelper.batchCreateDimensionMembers(this.getModel().getString("number"), dimensionobj.getString("number"), list);
            } else {
                OlapServiceHelper.batchCreateDimensionSchemes(this.getModel().getString("number"), dimensionobj.getString("number"), dimensionobj.getString("shortnumber"), list);
            }
        }
    }

    public PresetDataBuildResult buildPresetData() {
        ArrayList<DynamicObject> dotmembertrees = new ArrayList<DynamicObject>(10);
        HashMap<String, DynamicObject> dotmembers = new HashMap<String, DynamicObject>(16);
        ArrayList<String> numbers = new ArrayList<String>(10);
        DynamicObject dimensionobj = (DynamicObject)this.getDimension();
        this.iteratorTrees(this, dotmembertrees, dotmembers, numbers);
        this.delSharingTrees(dotmembertrees, dotmembers);
        numbers.remove("CNone");
        numbers.remove("ICNone");
        numbers.remove("PRONone");
        numbers.remove("BPNone");
        numbers.remove("MBNone");
        numbers.remove("PJNone");
        numbers.remove("VNone");
        if (dimensionobj.getBoolean("isexcdycompute")) {
            dimensionobj.set("isexcdycompute", (Object)false);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimensionobj});
        }
        return new PresetDataBuildResult(dotmembertrees, dotmembers, dimensionobj);
    }

    private void delSharingTrees(List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers) {
        for (DynamicObject trees : dotmembertrees) {
            if (!"3".equals(trees.getString("storagetype"))) continue;
            trees.set("member", (Object)dotmembers.get(trees.getString("number")));
        }
    }

    private void iteratorTrees(AbstractDimensionMemTree tree, List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers, List<String> numbers) {
        this.saveData(tree, dotmembertrees, dotmembers, numbers);
        Iterator<AbstractDimensionMemTree> iterator = tree.getChildren().iterator();
        while (iterator.hasNext()) {
            AbstractDimensionMemTree atree;
            AbstractDimensionMemTree btree = atree = iterator.next();
            this.iteratorTrees(btree, dotmembertrees, dotmembers, numbers);
        }
    }

    private void saveData(AbstractDimensionMemTree tree, List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers, List<String> numbers) {
        if (numbers.contains(tree.getNumber())) {
            return;
        }
        DynamicObject dot = tree.initToDyna();
        DynamicObject dotmember = dot.getDynamicObject("member");
        String storagetype = dot.getString("storagetype");
        if (!"3".equals(storagetype)) {
            dotmembers.put(dotmember.getString("number"), dotmember);
            numbers.add(tree.getNumber());
            if (((DynamicObject)tree.getDimension()).getString("number").equals(DimTypesEnum.ENTITY.getNumber()) && !tree.getNumber().equals(DimTypesEnum.ENTITY.getNumber()) && !tree.getNumber().equals("RatePreset")) {
                numbers.add(DimTypesEnum.ENTITY.getNumber() + "_" + tree.getNumber());
            }
        }
        dotmembertrees.add(dot);
    }

    public DynamicObject getDimensionmember() {
        return this.member;
    }

    public void setDimensionmember(DynamicObject member) {
        this.member = member;
    }

    public List<AbstractDimensionMemTree> getChildren() {
        return this.children;
    }

    public String getStoragetype() {
        return this.storagetype;
    }

    public void setStoragetype(String storagetype) {
        this.storagetype = storagetype;
    }

    public void setChildren(List<AbstractDimensionMemTree> children) {
        this.children = children;
    }

    public String getAggoprt() {
        return this.aggoprt;
    }

    public void setAggoprt(String aggoprt) {
        this.aggoprt = aggoprt;
    }

    public Object getDimension() {
        return this.dimension;
    }

    public DynamicObject getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getParent() {
        return this.parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public Boolean getIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(boolean isleaf) {
        this.isleaf = isleaf;
    }

    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int dseq) {
        this.dseq = dseq;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
        this.checkDyn(dimension);
    }

    public void setModel(DynamicObject model) {
        this.model = model;
    }

    public Long getId() {
        return this.id;
    }

    public Object readResolve() {
        this.id = GlobalIdUtil.genGlobalLongId();
        return this;
    }

    public String getIssysmember() {
        return this.issysmember;
    }

    public void setIssysmember(String issysmember) {
        this.issysmember = issysmember;
    }

    public long getCopyfrom() {
        return this.copyfrom;
    }

    public void setCopyfrom(long copyfrom) {
        this.copyfrom = copyfrom;
    }

    public DynamicObject getCreator() {
        return this.creator;
    }

    public void setCreator(DynamicObject creator) {
        this.creator = creator;
    }

    public DynamicObject getModifier() {
        return this.modifier;
    }

    public void setModifier(DynamicObject modifier) {
        this.modifier = modifier;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    protected AbstractDimensionMemTree searchTree(AbstractDimensionMemTree roottreemodel, String treeNumber) {
        IDimensionComponent child;
        if (treeNumber.equals(roottreemodel.getNumber())) {
            return roottreemodel;
        }
        AbstractDimensionMemTree truetree = null;
        Iterator<AbstractDimensionMemTree> iterator = roottreemodel.getChildren().iterator();
        while (iterator.hasNext() && (truetree = this.searchTree(roottreemodel = (AbstractDimensionMemTree)(child = (IDimensionComponent)iterator.next()), treeNumber)) == null) {
        }
        return truetree;
    }

    public static class PresetDataBuildResult {
        private List<DynamicObject> dotmembertrees;
        private Map<String, DynamicObject> dotmembers;
        private DynamicObject dimensionobj;

        public PresetDataBuildResult(List<DynamicObject> dotmembertrees, Map<String, DynamicObject> dotmembers, DynamicObject dimensionobj) {
            this.dotmembertrees = dotmembertrees;
            this.dotmembers = dotmembers;
            this.dimensionobj = dimensionobj;
        }

        public List<DynamicObject> getDotmembertrees() {
            return this.dotmembertrees;
        }

        public Map<String, DynamicObject> getDotmembers() {
            return this.dotmembers;
        }

        public DynamicObject getDimensionobj() {
            return this.dimensionobj;
        }
    }

    private class DimensionMem
    extends DimensionMember {
        private static final long serialVersionUID = 1L;

        public DimensionMem() {
            this.setName(AbstractDimensionMemTree.this.name);
            this.setNumber(AbstractDimensionMemTree.this.number);
            AbstractDimensionMemTree.this.checkDyn(AbstractDimensionMemTree.this.dimension);
            this.setDimension(AbstractDimensionMemTree.this.dimension);
            this.setModel(AbstractDimensionMemTree.this.model);
        }
    }
}

