/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.model;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.interfaces.IInitSpecialTree;
import kd.fi.bcm.business.dimension.model.AbstractDimensionMemTree;
import kd.fi.bcm.common.SysMembConstant;

public class PeriodMemTree
extends AbstractDimensionMemTree
implements IInitSpecialTree {
    private int effmonth;
    private int effday;
    private int expmonth;
    private int expday;
    private String effdate;
    private String expdate;
    private String lastperiod;
    private String relatednumber;
    private String isadjust;
    private String useyear;
    private static final long serialVersionUID = 1L;

    public PeriodMemTree() {
    }

    public PeriodMemTree(DynamicObject model, Object dimension) {
        super(model, dimension);
    }

    public int getEffmonth() {
        return this.effmonth;
    }

    public void setEffmonth(int effmonth) {
        this.effmonth = effmonth;
    }

    public int getEffday() {
        return this.effday;
    }

    public void setEffday(int effday) {
        this.effday = effday;
    }

    public int getExpmonth() {
        return this.expmonth;
    }

    public void setExpmonth(int expmonth) {
        this.expmonth = expmonth;
    }

    public int getExpday() {
        return this.expday;
    }

    public void setExpday(int expday) {
        this.expday = expday;
    }

    public String getEffdate() {
        return this.effdate;
    }

    public void setEffdate(String effdate) {
        this.effdate = effdate;
    }

    public String getExpdate() {
        return this.expdate;
    }

    public void setExpdate(String expdate) {
        this.expdate = expdate;
    }

    public String getLastperiod() {
        return this.lastperiod;
    }

    public void setLastperiod(String lastperiod) {
        this.lastperiod = lastperiod;
    }

    public String getIsadjust() {
        return this.isadjust;
    }

    public void setIsadjust(String isadjust) {
        this.isadjust = isadjust;
    }

    public String getUseyear() {
        return this.useyear;
    }

    public void setUseyear(String useyear) {
        this.useyear = useyear;
    }

    public String getRelatednumber() {
        return this.relatednumber;
    }

    public void setRelatednumber(String relatednumber) {
        this.relatednumber = relatednumber;
    }

    @Override
    public void initSpecialTrees() {
        boolean mincludeyear;
        String prefix = null;
        boolean isdetailtoday = this.model.getBoolean("isdetailtoday");
        boolean isdetailtomonth = this.model.getBoolean("isdetailtomonth");
        boolean isdetailtoqrt = this.model.getBoolean("isdetailtoqrt");
        boolean isdetailtohalfyear = this.model.getBoolean("isdetailtohalfyear");
        if (isdetailtomonth) {
            mincludeyear = this.model.getBoolean("mincludeyear");
            boolean mincludeqrt = this.model.getBoolean("mincludeqrt");
            boolean monthinclude13 = this.model.getBoolean("monthinclude13");
            prefix = "M";
            this.initPeriodTree(this, mincludeyear, mincludeqrt, true, monthinclude13, prefix);
        }
        if (isdetailtoqrt) {
            mincludeyear = this.model.getBoolean("qrtincludeyear");
            prefix = "Q";
            this.initPeriodTree(this, mincludeyear, true, false, false, prefix);
        }
        if (isdetailtohalfyear) {
            prefix = "HF";
            this.initPeriodTree(this, true, false, false, false, prefix);
        }
        if (isdetailtoday) {
            prefix = "YD";
            boolean mincludemouth = this.model.getBoolean("qrtincludemouth");
            this.initDayPeriodTree(this, mincludemouth, prefix);
        }
    }

    private void initDayPeriodTree(PeriodMemTree periodMemTree, boolean mincludemouth, String prefix) {
        AbstractDimensionMemTree YD_TotalMember;
        String name = ResManager.getLocaleString((String)"\u5e74\u5ea6\u5408\u8ba1", (String)"PeriodMemTree_0", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String number = prefix + "_YearTotal";
        int beginPeriod = this.model.getInt("beginperiod");
        int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];
        for (int i = 0; i < SysMembConstant.dayofMonth.size(); ++i) {
            dayofMonth[i] = (Integer)SysMembConstant.dayofMonth.get(i);
        }
        int M_Year_EndM = this.getMonth(beginPeriod, 11);
        int M_Year_EndD = dayofMonth[M_Year_EndM];
        AbstractDimensionMemTree parentDimensionMemTree = YD_TotalMember = this.setPeriodValue(name, number, this, beginPeriod, 1, M_Year_EndM, M_Year_EndD, "5");
        for (int i = beginPeriod; i < beginPeriod + 12; ++i) {
            int realPeriod = i > 12 ? i - 12 : i;
            int period = i - beginPeriod + 1;
            String month = ResManager.getLocaleString((String)"\u6708", (String)"PeriodMemTree_4", (String)"fi-bcm-business").getLocaleValue_zh_CN();
            String dayStr = ResManager.getLocaleString((String)"\u65e5", (String)"PeriodMemTree_6", (String)"fi-bcm-business").getLocaleValue_zh_CN();
            if (mincludemouth) {
                name = String.format("%s%s", realPeriod, month);
                number = String.format("YD_M%s", String.format("%02d", period));
                parentDimensionMemTree = this.setPeriodValue(name, number, YD_TotalMember, realPeriod, 1, realPeriod, dayofMonth[realPeriod], "1");
            }
            int mouthDays = dayofMonth[realPeriod];
            for (int day = 1; day <= mouthDays; ++day) {
                name = String.format("%s%s%s%s", realPeriod, month, day, dayStr);
                number = String.format("YD_D%s%s", String.format("%02d", period), String.format("%02d", day));
                this.setPeriodValue(name, number, parentDimensionMemTree, realPeriod, day, realPeriod, day, "1");
            }
        }
    }

    private void initPeriodTree(AbstractDimensionMemTree roottreemodel, boolean cludeHalfYear, boolean cludeQrt, boolean cludeMonth, boolean cludeMonth13, String prefix) {
        String number;
        int i;
        int beginPeriod;
        int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];
        for (int i2 = 0; i2 < SysMembConstant.dayofMonth.size(); ++i2) {
            dayofMonth[i2] = (Integer)SysMembConstant.dayofMonth.get(i2);
        }
        AbstractDimensionMemTree yeartotal = null;
        AbstractDimensionMemTree hfyear1 = null;
        AbstractDimensionMemTree hfyear2 = null;
        AbstractDimensionMemTree qrtyear1 = null;
        AbstractDimensionMemTree qrtyear2 = null;
        AbstractDimensionMemTree qrtyear3 = null;
        AbstractDimensionMemTree qrtyear4 = null;
        int M_Year_startM = beginPeriod = this.model.getInt("beginperiod");
        int M_Year_startD = 1;
        int M_Year_EndM = this.getMonth(M_Year_startM, 11);
        int M_Year_EndD = dayofMonth[M_Year_EndM];
        String ptname = ResManager.getLocaleString((String)"\u5e74\u5ea6\u5408\u8ba1", (String)"PeriodMemTree_0", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String ptnumber = prefix + "_YearTotal";
        yeartotal = this.setPeriodValue(ptname, ptnumber, roottreemodel, M_Year_startM, M_Year_startD, M_Year_EndM, M_Year_EndD, "5");
        if (cludeHalfYear) {
            for (i = 1; i <= 2; ++i) {
                int hf_startM = this.getMonth(beginPeriod, (i - 1) * 6);
                int hf_startD = 1;
                int hf_endM = this.getMonth(hf_startM, 5);
                int hf_endD = dayofMonth[hf_endM];
                String name = ResManager.getLocaleString((String)"\u4e0a\u534a\u5e74", (String)"PeriodMemTree_1", (String)"fi-bcm-business").getLocaleValue_zh_CN();
                if (i == 2) {
                    name = ResManager.getLocaleString((String)"\u4e0b\u534a\u5e74", (String)"PeriodMemTree_2", (String)"fi-bcm-business").getLocaleValue_zh_CN();
                }
                number = prefix + "_HF" + i;
                AbstractDimensionMemTree p = this.setPeriodValue(name, number, yeartotal, hf_startM, hf_startD, hf_endM, hf_endD, "1");
                if (i == 1) {
                    hfyear1 = p;
                    continue;
                }
                hfyear2 = p;
            }
        }
        if (cludeQrt) {
            block8: for (i = 1; i < 5; ++i) {
                AbstractDimensionMemTree parent = null;
                parent = cludeHalfYear ? (i == 1 || i == 2 ? hfyear1 : hfyear2) : yeartotal;
                int Q_startM = this.getMonth(beginPeriod, (i - 1) * 3);
                int Q_startD = 1;
                int Q_endM = this.getMonth(Q_startM, 2);
                int Q_endD = dayofMonth[Q_endM];
                number = prefix + "_Q" + i;
                String name = String.format(ResManager.getLocaleString((String)"%s\u5b63\u5ea6", (String)"PeriodMemTree_3", (String)"fi-bcm-business").getLocaleValue_zh_CN(), i);
                AbstractDimensionMemTree qrt = this.setPeriodValue(name, number, parent, Q_startM, Q_startD, Q_endM, Q_endD, "1");
                switch (i) {
                    case 1: {
                        qrtyear1 = qrt;
                        continue block8;
                    }
                    case 2: {
                        qrtyear2 = qrt;
                        continue block8;
                    }
                    case 3: {
                        qrtyear3 = qrt;
                        continue block8;
                    }
                    case 4: {
                        qrtyear4 = qrt;
                    }
                }
            }
        }
        if (cludeMonth) {
            int count = 0;
            count = cludeMonth13 ? 13 : 12;
            for (int i3 = 1; i3 <= count; ++i3) {
                AbstractDimensionMemTree parent = null;
                parent = cludeQrt ? (i3 <= 3 ? qrtyear1 : (i3 <= 6 ? qrtyear2 : (i3 <= 9 ? qrtyear3 : qrtyear4))) : (cludeHalfYear ? (i3 <= 6 ? hfyear1 : hfyear2) : yeartotal);
                int M_startM = this.getMonth(beginPeriod, (i3 - 1) * 1);
                int M_startD = 1;
                int M_endM = M_startM;
                int Q_endD = dayofMonth[M_endM];
                String monthLs = ResManager.getLocaleString((String)"\u6708", (String)"PeriodMemTree_4", (String)"fi-bcm-business").getLocaleValue_zh_CN();
                String name = M_startM + monthLs;
                String number2 = "M_M0" + i3;
                String aggoprt = "1";
                if (i3 >= 10) {
                    number2 = "M_M" + i3;
                }
                if (i3 == 13) {
                    String periodLs = ResManager.getLocaleString((String)"\u671f", (String)"PeriodMemTree_5", (String)"fi-bcm-business").getLocaleValue_zh_CN();
                    name = 13 + periodLs;
                    aggoprt = "5";
                    this.setPeriodValue(name, number2, parent, M_Year_EndM, M_Year_EndD, M_Year_EndM, M_Year_EndD, aggoprt);
                    continue;
                }
                this.setPeriodValue(name, number2, parent, M_startM, M_startD, M_endM, Q_endD, aggoprt);
            }
        }
    }

    private int getMonth(int month, int differ) {
        return month + differ >= 13 ? month + differ - 12 : month + differ;
    }

    private AbstractDimensionMemTree setPeriodValue(String name, String number, AbstractDimensionMemTree fyparent, int hf_startM, int hf_startD, int hf_endM, int hf_endD, String aggoprt) {
        PeriodMemTree pt_f1 = this.getTreeModel();
        pt_f1.setName(name);
        pt_f1.setNumber(number);
        pt_f1.setStoragetype("2");
        pt_f1.setAggoprt(aggoprt);
        pt_f1.setIsleaf(true);
        pt_f1.setEffmonth(hf_startM);
        pt_f1.setEffday(hf_startD);
        pt_f1.setExpmonth(hf_endM);
        pt_f1.setExpday(hf_endD);
        String month = ResManager.loadKDString((String)"\u6708", (String)"PeriodMemTree_4", (String)"fi-bcm-business", (Object[])new Object[0]);
        String dayStr = ResManager.loadKDString((String)"\u65e5", (String)"PeriodMemTree_6", (String)"fi-bcm-business", (Object[])new Object[0]);
        pt_f1.setEffdate(hf_startM + month + hf_startD + dayStr);
        pt_f1.setExpdate(hf_endM + month + hf_endD + dayStr);
        if (number.equals("M_M13")) {
            pt_f1.setRelatednumber("M_M12");
            pt_f1.setIsadjust("1");
            String yearNum = DimensionServiceHelper.getAllUseYear(pt_f1.model.getLong("id"));
            if (StringUtils.isNotEmpty((CharSequence)yearNum)) {
                pt_f1.setUseyear(yearNum);
            }
        } else if (!number.equals("M_M01")) {
            pt_f1.setLastperiod(this.getLastPeriodNum(number));
        }
        if (fyparent != null) {
            pt_f1.setLongnumber(fyparent.getLongnumber() + '!' + pt_f1.getNumber());
            pt_f1.setLevel(fyparent.getLevel() + 1);
            pt_f1.setParent(fyparent.getId());
            pt_f1.setDseq(fyparent.getChildren().size() + 1);
            fyparent.setIsleaf(false);
            fyparent.getChildren().add(pt_f1);
        }
        return pt_f1;
    }

    private String getLastPeriodNum(String number) {
        try {
            int month = Integer.parseInt(number.replace("M_M", "")) - 1;
            if (month == 0) {
                return "";
            }
            if (month < 10) {
                return "M_M0" + month;
            }
            return "M_M" + month;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private PeriodMemTree getTreeModel() {
        PeriodMemTree per = new PeriodMemTree();
        per.setModel(this.getModel());
        per.setDimension(this.getDimension());
        return per;
    }
}

