/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.model;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.fi.bcm.business.dimension.interfaces.IInitSpecialTree;
import kd.fi.bcm.business.dimension.model.AbstractDimensionMemTree;

public class YearMemTree
extends AbstractDimensionMemTree
implements IInitSpecialTree {
    private static final long serialVersionUID = 1L;

    public YearMemTree() {
    }

    public YearMemTree(DynamicObject model, Object dimension) {
        super(model, dimension);
    }

    @Override
    public void initSpecialTrees() {
        boolean isTrue = true;
        boolean isFalse = false;
        String startYearSeq = this.model.getString("startfy");
        int firstYear = 1997;
        int startYear = Integer.parseInt(startYearSeq) + firstYear - 1;
        int presetyear = this.model.getInt("presetyear");
        AbstractDimensionMemTree fyparent = this.searchTree(this, "AllYear");
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        for (int actualYear = startYear; actualYear < startYear + presetyear; ++actualYear) {
            YearMemTree fy = this.getTreeModel();
            fy.setLevel(fyparent.getLevel() + 1);
            fy.setDseq(fyparent.getChildren().size() + 1);
            fy.setIsleaf(isTrue);
            fy.setParent(fyparent.getId());
            fy.setStoragetype("4");
            fy.setAggoprt("1");
            fy.setNumber("FY" + actualYear);
            String yearLs = ResManager.getLocaleString((String)"\u5e74", (String)"YearMemTree_0", (String)"fi-bcm-business").getLocaleValue_zh_CN();
            fy.setName(actualYear + yearLs);
            fy.setLongnumber(fyparent.getLongnumber() + '!' + "FY" + actualYear);
            fyparent.getChildren().add(fy);
            fyparent.setIsleaf(isFalse);
        }
    }

    private YearMemTree getTreeModel() {
        YearMemTree ye = new YearMemTree();
        ye.setDimension(this.getDimension());
        ye.setModel(this.getModel());
        return ye;
    }
}

